-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: robmartinomusic_db
-- ------------------------------------------------------
-- Server version	8.0.42-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `addresses`
--

DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `addresses` (
  `id` int NOT NULL,
  `primaryOwnerId` int DEFAULT NULL,
  `fieldId` int DEFAULT NULL,
  `countryCode` varchar(255) NOT NULL,
  `administrativeArea` varchar(255) DEFAULT NULL,
  `locality` varchar(255) DEFAULT NULL,
  `dependentLocality` varchar(255) DEFAULT NULL,
  `postalCode` varchar(255) DEFAULT NULL,
  `sortingCode` varchar(255) DEFAULT NULL,
  `addressLine1` varchar(255) DEFAULT NULL,
  `addressLine2` varchar(255) DEFAULT NULL,
  `addressLine3` varchar(255) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `organizationTaxId` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_jgigqdygvkuyejbbmjtfnhstoqqnbhldaklo` (`primaryOwnerId`),
  CONSTRAINT `fk_jgigqdygvkuyejbbmjtfnhstoqqnbhldaklo` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rzetzucljiwsteewqihsmihvtjrtomiqlzog` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `pluginId` int DEFAULT NULL,
  `heading` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `dateRead` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_iawwcerjybssnnwbhfodrksilemslwifufln` (`userId`,`unread`,`dateRead`,`dateCreated`),
  KEY `idx_levgsyssoewwxvgkmmetlvmdfbkgyqhmubcv` (`dateRead`),
  KEY `fk_nljdfyrtigqdtfsgbgvjepppaiobbsnpnxbq` (`pluginId`),
  CONSTRAINT `fk_cuyshkgzogrkfvxewxqkiukllultikwxsjyd` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nljdfyrtigqdtfsgbgvjepppaiobbsnpnxbq` FOREIGN KEY (`pluginId`) REFERENCES `plugins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexdata`
--

DROP TABLE IF EXISTS `assetindexdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexdata` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sessionId` int NOT NULL,
  `volumeId` int NOT NULL,
  `uri` text,
  `size` bigint unsigned DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `isDir` tinyint(1) DEFAULT '0',
  `recordId` int DEFAULT NULL,
  `isSkipped` tinyint(1) DEFAULT '0',
  `inProgress` tinyint(1) DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ergzoqadkmhyfvzxpfwogqsodqpkskamkhoe` (`sessionId`,`volumeId`),
  KEY `idx_opxtfljblvllxtywrknerxlcwtzuizaoatva` (`volumeId`),
  CONSTRAINT `fk_dlqjskyzxescgvfokyvwaanumwlzriaimvcr` FOREIGN KEY (`sessionId`) REFERENCES `assetindexingsessions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sveysafobxzdpgswzwyaliyphotfmgkmkncr` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexingsessions`
--

DROP TABLE IF EXISTS `assetindexingsessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexingsessions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `indexedVolumes` text,
  `totalEntries` int DEFAULT NULL,
  `processedEntries` int NOT NULL DEFAULT '0',
  `cacheRemoteImages` tinyint(1) DEFAULT NULL,
  `listEmptyFolders` tinyint(1) DEFAULT '0',
  `isCli` tinyint(1) DEFAULT '0',
  `actionRequired` tinyint(1) DEFAULT '0',
  `processIfRootEmpty` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int NOT NULL,
  `volumeId` int DEFAULT NULL,
  `folderId` int NOT NULL,
  `uploaderId` int DEFAULT NULL,
  `filename` varchar(255) NOT NULL,
  `kind` varchar(50) NOT NULL DEFAULT 'unknown',
  `alt` text,
  `width` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `size` bigint unsigned DEFAULT NULL,
  `focalPoint` varchar(13) DEFAULT NULL,
  `deletedWithVolume` tinyint(1) DEFAULT NULL,
  `keptFile` tinyint(1) DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_hhbyknahgxqzojaeotdrtkjywytcotpngeic` (`filename`,`folderId`),
  KEY `idx_lnebzajxuozidncrfjokdtpkkjwapxxodmem` (`folderId`),
  KEY `idx_rmgjjdexrzniutkqseczhwlicmhdlnlulyns` (`volumeId`),
  KEY `fk_sruqxbuwmbskiiguvjcnwjmjkkzxrllfsxlh` (`uploaderId`),
  CONSTRAINT `fk_dtgkmeyglobhqaplznajpwouzfkfovbqzthw` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nvzegdvdryqjkmmoswhblhprkzjurjmewrwt` FOREIGN KEY (`folderId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sruqxbuwmbskiiguvjcnwjmjkkzxrllfsxlh` FOREIGN KEY (`uploaderId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_ulseoycpjpjryndbwipfdbnfcgyvxauodsgv` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets_sites`
--

DROP TABLE IF EXISTS `assets_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_sites` (
  `assetId` int NOT NULL,
  `siteId` int NOT NULL,
  `alt` text,
  PRIMARY KEY (`assetId`,`siteId`),
  KEY `fk_rpnpbfdoorgcztwklxtgccrdoknkritprzja` (`siteId`),
  CONSTRAINT `fk_gctpfxsujjjklyqlpoeovqcmqzbcdgrlcixn` FOREIGN KEY (`assetId`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rpnpbfdoorgcztwklxtgccrdoknkritprzja` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authenticator`
--

DROP TABLE IF EXISTS `authenticator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authenticator` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `auth2faSecret` varchar(255) DEFAULT NULL,
  `oldTimestamp` int unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_weiolwqjaydjzhocfswmmzuvduaclyjwfttx` (`userId`),
  CONSTRAINT `fk_weiolwqjaydjzhocfswmmzuvduaclyjwfttx` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bulkopevents`
--

DROP TABLE IF EXISTS `bulkopevents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bulkopevents` (
  `key` char(10) NOT NULL,
  `senderClass` varchar(255) NOT NULL,
  `eventName` varchar(255) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`key`,`senderClass`,`eventName`),
  KEY `idx_hjnpyeyznfgiwtwtsydbkduukdzhofnwtbms` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int NOT NULL,
  `groupId` int NOT NULL,
  `parentId` int DEFAULT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_ltdggbalbywumczaqtoetxfvfoomogkhiukt` (`groupId`),
  KEY `fk_fyeacsorfpewlkdhcynnlfemrirnjulaossy` (`parentId`),
  CONSTRAINT `fk_fjxwsztvmpihccgzqqzztjshblefarjaszum` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_fyeacsorfpewlkdhcynnlfemrirnjulaossy` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qaivficawaivrbqkikrsvnbjxqdepcvpteyr` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups`
--

DROP TABLE IF EXISTS `categorygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_mccdpoimenhwcyxlpexvmyqxjiqajrdmzhak` (`name`),
  KEY `idx_novtetufvajitxdtighvvfngrewxdzusdcaf` (`handle`),
  KEY `idx_fkybyuoynogzonqqdcnagktpizndagqsskjg` (`structureId`),
  KEY `idx_hmkbmsvhsysraudvctpbupcipqoailsyhxin` (`fieldLayoutId`),
  KEY `idx_aycqxlwqcqdhwmihnckxuylclqcdubxgyood` (`dateDeleted`),
  CONSTRAINT `fk_njyptuhhadmqkdttdzrmyammkfgclvsvxqhr` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_vdqgbliuhyxnibxtxibkuiqctzchvpqmpccx` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups_sites`
--

DROP TABLE IF EXISTS `categorygroups_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `siteId` int NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text,
  `template` varchar(500) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_qdawiveuokgjkdejojotdpdexnkudhiqwkvp` (`groupId`,`siteId`),
  KEY `idx_xdxrbcdjhwglbgzkqtxtxruefzgblisqmxba` (`siteId`),
  CONSTRAINT `fk_epouuhigmucdrpxuzlcswicyuzsjahmcqvqj` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_zuumfpwadzoodrdimbhqaddkcvrstjaysmim` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedattributes`
--

DROP TABLE IF EXISTS `changedattributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedattributes` (
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `attribute` varchar(255) NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`attribute`),
  KEY `idx_syhvnuuigmnraslrohtmmfwxqvzbkxmnqqnp` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_fjtnoifowtkztwvesxixezihgscpcszxaalm` (`siteId`),
  KEY `fk_nxydxkeewrdvzsdtldrhhiyulxoxmkqsgvph` (`userId`),
  CONSTRAINT `fk_cuwdfvilkxbczyauztxlsrafgmzixndrxaqp` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_fjtnoifowtkztwvesxixezihgscpcszxaalm` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_nxydxkeewrdvzsdtldrhhiyulxoxmkqsgvph` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedfields`
--

DROP TABLE IF EXISTS `changedfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedfields` (
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `fieldId` int NOT NULL,
  `layoutElementUid` char(36) NOT NULL DEFAULT '0',
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`fieldId`,`layoutElementUid`),
  KEY `idx_tfogpofksagixtslxpzkcjatiwocwilwtfor` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_eysuhdgsiytnrrrfelsadkqkfzsxclxftdct` (`siteId`),
  KEY `fk_hrjdwymoylzmzkopdrxmcqlyevifwlmqagcd` (`fieldId`),
  KEY `fk_wuftmpegbppzccenotpchbdpfbadjroaqziv` (`userId`),
  CONSTRAINT `fk_eysuhdgsiytnrrrfelsadkqkfzsxclxftdct` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ezbmzcttrextulzyezozsdxwtliwrelpwsql` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_hrjdwymoylzmzkopdrxmcqlyevifwlmqagcd` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_wuftmpegbppzccenotpchbdpfbadjroaqziv` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `craftidtokens`
--

DROP TABLE IF EXISTS `craftidtokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `craftidtokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `accessToken` text NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_cqtxxholbxlvzyrbsquvzyzoztncisqjtwff` (`userId`),
  CONSTRAINT `fk_cqtxxholbxlvzyrbsquvzyzoztncisqjtwff` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `deprecationerrors`
--

DROP TABLE IF EXISTS `deprecationerrors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `deprecationerrors` (
  `id` int NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `fingerprint` varchar(255) NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) NOT NULL,
  `line` smallint unsigned DEFAULT NULL,
  `message` text,
  `traces` json DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_pdaonxvzldupvhwegzukcvjtibqyyaxtgurx` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `drafts`
--

DROP TABLE IF EXISTS `drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `drafts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `canonicalId` int DEFAULT NULL,
  `creatorId` int DEFAULT NULL,
  `provisional` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `notes` text,
  `trackChanges` tinyint(1) NOT NULL DEFAULT '0',
  `dateLastMerged` datetime DEFAULT NULL,
  `saved` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_xkhqcldlgihyqgodcbxsveicatoqpewuckrp` (`creatorId`,`provisional`),
  KEY `idx_xygcgcxaqgzoacwrqzuucgailkiyugggufzg` (`saved`),
  KEY `fk_gywcntesglnrmgkhnyuotzityrrcevasiyvi` (`canonicalId`),
  CONSTRAINT `fk_bxhmwpdzhqfkymqipodxbxpaayyomwyqlozk` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_gywcntesglnrmgkhnyuotzityrrcevasiyvi` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elementactivity`
--

DROP TABLE IF EXISTS `elementactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elementactivity` (
  `elementId` int NOT NULL,
  `userId` int NOT NULL,
  `siteId` int NOT NULL,
  `draftId` int DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`elementId`,`userId`,`type`),
  KEY `idx_ywwhigjnxdrlrnucqwtjofwolmblqjchwpiw` (`elementId`,`timestamp`,`userId`),
  KEY `fk_qgpvnazgkxyjlwchycrxbfyfolixnlyrmcoy` (`userId`),
  KEY `fk_ylrqadnypgqkwvrnzhnqwsuubbplulxwapmb` (`siteId`),
  KEY `fk_qdabyirodgvrobbkmbgcxtbqwrwjttjlwtwy` (`draftId`),
  CONSTRAINT `fk_cgmospeicdpnuqaafncjucjxylunvnmslieb` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qdabyirodgvrobbkmbgcxtbqwrwjttjlwtwy` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qgpvnazgkxyjlwchycrxbfyfolixnlyrmcoy` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ylrqadnypgqkwvrnzhnqwsuubbplulxwapmb` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements`
--

DROP TABLE IF EXISTS `elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `canonicalId` int DEFAULT NULL,
  `draftId` int DEFAULT NULL,
  `revisionId` int DEFAULT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateLastMerged` datetime DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `deletedWithOwner` tinyint(1) DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_plcsbgocoagtmlkqlujucobabcuunrynyxyh` (`dateDeleted`),
  KEY `idx_jzxndazknouxfjwpxthsgcpzzqhlxqbrhdse` (`fieldLayoutId`),
  KEY `idx_ykmhbmzodqnyggdljtjwwngfbvplvwyrmqml` (`type`),
  KEY `idx_hmhwazbzjxrstqcswpxskyqlgjeqgfidksxx` (`enabled`),
  KEY `idx_ixhanuedhjjpxocujlrjwsjdavkhzwsnwuzx` (`archived`,`dateCreated`),
  KEY `idx_appxvckyvskgxwlcqqtynarxyhnfgfhxayyn` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`),
  KEY `idx_ltbsevtyrosxegdqipupbfxxcxltwcdpplzy` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`,`enabled`),
  KEY `fk_xnxabzqjkopbztbeyshasofjtqxosfhooiwk` (`canonicalId`),
  KEY `fk_nnynnvtojhbxsauyiewvwsanrxdjkkobrqyw` (`draftId`),
  KEY `fk_djxnwqpevivhvfnihnvudejuucnzsffkpnmy` (`revisionId`),
  CONSTRAINT `fk_djxnwqpevivhvfnihnvudejuucnzsffkpnmy` FOREIGN KEY (`revisionId`) REFERENCES `revisions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nnynnvtojhbxsauyiewvwsanrxdjkkobrqyw` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pjrknukohedntxmahtlzkoavaqighrggmrqw` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_xnxabzqjkopbztbeyshasofjtqxosfhooiwk` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_bulkops`
--

DROP TABLE IF EXISTS `elements_bulkops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_bulkops` (
  `elementId` int NOT NULL,
  `key` char(10) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`elementId`,`key`),
  KEY `idx_zzxzgwmmeofgpeuqkhctcgovzrtoqggonykv` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_owners`
--

DROP TABLE IF EXISTS `elements_owners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_owners` (
  `elementId` int NOT NULL,
  `ownerId` int NOT NULL,
  `sortOrder` smallint unsigned NOT NULL,
  PRIMARY KEY (`elementId`,`ownerId`),
  KEY `fk_mohivuazplzpjuozetdexumkitfmblmmmqfz` (`ownerId`),
  CONSTRAINT `fk_bkhbyegqzsronuhijmfpwgfdrgoxojlqbvfn` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mohivuazplzpjuozetdexumkitfmblmmmqfz` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_sites`
--

DROP TABLE IF EXISTS `elements_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `content` json DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_npadfznemjwhjiqsltckfyvdvitjcywwxxoq` (`elementId`,`siteId`),
  KEY `idx_nejiicducrjobgcoxanzwigiqqxemmjsqtwz` (`siteId`),
  KEY `idx_mawjdduxaxzfrakyivifeoevsmsqzpierqjr` (`slug`,`siteId`),
  KEY `idx_tvkejgoxjrrygivoolrwlgoeahiwvxuknwuu` (`enabled`),
  KEY `idx_oeeyapicjspqvuovvkdxhbbwowdsmkzgsaej` (`uri`,`siteId`),
  KEY `idx_gnkadcbubculjfsuoolbhtaygbhirbxoevyo` (`title`,`siteId`),
  CONSTRAINT `fk_elyyhmkznrpujhouujshkkzrpwhtvabbduwo` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zkwraqntxizlcddbpwgruermbglgfqgkxjoc` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries` (
  `id` int NOT NULL,
  `sectionId` int DEFAULT NULL,
  `parentId` int DEFAULT NULL,
  `primaryOwnerId` int DEFAULT NULL,
  `fieldId` int DEFAULT NULL,
  `typeId` int NOT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `status` enum('live','pending','expired') NOT NULL DEFAULT 'live',
  `deletedWithEntryType` tinyint(1) DEFAULT NULL,
  `deletedWithSection` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_heyfbpphyuvhvjqgttixlpglmhrqxakhuuhe` (`postDate`),
  KEY `idx_wvdppawqpcprjgbwywegydkhcszlurudfxef` (`expiryDate`),
  KEY `idx_kzoxqymskyhinabjdohgoarxhwgvdpuovzxy` (`sectionId`),
  KEY `idx_ivhzatmczspzbkfctwjalpxpgkhrujqixcep` (`typeId`),
  KEY `fk_mmjowjyfbnubwrclzwkflouhmxlgeoehwsjx` (`parentId`),
  KEY `idx_clbdjsawlkxqegohvpwunnkmqvtndpgodnks` (`primaryOwnerId`),
  KEY `idx_bskqtaicamyvyjcwdwyannsdtbqvbfcqddhf` (`fieldId`),
  KEY `idx_ajhnuuildbypuvvffpnkxsfwwcdkgspubgmo` (`status`),
  CONSTRAINT `fk_htjvcvmirnnjiirmdxvsaqfhfvypoyqgaipv` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mmjowjyfbnubwrclzwkflouhmxlgeoehwsjx` FOREIGN KEY (`parentId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_rnanaxmxzrkaucebzuvilxnumdlbbdstenos` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_stvnzkigkjrxvreyhwwzfuesggkspqwprudl` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tslnenivzsiqogljgxjmcpqhpjzbrmooagev` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yekevarphkdfawprcqzccbljuyqigilptwsh` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries_authors`
--

DROP TABLE IF EXISTS `entries_authors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries_authors` (
  `entryId` int NOT NULL,
  `authorId` int NOT NULL,
  `sortOrder` smallint unsigned NOT NULL,
  PRIMARY KEY (`entryId`,`authorId`),
  KEY `idx_wfcxjuclmsgpifjhcmupaowztczsxkrovmva` (`authorId`),
  KEY `idx_raiijpsaatqrxtvfuaohbruounkiuzxssxny` (`entryId`,`sortOrder`),
  CONSTRAINT `fk_tzaaiiistqwjxuyfcglawawcrzndnvrqikon` FOREIGN KEY (`entryId`) REFERENCES `entries` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yiodmxmjotyxoegkzogmybrbwquwfrrazana` FOREIGN KEY (`authorId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entrytypes`
--

DROP TABLE IF EXISTS `entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entrytypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `hasTitleField` tinyint(1) NOT NULL DEFAULT '1',
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text,
  `titleFormat` varchar(255) DEFAULT NULL,
  `showSlugField` tinyint(1) DEFAULT '1',
  `slugTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `slugTranslationKeyFormat` text,
  `showStatusField` tinyint(1) DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_okzowrbwfhlcxdmdyergkmdnmkpvlnzwdlhv` (`fieldLayoutId`),
  KEY `idx_snqdjvpgyhhogvqcadzzsqsorbtjejrisnzk` (`dateDeleted`),
  CONSTRAINT `fk_elnngctfoqadbqvdowruvkuwnxylekhplwlw` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouts`
--

DROP TABLE IF EXISTS `fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `config` json DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wvcjpdnlcnuiqcgfbbaxtyqphbbokczexjbb` (`dateDeleted`),
  KEY `idx_uaknqlckmktpldgoaxnjulaanbcoopuusvtf` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `context` varchar(255) NOT NULL DEFAULT 'global',
  `columnSuffix` char(8) DEFAULT NULL,
  `instructions` text,
  `searchable` tinyint(1) NOT NULL DEFAULT '1',
  `translationMethod` varchar(255) NOT NULL DEFAULT 'none',
  `translationKeyFormat` text,
  `type` varchar(255) NOT NULL,
  `settings` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_azwslvtwbtsdrkblzgrplpucwzojtqfgskmu` (`handle`,`context`),
  KEY `idx_atsjdzzsjltbgzrmbrmrujtnrimhnddyshtp` (`context`),
  KEY `idx_vkjguleisbvyjwvzmjippeqvqmghkrfhsijf` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_crm_fields`
--

DROP TABLE IF EXISTS `freeform_crm_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_crm_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `integrationId` int NOT NULL,
  `label` text NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `category` varchar(50) DEFAULT NULL,
  `required` tinyint(1) DEFAULT '0',
  `options` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_crm_fields_type_idx` (`type`),
  KEY `freeform_crm_fields_integrationId_category_idx` (`integrationId`,`category`),
  CONSTRAINT `freeform_crm_fields_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_email_marketing_fields`
--

DROP TABLE IF EXISTS `freeform_email_marketing_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_email_marketing_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `mailingListId` int NOT NULL,
  `label` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `category` varchar(50) DEFAULT NULL,
  `required` tinyint(1) DEFAULT '0',
  `options` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_email_marketing_fields_type_idx` (`type`),
  KEY `freeform_email_marketing_fields_mailingListId_category_idx` (`mailingListId`,`category`),
  CONSTRAINT `freeform_email_marketing_fields_mailingListId_fk` FOREIGN KEY (`mailingListId`) REFERENCES `freeform_email_marketing_lists` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_email_marketing_lists`
--

DROP TABLE IF EXISTS `freeform_email_marketing_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_email_marketing_lists` (
  `id` int NOT NULL AUTO_INCREMENT,
  `integrationId` int NOT NULL,
  `resourceId` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `memberCount` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_email_marketing_lists_integrationId_resourceId_unq_idx` (`integrationId`,`resourceId`),
  CONSTRAINT `freeform_email_marketing_lists_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_export_notifications`
--

DROP TABLE IF EXISTS `freeform_export_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_export_notifications` (
  `id` int NOT NULL AUTO_INCREMENT,
  `profileId` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `fileType` varchar(30) NOT NULL,
  `fileName` varchar(255) DEFAULT NULL,
  `frequency` varchar(20) NOT NULL,
  `recipients` longtext NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `freeform_export_notifications_profileId_fk` (`profileId`),
  CONSTRAINT `freeform_export_notifications_profileId_fk` FOREIGN KEY (`profileId`) REFERENCES `freeform_export_profiles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_export_profiles`
--

DROP TABLE IF EXISTS `freeform_export_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_export_profiles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `limit` int DEFAULT NULL,
  `dateRange` varchar(255) DEFAULT NULL,
  `rangeStart` varchar(255) DEFAULT NULL,
  `rangeEnd` varchar(255) DEFAULT NULL,
  `fields` longtext NOT NULL,
  `filters` longtext,
  `statuses` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `freeform_export_profiles_formId_fk` (`formId`),
  CONSTRAINT `freeform_export_profiles_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_export_settings`
--

DROP TABLE IF EXISTS `freeform_export_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_export_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `setting` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_export_settings_userId_fk` (`userId`),
  CONSTRAINT `freeform_export_settings_userId_fk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_favorite_fields`
--

DROP TABLE IF EXISTS `freeform_favorite_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_favorite_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int DEFAULT NULL,
  `label` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `metadata` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_favorite_fields_userId_fk` (`userId`),
  CONSTRAINT `freeform_favorite_fields_userId_fk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_feed_messages`
--

DROP TABLE IF EXISTS `freeform_feed_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_feed_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `feedId` int NOT NULL,
  `message` text NOT NULL,
  `conditions` longtext NOT NULL,
  `type` varchar(255) NOT NULL,
  `seen` tinyint(1) NOT NULL DEFAULT '0',
  `issueDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_feed_messages_feedId_fk` (`feedId`),
  CONSTRAINT `freeform_feed_messages_feedId_fk` FOREIGN KEY (`feedId`) REFERENCES `freeform_feeds` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_feeds`
--

DROP TABLE IF EXISTS `freeform_feeds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_feeds` (
  `id` int NOT NULL AUTO_INCREMENT,
  `hash` varchar(255) NOT NULL,
  `min` varchar(255) DEFAULT NULL,
  `max` varchar(255) DEFAULT NULL,
  `issueDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_feeds_hash_unq_idx` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_fields_type_groups`
--

DROP TABLE IF EXISTS `freeform_fields_type_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_fields_type_groups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `color` varchar(10) DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `types` longtext NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms`
--

DROP TABLE IF EXISTS `freeform_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `name` varchar(100) NOT NULL,
  `handle` varchar(100) NOT NULL,
  `spamBlockCount` int unsigned NOT NULL DEFAULT '0',
  `metadata` longtext,
  `order` int DEFAULT NULL,
  `createdByUserId` int DEFAULT NULL,
  `updatedByUserId` int DEFAULT NULL,
  `dateArchived` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`),
  KEY `freeform_forms_order_idx` (`order`),
  KEY `freeform_forms_createdByUserId_fk` (`createdByUserId`),
  KEY `freeform_forms_updatedByUserId_fk` (`updatedByUserId`),
  CONSTRAINT `freeform_forms_createdByUserId_fk` FOREIGN KEY (`createdByUserId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `freeform_forms_updatedByUserId_fk` FOREIGN KEY (`updatedByUserId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_fields`
--

DROP TABLE IF EXISTS `freeform_forms_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `type` varchar(255) NOT NULL,
  `metadata` longtext,
  `rowId` int DEFAULT NULL,
  `order` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_fields_rowId_order_idx` (`rowId`,`order`),
  KEY `freeform_forms_fields_formId_fk` (`formId`),
  CONSTRAINT `freeform_forms_fields_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_forms_fields_rowId_fk` FOREIGN KEY (`rowId`) REFERENCES `freeform_forms_rows` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_groups`
--

DROP TABLE IF EXISTS `freeform_forms_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_groups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `siteId` int NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `order` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_groups_siteId_fk` (`siteId`),
  CONSTRAINT `freeform_forms_groups_siteId_fk` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_groups_entries`
--

DROP TABLE IF EXISTS `freeform_forms_groups_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_groups_entries` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `formId` int NOT NULL,
  `order` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_groups_entries_groupId_fk` (`groupId`),
  KEY `freeform_forms_groups_entries_formId_fk` (`formId`),
  CONSTRAINT `freeform_forms_groups_entries_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_forms_groups_entries_groupId_fk` FOREIGN KEY (`groupId`) REFERENCES `freeform_forms_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_integrations`
--

DROP TABLE IF EXISTS `freeform_forms_integrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_integrations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `integrationId` int NOT NULL,
  `formId` int NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `metadata` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_integrations_integrationId_fk` (`integrationId`),
  KEY `freeform_forms_integrations_formId_fk` (`formId`),
  CONSTRAINT `freeform_forms_integrations_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_forms_integrations_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_layouts`
--

DROP TABLE IF EXISTS `freeform_forms_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_layouts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_layouts_formId_idx` (`formId`),
  CONSTRAINT `freeform_forms_layouts_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_notifications`
--

DROP TABLE IF EXISTS `freeform_forms_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_notifications` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class` varchar(255) NOT NULL,
  `formId` int NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `metadata` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_notifications_formId_fk` (`formId`),
  CONSTRAINT `freeform_forms_notifications_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_pages`
--

DROP TABLE IF EXISTS `freeform_forms_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `layoutId` int NOT NULL,
  `label` varchar(255) NOT NULL,
  `order` int DEFAULT NULL,
  `metadata` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_pages_formId_order_idx` (`formId`,`order`),
  KEY `freeform_forms_pages_layoutId_fk` (`layoutId`),
  CONSTRAINT `freeform_forms_pages_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_forms_pages_layoutId_fk` FOREIGN KEY (`layoutId`) REFERENCES `freeform_forms_layouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_rows`
--

DROP TABLE IF EXISTS `freeform_forms_rows`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_rows` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `layoutId` int NOT NULL,
  `order` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_forms_rows_formId_order_idx` (`formId`,`order`),
  KEY `freeform_forms_rows_layoutId_fk` (`layoutId`),
  CONSTRAINT `freeform_forms_rows_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_forms_rows_layoutId_fk` FOREIGN KEY (`layoutId`) REFERENCES `freeform_forms_layouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_sites`
--

DROP TABLE IF EXISTS `freeform_forms_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `siteId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_forms_sites_siteId_formId_unq_idx` (`siteId`,`formId`),
  KEY `freeform_forms_sites_formId_fk` (`formId`),
  CONSTRAINT `freeform_forms_sites_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_forms_sites_siteId_fk` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_forms_translations`
--

DROP TABLE IF EXISTS `freeform_forms_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_forms_translations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `siteId` int NOT NULL,
  `translations` longtext NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_forms_translations_formId_siteId_unq_idx` (`formId`,`siteId`),
  KEY `freeform_forms_translations_siteId_fk` (`siteId`),
  CONSTRAINT `freeform_forms_translations_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_forms_translations_siteId_fk` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_integrations`
--

DROP TABLE IF EXISTS `freeform_integrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_integrations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `enabled` tinyint(1) DEFAULT '1',
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `class` varchar(255) DEFAULT NULL,
  `metadata` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`),
  KEY `freeform_integrations_type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_integrations_queue`
--

DROP TABLE IF EXISTS `freeform_integrations_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_integrations_queue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `submissionId` int NOT NULL,
  `integrationType` varchar(50) NOT NULL,
  `status` varchar(50) NOT NULL,
  `fieldHash` varchar(20) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_integrations_queue_status_idx` (`status`),
  KEY `freeform_integrations_queue_submissionId_fk` (`submissionId`),
  CONSTRAINT `freeform_integrations_queue_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_limited_users`
--

DROP TABLE IF EXISTS `freeform_limited_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_limited_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `settings` longtext NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_notification_log`
--

DROP TABLE IF EXISTS `freeform_notification_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_notification_log` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_notification_log_type_dateCreated_idx` (`type`,`dateCreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_notification_templates`
--

DROP TABLE IF EXISTS `freeform_notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_notification_templates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pdfTemplateIds` text,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `description` text,
  `fromName` varchar(255) NOT NULL,
  `fromEmail` varchar(255) NOT NULL,
  `replyToName` varchar(255) DEFAULT NULL,
  `replyToEmail` varchar(255) DEFAULT NULL,
  `cc` varchar(255) DEFAULT NULL,
  `bcc` varchar(255) DEFAULT NULL,
  `bodyHtml` mediumtext,
  `bodyText` mediumtext,
  `autoText` tinyint(1) NOT NULL DEFAULT '1',
  `includeAttachments` tinyint(1) DEFAULT '1',
  `presetAssets` varchar(255) DEFAULT NULL,
  `sortOrder` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_payments`
--

DROP TABLE IF EXISTS `freeform_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `integrationId` int NOT NULL,
  `fieldId` int NOT NULL,
  `submissionId` int NOT NULL,
  `resourceId` varchar(50) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `status` varchar(40) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `metadata` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_payments_integrationId_resourceId_unq_idx` (`integrationId`,`resourceId`),
  KEY `freeform_payments_integrationId_type_idx` (`integrationId`,`type`),
  KEY `freeform_payments_resourceId_idx` (`resourceId`),
  KEY `freeform_payments_fieldId_fk` (`fieldId`),
  KEY `freeform_payments_submissionId_fk` (`submissionId`),
  CONSTRAINT `freeform_payments_fieldId_fk` FOREIGN KEY (`fieldId`) REFERENCES `freeform_forms_fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_payments_integrationId_fk` FOREIGN KEY (`integrationId`) REFERENCES `freeform_integrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_payments_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_pdf_templates`
--

DROP TABLE IF EXISTS `freeform_pdf_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_pdf_templates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `fileName` text NOT NULL,
  `body` longtext NOT NULL,
  `sortOrder` int NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_rules`
--

DROP TABLE IF EXISTS `freeform_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_rules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `combinator` varchar(20) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_rules_buttons`
--

DROP TABLE IF EXISTS `freeform_rules_buttons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_rules_buttons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pageId` int NOT NULL,
  `button` varchar(30) NOT NULL,
  `display` varchar(10) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_bwpgunexbzlcjlaewbznhktnentcaaufnuyl` (`pageId`),
  CONSTRAINT `fk_bwpgunexbzlcjlaewbznhktnentcaaufnuyl` FOREIGN KEY (`pageId`) REFERENCES `freeform_forms_pages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_jiskhfgbijzctjwagwnbqvaxofgxiepnygym` FOREIGN KEY (`id`) REFERENCES `freeform_rules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_rules_conditions`
--

DROP TABLE IF EXISTS `freeform_rules_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_rules_conditions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ruleId` int NOT NULL,
  `fieldId` int NOT NULL,
  `operator` varchar(20) NOT NULL,
  `value` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_rules_conditions_ruleId_fk` (`ruleId`),
  KEY `fk_djzsgsqmnlybwiyekxlyluwheatipjvudscv` (`fieldId`),
  CONSTRAINT `fk_djzsgsqmnlybwiyekxlyluwheatipjvudscv` FOREIGN KEY (`fieldId`) REFERENCES `freeform_forms_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `freeform_rules_conditions_ruleId_fk` FOREIGN KEY (`ruleId`) REFERENCES `freeform_rules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_rules_fields`
--

DROP TABLE IF EXISTS `freeform_rules_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_rules_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldId` int NOT NULL,
  `display` varchar(10) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_mtminnrppfudjvhgtxyamqvxyivledxbvlwy` (`fieldId`),
  CONSTRAINT `fk_imwpzrxtvwcogikdppygfwwivzwvezwwehof` FOREIGN KEY (`id`) REFERENCES `freeform_rules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_mtminnrppfudjvhgtxyamqvxyivledxbvlwy` FOREIGN KEY (`fieldId`) REFERENCES `freeform_forms_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_rules_notifications`
--

DROP TABLE IF EXISTS `freeform_rules_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_rules_notifications` (
  `id` int NOT NULL AUTO_INCREMENT,
  `notificationId` int NOT NULL,
  `send` tinyint(1) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_pitrzkalyrontoxhnzwvwgzerkqrrphfeskl` (`notificationId`),
  CONSTRAINT `fk_pitrzkalyrontoxhnzwvwgzerkqrrphfeskl` FOREIGN KEY (`notificationId`) REFERENCES `freeform_forms_notifications` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_vtmlrkfoyevfvcmaonyxoklaxxyhiiueqiij` FOREIGN KEY (`id`) REFERENCES `freeform_rules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_rules_pages`
--

DROP TABLE IF EXISTS `freeform_rules_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_rules_pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `pageId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_inpfyjbplsybykmctlgzozqgfngoijxuxved` (`pageId`),
  CONSTRAINT `fk_inpfyjbplsybykmctlgzozqgfngoijxuxved` FOREIGN KEY (`pageId`) REFERENCES `freeform_forms_pages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_kboyvcefekngjyiazorakdvsxrttdtvfxjej` FOREIGN KEY (`id`) REFERENCES `freeform_rules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_rules_submit_form`
--

DROP TABLE IF EXISTS `freeform_rules_submit_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_rules_submit_form` (
  `id` int NOT NULL AUTO_INCREMENT,
  `formId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_pzahhzinhvqobjohypazypvhrrqootglthfm` (`formId`),
  CONSTRAINT `fk_pzahhzinhvqobjohypazypvhrrqootglthfm` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_usajcbvahvgagcbfghakwwahlkovqbtbuflg` FOREIGN KEY (`id`) REFERENCES `freeform_rules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_saved_forms`
--

DROP TABLE IF EXISTS `freeform_saved_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_saved_forms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sessionId` varchar(100) DEFAULT NULL,
  `formId` int NOT NULL,
  `token` varchar(100) NOT NULL,
  `payload` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_saved_forms_token_idx` (`token`),
  KEY `freeform_saved_forms_dateCreated_idx` (`dateCreated`),
  KEY `freeform_saved_forms_sessionId_idx` (`sessionId`),
  KEY `freeform_saved_forms_formId_fk` (`formId`),
  CONSTRAINT `freeform_saved_forms_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_session_context`
--

DROP TABLE IF EXISTS `freeform_session_context`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_session_context` (
  `id` int NOT NULL AUTO_INCREMENT,
  `contextKey` varchar(100) NOT NULL,
  `sessionId` varchar(100) NOT NULL,
  `formId` int NOT NULL,
  `propertyBag` longtext,
  `attributeBag` longtext,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_session_context_contextKey_formId_idx` (`contextKey`,`formId`),
  KEY `freeform_session_context_sessionId_idx` (`sessionId`),
  KEY `freeform_session_context_formId_fk` (`formId`),
  CONSTRAINT `freeform_session_context_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_spam_reason`
--

DROP TABLE IF EXISTS `freeform_spam_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_spam_reason` (
  `id` int NOT NULL AUTO_INCREMENT,
  `submissionId` int NOT NULL,
  `reasonType` varchar(100) NOT NULL,
  `reasonMessage` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_spam_reason_submissionId_reasonType_idx` (`submissionId`,`reasonType`),
  CONSTRAINT `freeform_spam_reason_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_statuses`
--

DROP TABLE IF EXISTS `freeform_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_statuses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `color` varchar(30) DEFAULT NULL,
  `sortOrder` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_submission_notes`
--

DROP TABLE IF EXISTS `freeform_submission_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_submission_notes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `submissionId` int NOT NULL,
  `note` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_submission_notes_submissionId_fk` (`submissionId`),
  CONSTRAINT `freeform_submission_notes_submissionId_fk` FOREIGN KEY (`submissionId`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_submissions`
--

DROP TABLE IF EXISTS `freeform_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_submissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `incrementalId` int NOT NULL,
  `userId` int DEFAULT NULL,
  `statusId` int DEFAULT NULL,
  `formId` int NOT NULL,
  `token` varchar(100) NOT NULL,
  `ip` varchar(46) DEFAULT NULL,
  `isSpam` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `freeform_submissions_incrementalId_unq_idx` (`incrementalId`),
  UNIQUE KEY `freeform_submissions_token_unq_idx` (`token`),
  KEY `freeform_submissions_userId_fk` (`userId`),
  KEY `freeform_submissions_formId_fk` (`formId`),
  KEY `freeform_submissions_statusId_fk` (`statusId`),
  CONSTRAINT `freeform_submissions_formId_fk` FOREIGN KEY (`formId`) REFERENCES `freeform_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_submissions_id_fk` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_submissions_statusId_fk` FOREIGN KEY (`statusId`) REFERENCES `freeform_statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_submissions_userId_fk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_submissions_contact_form_1`
--

DROP TABLE IF EXISTS `freeform_submissions_contact_form_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_submissions_contact_form_1` (
  `id` int NOT NULL,
  `full_name_2` text,
  `email_address_3` text,
  `subject_4` text,
  `message_5` text,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_hfpdfqqessmcesjrpsepyfeoevrsslsqhqsh` FOREIGN KEY (`id`) REFERENCES `freeform_submissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_survey_preferences`
--

DROP TABLE IF EXISTS `freeform_survey_preferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_survey_preferences` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `fieldId` int NOT NULL,
  `chartType` varchar(200) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_survey_preferences_userId_fk` (`userId`),
  KEY `fk_erthazjgoolritzezqyignsdbothblejsjeh` (`fieldId`),
  CONSTRAINT `fk_erthazjgoolritzezqyignsdbothblejsjeh` FOREIGN KEY (`fieldId`) REFERENCES `freeform_forms_fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `freeform_survey_preferences_userId_fk` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `freeform_unfinalized_files`
--

DROP TABLE IF EXISTS `freeform_unfinalized_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `freeform_unfinalized_files` (
  `id` int NOT NULL AUTO_INCREMENT,
  `assetId` int NOT NULL,
  `fieldHandle` varchar(255) DEFAULT NULL,
  `formToken` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `freeform_unfinalized_files_fieldHandle_formToken_idx` (`fieldHandle`,`formToken`),
  KEY `fk_iektemprsswndmoyzvbixscxuvihjqavvmzj` (`assetId`),
  CONSTRAINT `fk_iektemprsswndmoyzvbixscxuvihjqavvmzj` FOREIGN KEY (`assetId`) REFERENCES `assets` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globalsets`
--

DROP TABLE IF EXISTS `globalsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `globalsets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ltsmxnhtglnaybpfjxozowbebisshlutpvjd` (`name`),
  KEY `idx_jghwhdtcorvfdxkrhqwyuqinunivyzqgvcts` (`handle`),
  KEY `idx_oykywznbtntcprsumxviwbfjufesfsmuzelt` (`fieldLayoutId`),
  KEY `idx_lcqvfaoxpodeeyqxccpulqphfcvmexfudlsi` (`sortOrder`),
  CONSTRAINT `fk_ftbfcsikjzpsalqwiacoakfqqdvpcfowurbg` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jqlkbolqgmwhqtflqbkflfdycdiiwvmpxuxh` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqlschemas`
--

DROP TABLE IF EXISTS `gqlschemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqlschemas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `scope` json DEFAULT NULL,
  `isPublic` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqltokens`
--

DROP TABLE IF EXISTS `gqltokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqltokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `accessToken` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `expiryDate` datetime DEFAULT NULL,
  `lastUsed` datetime DEFAULT NULL,
  `schemaId` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_plsnwybzuuryjrppdkjysortnylwsqxsqwtp` (`accessToken`),
  UNIQUE KEY `idx_ydjdlpwocejdjpotubosnwthnydqzzfchabu` (`name`),
  KEY `fk_atxkbvccwucnndongrrcsimbxrjgybytwuke` (`schemaId`),
  CONSTRAINT `fk_atxkbvccwucnndongrrcsimbxrjgybytwuke` FOREIGN KEY (`schemaId`) REFERENCES `gqlschemas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransformindex`
--

DROP TABLE IF EXISTS `imagetransformindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransformindex` (
  `id` int NOT NULL AUTO_INCREMENT,
  `assetId` int NOT NULL,
  `transformer` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `transformString` varchar(255) NOT NULL,
  `fileExists` tinyint(1) NOT NULL DEFAULT '0',
  `inProgress` tinyint(1) NOT NULL DEFAULT '0',
  `error` tinyint(1) NOT NULL DEFAULT '0',
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_omaaxjlthufnxilduqeslqszayovywnfntri` (`assetId`,`transformString`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransforms`
--

DROP TABLE IF EXISTS `imagetransforms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransforms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `mode` enum('stretch','fit','crop','letterbox') NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') NOT NULL DEFAULT 'center-center',
  `width` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `quality` int DEFAULT NULL,
  `interlace` enum('none','line','plane','partition') NOT NULL DEFAULT 'none',
  `fill` varchar(11) DEFAULT NULL,
  `upscale` tinyint(1) NOT NULL DEFAULT '1',
  `parameterChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_iynmoiejpdxvasqmjwxkhsiupvjoenlazehq` (`name`),
  KEY `idx_mfyghahroneyhcvxdrrdtlskkhcbxibflkft` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `info`
--

DROP TABLE IF EXISTS `info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `info` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version` varchar(50) NOT NULL,
  `schemaVersion` varchar(15) NOT NULL,
  `maintenance` tinyint(1) NOT NULL DEFAULT '0',
  `configVersion` char(12) NOT NULL DEFAULT '000000000000',
  `fieldVersion` char(12) NOT NULL DEFAULT '000000000000',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `track` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_pimirngqrrxjqvtgtwhiccyebpfkehvmjcwj` (`track`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `plugins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `schemaVersion` varchar(255) NOT NULL,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vvuxxffwuhjwekpoeiigavjrrdryofmkipny` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `projectconfig`
--

DROP TABLE IF EXISTS `projectconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projectconfig` (
  `path` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) NOT NULL DEFAULT 'queue',
  `job` longblob NOT NULL,
  `description` text,
  `timePushed` int NOT NULL,
  `ttr` int NOT NULL,
  `delay` int NOT NULL DEFAULT '0',
  `priority` int unsigned NOT NULL DEFAULT '1024',
  `dateReserved` datetime DEFAULT NULL,
  `timeUpdated` int DEFAULT NULL,
  `progress` smallint NOT NULL DEFAULT '0',
  `progressLabel` varchar(255) DEFAULT NULL,
  `attempt` int DEFAULT NULL,
  `fail` tinyint(1) DEFAULT '0',
  `dateFailed` datetime DEFAULT NULL,
  `error` text,
  PRIMARY KEY (`id`),
  KEY `idx_eifnvoutjhcjdkojwsuzlxvqyzmafddlrwgx` (`channel`,`fail`,`timeUpdated`,`timePushed`),
  KEY `idx_vzklueuhoygkgwrqhhnwwohmzcircolsyfwj` (`channel`,`fail`,`timeUpdated`,`delay`)
) ENGINE=InnoDB AUTO_INCREMENT=3192 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recoverycodes`
--

DROP TABLE IF EXISTS `recoverycodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `recoverycodes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `recoveryCodes` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_dkyhfrhhrxtrbqdbsnvkhjefmcqwcgthorzu` (`userId`),
  CONSTRAINT `fk_dkyhfrhhrxtrbqdbsnvkhjefmcqwcgthorzu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relations`
--

DROP TABLE IF EXISTS `relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `relations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldId` int NOT NULL,
  `sourceId` int NOT NULL,
  `sourceSiteId` int DEFAULT NULL,
  `targetId` int NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_enkzxcltsjlilekiinsynbxusvrgvmqsvseu` (`fieldId`,`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_ujobuehswswaszkrgzyxneoesydgaazwvdrq` (`sourceId`),
  KEY `idx_qwuelohfqclpsssjufoyfexqmmnoqaszovzz` (`targetId`),
  KEY `idx_kzecapdoimrjfkystnpiiasimfmwlgbztbus` (`sourceSiteId`),
  CONSTRAINT `fk_owqpagjirwmweugecsygclkvsqrhlxkvsqnu` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pregezqjfptlbclfbfypixssemqfartffdez` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_zxnbhrboqjopibwbzcsoprtbnrsjbxhrxjqq` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `resourcepaths`
--

DROP TABLE IF EXISTS `resourcepaths`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `resourcepaths` (
  `hash` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `canonicalId` int NOT NULL,
  `creatorId` int DEFAULT NULL,
  `num` int NOT NULL,
  `notes` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tdiwwnnamgknjnuzrnzwabrjrnoxkufmfzua` (`canonicalId`,`num`),
  KEY `fk_hokcjtpbfjtxvakndepduuuprlgxgbpohkcg` (`creatorId`),
  CONSTRAINT `fk_hokcjtpbfjtxvakndepduuuprlgxgbpohkcg` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_koisuznttrjmatbnxlykwwtgjrrvmsrnvpja` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindex`
--

DROP TABLE IF EXISTS `searchindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindex` (
  `elementId` int NOT NULL,
  `attribute` varchar(25) NOT NULL,
  `fieldId` int NOT NULL,
  `siteId` int NOT NULL,
  `keywords` text NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`siteId`),
  FULLTEXT KEY `idx_nanqjsivzrfjikldlhgpjykktiisysrfyhir` (`keywords`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue`
--

DROP TABLE IF EXISTS `searchindexqueue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `reserved` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wercggpafcinskjndapdrfqsxpadmdxcppbr` (`elementId`,`siteId`,`reserved`),
  CONSTRAINT `fk_laydipahvktacasabnkbpklhmvqkxwpnpnhh` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue_fields`
--

DROP TABLE IF EXISTS `searchindexqueue_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue_fields` (
  `jobId` int NOT NULL,
  `fieldHandle` varchar(255) NOT NULL,
  PRIMARY KEY (`jobId`,`fieldHandle`),
  UNIQUE KEY `idx_jugivkkmjdhfnlzbypzmsejcbmmhflljqoxp` (`jobId`,`fieldHandle`),
  CONSTRAINT `fk_taheafrrqnhzltegzbxqxlkrhxigtplarcvk` FOREIGN KEY (`jobId`) REFERENCES `searchindexqueue` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` enum('single','channel','structure') NOT NULL DEFAULT 'channel',
  `enableVersioning` tinyint(1) NOT NULL DEFAULT '0',
  `maxAuthors` smallint unsigned DEFAULT NULL,
  `propagationMethod` varchar(255) NOT NULL DEFAULT 'all',
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `previewTargets` json DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_xiftxowkbamaitdqodnozvjpauxtfeminbnl` (`handle`),
  KEY `idx_slwywwajhfepxbhizvucbjsbhhaphsslxaqs` (`name`),
  KEY `idx_orucpqhvixlcuhxbhdvgjdbdekqecoibnlxu` (`structureId`),
  KEY `idx_dpgubgtzvajitptsuaarxftulagwbymajppz` (`dateDeleted`),
  CONSTRAINT `fk_uydxsbczsevydhrqxncwktnjlrmtlptepjzb` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_entrytypes`
--

DROP TABLE IF EXISTS `sections_entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_entrytypes` (
  `sectionId` int NOT NULL,
  `typeId` int NOT NULL,
  `sortOrder` smallint unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `handle` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`sectionId`,`typeId`),
  KEY `fk_urarprjejimmtuixomkwevgkrpntrwaucflh` (`typeId`),
  CONSTRAINT `fk_hnuknqyhmryhvkybcuqefpwabprctbyygueb` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_urarprjejimmtuixomkwevgkrpntrwaucflh` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_sites`
--

DROP TABLE IF EXISTS `sections_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sectionId` int NOT NULL,
  `siteId` int NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text,
  `template` varchar(500) DEFAULT NULL,
  `enabledByDefault` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_uqxqxdoylyxiptmemiwmnaiivtvhhuvtfejl` (`sectionId`,`siteId`),
  KEY `idx_wjjqnjeizbtozvxfsjqdgipbgsvbcwycchfd` (`siteId`),
  CONSTRAINT `fk_puqruxqkmxkbccshtifuypuxzubgmxtqowie` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_vudupuueqcvyawsdnyvalmntabmuybbexkun` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequences`
--

DROP TABLE IF EXISTS `sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequences` (
  `name` varchar(255) NOT NULL,
  `next` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `token` char(100) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nppwrduvhpxlqhzzrjcvveyswgtbaradhxhr` (`uid`),
  KEY `idx_sybqspjyiyphtoczjxmaabvtgkflnomlltdo` (`token`),
  KEY `idx_ccdqujjytctlavgdcxatmegntaffsswpzczc` (`dateUpdated`),
  KEY `idx_gomsmxonkgsxtnwrlhhnfvstimpdvhmakqah` (`userId`),
  CONSTRAINT `fk_wbdlgrjrssoarztjcfzxlsxsxukmhskrrkjv` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shunnedmessages`
--

DROP TABLE IF EXISTS `shunnedmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shunnedmessages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `message` varchar(255) NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_nwicnypcxvgbngxsgswvdlydurgwxhuojxet` (`userId`,`message`),
  CONSTRAINT `fk_cfwfmirjvtqtxpmkvyougeufvdvmdlavxzii` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitegroups`
--

DROP TABLE IF EXISTS `sitegroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sitegroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_irxqcahzcbcivbyyqsctjanwgypsjbbvizmd` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sites`
--

DROP TABLE IF EXISTS `sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `primary` tinyint(1) NOT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `language` varchar(255) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '0',
  `baseUrl` varchar(255) DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lcwhzznsumiefxncmpgscwgvdwkafewpgngr` (`dateDeleted`),
  KEY `idx_gfinmbqzskbvpnqurgiuuyxfzaehrlhaswul` (`handle`),
  KEY `idx_fgsjdxescolickrnwqjlqautpqchljovwrsu` (`sortOrder`),
  KEY `fk_mfvvulrkhtbcfdscsqtvrftkosmkygzpfwyr` (`groupId`),
  CONSTRAINT `fk_mfvvulrkhtbcfdscsqtvrftkosmkygzpfwyr` FOREIGN KEY (`groupId`) REFERENCES `sitegroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sso_identities`
--

DROP TABLE IF EXISTS `sso_identities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sso_identities` (
  `provider` varchar(255) NOT NULL,
  `identityId` varchar(255) NOT NULL,
  `userId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`provider`,`identityId`,`userId`),
  KEY `fk_qttwjfokmjwhupccrvsdmlesaevrjkxmieid` (`userId`),
  CONSTRAINT `fk_qttwjfokmjwhupccrvsdmlesaevrjkxmieid` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structureelements`
--

DROP TABLE IF EXISTS `structureelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `structureelements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int NOT NULL,
  `elementId` int DEFAULT NULL,
  `root` int unsigned DEFAULT NULL,
  `lft` int unsigned NOT NULL,
  `rgt` int unsigned NOT NULL,
  `level` smallint unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_owlksxgmjmgslxeyqhaqekexcuoczwgwstth` (`structureId`,`elementId`),
  KEY `idx_ceufmqubcctikgpezamffafmaxczccrbbvoq` (`root`),
  KEY `idx_jimiwzoqtjomnpeggcbooidomphvwwxqgmdj` (`lft`),
  KEY `idx_bjiavzlnjefkeoivpsedakaqufuynklncebw` (`rgt`),
  KEY `idx_tdefyryilwcpvqkhzpjxaharryhwoudqkogu` (`level`),
  KEY `idx_cjoouxucjcqbyqixukvkgqrgwziiwvevugmx` (`elementId`),
  CONSTRAINT `fk_axkwnoawwbttlbyrqnqiizqjktlpbsodxhik` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structures`
--

DROP TABLE IF EXISTS `structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `structures` (
  `id` int NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_eexlpvyqjnyvdvbajjodvmbcyorvcwhpdhdv` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systemmessages`
--

DROP TABLE IF EXISTS `systemmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `systemmessages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_rtpivtyachikemcmhoawykvddzmtoegljkwa` (`key`,`language`),
  KEY `idx_lznqiqipiiabjmjcltrnzkqteuktwvkvputg` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taggroups`
--

DROP TABLE IF EXISTS `taggroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `taggroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_cavovbkdqabohnzhacgkmwmsgmpehxmhjvky` (`name`),
  KEY `idx_ogfymfuuqrupymkfvsepjeqxyjbklhonefpb` (`handle`),
  KEY `idx_gnzwettqjzdzvfdmvtustzwfxdizbnlymeou` (`dateDeleted`),
  KEY `fk_lzbnweiqnegfohkgktacsrwhoweridorxjuv` (`fieldLayoutId`),
  CONSTRAINT `fk_lzbnweiqnegfohkgktacsrwhoweridorxjuv` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` int NOT NULL,
  `groupId` int NOT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_khfbxlxjevjdgcxfadptwjaapcxfcwkderou` (`groupId`),
  CONSTRAINT `fk_pbunmkecdiqbugbwvqmbeeuqskzuowyinbyh` FOREIGN KEY (`groupId`) REFERENCES `taggroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qfvhskxuvywffbcwmnvflbphgxmjxgrefbfo` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `token` char(32) NOT NULL,
  `route` text,
  `usageLimit` tinyint unsigned DEFAULT NULL,
  `usageCount` tinyint unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_earxpfofpwbwrcevawstykhtklmxdzbhreaw` (`token`),
  KEY `idx_xzitzwqbugumkennfwjdadfxawsyhwissyhe` (`expiryDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups`
--

DROP TABLE IF EXISTS `usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_jielbdmggbfghhmxxeuboqrkagxmuxdbzkjy` (`handle`),
  KEY `idx_vapuhuhdcwtfqvqbfsafhhbzstzisimkkcoj` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups_users`
--

DROP TABLE IF EXISTS `usergroups_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `userId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_zxopzewasscaqasvofoofyzauuigycinbqxv` (`groupId`,`userId`),
  KEY `idx_ssrxmjgkfwwavjoxfauvohvcxqitdgnweohe` (`userId`),
  CONSTRAINT `fk_nnapkcmblhqwmirmjkyyfpgvqydhfcvjfagw` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xrgjdexsggenahaiiyhyfmjflzcogjzclmvg` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions`
--

DROP TABLE IF EXISTS `userpermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_kfqrrzekpruvcaornomcwsskosjvedmlwtxe` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_usergroups`
--

DROP TABLE IF EXISTS `userpermissions_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_usergroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permissionId` int NOT NULL,
  `groupId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wbpuftgwjuoipsgmhuwjwhsuabqqakmunksv` (`permissionId`,`groupId`),
  KEY `idx_oeafaroayxizcjfmunypphvadhtzbzoodvpu` (`groupId`),
  CONSTRAINT `fk_feonataxdhbwhqpqmmhezshnvpetynokvwjm` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wpjmcaxrnugoqecufgjubzbsefsiaducuvvm` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_users`
--

DROP TABLE IF EXISTS `userpermissions_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permissionId` int NOT NULL,
  `userId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_srefkiitkvnhtstdgbdkrumxgqbdlnvsjjlt` (`permissionId`,`userId`),
  KEY `idx_tqvolpatmsjcmmtzeqsoglxpnmcwopvxohwc` (`userId`),
  CONSTRAINT `fk_aahgcpkwajittsmpklgrzysejdngmzblmaew` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rzpcfqxojenpnknroibhvmmmxhpjwxncniql` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpreferences`
--

DROP TABLE IF EXISTS `userpreferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpreferences` (
  `userId` int NOT NULL AUTO_INCREMENT,
  `preferences` json DEFAULT NULL,
  PRIMARY KEY (`userId`),
  CONSTRAINT `fk_xnhsmmkosidfvzonqnfzyoabxzdamlbpytje` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int NOT NULL,
  `photoId` int DEFAULT NULL,
  `affiliatedSiteId` int DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `username` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIp` varchar(45) DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `hasDashboard` tinyint(1) NOT NULL DEFAULT '0',
  `verificationCode` varchar(255) DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) DEFAULT NULL,
  `passwordResetRequired` tinyint(1) NOT NULL DEFAULT '0',
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_dyudwomaowhbclqssrlgcfflsafsolqudthw` (`active`),
  KEY `idx_vmwhedftujetbmtbabvxxjflglmezjodiqnq` (`locked`),
  KEY `idx_wnknvaxtupckusfddgrjcuzbbchjymekqinl` (`pending`),
  KEY `idx_yvhuxswafevevcpmekgkouklcnzmlrlhwyrr` (`suspended`),
  KEY `idx_lesizfgdumhlnwqcgdydmemdsboofrfpgfqy` (`verificationCode`),
  KEY `idx_wyzbezgmdbeswiquipjdnyswtqnlkoonrbjd` (`email`),
  KEY `idx_rhqpjccpduahdfvpwltdrgdsojynrdqtcdyq` (`username`),
  KEY `fk_qlfdbomhjmpiqnsdfwioprbyogemaqblzpfm` (`photoId`),
  KEY `fk_orzgxoqzvulqozwdifdxvfptgtunmwxbikfu` (`affiliatedSiteId`),
  CONSTRAINT `fk_echtcpnpfngojuydhpmpwzoxqhkyopufmspt` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_orzgxoqzvulqozwdifdxvfptgtunmwxbikfu` FOREIGN KEY (`affiliatedSiteId`) REFERENCES `sites` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qlfdbomhjmpiqnsdfwioprbyogemaqblzpfm` FOREIGN KEY (`photoId`) REFERENCES `assets` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumefolders`
--

DROP TABLE IF EXISTS `volumefolders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumefolders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parentId` int DEFAULT NULL,
  `volumeId` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_iwxblynufqzhhhwxtdyzgjwvnfsajrdsfpxf` (`name`,`parentId`,`volumeId`),
  KEY `idx_xpssnmfcrjjiqoxccohzgubijghfuwisrkno` (`parentId`),
  KEY `idx_gvtovqonnajjxqnfnnboemwcanmrpwetesgt` (`volumeId`),
  CONSTRAINT `fk_nsfwcolnpbgyxdtjwqbgjrasbwfigvwtobwr` FOREIGN KEY (`parentId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qjmoznhqkmjzecnbnjrovmboyqskblrayxxv` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fs` varchar(255) NOT NULL,
  `subpath` varchar(255) DEFAULT NULL,
  `transformFs` varchar(255) DEFAULT NULL,
  `transformSubpath` varchar(255) DEFAULT NULL,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text,
  `altTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `altTranslationKeyFormat` text,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_kxmnjoadzgfouclqydhpguzyvqbeflcuyrzl` (`name`),
  KEY `idx_wmfbxdehuoxfcyfndcsnrfgxarksialocgnd` (`handle`),
  KEY `idx_lphcgbxakozfidmcicizsscacfexavekojuo` (`fieldLayoutId`),
  KEY `idx_zleuppemowwycvouvliknasvknfovkrvjsbg` (`dateDeleted`),
  CONSTRAINT `fk_yoszwkzmuqzzryowmoqinujdfepaxoukehbc` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `webauthn`
--

DROP TABLE IF EXISTS `webauthn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `webauthn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `credentialId` varchar(255) DEFAULT NULL,
  `credential` text,
  `credentialName` varchar(255) DEFAULT NULL,
  `dateLastUsed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_sxlrhklzefegwwqjiceqgvhpzowkrimlkwjj` (`userId`),
  CONSTRAINT `fk_sxlrhklzefegwwqjiceqgvhpzowkrimlkwjj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `colspan` tinyint DEFAULT NULL,
  `settings` json DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qiboywljkntxitphmwujrsmnpndqrrqfkmyp` (`userId`),
  CONSTRAINT `fk_amhylosbclgkfoffzshmlzgklzybckursymf` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'robmartinomusic_db'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-07-02 23:31:24
-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: robmartinomusic_db
-- ------------------------------------------------------
-- Server version	8.0.42-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `addresses`
--

LOCK TABLES `addresses` WRITE;
/*!40000 ALTER TABLE `addresses` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `addresses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assetindexingsessions`
--

LOCK TABLES `assetindexingsessions` WRITE;
/*!40000 ALTER TABLE `assetindexingsessions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `assetindexingsessions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets` VALUES (4,1,1,3,'hobbe-logo.png','image',NULL,150,138,30581,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 22:55:40','2024-12-23 17:06:42'),(6,1,1,NULL,'8static-dominos.jpg','image',NULL,1600,1065,316965,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:22','2024-12-23 17:06:44'),(7,1,1,NULL,'about.jpg','image',NULL,1500,998,407741,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:24','2024-12-23 17:06:41'),(8,1,1,NULL,'bitgen.jpg','image',NULL,2500,1667,914454,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:26','2024-12-23 17:06:42'),(9,1,1,NULL,'gallery-1.jpg','image',NULL,1500,998,320171,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:28','2024-12-23 17:06:44'),(10,1,1,NULL,'gallery-2.jpg','image',NULL,827,550,76765,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:31','2024-12-23 17:06:43'),(11,1,1,NULL,'gallery-3.jpg','image',NULL,750,499,152482,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:33','2024-12-23 17:06:43'),(12,1,1,NULL,'gallery-6.jpg','image',NULL,750,499,165923,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:35','2024-12-23 17:06:45'),(13,1,1,NULL,'gallery-7.jpg','image',NULL,750,534,99141,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:37','2024-12-23 17:06:42'),(14,1,1,NULL,'home-bg-mobile.jpg','image',NULL,1020,1528,418037,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:44','2024-12-23 17:06:44'),(15,1,1,NULL,'sentry-bar-feb2020-alt.jpg','image',NULL,1200,990,274469,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:46','2024-12-23 17:06:43'),(16,1,1,NULL,'sentry-bar-feb2020.jpg','image',NULL,1200,990,290033,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:48','2024-12-23 17:06:42'),(17,2,2,NULL,'rob-video.mp4','video',NULL,NULL,NULL,13626212,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-11 23:02:51','2024-12-23 17:06:45'),(48,1,1,3,'Drums_Blue.jpg','image',NULL,2048,1152,361433,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-12 18:57:18','2024-12-23 17:06:43'),(49,1,1,3,'nmlstyl.jpg','image',NULL,960,960,104793,NULL,NULL,NULL,'2023-11-10 03:31:58','2023-06-12 18:57:26','2024-12-23 17:06:43'),(114,1,7,3,'nmlstyl-bitgen13.jpg','image',NULL,640,480,56026,NULL,NULL,NULL,'2024-12-13 21:57:44','2024-12-23 17:20:53','2025-05-02 16:05:08'),(117,1,7,3,'nmlstyl-magfest2020.jpg','image',NULL,640,480,53566,NULL,NULL,NULL,'2024-12-13 21:58:34','2024-12-23 17:21:33','2025-05-02 16:05:08'),(120,1,7,3,'black-monday.jpg','image',NULL,640,480,74195,NULL,NULL,NULL,'2024-12-13 21:58:54','2024-12-23 17:21:44','2025-05-02 16:05:07'),(123,1,7,3,'110percent.jpg','image',NULL,640,480,59079,NULL,NULL,NULL,'2024-12-13 21:59:04','2024-12-23 17:21:54','2025-05-02 16:05:08'),(201,1,1,3,'face-new.png','image',NULL,150,138,21550,NULL,NULL,NULL,'2025-05-02 16:14:16','2025-05-02 16:14:16','2025-05-02 16:14:16'),(202,1,1,3,'hobbe-favicon.png','image',NULL,32,32,2468,NULL,NULL,NULL,'2025-05-02 16:14:21','2025-05-02 16:14:21','2025-05-02 16:14:21');
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets_sites`
--

LOCK TABLES `assets_sites` WRITE;
/*!40000 ALTER TABLE `assets_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets_sites` VALUES (4,1,NULL),(6,1,NULL),(7,1,NULL),(8,1,NULL),(9,1,NULL),(10,1,NULL),(11,1,NULL),(12,1,NULL),(13,1,NULL),(14,1,NULL),(15,1,NULL),(16,1,NULL),(17,1,NULL),(48,1,NULL),(49,1,NULL),(114,1,NULL),(117,1,NULL),(120,1,NULL),(123,1,NULL),(201,1,NULL),(202,1,NULL);
/*!40000 ALTER TABLE `assets_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `authenticator`
--

LOCK TABLES `authenticator` WRITE;
/*!40000 ALTER TABLE `authenticator` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `authenticator` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `bulkopevents`
--

LOCK TABLES `bulkopevents` WRITE;
/*!40000 ALTER TABLE `bulkopevents` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `bulkopevents` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups`
--

LOCK TABLES `categorygroups` WRITE;
/*!40000 ALTER TABLE `categorygroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups_sites`
--

LOCK TABLES `categorygroups_sites` WRITE;
/*!40000 ALTER TABLE `categorygroups_sites` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedattributes`
--

LOCK TABLES `changedattributes` WRITE;
/*!40000 ALTER TABLE `changedattributes` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `changedattributes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedfields`
--

LOCK TABLES `changedfields` WRITE;
/*!40000 ALTER TABLE `changedfields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `changedfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `craftidtokens`
--

LOCK TABLES `craftidtokens` WRITE;
/*!40000 ALTER TABLE `craftidtokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `craftidtokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `deprecationerrors`
--

LOCK TABLES `deprecationerrors` WRITE;
/*!40000 ALTER TABLE `deprecationerrors` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `deprecationerrors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `drafts`
--

LOCK TABLES `drafts` WRITE;
/*!40000 ALTER TABLE `drafts` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `drafts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elementactivity`
--

LOCK TABLES `elementactivity` WRITE;
/*!40000 ALTER TABLE `elementactivity` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `elementactivity` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements`
--

LOCK TABLES `elements` WRITE;
/*!40000 ALTER TABLE `elements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements` VALUES (1,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2023-06-11 22:50:14','2024-12-23 16:55:42',NULL,NULL,NULL,'14862431-9caa-4513-8969-b28c40be6302'),(2,NULL,NULL,NULL,10,'craft\\elements\\GlobalSet',1,0,'2023-06-11 22:50:15','2025-05-02 16:14:24',NULL,NULL,NULL,'4fa68a9e-b36c-4280-b726-dfd06429714e'),(3,NULL,NULL,NULL,NULL,'craft\\elements\\User',1,0,'2023-06-11 22:50:19','2024-08-24 00:03:00',NULL,NULL,NULL,'70a67f1c-6522-44c6-b053-4bb5507ed063'),(4,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 22:55:39','2025-05-02 16:14:37',NULL,NULL,NULL,'650496c3-4aee-454a-b5fa-4cf23fb46c87'),(6,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:22','2025-05-02 16:14:42',NULL,NULL,NULL,'e6a4c5b0-f1ad-428b-b932-295d6336c491'),(7,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:24','2025-05-02 16:14:37',NULL,NULL,NULL,'5a00bba2-e2d1-4c75-9388-ef5e0c67abef'),(8,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:26','2025-05-02 16:14:39',NULL,NULL,NULL,'2ec379e2-089d-40b5-9334-fd0de9e0fb39'),(9,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:28','2025-05-02 16:14:43',NULL,NULL,NULL,'205adaee-3b0a-44f5-bfa0-1a6e5fd53ad7'),(10,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:31','2025-05-02 16:14:39',NULL,NULL,NULL,'c0ff0753-c746-4edc-abdb-324e73bafd58'),(11,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:33','2025-05-02 16:14:41',NULL,NULL,NULL,'b6c57ba5-b3f0-4e41-b491-d0096a079e8a'),(12,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:35','2025-05-02 16:14:43',NULL,NULL,NULL,'4772ff72-35c9-402d-8375-8caeb312e374'),(13,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:37','2025-05-02 16:14:37',NULL,NULL,NULL,'ddf9cecf-1c3d-4bc0-a31e-e72514d48b26'),(14,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:44','2025-05-02 16:14:42',NULL,NULL,NULL,'3eb9519a-64e7-4f1c-8520-0af9d5a9c493'),(15,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:46','2025-05-02 16:14:40',NULL,NULL,NULL,'94de797a-2ee3-402c-bf80-eeebb6055524'),(16,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:48','2025-05-02 16:14:37',NULL,NULL,NULL,'f4863303-49f1-40c6-8da3-2d1d0c324a35'),(17,NULL,NULL,NULL,12,'craft\\elements\\Asset',1,0,'2023-06-11 23:02:51','2025-05-02 16:05:14',NULL,NULL,NULL,'43fa8cbe-cdc0-475d-b8fe-a9163b99205b'),(18,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2023-06-11 23:03:41','2024-12-23 17:25:31',NULL,NULL,NULL,'12405f17-4b88-4fde-a4b5-ad8b3a4f0548'),(19,18,NULL,1,2,'craft\\elements\\Entry',1,0,'2023-06-11 23:04:18','2023-06-11 23:04:18',NULL,NULL,NULL,'c07bcfa8-7b38-4c9a-8f5a-7d7552324521'),(20,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2023-06-11 23:04:18','2024-12-23 17:11:06',NULL,NULL,NULL,'f67ccd88-1cf2-4411-80a8-13d36a5ee8a2'),(21,20,NULL,2,2,'craft\\elements\\Entry',1,0,'2023-06-11 23:04:55','2023-06-11 23:04:55',NULL,NULL,NULL,'38d6b00c-3c3f-49eb-bea8-9db11e4122f7'),(22,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2023-06-11 23:05:19','2024-12-23 17:08:55',NULL,NULL,NULL,'071075f6-b388-4da9-861c-69a7e7336fb8'),(23,22,NULL,3,2,'craft\\elements\\Entry',1,0,'2023-06-11 23:05:53','2023-06-11 23:05:54',NULL,NULL,NULL,'19bfe641-ad8b-430b-9da5-6a9814542ba2'),(24,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2023-06-11 23:05:54','2024-12-23 17:29:11',NULL,NULL,NULL,'3952af60-93ed-428b-a087-7954e118b3ff'),(25,24,NULL,4,5,'craft\\elements\\Entry',1,0,'2023-06-11 23:07:20','2023-06-11 23:07:20',NULL,NULL,NULL,'6688da1e-2d16-4e0d-8929-bb623c623aed'),(26,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2023-06-11 23:07:20','2024-12-23 17:07:38',NULL,NULL,NULL,'191ad9b1-7308-4028-8c37-0f40426fd70d'),(27,26,NULL,5,2,'craft\\elements\\Entry',1,0,'2023-06-11 23:09:22','2023-06-11 23:09:22',NULL,NULL,NULL,'41350205-a532-48b0-b660-cdefac1bd5e9'),(28,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2023-06-11 23:10:38','2023-06-11 23:13:39',NULL,NULL,NULL,'2a8590c9-d89e-4af9-98dd-c604d5de6327'),(29,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2023-06-11 23:13:39','2023-06-11 23:15:36',NULL,NULL,NULL,'2fadbd75-b3f4-4836-a652-79d31fdcb6d9'),(30,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2023-06-11 23:15:36','2023-06-11 23:18:24',NULL,NULL,NULL,'49a31bd3-0b20-4064-8277-f019b527ce34'),(31,NULL,NULL,NULL,8,'craft\\elements\\Entry',1,0,'2023-06-11 23:18:24','2023-06-11 23:19:24',NULL,NULL,NULL,'b1998339-1e0e-48c1-95e5-7c53021d22f6'),(32,NULL,NULL,NULL,7,'craft\\elements\\Entry',1,0,'2023-06-11 23:19:24','2023-06-11 23:21:54',NULL,NULL,NULL,'48d902a0-279b-4d18-ac8f-7c8d93d23c4c'),(33,NULL,NULL,NULL,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:22:47','2024-12-23 17:21:56',NULL,NULL,NULL,'c8f68cd4-0b74-4bcb-8881-c4792af8cf01'),(34,33,NULL,6,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:24:30','2023-06-11 23:24:30',NULL,NULL,NULL,'e2a3c207-94c7-4ad7-91c6-e4edd93162cc'),(35,NULL,NULL,NULL,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:24:30','2024-12-23 17:21:47',NULL,NULL,NULL,'fa9fa8bc-bc59-4033-87d8-5a93e6ed19cf'),(36,35,NULL,7,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:25:49','2023-06-11 23:25:49',NULL,NULL,NULL,'a42ef3e9-7c3f-4991-9636-198243cb2128'),(37,NULL,NULL,NULL,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:25:49','2023-06-11 23:27:16',NULL,NULL,NULL,'32a642d6-2b98-44ac-a017-b82386051dbb'),(38,37,NULL,8,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:27:16','2023-06-11 23:27:16',NULL,NULL,NULL,'fe431de8-38dc-4394-86e7-dd8646ce7223'),(39,NULL,NULL,NULL,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:27:16','2024-12-23 17:21:36',NULL,NULL,NULL,'be74fdea-c642-4254-be4a-fd123adc84ab'),(40,39,NULL,9,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:28:53','2023-06-11 23:28:53',NULL,NULL,NULL,'481cf8d3-e085-4956-815f-6d43b9471b6d'),(41,NULL,NULL,NULL,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:28:53','2024-12-23 17:21:24',NULL,NULL,NULL,'e5241ec1-c762-4f17-9749-a07eea099f1d'),(42,41,NULL,10,9,'craft\\elements\\Entry',1,0,'2023-06-11 23:29:55','2023-06-11 23:29:55',NULL,NULL,NULL,'65912094-69ff-49fd-b047-68a5c87bd67d'),(48,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-12 18:57:17','2025-05-02 16:14:41',NULL,NULL,NULL,'24287c2a-7ef3-4bbb-b1a0-568e4e4724f7'),(49,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2023-06-12 18:57:24','2025-05-02 16:14:40',NULL,NULL,NULL,'52060e17-848d-40f2-ae85-19dab9fdc85c'),(51,24,NULL,11,5,'craft\\elements\\Entry',1,0,'2023-06-12 18:58:07','2023-06-12 18:58:07',NULL,NULL,NULL,'734fb5c5-e202-4546-88cf-ef97fab7544a'),(82,NULL,NULL,NULL,24,'craft\\elements\\GlobalSet',1,0,'2024-12-23 16:39:52','2024-12-23 17:09:39',NULL,NULL,NULL,'4b1a0293-717c-4678-95cd-9432e1a591c6'),(86,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2024-12-23 17:06:30','2024-12-23 17:07:38',NULL,NULL,NULL,'6026bb4f-263e-4800-b679-a2cc9c1961bf'),(87,26,NULL,12,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:06:30','2024-12-23 17:06:30',NULL,NULL,NULL,'05726072-a1fe-403f-905f-413e30680fbd'),(88,86,NULL,13,23,'craft\\elements\\Entry',1,0,'2024-12-23 17:06:30','2024-12-23 17:06:30',NULL,NULL,NULL,'d638f31a-3cb2-4255-ac6d-311c6c33b394'),(91,26,NULL,14,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:07:38','2024-12-23 17:07:38',NULL,NULL,NULL,'7a043844-fc23-4ee4-9f1c-ad0e0891378c'),(92,86,NULL,15,23,'craft\\elements\\Entry',1,0,'2024-12-23 17:07:38','2024-12-23 17:07:38',NULL,NULL,NULL,'957a8242-3886-4bd6-ac4a-21b697e45735'),(95,NULL,NULL,NULL,16,'craft\\elements\\Entry',1,0,'2024-12-23 17:08:55','2024-12-23 17:08:55',NULL,NULL,NULL,'02609c71-6c98-449d-965a-d63ba746592d'),(96,22,NULL,16,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:08:55','2024-12-23 17:08:55',NULL,NULL,NULL,'b3aa2049-9dbc-48fd-afeb-3896ecc4ce60'),(97,95,NULL,17,16,'craft\\elements\\Entry',1,0,'2024-12-23 17:08:55','2024-12-23 17:08:55',NULL,NULL,NULL,'163841cb-5a4a-46ee-b903-bbb914b1a263'),(101,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2024-12-23 17:11:06','2024-12-23 17:11:06',NULL,NULL,NULL,'2a7887de-03b3-4ad1-a44a-2a203e8a2e9c'),(102,NULL,NULL,NULL,17,'craft\\elements\\Entry',1,0,'2024-12-23 17:11:06','2024-12-23 17:11:06',NULL,NULL,NULL,'7e6b26df-984c-42d0-a6ed-0f2ef198c2a9'),(103,20,NULL,18,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:11:06','2024-12-23 17:11:06',NULL,NULL,NULL,'af1629de-d0b2-440d-af14-ac0ca37a90b8'),(104,101,NULL,19,18,'craft\\elements\\Entry',1,0,'2024-12-23 17:11:06','2024-12-23 17:11:06',NULL,NULL,NULL,'2d9e9d00-3f7e-4ce2-9f4c-91d3dd3b5c34'),(105,102,NULL,20,17,'craft\\elements\\Entry',1,0,'2024-12-23 17:11:06','2024-12-23 17:11:06',NULL,NULL,NULL,'c648e613-4281-4ec2-b697-9a880c0b6db8'),(114,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2024-12-23 17:20:53','2025-05-02 16:14:38',NULL,NULL,NULL,'3175a231-44ff-47dc-8c40-0dfa7c284cbf'),(116,41,NULL,21,9,'craft\\elements\\Entry',1,0,'2024-12-23 17:21:24','2024-12-23 17:21:24',NULL,NULL,NULL,'7f517f4d-550a-41b1-ac2d-f1a5230c3652'),(117,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2024-12-23 17:21:33','2025-05-02 16:14:38',NULL,NULL,NULL,'dde20f3c-815b-4a32-b932-25010c562528'),(119,39,NULL,22,9,'craft\\elements\\Entry',1,0,'2024-12-23 17:21:36','2024-12-23 17:21:36',NULL,NULL,NULL,'9a47176c-7356-40e8-9305-228d0a98923f'),(120,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2024-12-23 17:21:44','2025-05-02 16:14:38',NULL,NULL,NULL,'ae8d9bfc-e846-46e9-8079-aa160181a066'),(122,35,NULL,23,9,'craft\\elements\\Entry',1,0,'2024-12-23 17:21:47','2024-12-23 17:21:47',NULL,NULL,NULL,'072c4703-9966-46dd-b15b-4acb0210ee7c'),(123,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2024-12-23 17:21:54','2025-05-02 16:14:39',NULL,NULL,NULL,'baf2aa0f-3cf4-4b72-8443-bc03b1d3e672'),(125,33,NULL,24,9,'craft\\elements\\Entry',1,0,'2024-12-23 17:21:56','2024-12-23 17:21:56',NULL,NULL,NULL,'0ea71c6e-009a-4af2-a668-e035d4d893f7'),(128,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2024-12-23 17:24:00','2024-12-23 17:24:00',NULL,NULL,NULL,'f12b363a-5627-4dcf-b299-a45c59d968d2'),(129,18,NULL,25,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:24:00','2024-12-23 17:24:00',NULL,NULL,NULL,'f0fe6c82-905f-4477-8155-ff2efa32e7f8'),(130,128,NULL,26,19,'craft\\elements\\Entry',1,0,'2024-12-23 17:24:00','2024-12-23 17:24:01',NULL,NULL,NULL,'4693c4fa-a379-49cb-998c-a91a3999cc14'),(133,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2024-12-23 17:25:10','2024-12-23 17:25:31',NULL,NULL,NULL,'862a378a-88bd-4e14-abd1-d90ba47c7d28'),(134,18,NULL,27,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:25:10','2024-12-23 17:25:10',NULL,NULL,NULL,'feac1d62-44cf-476f-bf71-10c2db1485e4'),(135,133,NULL,28,15,'craft\\elements\\Entry',1,0,'2024-12-23 17:25:10','2024-12-23 17:25:10',NULL,NULL,NULL,'34d41c57-fe89-49e8-8322-bea5a9d2e36f'),(138,18,NULL,29,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:25:31','2024-12-23 17:25:31',NULL,NULL,NULL,'bc1afd11-60a8-46c5-8f48-b91589d92d78'),(139,133,NULL,30,15,'craft\\elements\\Entry',1,0,'2024-12-23 17:25:31','2024-12-23 17:25:31',NULL,NULL,NULL,'03f60edb-ecce-4a2e-a24f-27518c1933c2'),(142,NULL,NULL,NULL,22,'craft\\elements\\Entry',1,0,'2024-12-23 17:28:05','2024-12-23 17:29:11',NULL,NULL,NULL,'730ecefb-6ee1-41ac-b307-a42c2158459b'),(143,24,NULL,31,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:28:05','2024-12-23 17:28:05',NULL,NULL,NULL,'93303509-2c52-431d-8df0-415a97c6f580'),(144,142,NULL,32,22,'craft\\elements\\Entry',1,0,'2024-12-23 17:28:05','2024-12-23 17:28:05',NULL,NULL,NULL,'80ec1dc3-3246-4d9a-97cf-b54cd8d03851'),(147,24,NULL,33,21,'craft\\elements\\Entry',1,0,'2024-12-23 17:29:11','2024-12-23 17:29:11',NULL,NULL,NULL,'d4e18999-d53a-4358-bd79-e6f62fbea974'),(148,142,NULL,34,22,'craft\\elements\\Entry',1,0,'2024-12-23 17:29:11','2024-12-23 17:29:11',NULL,NULL,NULL,'e254bb35-256d-418f-822f-ab6ae758d945'),(149,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2024-12-25 17:56:26','2024-12-25 17:56:26',NULL,NULL,NULL,'9dd40bfb-ad87-4e40-b63a-d0b6c1cf3930'),(150,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2024-12-28 18:45:41','2024-12-28 18:45:42',NULL,NULL,NULL,'a3fe01be-fd12-436a-b1a7-033c64c06c11'),(151,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2024-12-31 07:15:51','2024-12-31 07:15:51',NULL,NULL,NULL,'e9f7e401-4f06-4b66-806f-12603d3d69cd'),(152,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-03 03:28:43','2025-01-03 03:28:43',NULL,NULL,NULL,'f91c8abc-ea60-46c4-95cd-39078e6e2996'),(153,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-16 10:55:55','2025-01-16 10:55:55',NULL,NULL,NULL,'97f97ee7-8f6a-47dd-85ff-965fed26f2ea'),(154,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-16 20:57:50','2025-01-16 20:57:50',NULL,NULL,NULL,'13b3dd99-a14f-4181-ac87-9521f9cc28b2'),(155,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-17 16:27:50','2025-01-17 16:27:50',NULL,NULL,NULL,'c99a461c-edf8-488b-94c4-3f78246f7ed6'),(156,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-25 02:12:52','2025-01-25 02:12:52',NULL,NULL,NULL,'d8b833d1-12fe-45e1-b29b-cd5e03b3d5cf'),(157,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-29 20:59:54','2025-01-29 20:59:54',NULL,NULL,NULL,'cf7e72c8-3a37-419c-8013-c715c890e378'),(158,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-31 08:42:58','2025-01-31 08:42:58',NULL,NULL,NULL,'8c83367d-4281-476f-a7e6-2c4a67f5d88a'),(159,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-01-31 08:56:43','2025-01-31 08:56:43',NULL,NULL,NULL,'3e9de4d4-5870-4cf3-8747-82e668b99624'),(160,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-04 08:53:55','2025-02-04 08:53:55',NULL,NULL,NULL,'e9f0516b-b6ef-4416-b658-4ddcecaf22ec'),(161,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-05 05:25:10','2025-02-05 05:25:10',NULL,NULL,NULL,'6504744b-1423-4457-868d-4381ba372dcd'),(162,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-05 22:54:44','2025-02-05 22:54:44',NULL,NULL,NULL,'1d7ff64b-06b8-4f89-98fb-f65f38aaa4f2'),(163,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-14 11:18:31','2025-02-18 01:48:55',NULL,NULL,NULL,'756cb999-cd97-4e20-a23f-4e2209c607ec'),(164,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-18 21:54:34','2025-02-18 21:54:34',NULL,NULL,NULL,'e331f94c-6223-48fc-a8f6-8aadbe211bc6'),(165,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-19 18:27:16','2025-02-19 18:27:16',NULL,NULL,NULL,'c77fcaae-40d3-4c7b-9b5f-31dee4148f8e'),(166,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-21 03:04:15','2025-02-21 03:04:15',NULL,NULL,NULL,'b8fe8a57-150f-4811-a6a7-147310747af4'),(167,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-22 22:56:10','2025-02-22 22:56:10',NULL,NULL,NULL,'01944825-21ce-453a-8639-8fe780aacd25'),(168,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-23 10:55:10','2025-02-23 10:55:11',NULL,NULL,NULL,'be071a59-d0f2-4e7f-a317-b280491deab7'),(169,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-02-24 18:57:07','2025-02-24 18:57:07',NULL,NULL,NULL,'8ae6026a-4049-469b-b979-cdef302a33b8'),(170,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-03 12:27:33','2025-03-03 12:27:33',NULL,NULL,NULL,'210aea2a-e676-4e9a-a76b-d040a418f450'),(171,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-03 22:03:03','2025-03-03 22:03:03',NULL,NULL,NULL,'92f6b6be-3602-4aee-bcc4-bf20b683ead3'),(172,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-05 14:39:17','2025-03-05 14:39:17',NULL,NULL,NULL,'d3b43690-2bcf-40fc-9a2a-cfd6bf2120dd'),(173,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-06 20:26:41','2025-03-06 20:26:41',NULL,NULL,NULL,'b6357d09-aac7-4f98-87b8-3b7d646dd5e0'),(174,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-11 06:26:01','2025-03-11 06:26:01',NULL,NULL,NULL,'94f0e63b-636d-48c7-bfef-c7b29c752b66'),(175,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-18 21:52:25','2025-03-18 21:52:25',NULL,NULL,NULL,'ba592d6f-cc5b-4931-842f-1c106afc80a1'),(176,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-21 14:55:16','2025-03-21 14:55:16',NULL,NULL,NULL,'a66a68e1-1a6d-4eff-acff-baf7915d511e'),(177,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-23 21:24:34','2025-03-23 21:24:34',NULL,NULL,NULL,'f00602c0-bec3-4704-a3ae-22e770a9c02a'),(178,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-24 09:24:28','2025-03-24 09:24:28',NULL,NULL,NULL,'71ac2a4e-2947-46f4-84c9-6b1a9ca43f1e'),(179,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-25 16:22:21','2025-03-25 16:22:21',NULL,NULL,NULL,'8c4982f2-26c9-454e-898d-fd60ba1e4bb9'),(180,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-27 01:23:02','2025-03-27 01:23:02',NULL,NULL,NULL,'b5afa86c-44fb-48fe-9ab3-463c96e49c9f'),(181,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-27 17:23:07','2025-03-27 17:23:07',NULL,NULL,NULL,'65ef2ce8-1f2e-44df-a55a-52edc4bff4c8'),(182,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-29 21:52:28','2025-03-29 21:52:28',NULL,NULL,NULL,'53bcf173-9b2c-4b6f-ae99-c978d3e236e5'),(183,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-03-31 22:23:23','2025-03-31 22:23:23',NULL,NULL,NULL,'df08355b-8c89-478a-a207-1c591c938be7'),(184,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-01 00:52:59','2025-04-01 00:52:59',NULL,NULL,NULL,'8db41e2d-b710-460f-a0f6-fb62aca66122'),(185,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-02 04:52:06','2025-04-02 04:52:06',NULL,NULL,NULL,'d90a4bc7-9277-42ad-9259-ac9e3e02455a'),(186,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-10 04:05:45','2025-04-10 04:05:45',NULL,NULL,NULL,'780f4976-7695-4eb6-b2d9-97d580e24ce9'),(187,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-11 19:39:08','2025-04-11 19:39:08',NULL,NULL,NULL,'342b80f3-8dbf-4557-b78a-ef8d2feb8fba'),(188,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-12 03:53:33','2025-04-12 03:53:33',NULL,NULL,NULL,'d88e04f5-e1eb-49fd-a478-84b32d2ea20e'),(189,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-13 13:23:39','2025-04-13 13:23:39',NULL,NULL,NULL,'c60faacf-185b-40dd-aa69-82a3838ed7a7'),(190,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-17 01:41:07','2025-04-17 01:41:07',NULL,NULL,NULL,'2b6043c0-294e-4c44-bbac-c1bedb076f88'),(191,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-20 16:42:42','2025-04-20 16:42:42',NULL,NULL,NULL,'97f0e86c-3f3b-40d9-b7ae-b9d03c37ccf9'),(192,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-21 10:42:51','2025-04-21 10:42:51',NULL,NULL,NULL,'deddf62e-fd4a-4763-8e0f-ca50b4a66c84'),(193,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-22 20:47:58','2025-04-22 20:47:58',NULL,NULL,NULL,'2cb609d2-b710-4727-b7fe-c0b458a84acd'),(194,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-24 16:23:16','2025-04-24 16:23:16',NULL,NULL,NULL,'5cd74dbf-c2f5-4f84-9051-d93cc42704d8'),(195,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-26 05:25:10','2025-04-26 05:25:10',NULL,NULL,NULL,'75c9cf3b-bb40-40ee-9aac-f1175443c027'),(196,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-27 07:57:52','2025-04-27 07:57:52',NULL,NULL,NULL,'90008344-1780-45b8-972d-365993f1f44d'),(197,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-04-27 20:08:59','2025-04-27 20:08:59',NULL,NULL,NULL,'aeaf709b-1122-4e58-b355-a2a915751c0b'),(201,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2025-05-02 16:14:16','2025-05-02 16:14:41',NULL,NULL,NULL,'7a766920-f05d-49cc-adc9-be88f314c35c'),(202,NULL,NULL,NULL,11,'craft\\elements\\Asset',1,0,'2025-05-02 16:14:21','2025-05-02 16:14:40',NULL,NULL,NULL,'6e82fa90-4994-4a13-bec1-7037447c1798'),(203,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-02 17:12:28','2025-05-02 17:12:28',NULL,NULL,NULL,'10ecc42e-0769-469a-87dc-664dbe4ec993'),(204,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-06 09:25:00','2025-05-06 09:25:00',NULL,NULL,NULL,'5aec0d2c-aa90-4264-b1cc-7531c77b0d0b'),(205,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-07 13:34:27','2025-05-07 13:34:27',NULL,NULL,NULL,'07cff9e6-7475-4412-8ea5-9d1bbcb45393'),(206,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-10 10:43:36','2025-05-10 10:43:37',NULL,NULL,NULL,'50c2acb8-e13e-4d7e-9bb3-80d80f8aa33d'),(207,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-16 04:25:45','2025-05-16 04:25:45',NULL,NULL,NULL,'5c17d623-a377-4850-919e-b608101f756d'),(208,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-18 06:55:56','2025-05-18 06:55:57',NULL,NULL,NULL,'332093b4-bd0b-40b4-b93e-5891ac32226a'),(209,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-20 20:38:05','2025-05-20 20:38:05',NULL,NULL,NULL,'89514896-750a-4545-916e-ce6fdfbfddc5'),(210,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-21 16:17:26','2025-05-21 16:17:26',NULL,NULL,NULL,'f13a234c-22f0-4111-a444-00e20b27dc20'),(211,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-05-23 09:56:42','2025-05-23 09:56:42',NULL,NULL,NULL,'7227e17f-419b-4d06-978a-223e36b60c4c'),(212,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-06-13 22:15:48','2025-06-13 22:15:48',NULL,NULL,NULL,'5b7b69db-6f6f-4cba-a7fd-38d4e9bb988c'),(213,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-06-18 19:30:26','2025-06-18 19:30:26',NULL,NULL,NULL,'ce5374d0-5ca0-4a1d-9922-aa90f4b8371b'),(214,NULL,NULL,NULL,NULL,'Solspace\\Freeform\\Elements\\Submission',1,0,'2025-07-02 04:50:52','2025-07-02 04:50:53',NULL,NULL,NULL,'9de0a7ff-f0a1-4d26-8272-90c3140489ae');
/*!40000 ALTER TABLE `elements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_bulkops`
--

LOCK TABLES `elements_bulkops` WRITE;
/*!40000 ALTER TABLE `elements_bulkops` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `elements_bulkops` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_owners`
--

LOCK TABLES `elements_owners` WRITE;
/*!40000 ALTER TABLE `elements_owners` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_owners` VALUES (86,26,1),(88,87,1),(92,91,1),(95,22,1),(97,96,1),(101,20,1),(102,20,2),(104,103,1),(105,103,2),(128,18,1),(130,129,1),(130,134,1),(130,138,1),(133,18,2),(135,134,2),(139,138,2),(142,24,1),(144,143,1),(148,147,1);
/*!40000 ALTER TABLE `elements_owners` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_sites`
--

LOCK TABLES `elements_sites` WRITE;
/*!40000 ALTER TABLE `elements_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_sites` VALUES (1,1,1,'Home','home','__home__','{\"6632dbcb-1a41-4851-b4ce-714e6ed7806a\": \"DRUMMER | COMPOSER | EDUCATOR\", \"a04b38f6-8a21-4cab-868b-a8272a1734d6\": \"ROB MARTINO\", \"d967ff84-b439-468f-9c28-9ddfdcc40765\": [17]}',1,'2023-06-11 22:50:14','2024-12-23 16:55:42','3af4e3f5-7666-411d-84f7-85f6751e2fad'),(2,2,1,NULL,NULL,NULL,'{\"71169323-2209-4100-8975-7e9bb5a6d9d7\": [202], \"c8c54e69-7104-493a-bd99-0e36b6428cac\": \"robmartinomusic@gmail.com\", \"ce516f33-2e70-405c-99a1-2d8d64bacc3d\": [201]}',1,'2023-06-11 22:50:15','2025-05-02 16:14:24','49ad5732-d456-4c77-92dc-1bcc9949c640'),(3,3,1,NULL,NULL,NULL,NULL,1,'2023-06-11 22:50:19','2023-06-11 22:50:19','8e84b3ec-7e86-4964-ad07-ba69f7bf4780'),(4,4,1,'Hobbe logo',NULL,NULL,NULL,1,'2023-06-11 22:55:39','2023-06-11 22:55:39','7748b5bb-6a46-4fb6-939e-5145010f47aa'),(6,6,1,'8static dominos',NULL,NULL,NULL,1,'2023-06-11 23:02:22','2023-06-11 23:02:22','53155c30-26d1-4b2f-9f3a-740bf6ba8c30'),(7,7,1,'About',NULL,NULL,NULL,1,'2023-06-11 23:02:24','2023-06-11 23:02:24','711d749d-333c-40ed-85bc-c3b75359bd98'),(8,8,1,'Bitgen',NULL,NULL,NULL,1,'2023-06-11 23:02:26','2023-06-11 23:02:26','a6156c49-7c62-4438-ab5c-130695a19d3f'),(9,9,1,'Gallery 1',NULL,NULL,NULL,1,'2023-06-11 23:02:28','2023-06-11 23:02:28','f1fff760-44fc-4d3a-987a-cd73391a39b7'),(10,10,1,'Gallery 2',NULL,NULL,NULL,1,'2023-06-11 23:02:31','2023-06-11 23:02:31','3ef41ed9-5551-4fda-bf3c-50443d3335ec'),(11,11,1,'Gallery 3',NULL,NULL,NULL,1,'2023-06-11 23:02:33','2023-06-11 23:02:33','90de4f4a-60a2-44e6-9aa3-d582456f022c'),(12,12,1,'Gallery 6',NULL,NULL,NULL,1,'2023-06-11 23:02:35','2023-06-11 23:02:35','50a9e381-8bec-4e78-ba51-364529f4b097'),(13,13,1,'Gallery 7',NULL,NULL,NULL,1,'2023-06-11 23:02:37','2023-06-11 23:02:37','3d2e8d18-ff64-49bc-b432-94cd6448f8fe'),(14,14,1,'Home bg mobile',NULL,NULL,NULL,1,'2023-06-11 23:02:44','2023-06-11 23:02:44','07e50f46-79fb-4614-9059-220af99562f2'),(15,15,1,'Sentry bar feb2020 alt',NULL,NULL,NULL,1,'2023-06-11 23:02:46','2023-06-11 23:02:46','5891f27f-3d39-43d2-ae99-0125e49157d7'),(16,16,1,'Sentry bar feb2020',NULL,NULL,NULL,1,'2023-06-11 23:02:48','2023-06-11 23:02:48','058abd61-b9b8-49d5-b6ea-ae5e569466a4'),(17,17,1,'Rob video',NULL,NULL,NULL,1,'2023-06-11 23:02:51','2023-06-11 23:02:51','6e851845-d7b8-4883-b7d1-aabf9c794f62'),(18,18,1,'About','about','about',NULL,1,'2023-06-11 23:03:41','2024-12-23 17:24:00','c2702226-67da-48b2-b29d-f960f5ee9d2a'),(19,19,1,'About','about','about','{\"00aaed21-f3e9-4b6c-958f-618a06e3e7ca\": \"about\"}',1,'2023-06-11 23:04:18','2023-06-11 23:04:18','9a6f5e07-8fe6-4dee-82d9-85d66da5c6d2'),(20,20,1,'Live','live','live',NULL,1,'2023-06-11 23:04:18','2024-12-23 17:11:06','a07b2e35-78c1-46a1-b5ad-c16e1979a447'),(21,21,1,'Live','live','live','{\"00aaed21-f3e9-4b6c-958f-618a06e3e7ca\": \"live\"}',1,'2023-06-11 23:04:55','2023-06-11 23:04:55','b8ee31a4-f9a1-490e-ae15-013c00cab477'),(22,22,1,'Listen','listen','listen',NULL,1,'2023-06-11 23:05:19','2024-12-23 17:08:55','b5487cf1-a465-4342-85c6-1c3dc458c48d'),(23,23,1,'Listen','listen','listen','{\"00aaed21-f3e9-4b6c-958f-618a06e3e7ca\": \"listen\"}',1,'2023-06-11 23:05:54','2023-06-11 23:05:54','7248c653-8b92-4280-8818-9164803984aa'),(24,24,1,'Gallery','gallery','gallery',NULL,1,'2023-06-11 23:05:54','2023-06-11 23:06:15','34dca773-c23c-4fff-8fdc-9a318100596a'),(25,25,1,'Gallery','gallery','gallery',NULL,1,'2023-06-11 23:07:20','2023-06-11 23:07:20','412a8d7d-7f18-4417-856a-99690554cf94'),(26,26,1,'Contact','contact','contact',NULL,1,'2023-06-11 23:07:20','2024-12-23 17:06:30','b67c6d55-bdad-4e03-be1f-29d5a31fdd30'),(27,27,1,'Contact','contact','contact','{\"00aaed21-f3e9-4b6c-958f-618a06e3e7ca\": \"contact\"}',1,'2023-06-11 23:09:22','2023-06-11 23:09:22','7275ac15-5ad8-4aff-8c8d-698584531e68'),(28,28,1,'Craggy Rabbit','craggy-rabbit',NULL,'{\"8a8f6a4e-e44f-4f75-ba6c-93934f05d583\": \"<iframe style=\\\"border: 0; width: 100%; height: 120px;\\\" src=\\\"https://bandcamp.com/EmbeddedPlayer/track=4072598133/size=large/bgcol=333333/linkcol=ffffff/tracklist=false/artwork=small/transparent=true/\\\" seamless><a href=\\\"https://robmartinomusic.bandcamp.com/track/craggy-rabbit\\\">Craggy Rabbit by Rob Martino</a></iframe>\"}',1,'2023-06-11 23:10:38','2023-06-11 23:12:48','9ecf994c-a7bd-42d4-8fba-0bf61697fffb'),(29,29,1,'nmlstyl - fourtitude (Band Version)','nmlstyl-fourtitude-band-version',NULL,'{\"8a8f6a4e-e44f-4f75-ba6c-93934f05d583\": \"<iframe style=\\\"border: 0; width: 100%; height: 120px;\\\" src=\\\"https://bandcamp.com/EmbeddedPlayer/album=1855074200/size=large/bgcol=ffffff/linkcol=0687f5/tracklist=false/artwork=small/track=1453079401/transparent=true/\\\" seamless><a href=\\\"https://ptesquad.bandcamp.com/album/hikikomori\\\">ひきこもり・Hikikomori by nmlstyl</a></iframe>\"}',1,'2023-06-11 23:13:39','2023-06-11 23:15:18','eff5e9b1-b24b-4fa9-8fd7-281dd791d173'),(30,30,1,'Valentine\'s Day Lottery','valentines-day-lottery',NULL,'{\"8a8f6a4e-e44f-4f75-ba6c-93934f05d583\": \"<iframe style=\\\"border: 0; width: 100%; height: 120px;\\\" src=\\\"https://bandcamp.com/EmbeddedPlayer/track=3885342436/size=large/bgcol=333333/linkcol=ffffff/tracklist=false/artwork=small/transparent=true/\\\" seamless><a href=\\\"https://robmartinomusic.bandcamp.com/track/valentines-day-lottery\\\">Valentine&#39;s Day Lottery by Rob Martino</a></iframe>\"}',1,'2023-06-11 23:15:36','2023-06-11 23:16:31','fcfef28f-7b13-4897-a9be-80cc1a3cba1e'),(31,31,1,'nmlstyl - s/t (Spotify)','nmlstyl-s-t-spotify',NULL,'{\"58557f92-7d83-4a51-8d3e-b9b38ab91b11\": \"<iframe style=\\\"border-radius:12px\\\" src=\\\"https://open.spotify.com/embed/album/5GGumb4GPisa6Dwba1yuUq?utm_source=generator\\\" width=\\\"100%\\\" height=\\\"380\\\" frameBorder=\\\"0\\\" allowfullscreen=\\\"\\\" allow=\\\"autoplay; clipboard-write; encrypted-media; fullscreen; picture-in-picture\\\" loading=\\\"lazy\\\"></iframe>\"}',1,'2023-06-11 23:18:24','2023-06-11 23:19:24','e57b5e6a-19e7-4bb4-a937-44d70136c011'),(32,32,1,'Speed of Three - Paradox','speed-of-three-paradox',NULL,'{\"036d6841-6bb9-487d-a01b-c28cb4d2937b\": \"<iframe width=\\\"100%\\\" height=\\\"166\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/85505705&color=%23283450&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true\\\"></iframe><div style=\\\"font-size: 10px; color: #cccccc;line-break: anywhere;word-break: normal;overflow: hidden;white-space: nowrap;text-overflow: ellipsis; font-family: Interstate,Lucida Grande,Lucida Sans Unicode,Lucida Sans,Garuda,Verdana,Tahoma,sans-serif;font-weight: 100;\\\"><a href=\\\"https://soundcloud.com/robmartinodrums\\\" title=\\\"Rob Martino\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">Rob Martino</a> · <a href=\\\"https://soundcloud.com/robmartinodrums/paradox-speed-of-three\\\" title=\\\"Paradox-Speed of Three\\\" target=\\\"_blank\\\" style=\\\"color: #cccccc; text-decoration: none;\\\">Paradox-Speed of Three</a></div>\"}',1,'2023-06-11 23:19:24','2023-06-11 23:21:15','42ad2951-88ef-4e18-8e75-0b880a9b5219'),(33,33,1,'\"110 Percent\" - Mysterious Travelers','110-percent-mysterious-travelers',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [123], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"E_I-b-8QSYA\"}',1,'2023-06-11 23:22:47','2024-12-23 17:21:56','74fe8855-e221-4fa8-b336-968bc716f84e'),(34,34,1,'\"110 Percent\" - Mysterious Travelers','110-percent-mysterious-travelers',NULL,'{\"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"E_I-b-8QSYA\"}',1,'2023-06-11 23:24:30','2023-06-11 23:24:30','c33da2d1-29ee-48a5-80c6-99ab2680d3b5'),(35,35,1,'\"Black Monday\" - Mysterious Travelers','black-monday-mysterious-travelers',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [120], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"iXeAD98tRtg\"}',1,'2023-06-11 23:24:30','2024-12-23 17:21:47','78abffaf-9b30-4210-b383-743613604517'),(36,36,1,'\"Black Monday\" - Mysterious Travelers','black-monday-mysterious-travelers',NULL,'{\"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"iXeAD98tRtg\"}',1,'2023-06-11 23:25:49','2023-06-11 23:25:49','d5d740bf-ffba-4fed-8600-77432f20d423'),(37,37,1,'\"The Overtime\" - McGill Chamber Jazz Orchestra 2019','the-overtime-mcgill-chamber-jazz-orchestra-2019',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"7W4Z7B2i52w\"}',1,'2023-06-11 23:25:49','2024-12-23 16:40:04','4ac4a917-a180-45ef-89b2-bff6610763e7'),(38,38,1,'\"The Overtime\" - McGill Chamber Jazz Orchestra 2019','the-overtime-mcgill-chamber-jazz-orchestra-2019',NULL,'{\"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"7W4Z7B2i52w\"}',1,'2023-06-11 23:27:16','2023-06-11 23:27:16','0390a999-80e8-42bf-9edf-dcdf8163286f'),(39,39,1,'\"Infinitaves\" - nmlstyl @ MAGFest 2020','infinitaves-nmlstyl-magfest-2020',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [117], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"3xPYUxdLQ7Y\"}',1,'2023-06-11 23:27:16','2024-12-23 17:21:36','ebb26527-7e45-4ecb-ab35-b8943a65c7ef'),(40,40,1,'\"Infinitaves\" - nmlstyl @ MAGFest 2020','infinitaves-nmlstyl-magfest-2020',NULL,'{\"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"3xPYUxdLQ7Y\"}',1,'2023-06-11 23:28:53','2023-06-11 23:28:53','f6804f8a-435b-47be-b12f-38386a639938'),(41,41,1,'nmlstyl - BitGen XIII (full set)','nmlstyl-bitgen-xiii-full-set',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [114], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"vnDvFTKlQno\"}',1,'2023-06-11 23:28:53','2024-12-23 17:21:24','375a3c98-6cd3-4920-bdf1-761d030908e7'),(42,42,1,'nmlstyl - BitGen XIII (full set)','nmlstyl-bitgen-xiii-full-set',NULL,'{\"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"vnDvFTKlQno\"}',1,'2023-06-11 23:29:55','2023-06-11 23:29:55','35b09517-6c3f-4971-9995-fea365365709'),(48,48,1,'Drums Blue',NULL,NULL,NULL,1,'2023-06-12 18:57:17','2023-06-12 18:57:17','9343b348-ecc9-4c96-9abd-dbfb7177380e'),(49,49,1,'Nmlstyl',NULL,NULL,NULL,1,'2023-06-12 18:57:24','2023-06-12 18:57:24','b5062f08-6a40-4324-8a13-6cf5f554ff5f'),(51,51,1,'Gallery','gallery','gallery',NULL,1,'2023-06-12 18:58:07','2023-06-12 18:58:07','74f37029-8041-4ec3-afbe-148734b14b95'),(82,82,1,NULL,NULL,NULL,'{\"b21157a3-3efc-42f6-8515-0897c09c344d\": [18, 20, 22, 24, 26]}',1,'2024-12-23 16:39:52','2024-12-23 17:09:39','f44f88fe-e7b1-4bd4-9f94-6c8b8ae3c527'),(86,86,1,'Contact','contact',NULL,'{\"8d2fe42a-ce89-4c3c-ab75-7077c8288c8b\": \"left\", \"e38579d0-3f4b-46df-86e4-9b46d38f80fb\": [15]}',1,'2024-12-23 17:06:30','2024-12-23 17:07:38','dabdbb74-e277-4727-aba1-dd93ad699daa'),(87,87,1,'Contact','contact','contact',NULL,1,'2024-12-23 17:06:30','2024-12-23 17:06:30','40a294ee-cea5-420e-99cf-daaa126c2798'),(88,88,1,'Contact','contact',NULL,'{\"8d2fe42a-ce89-4c3c-ab75-7077c8288c8b\": \"right\", \"e38579d0-3f4b-46df-86e4-9b46d38f80fb\": [15]}',1,'2024-12-23 17:06:30','2024-12-23 17:06:30','7c8f627b-bb3e-4299-ac38-14c06009b8ca'),(91,91,1,'Contact','contact','contact',NULL,1,'2024-12-23 17:07:38','2024-12-23 17:07:38','0b89d638-3f4c-4738-b37f-6b03436f44df'),(92,92,1,'Contact','contact',NULL,'{\"8d2fe42a-ce89-4c3c-ab75-7077c8288c8b\": \"left\", \"e38579d0-3f4b-46df-86e4-9b46d38f80fb\": [15]}',1,'2024-12-23 17:07:38','2024-12-23 17:07:38','bf596660-2433-48d5-ad63-356e0cda8bf8'),(95,95,1,'Embeds','embeds',NULL,'{\"23d6b77a-e903-4ceb-991d-6b1f2310d49b\": [32, 31], \"d89d9435-d547-4ba7-bc61-7ab17389355e\": [28, 30, 29]}',1,'2024-12-23 17:08:55','2024-12-23 17:08:55','f76e59d0-15c5-4096-9ce2-b30efc113cc5'),(96,96,1,'Listen','listen','listen',NULL,1,'2024-12-23 17:08:55','2024-12-23 17:08:55','ec7cea2a-d3ef-4322-a770-a5a5ed28ff9b'),(97,97,1,'Embeds','embeds',NULL,'{\"23d6b77a-e903-4ceb-991d-6b1f2310d49b\": [32, 31], \"d89d9435-d547-4ba7-bc61-7ab17389355e\": [28, 30, 29]}',1,'2024-12-23 17:08:55','2024-12-23 17:08:55','ce3fa8c7-321c-4c38-af77-6cc7ccb76106'),(101,101,1,'Upcoming Gigs','upcoming-gigs',NULL,'{\"bf086f1b-fdb4-49a5-914d-ff5be4160d9e\": []}',1,'2024-12-23 17:11:06','2024-12-23 17:11:06','9b7248b1-9b0f-41ed-921e-b3cf90f73efe'),(102,102,1,'Videos','videos',NULL,'{\"6943897f-3459-431b-acf7-eda6ce763c03\": [41, 39, 35, 33], \"a08a9864-42f7-402e-91e4-c3c5b829ec12\": \"#eeeeee\", \"a3d64401-5bbb-4c18-bf87-927e5484984a\": \"lg:grid-cols-2\"}',1,'2024-12-23 17:11:06','2024-12-23 17:11:06','dcf241bd-d1c7-44b1-9a1a-9be67a57e16c'),(103,103,1,'Live','live','live',NULL,1,'2024-12-23 17:11:06','2024-12-23 17:11:06','852805c6-810e-4142-9368-19a4be7aa8b4'),(104,104,1,'Upcoming Gigs','upcoming-gigs',NULL,'{\"bf086f1b-fdb4-49a5-914d-ff5be4160d9e\": []}',1,'2024-12-23 17:11:06','2024-12-23 17:11:06','c9b58e16-9164-45fd-903c-f1a63ca1aa44'),(105,105,1,'Videos','videos',NULL,'{\"6943897f-3459-431b-acf7-eda6ce763c03\": [41, 39, 35, 33], \"a08a9864-42f7-402e-91e4-c3c5b829ec12\": \"#eeeeee\", \"a3d64401-5bbb-4c18-bf87-927e5484984a\": \"lg:grid-cols-2\"}',1,'2024-12-23 17:11:06','2024-12-23 17:11:06','ea59bf91-4c83-427a-a9cb-2db427ab8368'),(114,114,1,'Nmlstyl bitgen13',NULL,NULL,NULL,1,'2024-12-23 17:20:53','2024-12-23 17:20:53','74f422d1-537b-4d54-9861-465670adcac8'),(116,116,1,'nmlstyl - BitGen XIII (full set)','nmlstyl-bitgen-xiii-full-set',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [114], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"vnDvFTKlQno\"}',1,'2024-12-23 17:21:24','2024-12-23 17:21:24','51327f4e-b767-4d0d-b719-c6ab8f90bb6c'),(117,117,1,'Nmlstyl magfest2020',NULL,NULL,NULL,1,'2024-12-23 17:21:33','2024-12-23 17:21:33','fc850185-8d5a-48d6-b631-e383a250ddac'),(119,119,1,'\"Infinitaves\" - nmlstyl @ MAGFest 2020','infinitaves-nmlstyl-magfest-2020',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [117], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"3xPYUxdLQ7Y\"}',1,'2024-12-23 17:21:36','2024-12-23 17:21:36','e066e395-0a1e-43f1-8a13-500e4dfa7042'),(120,120,1,'Black monday',NULL,NULL,NULL,1,'2024-12-23 17:21:44','2024-12-23 17:21:44','55b088e3-1a11-4e2c-b227-56dfb5bf865f'),(122,122,1,'\"Black Monday\" - Mysterious Travelers','black-monday-mysterious-travelers',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [120], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"iXeAD98tRtg\"}',1,'2024-12-23 17:21:47','2024-12-23 17:21:47','b1866513-c04e-4d49-986a-60bf69ba180c'),(123,123,1,'110percent',NULL,NULL,NULL,1,'2024-12-23 17:21:54','2024-12-23 17:21:54','b9b03844-1822-4535-a7a1-6575398c1453'),(125,125,1,'\"110 Percent\" - Mysterious Travelers','110-percent-mysterious-travelers',NULL,'{\"64feaee3-2e6d-4070-8a5f-799139399d2c\": [123], \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\": \"E_I-b-8QSYA\"}',1,'2024-12-23 17:21:56','2024-12-23 17:21:56','3fbb5471-038b-4299-8b3d-583554fc5a6a'),(128,128,1,NULL,'__temp_czklqsvrjkusygouvtqvcscsjiriclpsylwj',NULL,'{\"646a03f3-de83-4c80-a744-3df1b36feaa6\": \"<p><strong>Rob Martino</strong> is New Jersey and New York-based drummer, composer, and educator. He received his Bachelor of Music from <strong>Temple University</strong> and a Master of Music from <strong>McGill University</strong> in Montréal, Canada He has performed with some world-class jazz musicians including Grammy-nominated <strong>Ambrose Akinmusire</strong>, and <strong>John Hollenbeck</strong>.</p><p>Martino has traveled all over the U.S. with various groups including the <strong>All Hands On Deck Show</strong>. He has composed and arranged for the <strong>Materia Collective</strong> and is also the drummer for <strong>NMLSTYL</strong>: an audiovisual project by Joey Michalina Mariano, a Philadelphia-based electronic musician, coder, and visual artist.</p><p>He was the recipient of the <i>2018 Philadelphia Jazz Project: Mysterious Travelers Commission</i>, and attended the <i>School for Improvisational Music (SIM)</i> Workshop directed by <strong>Ralph Alessi</strong> in 2019.</p><p>Martino is currently working on an upcoming analog synth/acoustic drum album and has released a suite of electronic compositions on Bandcamp.</p>\", \"b2a010a0-f97d-4241-97fa-34e1309866ce\": \"left\", \"ddf98bdc-334f-45fb-ad97-ff47dab66999\": false, \"e852593c-0eee-4f81-9f97-6d7338a34729\": [7]}',1,'2024-12-23 17:24:00','2024-12-23 17:24:00','59b4c5e2-37b6-4f02-a856-c4764be193c2'),(129,129,1,'About','about','about',NULL,1,'2024-12-23 17:24:00','2024-12-23 17:24:00','39767ea0-ad59-4412-8075-becf763b3f53'),(130,130,1,NULL,'__temp_czklqsvrjkusygouvtqvcscsjiriclpsylwj',NULL,'{\"646a03f3-de83-4c80-a744-3df1b36feaa6\": \"<p><strong>Rob Martino</strong> is New Jersey and New York-based drummer, composer, and educator. He received his Bachelor of Music from <strong>Temple University</strong> and a Master of Music from <strong>McGill University</strong> in Montréal, Canada He has performed with some world-class jazz musicians including Grammy-nominated <strong>Ambrose Akinmusire</strong>, and <strong>John Hollenbeck</strong>.</p><p>Martino has traveled all over the U.S. with various groups including the <strong>All Hands On Deck Show</strong>. He has composed and arranged for the <strong>Materia Collective</strong> and is also the drummer for <strong>NMLSTYL</strong>: an audiovisual project by Joey Michalina Mariano, a Philadelphia-based electronic musician, coder, and visual artist.</p><p>He was the recipient of the <i>2018 Philadelphia Jazz Project: Mysterious Travelers Commission</i>, and attended the <i>School for Improvisational Music (SIM)</i> Workshop directed by <strong>Ralph Alessi</strong> in 2019.</p><p>Martino is currently working on an upcoming analog synth/acoustic drum album and has released a suite of electronic compositions on Bandcamp.</p>\", \"b2a010a0-f97d-4241-97fa-34e1309866ce\": \"left\", \"ddf98bdc-334f-45fb-ad97-ff47dab66999\": false, \"e852593c-0eee-4f81-9f97-6d7338a34729\": [7]}',1,'2024-12-23 17:24:01','2024-12-23 17:24:01','a00a090e-c5ea-47a7-91b0-1f844a3ca69a'),(133,133,1,NULL,'__temp_ebhrszhslredkrpkuolcxlowaojtfidtbety',NULL,'{\"83e1b785-31e6-43ef-b9f4-bb7876909f01\": \"<p style=\\\"text-align:center;\\\"><sub>Photographer: </sub><a href=\\\"https://chiptography.com/about\\\"><sub>Chiptography</sub></a></p>\"}',1,'2024-12-23 17:25:10','2024-12-23 17:25:31','8df1f8b0-d7bf-4a2f-a13f-f0abb4d486b4'),(134,134,1,'About','about','about',NULL,1,'2024-12-23 17:25:10','2024-12-23 17:25:10','29a5ff99-b21c-4b7d-8ad8-53ba756f2074'),(135,135,1,NULL,'__temp_ebhrszhslredkrpkuolcxlowaojtfidtbety',NULL,'{\"83e1b785-31e6-43ef-b9f4-bb7876909f01\": \"<p><sub>Photographer: </sub><a href=\\\"https://chiptography.com/about\\\"><sub>Chiptography</sub></a></p>\"}',1,'2024-12-23 17:25:10','2024-12-23 17:25:10','3581f728-4cac-4143-a995-562fe15e51a0'),(138,138,1,'About','about','about',NULL,1,'2024-12-23 17:25:31','2024-12-23 17:25:31','8f0ccaa3-ca36-409a-951d-50f1977c01cb'),(139,139,1,NULL,'__temp_ebhrszhslredkrpkuolcxlowaojtfidtbety',NULL,'{\"83e1b785-31e6-43ef-b9f4-bb7876909f01\": \"<p style=\\\"text-align:center;\\\"><sub>Photographer: </sub><a href=\\\"https://chiptography.com/about\\\"><sub>Chiptography</sub></a></p>\"}',1,'2024-12-23 17:25:31','2024-12-23 17:25:31','4a654e35-7382-4cfe-976c-a3a500965b69'),(142,142,1,NULL,'__temp_cjdotupksogqdkxjsqpktajhayvxkxjgjblc',NULL,'{\"349be4f9-a1b7-4e71-be5c-412fbc7d4b81\": 10, \"3af07ae9-5448-41b1-a5d7-8cf7c680a3bb\": false, \"43c8d12b-18de-4460-91f7-13da7b631af9\": \"fade\", \"5045aa0a-dc55-44d3-9da7-f3f4eb28a0ba\": true, \"77074409-4fed-4ddf-85c4-f0ad4e1aa6cb\": 4, \"87a5d55e-755f-4b58-b0b0-b83f8253e5a0\": true, \"ac1e7d09-fa7f-4da0-9c9c-01a72d9c5afd\": true, \"b3f6966d-7da6-4790-b5c4-d67b739b0c0f\": false, \"b82c031d-45a7-4f45-994c-1b3fd2339738\": true, \"b97b878c-6671-4f9e-8d1b-19c8f1f218a6\": true, \"cba033be-6772-48c8-a025-f758da83e0c7\": [9, 12, 6, 49, 10, 11, 48, 13], \"f8f3c242-ec5c-4eb5-bc50-bdb9e7f8c73d\": 4}',1,'2024-12-23 17:28:05','2024-12-23 17:29:11','bb6c7be1-266a-4dbb-b472-2c6aa141bbed'),(143,143,1,'Gallery','gallery','gallery',NULL,1,'2024-12-23 17:28:05','2024-12-23 17:28:05','0c8aa26e-c823-4e47-ae52-5e050c7ab424'),(144,144,1,NULL,'__temp_cjdotupksogqdkxjsqpktajhayvxkxjgjblc',NULL,'{\"349be4f9-a1b7-4e71-be5c-412fbc7d4b81\": 10, \"3af07ae9-5448-41b1-a5d7-8cf7c680a3bb\": false, \"43c8d12b-18de-4460-91f7-13da7b631af9\": \"fade\", \"5045aa0a-dc55-44d3-9da7-f3f4eb28a0ba\": true, \"77074409-4fed-4ddf-85c4-f0ad4e1aa6cb\": 3, \"87a5d55e-755f-4b58-b0b0-b83f8253e5a0\": true, \"ac1e7d09-fa7f-4da0-9c9c-01a72d9c5afd\": true, \"b3f6966d-7da6-4790-b5c4-d67b739b0c0f\": false, \"b82c031d-45a7-4f45-994c-1b3fd2339738\": true, \"b97b878c-6671-4f9e-8d1b-19c8f1f218a6\": true, \"cba033be-6772-48c8-a025-f758da83e0c7\": [9, 12, 6, 49, 10, 11, 48, 13], \"f8f3c242-ec5c-4eb5-bc50-bdb9e7f8c73d\": 3}',1,'2024-12-23 17:28:05','2024-12-23 17:28:05','3701b858-285f-4fa2-a851-a08ef1508b39'),(147,147,1,'Gallery','gallery','gallery',NULL,1,'2024-12-23 17:29:11','2024-12-23 17:29:11','d28bf317-c826-4e0c-aea6-5229c3e13ac4'),(148,148,1,NULL,'__temp_cjdotupksogqdkxjsqpktajhayvxkxjgjblc',NULL,'{\"349be4f9-a1b7-4e71-be5c-412fbc7d4b81\": 10, \"3af07ae9-5448-41b1-a5d7-8cf7c680a3bb\": false, \"43c8d12b-18de-4460-91f7-13da7b631af9\": \"fade\", \"5045aa0a-dc55-44d3-9da7-f3f4eb28a0ba\": true, \"77074409-4fed-4ddf-85c4-f0ad4e1aa6cb\": 4, \"87a5d55e-755f-4b58-b0b0-b83f8253e5a0\": true, \"ac1e7d09-fa7f-4da0-9c9c-01a72d9c5afd\": true, \"b3f6966d-7da6-4790-b5c4-d67b739b0c0f\": false, \"b82c031d-45a7-4f45-994c-1b3fd2339738\": true, \"b97b878c-6671-4f9e-8d1b-19c8f1f218a6\": true, \"cba033be-6772-48c8-a025-f758da83e0c7\": [9, 12, 6, 49, 10, 11, 48, 13], \"f8f3c242-ec5c-4eb5-bc50-bdb9e7f8c73d\": 4}',1,'2024-12-23 17:29:11','2024-12-23 17:29:11','c9bf8425-3cce-45bf-9766-c2dbcd71f242'),(149,149,1,'2024-12-25 09:56:26',NULL,NULL,NULL,1,'2024-12-25 17:56:26','2024-12-25 17:56:26','0cee1df2-f691-482a-bddf-d78274731339'),(150,150,1,'2024-12-28 10:45:41',NULL,NULL,NULL,1,'2024-12-28 18:45:42','2024-12-28 18:45:42','00b9f1ee-f5e7-4f75-a075-47e0e36abc6c'),(151,151,1,'2024-12-30 23:15:51',NULL,NULL,NULL,1,'2024-12-31 07:15:51','2024-12-31 07:15:51','a4f1be46-c212-48f0-ba1d-9e6cf998d259'),(152,152,1,'2025-01-02 19:28:43',NULL,NULL,NULL,1,'2025-01-03 03:28:43','2025-01-03 03:28:43','3755b2f3-3792-46db-a796-c5bccce141a0'),(153,153,1,'2025-01-16 02:55:55',NULL,NULL,NULL,1,'2025-01-16 10:55:55','2025-01-16 10:55:55','ffdb4e47-407b-4560-9b44-fde70fa7db65'),(154,154,1,'2025-01-16 12:57:50',NULL,NULL,NULL,1,'2025-01-16 20:57:50','2025-01-16 20:57:50','b770f27a-b034-47e2-b874-ac03406f15e0'),(155,155,1,'2025-01-17 08:27:50',NULL,NULL,NULL,1,'2025-01-17 16:27:50','2025-01-17 16:27:50','8eae6e1c-2dbc-4f6f-9a80-1f175eca10dc'),(156,156,1,'2025-01-24 18:12:52',NULL,NULL,NULL,1,'2025-01-25 02:12:52','2025-01-25 02:12:52','587415c4-ad63-40cb-b063-5575c8233cc4'),(157,157,1,'2025-01-29 12:59:54',NULL,NULL,NULL,1,'2025-01-29 20:59:54','2025-01-29 20:59:54','68af9228-b8d3-4fba-bd68-a7c7147e2ee0'),(158,158,1,'2025-01-31 00:42:58',NULL,NULL,NULL,1,'2025-01-31 08:42:58','2025-01-31 08:42:58','1ca1048e-1384-4215-bbee-fc84cfa14b23'),(159,159,1,'2025-01-31 00:56:43',NULL,NULL,NULL,1,'2025-01-31 08:56:43','2025-01-31 08:56:43','d993defe-1fa9-4ae6-9ddd-267de7abb07a'),(160,160,1,'2025-02-04 00:53:55',NULL,NULL,NULL,1,'2025-02-04 08:53:55','2025-02-04 08:53:55','093d95fe-51e8-4856-92c7-35ee7d157789'),(161,161,1,'2025-02-04 21:25:10',NULL,NULL,NULL,1,'2025-02-05 05:25:10','2025-02-05 05:25:10','684c36e7-fb9c-4897-a30e-12c29afc6e0b'),(162,162,1,'2025-02-05 14:54:44',NULL,NULL,NULL,1,'2025-02-05 22:54:44','2025-02-05 22:54:44','e22d14b7-bfef-4c02-8662-859f8e626678'),(163,163,1,'2025-02-14 03:18:31',NULL,NULL,NULL,1,'2025-02-14 11:18:31','2025-02-14 11:18:31','e593a466-8c78-41c8-82b7-d555ce9da36c'),(164,164,1,'2025-02-18 13:54:34',NULL,NULL,NULL,1,'2025-02-18 21:54:34','2025-02-18 21:54:34','ba02472a-5e20-430d-882e-afc4fec954ba'),(165,165,1,'2025-02-19 10:27:16',NULL,NULL,NULL,1,'2025-02-19 18:27:16','2025-02-19 18:27:16','80406f37-c9bc-4fe6-8ea0-ff636c360d74'),(166,166,1,'2025-02-20 19:04:15',NULL,NULL,NULL,1,'2025-02-21 03:04:15','2025-02-21 03:04:15','f848b2b9-b8ac-4657-abae-843adfafe318'),(167,167,1,'2025-02-22 14:56:10',NULL,NULL,NULL,1,'2025-02-22 22:56:10','2025-02-22 22:56:10','902ef17f-3809-450b-b721-8cf5091f832c'),(168,168,1,'2025-02-23 02:55:10',NULL,NULL,NULL,1,'2025-02-23 10:55:11','2025-02-23 10:55:11','4fd0a490-1937-4a07-a1b4-11e8211417a6'),(169,169,1,'2025-02-24 10:57:07',NULL,NULL,NULL,1,'2025-02-24 18:57:07','2025-02-24 18:57:07','c935ca38-6cab-4f8e-b7c5-4cd192d10ef8'),(170,170,1,'2025-03-03 04:27:33',NULL,NULL,NULL,1,'2025-03-03 12:27:33','2025-03-03 12:27:33','b8dd6843-e27b-4db4-9c8b-19ca387796ee'),(171,171,1,'2025-03-03 14:03:03',NULL,NULL,NULL,1,'2025-03-03 22:03:03','2025-03-03 22:03:03','5604002a-8bb7-45f3-bd0c-ef3080815f99'),(172,172,1,'2025-03-05 06:39:17',NULL,NULL,NULL,1,'2025-03-05 14:39:17','2025-03-05 14:39:17','5290b973-b224-4917-91bb-dd576465fbf4'),(173,173,1,'2025-03-06 12:26:41',NULL,NULL,NULL,1,'2025-03-06 20:26:41','2025-03-06 20:26:41','d862bf6e-e772-433d-8107-ed2b5465d220'),(174,174,1,'2025-03-10 23:26:01',NULL,NULL,NULL,1,'2025-03-11 06:26:01','2025-03-11 06:26:01','a09e80c9-ae5e-42c3-9169-ba7fc3b5a6c7'),(175,175,1,'2025-03-18 14:52:25',NULL,NULL,NULL,1,'2025-03-18 21:52:25','2025-03-18 21:52:25','4af5cebd-b0e0-4678-9466-396ff6eca4a8'),(176,176,1,'2025-03-21 07:55:16',NULL,NULL,NULL,1,'2025-03-21 14:55:16','2025-03-21 14:55:16','2275ab56-6d1d-48c9-be19-b3b8cac81dce'),(177,177,1,'2025-03-23 14:24:34',NULL,NULL,NULL,1,'2025-03-23 21:24:34','2025-03-23 21:24:34','8e54e3d7-81c0-4092-a930-bb4df6771f1c'),(178,178,1,'2025-03-24 02:24:28',NULL,NULL,NULL,1,'2025-03-24 09:24:28','2025-03-24 09:24:28','531b5138-aaa5-4af9-a4c0-c2813135cc0c'),(179,179,1,'2025-03-25 09:22:21',NULL,NULL,NULL,1,'2025-03-25 16:22:21','2025-03-25 16:22:21','4b906736-3834-4e74-adc9-4a87cf23a5e0'),(180,180,1,'2025-03-26 18:23:02',NULL,NULL,NULL,1,'2025-03-27 01:23:02','2025-03-27 01:23:02','3736d36a-497b-4e56-ad30-bf0ce094a382'),(181,181,1,'2025-03-27 10:23:07',NULL,NULL,NULL,1,'2025-03-27 17:23:07','2025-03-27 17:23:07','efa53d05-0e6b-4148-88ea-cdc905237e29'),(182,182,1,'2025-03-29 14:52:28',NULL,NULL,NULL,1,'2025-03-29 21:52:28','2025-03-29 21:52:28','8273636e-8622-4ed0-926d-84173a5177bb'),(183,183,1,'2025-03-31 15:23:23',NULL,NULL,NULL,1,'2025-03-31 22:23:23','2025-03-31 22:23:23','2265f11c-b421-4233-99d4-0e6b30032f74'),(184,184,1,'2025-03-31 17:52:59',NULL,NULL,NULL,1,'2025-04-01 00:52:59','2025-04-01 00:52:59','384e726f-2ccc-4fa5-8bb7-e493325ca15b'),(185,185,1,'2025-04-01 21:52:06',NULL,NULL,NULL,1,'2025-04-02 04:52:06','2025-04-02 04:52:06','7ac751dd-70fd-420f-9356-7e5fd7414029'),(186,186,1,'2025-04-09 21:05:45',NULL,NULL,NULL,1,'2025-04-10 04:05:45','2025-04-10 04:05:45','cdeb115b-9808-4209-a9de-a7a5ad9146f0'),(187,187,1,'2025-04-11 12:39:08',NULL,NULL,NULL,1,'2025-04-11 19:39:08','2025-04-11 19:39:08','86d8bd8a-eebc-4c61-8a0d-541283b9eb7e'),(188,188,1,'2025-04-11 20:53:33',NULL,NULL,NULL,1,'2025-04-12 03:53:33','2025-04-12 03:53:33','f97dc443-81cc-46e5-bf4e-83d0dc1b74bf'),(189,189,1,'2025-04-13 06:23:39',NULL,NULL,NULL,1,'2025-04-13 13:23:39','2025-04-13 13:23:39','f54edfc0-b800-423a-82e6-f192a6729745'),(190,190,1,'2025-04-16 18:41:07',NULL,NULL,NULL,1,'2025-04-17 01:41:07','2025-04-17 01:41:07','0e72f372-e598-4e54-91cf-bbfc1e68c67b'),(191,191,1,'2025-04-20 09:42:42',NULL,NULL,NULL,1,'2025-04-20 16:42:42','2025-04-20 16:42:42','8f18ca56-b703-41ab-a105-251ab3a49952'),(192,192,1,'2025-04-21 03:42:51',NULL,NULL,NULL,1,'2025-04-21 10:42:51','2025-04-21 10:42:51','f5b98049-6726-419c-b722-e36dd3d11876'),(193,193,1,'2025-04-22 13:47:58',NULL,NULL,NULL,1,'2025-04-22 20:47:58','2025-04-22 20:47:58','df909203-dad2-44e8-99c4-9f1583a7ac15'),(194,194,1,'2025-04-24 09:23:16',NULL,NULL,NULL,1,'2025-04-24 16:23:16','2025-04-24 16:23:16','c69a61b7-2165-4098-8215-57192dd0372e'),(195,195,1,'2025-04-25 22:25:10',NULL,NULL,NULL,1,'2025-04-26 05:25:10','2025-04-26 05:25:10','b9b27b78-e75f-42dc-b3bf-678e85d819ea'),(196,196,1,'2025-04-27 00:57:52',NULL,NULL,NULL,1,'2025-04-27 07:57:52','2025-04-27 07:57:52','75c2b4a5-2cd2-4861-a0d8-fdc287000443'),(197,197,1,'2025-04-27 13:08:59',NULL,NULL,NULL,1,'2025-04-27 20:08:59','2025-04-27 20:08:59','fe7f72bd-5ee6-4de1-a33e-754e8b7e0b6f'),(201,201,1,'Face new',NULL,NULL,NULL,1,'2025-05-02 16:14:16','2025-05-02 16:14:16','4e8b9ada-4323-4d72-85c7-17f631cd3df1'),(202,202,1,'Hobbe favicon',NULL,NULL,NULL,1,'2025-05-02 16:14:21','2025-05-02 16:14:21','46732f7e-5211-4acd-8ba9-6a08038e40b1'),(203,203,1,'2025-05-02 10:12:28',NULL,NULL,NULL,1,'2025-05-02 17:12:28','2025-05-02 17:12:28','c4d506c5-8984-4cd0-832f-8d8d972f7654'),(204,204,1,'2025-05-06 02:25:00',NULL,NULL,NULL,1,'2025-05-06 09:25:00','2025-05-06 09:25:00','68ac17cd-5d62-497f-b5ec-3e029f1ace78'),(205,205,1,'2025-05-07 06:34:27',NULL,NULL,NULL,1,'2025-05-07 13:34:27','2025-05-07 13:34:27','68b0e658-fa00-41fb-9a6d-b0021374158f'),(206,206,1,'2025-05-10 03:43:36',NULL,NULL,NULL,1,'2025-05-10 10:43:37','2025-05-10 10:43:37','a268ccc4-d2ea-4451-bc56-f40744575889'),(207,207,1,'2025-05-15 21:25:45',NULL,NULL,NULL,1,'2025-05-16 04:25:45','2025-05-16 04:25:45','bf3d3e7c-4648-41de-b4b7-cc99e0ce7c4a'),(208,208,1,'2025-05-17 23:55:56',NULL,NULL,NULL,1,'2025-05-18 06:55:57','2025-05-18 06:55:57','d10cfa08-852d-4942-afa5-fcc7f3cb5d72'),(209,209,1,'2025-05-20 13:38:05',NULL,NULL,NULL,1,'2025-05-20 20:38:05','2025-05-20 20:38:05','e0d29083-9913-44cc-b5e0-eeaf205dd258'),(210,210,1,'2025-05-21 09:17:26',NULL,NULL,NULL,1,'2025-05-21 16:17:26','2025-05-21 16:17:26','b067c90a-08a1-46f8-86f3-721936076df3'),(211,211,1,'2025-05-23 02:56:42',NULL,NULL,NULL,1,'2025-05-23 09:56:42','2025-05-23 09:56:42','04fd6c35-3091-4f34-96b8-b265d6674783'),(212,212,1,'2025-06-13 15:15:48',NULL,NULL,NULL,1,'2025-06-13 22:15:48','2025-06-13 22:15:48','e5edf557-e8db-4627-a571-55b0a15a37e8'),(213,213,1,'2025-06-18 12:30:26',NULL,NULL,NULL,1,'2025-06-18 19:30:26','2025-06-18 19:30:26','2cd9c57e-d99b-4e49-b9c6-5eae1e54e32a'),(214,214,1,'2025-07-01 21:50:52',NULL,NULL,NULL,1,'2025-07-02 04:50:53','2025-07-02 04:50:53','da79b331-b07d-4d57-827f-56d5386a69d3');
/*!40000 ALTER TABLE `elements_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entries`
--

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entries` VALUES (1,4,NULL,NULL,NULL,6,'2023-06-11 22:50:00',NULL,'live',NULL,NULL,'2023-06-11 22:50:14','2023-06-11 22:50:14'),(18,5,NULL,NULL,NULL,16,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2023-06-11 23:03:41','2024-12-23 17:24:00'),(19,5,NULL,NULL,NULL,2,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2023-06-11 23:04:18','2023-06-11 23:04:18'),(20,5,NULL,NULL,NULL,16,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2023-06-11 23:04:18','2024-12-23 17:11:06'),(21,5,NULL,NULL,NULL,2,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2023-06-11 23:04:55','2023-06-11 23:04:55'),(22,5,NULL,NULL,NULL,16,'2023-06-11 23:05:00',NULL,'live',NULL,NULL,'2023-06-11 23:05:19','2024-12-23 17:08:55'),(23,5,NULL,NULL,NULL,2,'2023-06-11 23:05:00',NULL,'live',NULL,NULL,'2023-06-11 23:05:54','2023-06-11 23:05:54'),(24,5,NULL,NULL,NULL,16,'2023-06-11 23:07:00',NULL,'live',NULL,NULL,'2023-06-11 23:05:54','2024-12-23 17:28:05'),(25,5,NULL,NULL,NULL,5,'2023-06-11 23:07:00',NULL,'live',NULL,NULL,'2023-06-11 23:07:20','2023-06-11 23:07:20'),(26,5,NULL,NULL,NULL,16,'2023-06-11 23:09:00',NULL,'live',NULL,NULL,'2023-06-11 23:07:20','2024-12-23 17:06:30'),(27,5,NULL,NULL,NULL,2,'2023-06-11 23:09:00',NULL,'live',NULL,NULL,'2023-06-11 23:09:22','2023-06-11 23:09:22'),(28,2,NULL,NULL,NULL,1,'2023-06-11 23:13:00',NULL,'live',NULL,NULL,'2023-06-11 23:10:38','2023-06-11 23:13:38'),(29,2,NULL,NULL,NULL,1,'2023-06-11 23:15:00',NULL,'live',NULL,NULL,'2023-06-11 23:13:39','2023-06-11 23:15:36'),(30,2,NULL,NULL,NULL,1,'2023-06-11 23:18:00',NULL,'live',NULL,NULL,'2023-06-11 23:15:36','2023-06-11 23:18:23'),(31,2,NULL,NULL,NULL,8,'2023-06-11 23:19:00',NULL,'live',NULL,NULL,'2023-06-11 23:18:24','2023-06-11 23:19:24'),(32,2,NULL,NULL,NULL,7,'2023-06-11 23:21:00',NULL,'live',NULL,NULL,'2023-06-11 23:19:24','2023-06-11 23:21:53'),(33,6,NULL,NULL,NULL,9,'2023-06-11 23:24:00',NULL,'live',NULL,NULL,'2023-06-11 23:22:47','2023-06-11 23:24:30'),(34,6,NULL,NULL,NULL,9,'2023-06-11 23:24:00',NULL,'live',NULL,NULL,'2023-06-11 23:24:30','2023-06-11 23:24:30'),(35,6,NULL,NULL,NULL,9,'2023-06-11 23:25:00',NULL,'live',NULL,NULL,'2023-06-11 23:24:30','2023-06-11 23:25:48'),(36,6,NULL,NULL,NULL,9,'2023-06-11 23:25:00',NULL,'live',NULL,NULL,'2023-06-11 23:25:49','2023-06-11 23:25:49'),(37,6,NULL,NULL,NULL,9,'2023-06-11 23:27:00',NULL,'live',NULL,NULL,'2023-06-11 23:25:49','2023-06-11 23:27:15'),(38,6,NULL,NULL,NULL,9,'2023-06-11 23:27:00',NULL,'live',NULL,NULL,'2023-06-11 23:27:16','2023-06-11 23:27:16'),(39,6,NULL,NULL,NULL,9,'2023-06-11 23:28:00',NULL,'live',NULL,NULL,'2023-06-11 23:27:16','2023-06-11 23:28:53'),(40,6,NULL,NULL,NULL,9,'2023-06-11 23:28:00',NULL,'live',NULL,NULL,'2023-06-11 23:28:53','2023-06-11 23:28:53'),(41,6,NULL,NULL,NULL,9,'2023-06-11 23:29:00',NULL,'live',NULL,NULL,'2023-06-11 23:28:53','2023-06-11 23:29:54'),(42,6,NULL,NULL,NULL,9,'2023-06-11 23:29:00',NULL,'live',NULL,NULL,'2023-06-11 23:29:55','2023-06-11 23:29:55'),(51,5,NULL,NULL,NULL,5,'2023-06-11 23:07:00',NULL,'live',NULL,NULL,'2023-06-12 18:58:07','2023-06-12 18:58:07'),(86,NULL,NULL,26,24,18,'2024-12-23 17:06:00',NULL,'live',NULL,NULL,'2024-12-23 17:06:30','2024-12-23 17:06:30'),(87,5,NULL,NULL,NULL,16,'2023-06-11 23:09:00',NULL,'live',NULL,NULL,'2024-12-23 17:06:30','2024-12-23 17:06:30'),(88,NULL,NULL,87,24,18,'2024-12-23 17:06:00',NULL,'live',NULL,NULL,'2024-12-23 17:06:30','2024-12-23 17:06:30'),(91,5,NULL,NULL,NULL,16,'2023-06-11 23:09:00',NULL,'live',NULL,NULL,'2024-12-23 17:07:38','2024-12-23 17:07:38'),(92,NULL,NULL,91,24,18,'2024-12-23 17:06:00',NULL,'live',NULL,NULL,'2024-12-23 17:07:38','2024-12-23 17:07:38'),(95,NULL,NULL,22,24,11,'2024-12-23 17:08:00',NULL,'live',NULL,NULL,'2024-12-23 17:08:55','2024-12-23 17:08:55'),(96,5,NULL,NULL,NULL,16,'2023-06-11 23:05:00',NULL,'live',NULL,NULL,'2024-12-23 17:08:55','2024-12-23 17:08:55'),(97,NULL,NULL,96,24,11,'2024-12-23 17:08:00',NULL,'live',NULL,NULL,'2024-12-23 17:08:55','2024-12-23 17:08:55'),(101,NULL,NULL,20,24,13,'2024-12-23 17:10:00',NULL,'live',NULL,NULL,'2024-12-23 17:11:06','2024-12-23 17:11:06'),(102,NULL,NULL,20,24,12,'2024-12-23 17:11:00',NULL,'live',NULL,NULL,'2024-12-23 17:11:06','2024-12-23 17:11:06'),(103,5,NULL,NULL,NULL,16,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2024-12-23 17:11:06','2024-12-23 17:11:06'),(104,NULL,NULL,103,24,13,'2024-12-23 17:10:00',NULL,'live',NULL,NULL,'2024-12-23 17:11:06','2024-12-23 17:11:06'),(105,NULL,NULL,103,24,12,'2024-12-23 17:11:00',NULL,'live',NULL,NULL,'2024-12-23 17:11:06','2024-12-23 17:11:06'),(116,6,NULL,NULL,NULL,9,'2023-06-11 23:29:00',NULL,'live',NULL,NULL,'2024-12-23 17:21:24','2024-12-23 17:21:24'),(119,6,NULL,NULL,NULL,9,'2023-06-11 23:28:00',NULL,'live',NULL,NULL,'2024-12-23 17:21:36','2024-12-23 17:21:36'),(122,6,NULL,NULL,NULL,9,'2023-06-11 23:25:00',NULL,'live',NULL,NULL,'2024-12-23 17:21:47','2024-12-23 17:21:47'),(125,6,NULL,NULL,NULL,9,'2023-06-11 23:24:00',NULL,'live',NULL,NULL,'2024-12-23 17:21:56','2024-12-23 17:21:56'),(128,NULL,NULL,18,24,14,'2024-12-23 17:23:00',NULL,'live',NULL,NULL,'2024-12-23 17:24:00','2024-12-23 17:24:00'),(129,5,NULL,NULL,NULL,16,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2024-12-23 17:24:00','2024-12-23 17:24:00'),(130,NULL,NULL,129,24,14,'2024-12-23 17:23:00',NULL,'live',NULL,NULL,'2024-12-23 17:24:01','2024-12-23 17:24:01'),(133,NULL,NULL,18,24,10,'2024-12-23 17:25:00',NULL,'live',NULL,NULL,'2024-12-23 17:25:10','2024-12-23 17:25:10'),(134,5,NULL,NULL,NULL,16,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2024-12-23 17:25:10','2024-12-23 17:25:10'),(135,NULL,NULL,134,24,10,'2024-12-23 17:25:00',NULL,'live',NULL,NULL,'2024-12-23 17:25:10','2024-12-23 17:25:10'),(138,5,NULL,NULL,NULL,16,'2023-06-11 23:04:00',NULL,'live',NULL,NULL,'2024-12-23 17:25:31','2024-12-23 17:25:31'),(139,NULL,NULL,138,24,10,'2024-12-23 17:25:00',NULL,'live',NULL,NULL,'2024-12-23 17:25:31','2024-12-23 17:25:31'),(142,NULL,NULL,24,24,17,'2024-12-23 17:28:00',NULL,'live',NULL,NULL,'2024-12-23 17:28:05','2024-12-23 17:28:05'),(143,5,NULL,NULL,NULL,16,'2023-06-11 23:07:00',NULL,'live',NULL,NULL,'2024-12-23 17:28:05','2024-12-23 17:28:05'),(144,NULL,NULL,143,24,17,'2024-12-23 17:28:00',NULL,'live',NULL,NULL,'2024-12-23 17:28:05','2024-12-23 17:28:05'),(147,5,NULL,NULL,NULL,16,'2023-06-11 23:07:00',NULL,'live',NULL,NULL,'2024-12-23 17:29:11','2024-12-23 17:29:11'),(148,NULL,NULL,147,24,17,'2024-12-23 17:28:00',NULL,'live',NULL,NULL,'2024-12-23 17:29:11','2024-12-23 17:29:11');
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entries_authors`
--

LOCK TABLES `entries_authors` WRITE;
/*!40000 ALTER TABLE `entries_authors` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entries_authors` VALUES (18,3,1),(19,3,1),(20,3,1),(21,3,1),(22,3,1),(23,3,1),(24,3,1),(25,3,1),(26,3,1),(27,3,1),(28,3,1),(29,3,1),(30,3,1),(31,3,1),(32,3,1),(33,3,1),(34,3,1),(35,3,1),(36,3,1),(37,3,1),(38,3,1),(39,3,1),(40,3,1),(41,3,1),(42,3,1),(51,3,1),(87,3,1),(91,3,1),(96,3,1),(103,3,1),(116,3,1),(119,3,1),(122,3,1),(125,3,1),(129,3,1),(134,3,1),(138,3,1),(143,3,1),(147,3,1);
/*!40000 ALTER TABLE `entries_authors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entrytypes`
--

LOCK TABLES `entrytypes` WRITE;
/*!40000 ALTER TABLE `entrytypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entrytypes` VALUES (1,1,'Bandcamp Embed','bandcampEmbed','',NULL,1,'site',NULL,'',1,'site',NULL,1,'2023-06-11 22:50:13','2024-12-23 16:39:51',NULL,'1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9'),(2,2,'Custom Page','customPage',NULL,NULL,1,'site',NULL,NULL,1,'site',NULL,1,'2023-06-11 22:50:13','2023-06-11 22:50:13',NULL,'7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1'),(4,4,'Gigs - Default','gigs_default','',NULL,1,'site',NULL,'',1,'site',NULL,1,'2023-06-11 22:50:13','2024-12-23 16:39:51',NULL,'66d475d7-97b8-40dc-9212-f05ea6e23d4c'),(5,5,'Gallery Page','galleryPage',NULL,NULL,1,'site',NULL,NULL,1,'site',NULL,1,'2023-06-11 22:50:13','2023-06-11 22:50:13',NULL,'d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae'),(6,6,'Home','home','house',NULL,0,'site',NULL,'{section.name|raw}',1,'site',NULL,1,'2023-06-11 22:50:13','2024-12-23 16:39:51',NULL,'8506d742-5b2a-47fe-97d8-880505113629'),(7,7,'SoundCloud Embed','soundcloudEmbed','',NULL,1,'site',NULL,'',1,'site',NULL,1,'2023-06-11 22:50:15','2024-12-23 16:39:51',NULL,'44f5fc6a-9bb6-457e-99fd-d88a30b802f0'),(8,8,'Spotify Embed','spotifyEmbed','',NULL,1,'site',NULL,'',1,'site',NULL,1,'2023-06-11 22:50:15','2024-12-23 16:39:51',NULL,'f494ab8a-02d3-48a3-bf69-103c6c96824c'),(9,9,'YouTube Video','youtubeVideo','',NULL,1,'site',NULL,'',0,'site',NULL,1,'2023-06-11 22:50:15','2024-12-23 16:39:51',NULL,'3879dbdd-7514-41f1-b0f8-cb825ab28546'),(10,15,'General Content','generalContent','align-justify','sky',1,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'cd84622a-df79-4b5b-9d98-f9e7ed621fd0'),(11,16,'Embeds Module','embedsModule','music','sky',1,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'2e37ec0b-896a-4a3b-953f-59d7f5127a84'),(12,17,'Video Grid','videoGrid','play','sky',1,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'9d2b7c77-acc5-4dba-8641-d02de2fbc1b6'),(13,18,'Gigs Module','gigsModule','drum','sky',1,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'72dbefd4-129d-400a-8161-f80241c6cd51'),(14,19,'Media & Content','mediaContent','image-polaroid','sky',1,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e'),(15,20,'Spacer','spacer','gear',NULL,0,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'9acc1147-87aa-4431-a099-130a6abe949c'),(16,21,'Builder Page','builderPage','cubes',NULL,1,'site',NULL,'',1,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'b2893806-8044-42c4-967c-a961476b4c1c'),(17,22,'Gallery','gallery','rectangle-history','sky',1,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'e01c47a5-80c5-41ea-9079-eb5d9c990ce4'),(18,23,'Media & Form','mediaForm','pen-field','sky',1,'site',NULL,'',0,'site',NULL,1,'2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'bb9b9ea2-bf37-44e0-be22-153bca5edd1b');
/*!40000 ALTER TABLE `entrytypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayouts`
--

LOCK TABLES `fieldlayouts` WRITE;
/*!40000 ALTER TABLE `fieldlayouts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayouts` VALUES (1,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"358b2e5f-a79a-4b07-8eeb-00b203dc8e18\", \"name\": \"Bandcamp Embed\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"d3f55934-f5cf-488b-b225-68d224808a22\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-06T21:22:42+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"8a8f6a4e-e44f-4f75-ba6c-93934f05d583\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": \"embedCode\", \"warning\": null, \"fieldUid\": \"e8fbb0cf-f013-47b2-8a71-e0aac50e9a06\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:42+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:13','2024-12-23 16:39:51',NULL,'a17f307f-c301-4429-8b56-b7558f30ea0c'),(2,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"ba7ae951-de64-4bf5-9fab-7c37580fc30a\", \"name\": \"Custom Page\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"ccf316cc-dcf8-4899-ad56-a2c7a5b7b9c3\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-23T08:45:54-08:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"00aaed21-f3e9-4b6c-958f-618a06e3e7ca\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"139b20e8-6e1b-4e75-be7f-776bc8a50d43\", \"required\": false, \"dateAdded\": \"2024-12-23T08:45:54-08:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:13','2024-12-23 16:46:54',NULL,'25586ae0-ad0e-4e86-84bc-2aa4a77fbc94'),(4,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"49e37225-d557-43d3-bf39-bc06951a61f1\", \"name\": \"Gigs\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"6dfceb4f-a9aa-4a26-ac03-e7b49f426172\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"4449fc6a-6bcd-4096-9f74-db2eb500d9c3\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"cf9cc357-e972-4534-96a3-16243a7d4e25\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"09393b89-901f-431a-ac15-6e09ec994593\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"e2acdefe-2270-4161-989c-4cacd80454da\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"24fce9c1-bfcc-4bc8-be40-6c1a4d7b1bf2\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"afa92d21-9da5-4728-b388-676ab1b11c37\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": true, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"f0b26a45-2a0e-4226-97d0-031e0c5f7f1e\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"82e690ff-8e29-4b0d-850d-c09a6cc8871f\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"layoutElement:4449fc6a-6bcd-4096-9f74-db2eb500d9c3\", \"layoutElement:09393b89-901f-431a-ac15-6e09ec994593\"]}','2023-06-11 22:50:13','2024-12-23 16:39:51',NULL,'45ee0ef2-d574-44c6-a28d-ac7826a02477'),(5,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"7436cdd9-7d2e-4b5e-a35f-3aa5153924ca\", \"name\": \"Gallery Page\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"22625b58-3084-4a82-b270-15b8198b5ce6\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-23T08:45:53-08:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"7c7f8bad-b29c-43d4-aab7-e46e00775240\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"ad2a34fc-908d-4a7e-b211-235d769602d3\", \"required\": false, \"dateAdded\": \"2024-12-23T08:45:53-08:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:13','2024-12-23 16:46:53',NULL,'279e5b91-22f6-4dbb-8e3d-95bc6c2706a9'),(6,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"8165a1c5-0fdb-4e05-b74d-815df015a964\", \"name\": \"Content\", \"elements\": [{\"uid\": \"42183623-71c0-4fd4-9458-52dcc7bbdd6f\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Homepage Content\", \"dateAdded\": \"2024-12-11T22:07:54+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"a04b38f6-8a21-4cab-868b-a8272a1734d6\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"d036f92a-3e96-4a73-b959-e8cf8df3c077\", \"required\": false, \"dateAdded\": \"2024-12-11T21:55:33+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"6632dbcb-1a41-4851-b4ce-714e6ed7806a\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Subheading\", \"width\": 100, \"handle\": \"subheading\", \"warning\": null, \"fieldUid\": \"d036f92a-3e96-4a73-b959-e8cf8df3c077\", \"required\": false, \"dateAdded\": \"2024-12-11T21:55:33+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"uid\": \"9cd608f7-2056-47ea-a23d-66c6e245f5b2\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-11T21:55:33+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Will fallback to an image by default on mobile view.\", \"uid\": \"d967ff84-b439-468f-9c28-9ddfdcc40765\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Background Video\", \"width\": 100, \"handle\": \"backgroundVideo\", \"warning\": null, \"fieldUid\": \"d10f8d89-ce67-4b10-bbe3-42358861dbc1\", \"required\": false, \"dateAdded\": \"2024-12-11T21:55:33+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:13','2024-12-23 16:39:51',NULL,'d4aefd62-4576-451d-bfed-e8d83cd166ff'),(7,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"20decf46-25c4-45dc-87cc-dd00b5b911b9\", \"name\": \"SoundCloud Embed\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"47116a2f-d30d-40a7-a63e-23502354a68d\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"036d6841-6bb9-487d-a01b-c28cb4d2937b\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": \"embedCode\", \"warning\": null, \"fieldUid\": \"be2a1882-9121-4306-87b1-450de9d53256\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:15','2024-12-23 16:39:51',NULL,'e4347c61-d895-4989-b23b-7902e307d7da'),(8,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"9dd4191e-eea3-4711-bfea-cf7c2564ca6e\", \"name\": \"Spotify Embed\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"9a388b4a-5b98-4822-82f9-ef14e26b3e64\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"58557f92-7d83-4a51-8d3e-b9b38ab91b11\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": \"embedCode\", \"warning\": null, \"fieldUid\": \"9529e1cb-135c-4e74-bd95-f62c6d2bc858\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:15','2024-12-23 16:39:51',NULL,'c123a272-94e8-4203-bbe3-9b0757fe5ebc'),(9,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"722bb48c-811c-419a-9a90-a20cf0e98a2c\", \"name\": \"YouTube Video\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"6fc70047-bb74-4133-9e67-2e87291af2a2\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 50, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 50, \"handle\": null, \"warning\": null, \"fieldUid\": \"21bf5ac9-a185-4970-b6dc-e66c96ef0807\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}, {\"uid\": \"8d3a8b42-9b0d-426b-8222-730940f8f05b\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-13T21:56:34+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"64feaee3-2e6d-4070-8a5f-799139399d2c\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"8714d452-365e-4edd-ba97-237557f2207f\", \"required\": false, \"dateAdded\": \"2024-12-13T21:56:34+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": true, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"layoutElement:fe57c07c-1d69-43c3-8baf-c2260e45ac3e\"]}','2023-06-11 22:50:15','2024-12-23 16:39:51',NULL,'c1f4dd43-494c-4ed0-a33e-4dd588a90f0d'),(10,'craft\\elements\\GlobalSet','{\"tabs\": [{\"uid\": \"c0ed7fb0-9c7a-44ca-8762-26003b537f66\", \"name\": \"Site Settings\", \"elements\": [{\"uid\": \"66a5705a-cde3-4ef9-b59e-e5b804664329\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Site Settings\", \"dateAdded\": \"2024-12-17T15:28:07+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"ce516f33-2e70-405c-99a1-2d8d64bacc3d\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"a10d1b66-619c-4f4b-99c3-ad63094cbee2\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"71169323-2209-4100-8975-7e9bb5a6d9d7\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"c8c54e69-7104-493a-bd99-0e36b6428cac\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"9167b446-1840-45ea-8aa9-300e555b1344\", \"required\": false, \"dateAdded\": \"2024-12-06T21:22:43+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:15','2024-12-23 16:39:51',NULL,'f894566f-5464-4b8d-8ad0-d61946bf5361'),(11,'craft\\elements\\Asset','{\"tabs\": [{\"uid\": \"feee6ad3-4eb1-45da-99bf-88c9fe87c140\", \"name\": \"Content\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"f278b982-ac20-4918-ac40-1849d642bb11\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\assets\\\\AssetTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"dateAdded\": \"2024-12-23T08:45:53-08:00\", \"inputType\": null, \"requirable\": false, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:16','2024-12-23 16:46:53',NULL,'d30ad1d2-d72e-47f0-b630-a60820c3ddb2'),(12,'craft\\elements\\Asset','{\"tabs\": [{\"uid\": \"36b29584-0e2c-44aa-9183-9125ce17a094\", \"name\": \"Content\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"b1e1be8c-0a34-4ab5-b928-12be7d716ef3\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\assets\\\\AssetTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"dateAdded\": \"2024-12-23T08:45:53-08:00\", \"inputType\": null, \"requirable\": false, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2023-06-11 22:50:16','2024-12-23 16:46:53',NULL,'4631d292-bafd-4363-a467-9e79d10e2b83'),(13,'craft\\elements\\Address','{\"tabs\": [{\"uid\": \"0eecb70d-d965-4f3f-9be4-1649ebedaeb8\", \"name\": \"Content\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"70e5e657-7239-4906-b051-e615e0bb82aa\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\addresses\\\\LabelField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"dateAdded\": \"2024-12-23T16:29:15+00:00\", \"inputType\": null, \"requirable\": false, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"id\": null, \"tip\": null, \"uid\": \"879b37dc-7f98-497a-83eb-316e40a714dc\", \"type\": \"craft\\\\fieldlayoutelements\\\\addresses\\\\CountryCodeField\", \"label\": null, \"width\": 100, \"warning\": null, \"attribute\": \"countryCode\", \"dateAdded\": \"2024-12-23T16:29:15+00:00\", \"requirable\": false, \"orientation\": null, \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"a53dc581-c151-4f75-8a63-b2e9493fc545\", \"type\": \"craft\\\\fieldlayoutelements\\\\addresses\\\\AddressField\", \"label\": null, \"warning\": null, \"required\": false, \"dateAdded\": \"2024-12-23T16:29:15+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2024-12-23 16:33:36','2024-12-23 16:33:36',NULL,'ac88ed23-0855-458d-b3de-ef7a980d97f0'),(15,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"278ac8ce-0230-45f8-8b5a-db1e203ae280\", \"name\": \"Content\", \"elements\": [{\"uid\": \"8c600950-1ddd-49d3-aced-19eb226522fe\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Content\", \"dateAdded\": \"2024-12-11T16:12:40+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"0a6f6218-f26f-44f8-ad46-e01dbe2f2db1\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": \"Title (optional)\", \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": false, \"dateAdded\": \"2024-12-09T21:01:17+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"tip\": null, \"uid\": \"83e1b785-31e6-43ef-b9f4-bb7876909f01\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Content Body\", \"width\": 100, \"handle\": \"contentBody\", \"warning\": null, \"fieldUid\": \"bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1\", \"required\": false, \"dateAdded\": \"2024-12-11T16:04:45+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"8619f87b-709b-4fd7-8ddc-d85284ad8338\", \"name\": \"Appearance\", \"elements\": [{\"uid\": \"7203d243-646c-468d-a2eb-349045146575\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Appearance\", \"dateAdded\": \"2024-12-11T16:12:40+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Defaults to light grey (#eeeeee)\", \"uid\": \"c16179d6-400d-4018-be91-230624617fa4\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Background Color\", \"width\": 50, \"handle\": \"backgroundColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-11T16:12:40+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": \"Defaults to Slate 600 (#475569)\", \"uid\": \"6f905075-4334-45e7-b089-8ad3f5347372\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Content Color\", \"width\": 50, \"handle\": \"contentColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-11T16:12:40+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"type\", \"layoutElement:83e1b785-31e6-43ef-b9f4-bb7876909f01\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'f3684c66-104b-4a56-901c-f8c161bb11f1'),(16,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"2a63d9c1-a199-47a4-9e5d-1c4a71633778\", \"name\": \"Content\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"a268d50a-a1d3-441e-b8c6-8b59b92c4cd9\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": false, \"dateAdded\": \"2024-12-23T15:39:46+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"uid\": \"73adf8b9-bf6e-4c4d-ad7b-3e52904c0f12\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-23T15:49:44+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"23d6b77a-e903-4ceb-991d-6b1f2310d49b\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Embeds | Left\", \"width\": 50, \"handle\": \"embedsLeft\", \"warning\": null, \"fieldUid\": \"299192bd-bbe9-4f2a-b1b4-b8f6f80905ef\", \"required\": false, \"dateAdded\": \"2024-12-23T15:49:44+00:00\", \"instructions\": \"Select the music embeds to display on the left side of this module (top on mobile).\", \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"d89d9435-d547-4ba7-bc61-7ab17389355e\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Embeds | Right\", \"width\": 50, \"handle\": \"embedsRight\", \"warning\": null, \"fieldUid\": \"299192bd-bbe9-4f2a-b1b4-b8f6f80905ef\", \"required\": false, \"dateAdded\": \"2024-12-23T15:49:44+00:00\", \"instructions\": \"Select the music embeds to display on the right side of this module (bottom on mobile).\", \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"layoutElement:23d6b77a-e903-4ceb-991d-6b1f2310d49b\", \"layoutElement:d89d9435-d547-4ba7-bc61-7ab17389355e\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'63310011-23c1-4072-bb75-680121ee9d7e'),(17,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"a5dc5f50-b6b2-4f71-8403-493a84bcdf3d\", \"name\": \"Content\", \"elements\": [{\"uid\": \"49096e4c-fbeb-47dd-afb1-8a980e3f4a01\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Content\", \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"a4976ec1-004b-465e-9668-663eef31afb4\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": false, \"dateAdded\": \"2024-12-09T21:02:59+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"uid\": \"e941b2be-fb17-4079-9f98-4e6b178a6651\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"6943897f-3459-431b-acf7-eda6ce763c03\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"3b374f35-1602-4985-917c-bd65649ca09e\", \"required\": false, \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"4e73971e-c42e-41d7-b623-14f437aac977\", \"name\": \"Appearance\", \"elements\": [{\"uid\": \"d71f2690-6e17-4cbb-acc7-d1d665367050\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Appearance\", \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Defaults to light grey (#eeeeee)\", \"uid\": \"a08a9864-42f7-402e-91e4-c3c5b829ec12\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Background Color\", \"width\": 50, \"handle\": \"backgroundColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": \"Defaults to Slate 600 (#475569)\", \"uid\": \"3c5e564b-5439-4a1b-9dd1-790d5b051f4b\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Content Color\", \"width\": 50, \"handle\": \"contentColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"uid\": \"c2453b04-ec57-433d-98d4-9168e12bd9e6\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Defaults to 2 columns.\", \"uid\": \"a3d64401-5bbb-4c18-bf87-927e5484984a\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Number of Card Columns\", \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"00f0f6fc-444a-4eb0-b660-fcbb5c85f41f\", \"required\": false, \"dateAdded\": \"2024-12-16T21:04:31+00:00\", \"instructions\": \"Select number of card columns within the video grid.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"layoutElement:6943897f-3459-431b-acf7-eda6ce763c03\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'1ea3226d-28de-4336-8608-8923a8c6d075'),(18,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"e1cf09d8-74f4-475c-8524-2a3e91c02c2f\", \"name\": \"Content\", \"elements\": [{\"uid\": \"3dbe31b5-53d2-482b-b91b-a6d44c5290c2\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Content\", \"dateAdded\": \"2024-12-17T16:22:42+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"393267c5-a945-4648-9976-949f21d2842f\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": false, \"dateAdded\": \"2024-12-17T15:59:14+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"uid\": \"73dbc846-3428-4615-930a-0dc1f3e5dd34\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-17T16:02:07+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"bf086f1b-fdb4-49a5-914d-ff5be4160d9e\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6\", \"required\": false, \"dateAdded\": \"2024-12-17T16:02:07+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"9a89d999-ab9b-4ea7-aa37-537e93e629b1\", \"name\": \"Appearance\", \"elements\": [{\"uid\": \"1f571744-b142-453d-9b23-79c8c0c6efea\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Appearance\", \"dateAdded\": \"2024-12-17T16:22:42+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Defaults to light grey (#eeeeee)\", \"uid\": \"71ded80b-49b9-46e3-85ff-2602c77d923f\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Background Color\", \"width\": 50, \"handle\": \"backgroundColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-17T16:22:42+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": \"Defaults to Slate 600 (#475569)\", \"uid\": \"6bec848a-f4fe-4af0-bdae-e301b4a079f4\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Content Color\", \"width\": 50, \"handle\": \"contentColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-17T16:22:42+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"type\", \"layoutElement:bf086f1b-fdb4-49a5-914d-ff5be4160d9e\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'d78b9da7-5b76-4153-a3de-121fee83c729'),(19,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"77d98afa-4006-40be-bbb4-028c6fe10e7a\", \"name\": \"Content\", \"elements\": [{\"uid\": \"f03f0f81-dbd6-4091-ba52-545150533398\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Content\", \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"1e61cece-f808-4530-8dd9-3d772838e9ab\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": \"Title (optional)\", \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": false, \"dateAdded\": \"2024-12-09T21:00:14+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"uid\": \"a19d6249-3292-40f1-a7cb-762d49609ffe\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"646a03f3-de83-4c80-a744-3df1b36feaa6\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Content Body\", \"width\": 100, \"handle\": \"contentBody\", \"warning\": null, \"fieldUid\": \"bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1\", \"required\": false, \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"5547c3e2-8d95-46fe-92c1-fa64213d2e81\", \"name\": \"Media\", \"elements\": [{\"uid\": \"a7b2d8fd-94c6-40ed-adbb-c244b11de5ba\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Media\", \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"e852593c-0eee-4f81-9f97-6d7338a34729\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 50, \"handle\": null, \"warning\": null, \"fieldUid\": \"77d34c46-29a6-47a9-b5c4-8a7ffa61a10d\", \"required\": false, \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": \"Enable this to add a video popup element to this image.\", \"uid\": \"ddf98bdc-334f-45fb-ad97-ff47dab66999\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Add Video\", \"width\": 50, \"handle\": \"includeVideo\", \"warning\": null, \"fieldUid\": \"8f75a6ba-cffb-47c7-8031-e37daf2cdd33\", \"required\": false, \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"uid\": \"2fc91234-2b25-4145-b42e-3585eb13f8fb\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Video\", \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"userCondition\": null, \"elementCondition\": {\"class\": \"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\", \"elementType\": \"craft\\\\elements\\\\Entry\", \"fieldContext\": \"global\", \"conditionRules\": [{\"uid\": \"0360ecd4-be32-4082-8256-697b6370e199\", \"class\": \"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\", \"value\": true, \"fieldUid\": \"8f75a6ba-cffb-47c7-8031-e37daf2cdd33\", \"layoutElementUid\": \"ddf98bdc-334f-45fb-ad97-ff47dab66999\"}]}}, {\"tip\": null, \"uid\": \"997a595a-0b6b-4019-b9e1-1f110d6b36b7\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"21bf5ac9-a185-4970-b6dc-e66c96ef0807\", \"required\": false, \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": {\"class\": \"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\", \"elementType\": \"craft\\\\elements\\\\Entry\", \"fieldContext\": \"global\", \"conditionRules\": [{\"uid\": \"cbc5c51c-af75-4afb-9361-83661dd9a2ba\", \"class\": \"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\", \"value\": true, \"fieldUid\": \"8f75a6ba-cffb-47c7-8031-e37daf2cdd33\", \"layoutElementUid\": \"ddf98bdc-334f-45fb-ad97-ff47dab66999\"}]}}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"3c248002-9f57-4f9d-b790-b8be7b481a8c\", \"name\": \"Appearance\", \"elements\": [{\"uid\": \"ea8c56f0-739b-46fd-95ff-18254a5bd550\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Appearance\", \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Select where the media should be aligned in this module.\", \"uid\": \"b2a010a0-f97d-4241-97fa-34e1309866ce\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"e253049a-7803-4ae2-9b10-fb60c6c591b8\", \"required\": false, \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"uid\": \"63ad09fd-e9fb-4fd1-b72c-5f5f571a7de5\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-10T21:09:07+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Defaults to light grey (#eeeeee)\", \"uid\": \"e3c2d2bb-2ed2-4842-b343-da08f0fef487\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Background Color\", \"width\": 50, \"handle\": \"backgroundColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-10T20:55:24+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": \"Defaults to Slate 600 (#475569)\", \"uid\": \"ffa6c54e-cb3d-4884-a2f6-0c39e11ced39\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Content Color\", \"width\": 50, \"handle\": \"contentColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-10T21:09:07+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"type\", \"layoutElement:e852593c-0eee-4f81-9f97-6d7338a34729\", \"layoutElement:646a03f3-de83-4c80-a744-3df1b36feaa6\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'6ad38b32-9a3d-498f-be49-6983ca12bc18'),(20,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"f682f24c-294a-4d33-8715-73444572bc43\", \"name\": \"Content\", \"elements\": [{\"tip\": null, \"uid\": \"23c0dbad-08fa-486b-8725-6ac79053a366\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"29495b4d-2d51-4bf0-8f60-535b022b411f\", \"required\": false, \"dateAdded\": \"2024-12-11T15:37:30+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"02d96b39-4c8f-4939-ba82-0ee166c39ac2\", \"name\": \"Appearance\", \"elements\": [{\"tip\": \"Defaults to light grey (#eeeeee)\", \"uid\": \"18a0333b-a5a3-48b0-9081-bb68339fe86e\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Background Color\", \"width\": 100, \"handle\": \"backgroundColor\", \"warning\": null, \"fieldUid\": \"b28163a8-205c-4838-ac55-20538571deaa\", \"required\": false, \"dateAdded\": \"2024-12-11T15:38:29+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"type\", \"layoutElement:23c0dbad-08fa-486b-8725-6ac79053a366\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'b319f363-355d-4058-ada9-93d307a7fb0d'),(21,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"a575f1c4-0d9d-4756-b161-3bd618e29634\", \"name\": \"Content\", \"elements\": [{\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"cb6948ae-53c8-42d5-88df-09a622aef28b\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": true, \"dateAdded\": \"2024-12-09T20:57:15+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"uid\": \"aed4db2f-2fa6-4762-85c7-18fca033f959\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-09T21:05:37+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"bdd64b90-f86e-490a-9c9f-dd52808849f8\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"643f413e-3181-4811-821a-4eb565329c16\", \"required\": false, \"dateAdded\": \"2024-12-09T21:05:37+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'ee98d65b-ec38-434d-8fc9-622afe9c9010'),(22,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"337bbd63-718d-4ad0-b9b8-b46ad2bd16c1\", \"name\": \"Content\", \"elements\": [{\"uid\": \"ea4446f9-aba1-44b0-838c-937914534360\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Content\", \"dateAdded\": \"2024-12-19T16:58:36+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"049d8f86-7169-4019-af93-a04ffbdaada3\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": false, \"dateAdded\": \"2024-12-09T21:03:50+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"uid\": \"50c97eb0-5ccd-476f-892f-40be1c7a21f2\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-18T20:57:48+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"cba033be-6772-48c8-a025-f758da83e0c7\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"ad2a34fc-908d-4a7e-b211-235d769602d3\", \"required\": false, \"dateAdded\": \"2024-12-18T20:57:48+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"b6e78faf-d2f6-4539-8a04-5974a60a9a62\", \"name\": \"Appearance\", \"elements\": [{\"uid\": \"410afcef-8165-4020-a171-e898c2496f9b\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"General Swiper Settings\", \"dateAdded\": \"2024-12-19T16:58:36+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"87a5d55e-755f-4b58-b0b0-b83f8253e5a0\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Auto-Height\", \"width\": 100, \"handle\": \"configAutoHeight\", \"warning\": null, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"required\": false, \"dateAdded\": \"2024-12-19T16:58:36+00:00\", \"instructions\": \"If enabled, slider wrapper will adapt its height to the height of the currently active slide.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"b82c031d-45a7-4f45-994c-1b3fd2339738\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Autoplay\", \"width\": 50, \"handle\": \"configAutoplay\", \"warning\": null, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"required\": false, \"dateAdded\": \"2024-12-19T17:35:07+00:00\", \"instructions\": \"If enabled, the swiper will automatically swipe to the next slide without interaction.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": \"Defaults to 5 seconds if not set.\", \"uid\": \"77074409-4fed-4ddf-85c4-f0ad4e1aa6cb\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 50, \"handle\": \"configAutoplayDelay\", \"warning\": null, \"fieldUid\": \"9200bcdf-7a8c-466f-97f5-f08080ac3d03\", \"required\": false, \"dateAdded\": \"2024-12-19T17:35:07+00:00\", \"instructions\": \"Set the number of seconds to wait until the next slide is displayed.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": {\"class\": \"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\", \"elementType\": \"craft\\\\elements\\\\Entry\", \"fieldContext\": \"global\", \"conditionRules\": [{\"uid\": \"eb329d17-11a2-42ac-848d-ecdd4c09e71f\", \"class\": \"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\", \"value\": true, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"layoutElementUid\": \"b82c031d-45a7-4f45-994c-1b3fd2339738\"}]}}, {\"tip\": null, \"uid\": \"b3f6966d-7da6-4790-b5c4-d67b739b0c0f\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Freemode\", \"width\": 100, \"handle\": \"configFreemode\", \"warning\": null, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"required\": false, \"dateAdded\": \"2024-12-19T18:07:20+00:00\", \"instructions\": \"If enabled, the swiper slides will be \\\"unlocked\\\" so that slides can be loosely navigated.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"ac1e7d09-fa7f-4da0-9c9c-01a72d9c5afd\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Grab Cursor\", \"width\": 100, \"handle\": \"configGrabCursor\", \"warning\": null, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"required\": false, \"dateAdded\": \"2024-12-19T19:12:04+00:00\", \"instructions\": \"If enabled, the user\'s mouse cursor will be a grab hand when interacting with the swiper slides.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"b97b878c-6671-4f9e-8d1b-19c8f1f218a6\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Loop\", \"width\": 100, \"handle\": \"configLoop\", \"warning\": null, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"required\": false, \"dateAdded\": \"2024-12-19T19:16:46+00:00\", \"instructions\": \"If enabled, the swiper\'s slides will continuously loop.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"3af07ae9-5448-41b1-a5d7-8cf7c680a3bb\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"One-Way Movement\", \"width\": 100, \"handle\": \"configOneWayMovement\", \"warning\": null, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"required\": false, \"dateAdded\": \"2024-12-19T19:20:52+00:00\", \"instructions\": \"If enabled, slides will swipe only forward (one-way) regardless of swipe direction.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"f8f3c242-ec5c-4eb5-bc50-bdb9e7f8c73d\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Speed\", \"width\": 100, \"handle\": \"configSpeed\", \"warning\": null, \"fieldUid\": \"bced0888-a5a3-4f1f-b38c-6b52b005477d\", \"required\": false, \"dateAdded\": \"2024-12-19T19:30:47+00:00\", \"instructions\": \"Adjust the speed (in seconds) of the swipe animation between slides.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"uid\": \"98513b59-10f7-4be5-a2bb-0a1f45e2f176\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Swiper Effects\", \"dateAdded\": \"2024-12-19T21:58:04+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Defaults to \'slide\' setting.\", \"uid\": \"43c8d12b-18de-4460-91f7-13da7b631af9\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"46e12ab7-e122-464d-8364-4bfe2eefa5c3\", \"required\": false, \"dateAdded\": \"2024-12-19T21:58:04+00:00\", \"instructions\": \"Select the slide transition effect.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"uid\": \"11cb01a4-4057-424c-9143-b2a3fd2bb929\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Thumbnails\", \"dateAdded\": \"2024-12-20T18:34:16+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"5045aa0a-dc55-44d3-9da7-f3f4eb28a0ba\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Include Thumbnail Slider\", \"width\": 50, \"handle\": \"configThumbnails\", \"warning\": null, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"required\": false, \"dateAdded\": \"2024-12-20T18:34:16+00:00\", \"instructions\": \"If enabled, a navigable thumbnail slider will display below the main slider.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}, {\"tip\": \"Defaults to 10 pixels.\", \"uid\": \"349be4f9-a1b7-4e71-be5c-412fbc7d4b81\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": \"Space Between Thumbnail Slides\", \"width\": 50, \"handle\": \"configSpaceBetween\", \"warning\": null, \"fieldUid\": \"e6988761-5603-46e0-8f9a-7ec7b54a0e3e\", \"required\": false, \"dateAdded\": \"2024-12-20T19:15:43+00:00\", \"instructions\": \"Set the space/gap between the thumbnail slides.\", \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": {\"class\": \"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\", \"elementType\": \"craft\\\\elements\\\\Entry\", \"fieldContext\": \"global\", \"conditionRules\": [{\"uid\": \"9e0a0c7c-d42d-4a29-9bb5-54a78ea6acb0\", \"class\": \"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\", \"value\": true, \"fieldUid\": \"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\", \"layoutElementUid\": \"5045aa0a-dc55-44d3-9da7-f3f4eb28a0ba\"}]}}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"layoutElement:cba033be-6772-48c8-a025-f758da83e0c7\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'cf958c25-b339-481e-aa05-c28eb5453c5b'),(23,'craft\\elements\\Entry','{\"tabs\": [{\"uid\": \"51fe21f1-e92d-44d5-993e-af1a1747109b\", \"name\": \"Content\", \"elements\": [{\"uid\": \"01d39a1d-da3c-4258-b2fe-05a9fcb8459b\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Content & Form\", \"dateAdded\": \"2024-12-17T15:55:45+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"id\": null, \"max\": null, \"min\": null, \"tip\": null, \"uid\": \"f40941ff-b0aa-491d-899b-0a8c438d8c6a\", \"name\": null, \"size\": null, \"step\": null, \"type\": \"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\", \"class\": null, \"label\": null, \"title\": null, \"width\": 100, \"warning\": null, \"disabled\": false, \"readonly\": false, \"required\": false, \"dateAdded\": \"2024-12-09T21:02:19+00:00\", \"inputType\": null, \"autocorrect\": true, \"orientation\": null, \"placeholder\": null, \"autocomplete\": false, \"instructions\": null, \"userCondition\": null, \"autocapitalize\": true, \"includeInCards\": false, \"providesThumbs\": false, \"labelAttributes\": [], \"elementCondition\": null, \"containerAttributes\": [], \"inputContainerAttributes\": []}, {\"uid\": \"e793e111-2bfc-45c2-a543-cd575cb2f236\", \"type\": \"craft\\\\fieldlayoutelements\\\\HorizontalRule\", \"dateAdded\": \"2024-12-17T15:55:45+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Contact Form will automatically be rendered within this module.\", \"uid\": \"26cb54e9-692c-4234-be3a-a78aeb2a7a81\", \"type\": \"craft\\\\fieldlayoutelements\\\\Tip\", \"style\": \"tip\", \"dateAdded\": \"2024-12-17T15:57:14+00:00\", \"dismissible\": false, \"userCondition\": null, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"e14063ce-488f-4db9-8bc4-c594f8e754ac\", \"name\": \"Media\", \"elements\": [{\"uid\": \"d589a319-b8e6-483d-b610-c603bae58e6e\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Media\", \"dateAdded\": \"2024-12-17T15:55:45+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"e38579d0-3f4b-46df-86e4-9b46d38f80fb\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"77d34c46-29a6-47a9-b5c4-8a7ffa61a10d\", \"required\": false, \"dateAdded\": \"2024-12-17T15:55:45+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": true, \"providesThumbs\": true, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}, {\"uid\": \"9c4a77d1-3a35-4329-b09d-a357d5a31f9f\", \"name\": \"Appearance\", \"elements\": [{\"uid\": \"c3fb8968-1b77-40f0-b64d-a3d18964fabe\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Appearance\", \"dateAdded\": \"2024-12-17T15:55:45+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": \"Select where the media should be aligned in this module.\", \"uid\": \"8d2fe42a-ce89-4c3c-ab75-7077c8288c8b\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"e253049a-7803-4ae2-9b10-fb60c6c591b8\", \"required\": false, \"dateAdded\": \"2024-12-17T15:55:45+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": [\"type\", \"layoutElement:e38579d0-3f4b-46df-86e4-9b46d38f80fb\"]}','2024-12-23 16:39:51','2024-12-23 16:39:51',NULL,'3b9e8101-e667-460d-9d58-b3263e2b40d2'),(24,'craft\\elements\\GlobalSet','{\"tabs\": [{\"uid\": \"4b8af8d8-2cc9-47dd-80b5-7df1d539415a\", \"name\": \"Navigation Settings\", \"elements\": [{\"uid\": \"35f658d7-2d63-4079-b1b7-8ffee70ec203\", \"type\": \"craft\\\\fieldlayoutelements\\\\Heading\", \"heading\": \"Navigation Settings\", \"dateAdded\": \"2024-12-17T15:32:01+00:00\", \"userCondition\": null, \"elementCondition\": null}, {\"tip\": null, \"uid\": \"b21157a3-3efc-42f6-8515-0897c09c344d\", \"type\": \"craft\\\\fieldlayoutelements\\\\CustomField\", \"label\": null, \"width\": 100, \"handle\": null, \"warning\": null, \"fieldUid\": \"186e3495-0405-4ef9-8b6a-13ea813ea449\", \"required\": false, \"dateAdded\": \"2024-12-17T15:42:36+00:00\", \"instructions\": null, \"userCondition\": null, \"includeInCards\": false, \"providesThumbs\": false, \"elementCondition\": null}], \"userCondition\": null, \"elementCondition\": null}], \"cardView\": []}','2024-12-23 16:39:52','2024-12-23 16:39:52',NULL,'30ebfe5c-9f2a-4441-b824-d086e91d839e');
/*!40000 ALTER TABLE `fieldlayouts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fields`
--

LOCK TABLES `fields` WRITE;
/*!40000 ALTER TABLE `fields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fields` VALUES (1,'Bandcamp Embed','bandcampEmbed','global','inugegzp','Copy the Embed code from Bandcamp and paste it here ...',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":10,\"multiline\":true,\"placeholder\":\"Code goes here ...\",\"uiMode\":\"normal\"}','2023-06-11 22:50:10','2024-12-23 16:39:50',NULL,'e8fbb0cf-f013-47b2-8a71-e0aac50e9a06'),(2,'Client Email','clientEmail','global','vhxmksft',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":\"email@email.com\",\"uiMode\":\"normal\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'9167b446-1840-45ea-8aa9-300e555b1344'),(3,'Favicon','favicon','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"defaultUploadLocationSubpath\":null,\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"restrictedLocationSubpath\":null,\"selectionLabel\":\"Add a favicon\",\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":[\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83'),(4,'Gallery Images','galleryImages','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"defaultUploadLocationSubpath\":null,\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":null,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"restrictedLocationSubpath\":null,\"selectionLabel\":\"Add Gallery images\",\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":[\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'ad2a34fc-908d-4a7e-b211-235d769602d3'),(5,'Date','gigDate','global','rzbqtsud',NULL,0,'none',NULL,'craft\\fields\\Date','{\"max\":null,\"min\":null,\"minuteIncrement\":30,\"showDate\":true,\"showTime\":true,\"showTimeZone\":true}','2023-06-11 22:50:11','2023-06-11 22:50:11',NULL,'cf9cc357-e972-4534-96a3-16243a7d4e25'),(6,'Featured Image','gigFeaturedImage','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"defaultUploadLocationSubpath\":null,\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"restrictedLocationSubpath\":null,\"selectionLabel\":\"Add a featured image\",\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":[\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'afa92d21-9da5-4728-b388-676ab1b11c37'),(7,'Link','gigLink','global','lcmhpagu',NULL,0,'none',NULL,'craft\\fields\\Url','{\"maxLength\":255,\"types\":[\"url\"]}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'82e690ff-8e29-4b0d-850d-c09a6cc8871f'),(8,'Location','gigLocation','global','secazwrd',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'e2acdefe-2270-4161-989c-4cacd80454da'),(9,'Page Template','pageTemplate','global','jxvqpmcm','Path to page template',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'139b20e8-6e1b-4e75-be7f-776bc8a50d43'),(10,'Site Logo','siteLogo','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"defaultUploadLocationSubpath\":null,\"localizeRelations\":false,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"restrictedLocationSubpath\":null,\"selectionLabel\":null,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":[\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'a10d1b66-619c-4f4b-99c3-ad63094cbee2'),(11,'SoundCloud Embed','soundcloudEmbed','global','qpoyhsol','Copy the SoiundCloud Embed code from your track and paste it here ...',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":10,\"multiline\":true,\"placeholder\":\"Code goes here ...\",\"uiMode\":\"normal\"}','2023-06-11 22:50:11','2024-12-23 16:39:50',NULL,'be2a1882-9121-4306-87b1-450de9d53256'),(12,'Spotify Embed','spotifyEmbed','global','yzgetqnv','Copy your Spotify Embed code and paste it here ...',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":10,\"multiline\":true,\"placeholder\":\"Code goes here ...\",\"uiMode\":\"normal\"}','2023-06-11 22:50:12','2024-12-23 16:39:50',NULL,'9529e1cb-135c-4e74-bd95-f62c6d2bc858'),(13,'Email Address','submissionEmail','global','qqiavbhr',NULL,0,'none',NULL,'craft\\fields\\Email','{\"placeholder\":null}','2023-06-11 22:50:12','2023-06-11 22:50:12',NULL,'57ee90df-01e6-437a-8c5c-38815877f909'),(14,'Message','submissionMessage','global','rtpzqnhp',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":6,\"multiline\":true,\"placeholder\":null,\"uiMode\":\"normal\"}','2023-06-11 22:50:12','2024-12-23 16:39:50',NULL,'e17818c9-74b2-427e-9cf0-57f61d51b663'),(15,'Name','submissionName','global','fggnchnh',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2023-06-11 22:50:12','2024-12-23 16:39:50',NULL,'b61a32ce-4093-4b76-986a-5303ee05cc28'),(16,'Phone Number','submissionPhone','global','siyosvvg',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2023-06-11 22:50:12','2024-12-23 16:39:50',NULL,'ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d'),(17,'Subject','submissionSubject','global','ziqqexut',NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2023-06-11 22:50:12','2024-12-23 16:39:50',NULL,'962ca735-e2e0-4550-a295-93f517459468'),(18,'YouTube Video ID','youtubeVideoId','global','ydkphbeb','YouTube Video ID\r\nExample: ID for https://www.youtube.com/watch?v=E_l-b-8qSYA is E_l-b-8qSYA.',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"columnType\":null,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2023-06-11 22:50:12','2024-12-23 16:39:50',NULL,'21bf5ac9-a185-4970-b6dc-e66c96ef0807'),(19,'Space Between','spaceBetween','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Range','{\"defaultValue\":10,\"max\":40,\"min\":2,\"step\":2,\"suffix\":\"pixels\"}','2024-12-23 16:39:49','2024-12-23 16:39:49',NULL,'e6988761-5603-46e0-8f9a-7ec7b54a0e3e'),(20,'Padding Spacer','paddingSpacer','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Dropdown','{\"customOptions\":false,\"options\":[{\"label\":\"Small\",\"value\":\"small\",\"default\":\"1\"},{\"label\":\"Medium\",\"value\":\"medium\",\"default\":\"\"},{\"label\":\"Large\",\"value\":\"large\",\"default\":\"\"},{\"label\":\"XL\",\"value\":\"xl\",\"default\":\"\"},{\"label\":\"2XL\",\"value\":\"2xl\",\"default\":\"\"},{\"label\":\"3XL\",\"value\":\"3xl\",\"default\":\"\"}]}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'29495b4d-2d51-4bf0-8f60-535b022b411f'),(21,'Content Body (Simple)','contentBodySimple','global',NULL,NULL,0,'none',NULL,'craft\\ckeditor\\Field','{\"availableTransforms\":\"\",\"availableVolumes\":\"*\",\"ckeConfig\":\"e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465\",\"createButtonLabel\":null,\"defaultTransform\":null,\"enableSourceEditingForNonAdmins\":false,\"purifierConfig\":null,\"purifyHtml\":true,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"showWordCount\":true,\"wordLimit\":null}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1'),(22,'Lightswitch','lightswitch','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Lightswitch','{\"default\":false,\"offLabel\":null,\"onLabel\":null}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2'),(23,'Gig Select','gigSelect','global',NULL,'If none are selected, all upcoming gigs will be dynamically rendered in this module.',0,'none',NULL,'craft\\fields\\Entries','{\"allowSelfRelations\":false,\"branchLimit\":null,\"maintainHierarchy\":false,\"maxRelations\":20,\"minRelations\":null,\"selectionLabel\":\"Add a gig\",\"showCardsInGrid\":false,\"showSiteMenu\":true,\"sources\":[\"section:825f4bb2-160e-43de-b9e1-179a555f48ec\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"cards\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6'),(24,'Page Builder','pageBuilder','global',NULL,NULL,0,'site',NULL,'craft\\fields\\Matrix','{\"createButtonLabel\":\"New module\",\"defaultIndexViewMode\":\"cards\",\"entryTypes\":[\"2e37ec0b-896a-4a3b-953f-59d7f5127a84\",\"e01c47a5-80c5-41ea-9079-eb5d9c990ce4\",\"cd84622a-df79-4b5b-9d98-f9e7ed621fd0\",\"72dbefd4-129d-400a-8161-f80241c6cd51\",\"ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e\",\"bb9b9ea2-bf37-44e0-be22-153bca5edd1b\",\"9d2b7c77-acc5-4dba-8641-d02de2fbc1b6\",\"9acc1147-87aa-4431-a099-130a6abe949c\"],\"includeTableView\":false,\"maxEntries\":12,\"minEntries\":null,\"pageSize\":50,\"propagationKeyFormat\":null,\"propagationMethod\":\"all\",\"showCardsInGrid\":false,\"viewMode\":\"cards\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'643f413e-3181-4811-821a-4eb565329c16'),(25,'Color Picker','colorPicker','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Color','{\"defaultColor\":null,\"presets\":[\"#283450\",\"#475569\",\"#eeeeee\",\"#198754\"]}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'b28163a8-205c-4838-ac55-20538571deaa'),(26,'Navigation Links','navigationLinks','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Entries','{\"allowSelfRelations\":false,\"branchLimit\":null,\"maintainHierarchy\":false,\"maxRelations\":10,\"minRelations\":null,\"selectionLabel\":\"Add a nav link\",\"showCardsInGrid\":false,\"showSiteMenu\":false,\"sources\":[\"section:d9c26beb-6bee-444c-b33f-13a168793722\",\"singles\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'186e3495-0405-4ef9-8b6a-13ea813ea449'),(27,'Video Select','videoSelect','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Entries','{\"allowSelfRelations\":false,\"branchLimit\":null,\"maintainHierarchy\":false,\"maxRelations\":10,\"minRelations\":null,\"selectionLabel\":\"Add a video\",\"showCardsInGrid\":false,\"showSiteMenu\":false,\"sources\":[\"section:15fdb8d9-166a-4c6c-b61e-17cbec66abd1\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"cards\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'3b374f35-1602-4985-917c-bd65649ca09e'),(28,'Embed Select','embedSelect','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Entries','{\"allowSelfRelations\":false,\"branchLimit\":null,\"maintainHierarchy\":false,\"maxRelations\":10,\"minRelations\":null,\"selectionLabel\":\"Add an embed\",\"showCardsInGrid\":false,\"showSiteMenu\":false,\"sources\":[\"section:e83e534b-ba3e-41e5-9e73-051db8c4b65b\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'299192bd-bbe9-4f2a-b1b4-b8f6f80905ef'),(29,'Autoplay Delay','autoplayDelay','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Range','{\"defaultValue\":5,\"max\":12,\"min\":2,\"step\":1,\"suffix\":\"seconds\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'9200bcdf-7a8c-466f-97f5-f08080ac3d03'),(30,'Single Video','singleVideo','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"video\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:542617dd-cf2a-41c4-9716-97fac95cd8f6\",\"defaultUploadLocationSubpath\":null,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"restrictedLocationSubpath\":null,\"selectionLabel\":\"Add a video\",\"showCardsInGrid\":false,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":[\"volume:542617dd-cf2a-41c4-9716-97fac95cd8f6\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'d10f8d89-ce67-4b10-bbe3-42358861dbc1'),(31,'Video Thumbnail','videoThumbnail','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"defaultUploadLocationSubpath\":\"video-thumbs\",\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"restrictedLocationSubpath\":null,\"selectionLabel\":\"Add a thumbnail\",\"showCardsInGrid\":false,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":[\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'8714d452-365e-4edd-ba97-237557f2207f'),(32,'Page Select','pageSelect','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Entries','{\"allowSelfRelations\":false,\"branchLimit\":null,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":null,\"selectionLabel\":\"Add a page\",\"showCardsInGrid\":false,\"showSiteMenu\":false,\"sources\":[\"section:d9c26beb-6bee-444c-b33f-13a168793722\",\"singles\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea'),(33,'Animation Effect','configEffect','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Dropdown','{\"customOptions\":false,\"options\":[{\"label\":\"Slide\",\"value\":\"slide\",\"default\":\"1\"},{\"label\":\"Fade\",\"value\":\"fade\",\"default\":\"\"},{\"label\":\"Cube\",\"value\":\"cube\",\"default\":\"\"},{\"label\":\"Coverflow\",\"value\":\"coverflow\",\"default\":\"\"},{\"label\":\"Flip\",\"value\":\"flip\",\"default\":\"\"},{\"label\":\"Cards\",\"value\":\"cards\",\"default\":\"\"}]}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'46e12ab7-e122-464d-8364-4bfe2eefa5c3'),(34,'Heading','heading','global',NULL,NULL,0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":false,\"initialRows\":4,\"multiline\":false,\"placeholder\":null,\"uiMode\":\"normal\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'d036f92a-3e96-4a73-b959-e8cf8df3c077'),(35,'Media Align','mediaAlign','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Dropdown','{\"customOptions\":false,\"options\":[{\"label\":\"Left\",\"value\":\"left\",\"default\":\"1\"},{\"label\":\"Right\",\"value\":\"right\",\"default\":\"\"}]}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'e253049a-7803-4ae2-9b10-fb60c6c591b8'),(36,'Simple Toggle','simpleToggle','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Lightswitch','{\"default\":false,\"offLabel\":null,\"onLabel\":null}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'8f75a6ba-cffb-47c7-8031-e37daf2cdd33'),(37,'Single Image','singleImage','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowSubfolders\":false,\"allowUploads\":true,\"allowedKinds\":[\"image\"],\"branchLimit\":null,\"defaultUploadLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"defaultUploadLocationSubpath\":null,\"maintainHierarchy\":false,\"maxRelations\":1,\"minRelations\":null,\"previewMode\":\"full\",\"restrictFiles\":true,\"restrictLocation\":false,\"restrictedDefaultUploadSubpath\":null,\"restrictedLocationSource\":\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\",\"restrictedLocationSubpath\":null,\"selectionLabel\":\"Add an image\",\"showCardsInGrid\":false,\"showSiteMenu\":false,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"sources\":[\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"],\"targetSiteId\":null,\"validateRelatedElements\":false,\"viewMode\":\"large\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'77d34c46-29a6-47a9-b5c4-8a7ffa61a10d'),(38,'Swiper Speed','swiperSpeed','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Range','{\"defaultValue\":3,\"max\":10,\"min\":1,\"step\":1,\"suffix\":\"seconds\"}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'bced0888-a5a3-4f1f-b38c-6b52b005477d'),(39,'Grid Columns','gridColumns','global',NULL,NULL,0,'none',NULL,'craft\\fields\\Dropdown','{\"customOptions\":false,\"options\":[{\"label\":\"2-column\",\"value\":\"lg:grid-cols-2\",\"default\":\"1\"},{\"label\":\"3-column\",\"value\":\"lg:grid-cols-3\",\"default\":\"\"},{\"label\":\"4-column\",\"value\":\"md:grid-cols-3 lg:grid-cols-4\",\"default\":\"\"}]}','2024-12-23 16:39:50','2024-12-23 16:39:50',NULL,'00f0f6fc-444a-4eb0-b660-fcbb5c85f41f');
/*!40000 ALTER TABLE `fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_crm_fields`
--

LOCK TABLES `freeform_crm_fields` WRITE;
/*!40000 ALTER TABLE `freeform_crm_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_crm_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_email_marketing_fields`
--

LOCK TABLES `freeform_email_marketing_fields` WRITE;
/*!40000 ALTER TABLE `freeform_email_marketing_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_email_marketing_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_email_marketing_lists`
--

LOCK TABLES `freeform_email_marketing_lists` WRITE;
/*!40000 ALTER TABLE `freeform_email_marketing_lists` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_email_marketing_lists` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_export_notifications`
--

LOCK TABLES `freeform_export_notifications` WRITE;
/*!40000 ALTER TABLE `freeform_export_notifications` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_export_notifications` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_export_profiles`
--

LOCK TABLES `freeform_export_profiles` WRITE;
/*!40000 ALTER TABLE `freeform_export_profiles` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_export_profiles` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_export_settings`
--

LOCK TABLES `freeform_export_settings` WRITE;
/*!40000 ALTER TABLE `freeform_export_settings` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_export_settings` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_favorite_fields`
--

LOCK TABLES `freeform_favorite_fields` WRITE;
/*!40000 ALTER TABLE `freeform_favorite_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_favorite_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_feed_messages`
--

LOCK TABLES `freeform_feed_messages` WRITE;
/*!40000 ALTER TABLE `freeform_feed_messages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_feed_messages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_feeds`
--

LOCK TABLES `freeform_feeds` WRITE;
/*!40000 ALTER TABLE `freeform_feeds` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_feeds` VALUES (1,'4b83d5a4-f9b0-42d5-ae0a-e1e280369642','5.9.1','5.9.1','2025-01-23 07:00:00','2025-05-02 21:17:18','2025-05-02 21:17:18','8878d4a2-811f-4165-950d-2787df3d11f3');
/*!40000 ALTER TABLE `freeform_feeds` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_fields_type_groups`
--

LOCK TABLES `freeform_fields_type_groups` WRITE;
/*!40000 ALTER TABLE `freeform_fields_type_groups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_fields_type_groups` VALUES (1,'#007add','Text','[\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\TextField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\TextareaField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\EmailField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\NumberField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\PhoneField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\DatetimeField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\WebsiteField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\RegexField\"]','2024-12-23 16:39:49','2024-12-23 16:39:49','e1b97ad0-859c-45d6-b5f5-f9851d2f5dc2'),(2,'#9013fe','Options','[\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\DropdownField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\MultipleSelectField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\CheckboxField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\CheckboxesField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\RadiosField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\OpinionScaleField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\RatingField\"]','2024-12-23 16:39:49','2024-12-23 16:39:49','944befd5-25bc-41c7-a1eb-4164674faf16'),(3,'#f5a623','Files','[\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\FileUploadField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\FileDragAndDropField\"]','2024-12-23 16:39:49','2024-12-23 16:39:49','66b373bf-3b88-4130-b681-de24aab670e8'),(4,'#5d9901','Special','[\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\GroupField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\TableField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\ConfirmationField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\PasswordField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\CalculationField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\SignatureField\"]','2024-12-23 16:39:49','2024-12-23 16:39:49','a268c0b5-7b5c-439d-b456-3b6871ed87b9'),(5,'#000000','Content','[\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\HtmlField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\RichTextField\"]','2024-12-23 16:39:49','2024-12-23 16:39:49','48ee34ad-6056-49c3-99cc-b56fa1a63a62'),(6,'#9b9b9b','Hidden','[\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\HiddenField\",\"Solspace\\\\Freeform\\\\Fields\\\\Implementations\\\\Pro\\\\InvisibleField\"]','2024-12-23 16:39:49','2024-12-23 16:39:49','716a80f0-52f6-453a-86de-bc1ca8232156');
/*!40000 ALTER TABLE `freeform_fields_type_groups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms`
--

LOCK TABLES `freeform_forms` WRITE;
/*!40000 ALTER TABLE `freeform_forms` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms` VALUES (1,'Solspace\\Freeform\\Form\\Types\\Regular','Contact Form','contactForm',0,'{\"behavior\":{\"ajax\":true,\"successBehavior\":\"reload\",\"duplicateCheck\":\"no_limit\",\"showProcessingSpinner\":true,\"successTemplate\":null,\"stopSubmissionsAfter\":null,\"showProcessingText\":true,\"returnUrl\":\"\",\"processingText\":\"Processing...\",\"successMessage\":\"Form has been submitted successfully!\",\"errorMessage\":\"Sorry, there was an error submitting the form. Please try again.\"},\"general\":{\"name\":\"Contact Form\",\"storeData\":true,\"handle\":\"contactForm\",\"defaultStatus\":2,\"type\":\"Solspace\\\\Freeform\\\\Form\\\\Types\\\\Regular\",\"collectIpAddresses\":true,\"sites\":[\"1\"],\"allowUsersToOptIn\":false,\"translations\":false,\"optInCheckbox\":null,\"submissionTitle\":\"{{ dateCreated|date(\\\"Y-m-d H:i:s\\\") }}\",\"formattingTemplate\":\"basic-light\\/index.twig\",\"description\":\"\",\"color\":\"#6302C5\",\"attributes\":{\"form\":{},\"row\":{},\"success\":{},\"errors\":{}}}}',NULL,3,3,NULL,'2024-12-23 16:56:46','2025-02-18 02:47:57','910c0e20-d19f-49d1-ae13-64cd64ce295f');
/*!40000 ALTER TABLE `freeform_forms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_fields`
--

LOCK TABLES `freeform_forms_fields` WRITE;
/*!40000 ALTER TABLE `freeform_forms_fields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms_fields` VALUES (1,1,'Solspace\\Freeform\\Fields\\Implementations\\HtmlField','{\"twig\":false,\"label\":\"HTML\",\"content\":\"<div>\\n    <h2>Please contact me below for any questions!<\\/h2>\\n    <h5>(Private lessons also available)<\\/h5>\\n<\\/div>\",\"handle\":\"html\",\"fieldType\":null,\"attributes\":{\"input\":{},\"label\":{},\"instructions\":{},\"container\":{},\"error\":{}},\"requiredMessage\":null}',1,0,'2024-12-23 16:58:39','2024-12-23 17:00:13','5141661f-87cc-46e9-ac6b-e8a06dd62a18'),(2,1,'Solspace\\Freeform\\Fields\\Implementations\\TextField','{\"label\":\"Full Name\",\"encrypted\":false,\"handle\":\"fullName\",\"fieldType\":null,\"instructions\":\"\",\"attributes\":{\"input\":{},\"label\":{},\"instructions\":{},\"container\":{},\"error\":{}},\"placeholder\":\"\",\"required\":true,\"requiredMessage\":null,\"defaultValue\":null,\"maxLength\":null}',2,0,'2024-12-23 16:58:39','2024-12-23 17:00:13','ef8100ce-5b0c-469b-8343-59b22d82d933'),(3,1,'Solspace\\Freeform\\Fields\\Implementations\\EmailField','{\"label\":\"Email Address\",\"encrypted\":false,\"handle\":\"emailAddress\",\"fieldType\":null,\"instructions\":\"\",\"attributes\":{\"input\":{},\"label\":{},\"instructions\":{},\"container\":{},\"error\":{}},\"placeholder\":\"\",\"required\":true,\"requiredMessage\":null,\"defaultValue\":null,\"maxLength\":null}',3,0,'2024-12-23 16:58:39','2024-12-23 17:00:13','7a16a837-0422-4d9a-8b7f-c4154de1c3ed'),(4,1,'Solspace\\Freeform\\Fields\\Implementations\\TextField','{\"label\":\"Subject\",\"encrypted\":false,\"handle\":\"subject\",\"fieldType\":null,\"instructions\":\"\",\"attributes\":{\"input\":{},\"label\":{},\"instructions\":{},\"container\":{},\"error\":{}},\"placeholder\":\"\",\"required\":true,\"requiredMessage\":null,\"defaultValue\":null,\"maxLength\":null}',4,0,'2024-12-23 16:58:39','2024-12-23 17:00:13','4ed4cf8b-0655-49a3-8e46-1c95685a9dac'),(5,1,'Solspace\\Freeform\\Fields\\Implementations\\TextareaField','{\"defaultValue\":null,\"label\":\"Message\",\"encrypted\":false,\"rows\":2,\"handle\":\"message\",\"fieldType\":null,\"instructions\":\"\",\"attributes\":{\"input\":{},\"label\":{},\"instructions\":{},\"container\":{},\"error\":{}},\"placeholder\":\"\",\"required\":false,\"requiredMessage\":null,\"maxLength\":null}',5,0,'2024-12-23 16:58:39','2024-12-23 17:00:13','5bc43cf6-4579-4fb3-8c7f-a0442344dbc4');
/*!40000 ALTER TABLE `freeform_forms_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_groups`
--

LOCK TABLES `freeform_forms_groups` WRITE;
/*!40000 ALTER TABLE `freeform_forms_groups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_forms_groups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_groups_entries`
--

LOCK TABLES `freeform_forms_groups_entries` WRITE;
/*!40000 ALTER TABLE `freeform_forms_groups_entries` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_forms_groups_entries` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_integrations`
--

LOCK TABLES `freeform_forms_integrations` WRITE;
/*!40000 ALTER TABLE `freeform_forms_integrations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms_integrations` VALUES (1,1,1,1,'{}','2024-12-23 17:04:08','2025-02-18 02:47:58','4f5bd3bf-decf-4498-b2da-6089a25eb94c'),(2,2,1,0,'{}','2025-02-18 02:47:15','2025-02-18 02:47:58','ec68cc1b-fee8-4666-beba-ca9e95be7e7c');
/*!40000 ALTER TABLE `freeform_forms_integrations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_layouts`
--

LOCK TABLES `freeform_forms_layouts` WRITE;
/*!40000 ALTER TABLE `freeform_forms_layouts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms_layouts` VALUES (1,1,'2024-12-23 16:58:39','2024-12-23 16:58:39','02db56f1-8916-4b72-99d9-078831264ae8');
/*!40000 ALTER TABLE `freeform_forms_layouts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_notifications`
--

LOCK TABLES `freeform_forms_notifications` WRITE;
/*!40000 ALTER TABLE `freeform_forms_notifications` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms_notifications` VALUES (1,'Solspace\\Freeform\\Notifications\\Types\\Admin\\Admin',1,1,'{\"name\":\"Admin notification\",\"enabled\":true,\"template\":1,\"recipients\":[{\"email\":\"robmartinomusic@gmail.com\",\"name\":\"\"},{\"email\":\"jsudimak302@gmail.com\",\"name\":\"\"}]}','2024-12-23 17:00:13','2024-12-23 17:00:13','77f48cf3-4a2f-492f-8ff5-f42f1e2e8011');
/*!40000 ALTER TABLE `freeform_forms_notifications` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_pages`
--

LOCK TABLES `freeform_forms_pages` WRITE;
/*!40000 ALTER TABLE `freeform_forms_pages` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms_pages` VALUES (1,1,1,'Page 1',0,'{\"buttons\":{\"layout\":\"back|submit save\",\"attributes\":{\"container\":[],\"column\":[],\"submit\":{\"class\":\"btn btn-primary btn-lg\"},\"back\":[],\"save\":[]},\"submitLabel\":\"Submit\",\"back\":true,\"backLabel\":\"Back\",\"save\":false,\"saveLabel\":\"Save\"}}','2024-12-23 16:58:39','2024-12-23 17:00:13','fae03cc5-00e2-424a-929a-f01c5c1839fb');
/*!40000 ALTER TABLE `freeform_forms_pages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_rows`
--

LOCK TABLES `freeform_forms_rows` WRITE;
/*!40000 ALTER TABLE `freeform_forms_rows` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms_rows` VALUES (1,1,1,0,'2024-12-23 16:58:39','2024-12-23 16:58:39','50d5e498-7123-4763-a445-ad1caa662760'),(2,1,1,1,'2024-12-23 16:58:39','2024-12-23 16:58:39','3394c29a-d16c-4c61-9e0f-2066033a449d'),(3,1,1,2,'2024-12-23 16:58:39','2024-12-23 16:58:39','5078f754-68d1-4a53-b88a-1f7cf37ba1af'),(4,1,1,3,'2024-12-23 16:58:39','2024-12-23 16:58:39','04d29010-5265-4a48-8cf9-222b2f601cf4'),(5,1,1,4,'2024-12-23 16:58:39','2024-12-23 16:58:39','ffcb49b0-5033-473c-a6de-d4faca8032d8');
/*!40000 ALTER TABLE `freeform_forms_rows` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_sites`
--

LOCK TABLES `freeform_forms_sites` WRITE;
/*!40000 ALTER TABLE `freeform_forms_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_forms_sites` VALUES (1,1,1,'2024-12-23 16:56:46','2024-12-23 16:56:46','4b877818-89c6-40f6-95cf-bc6990a787eb');
/*!40000 ALTER TABLE `freeform_forms_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_forms_translations`
--

LOCK TABLES `freeform_forms_translations` WRITE;
/*!40000 ALTER TABLE `freeform_forms_translations` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_forms_translations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_integrations`
--

LOCK TABLES `freeform_integrations` WRITE;
/*!40000 ALTER TABLE `freeform_integrations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_integrations` VALUES (1,1,'Google reCAPTCHA v2','googleRecaptchaV2','captchas','Solspace\\Freeform\\Integrations\\Captchas\\ReCaptcha\\ReCaptcha','{\"enabledByDefault\":true,\"version\":\"v2-checkbox\",\"siteKey\":\"$RECAPTCHA_SITE_KEY_V2\",\"secretKey\":\"$RECAPTCHA_SECRET_KEY_V2\",\"triggerOnInteract\":false,\"failureBehavior\":\"display-error\",\"errorMessage\":\"Please verify that you are not a robot.\",\"theme\":\"light\",\"size\":\"compact\",\"scoreThreshold\":\"0.5\",\"action\":\"submit\",\"locale\":\"\"}','2024-12-23 17:03:59','2024-12-23 17:03:59','a796ddf0-10c5-4f60-a2e6-6be379ceab67'),(2,1,'Google reCAPTCHA v3','googleRecaptchaV3','captchas','Solspace\\Freeform\\Integrations\\Captchas\\ReCaptcha\\ReCaptcha','{\"enabledByDefault\":true,\"version\":\"v2-checkbox\",\"siteKey\":\"$RECAPTCHA_SITE_KEY_V3\",\"secretKey\":\"$RECAPTCHA_SECRET_KEY_V3\",\"triggerOnInteract\":false,\"failureBehavior\":\"display-error\",\"errorMessage\":\"Please verify that you are not a robot.\",\"theme\":\"light\",\"size\":\"normal\",\"scoreThreshold\":\"0.5\",\"action\":\"submit\",\"locale\":\"\"}','2025-02-18 02:46:59','2025-02-18 02:46:59','ea686ac3-ec66-4a05-9032-c50dfa1732a4');
/*!40000 ALTER TABLE `freeform_integrations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_integrations_queue`
--

LOCK TABLES `freeform_integrations_queue` WRITE;
/*!40000 ALTER TABLE `freeform_integrations_queue` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_integrations_queue` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_limited_users`
--

LOCK TABLES `freeform_limited_users` WRITE;
/*!40000 ALTER TABLE `freeform_limited_users` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_limited_users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_notification_log`
--

LOCK TABLES `freeform_notification_log` WRITE;
/*!40000 ALTER TABLE `freeform_notification_log` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_notification_log` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_notification_templates`
--

LOCK TABLES `freeform_notification_templates` WRITE;
/*!40000 ALTER TABLE `freeform_notification_templates` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_notification_templates` VALUES (1,NULL,'Admin Notification','templateAdminNotification','New submission on your {{ form.name }} form','','{{ craft.app.projectConfig.get(\'email.fromName\') }}','{{ craft.app.projectConfig.get(\'email.fromEmail\') }}','','','','','<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta name=\"viewport\" content=\"width=device-width\" />\r\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\r\n    <meta http-equiv=\"X-UA-Compatible\" content=\"ie=edge\">\r\n    <title>{{ subject }}</title>\r\n    <style>\r\n      body,table td{font-size:14px}.body,body{background-color:#f6f6f6}.container,.content{display:block;max-width:580px;padding:10px}body,h1,h2,h3,h4{line-height:1.4;font-family:sans-serif}body,h1,h2,h3,h4,ol,p,table td,ul{font-family:sans-serif}.btn a,.btn table td{background-color:#fff}.btn,.btn a,.content,.wrapper{box-sizing:border-box}.btn a,h1{text-transform:capitalize}.align-center,.btn table td,.footer,h1{text-align:center}.clear,.footer{clear:both}.btn a,.powered-by a{text-decoration:none}img{border:none;-ms-interpolation-mode:bicubic;max-width:100%}body{-webkit-font-smoothing:antialiased;margin:0;padding:0;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}table{border-collapse:separate;mso-table-lspace:0pt;mso-table-rspace:0pt;width:100%}table td{vertical-align:top}.body{width:100%}.container{margin:0 auto!important;width:580px}.btn,.footer,.main,.main-img{width:100%}.content{margin:0 auto}.main{background:#fff;border-radius:3px;border-top:3px solid #283450;border-bottom:3px solid #283450}.main-img{padding-top:10px;padding-bottom:20px}.wrapper{padding:20px}.content-block{padding-bottom:10px;padding-top:10px}.footer{margin-top:10px}.footer a,.footer p,.footer span,.footer td{color:#999;font-size:12px;text-align:center}h1,h2,h3,h4{color:#000;margin:0 0 10px;font-weight:700}.btn a,a{color:#3498db}h1{font-size:35px}.btn a,ol,p,ul{font-size:14px}ol,p,ul{font-weight:400;margin:0 0 25px}ol li,p li,ul li{list-style-position:inside;margin-left:5px}a{text-decoration:underline}.btn>tbody>tr>td{padding-bottom:15px}.btn table{width:auto}.btn table td{border-radius:5px}.btn a{border:1px solid #3498db;border-radius:5px;cursor:pointer;display:inline-block;font-weight:700;margin:0;padding:12px 25px}.btn-primary a,.btn-primary table td{background-color:#3498db}.btn-primary a{border-color:#3498db;color:#fff}.last,.mb0{margin-bottom:0}.first,.mt0{margin-top:0}.align-right{text-align:right}.align-left{text-align:left}.preheader{color:transparent;display:none;height:0;max-height:0;max-width:0;opacity:0;overflow:hidden;mso-hide:all;visibility:hidden;width:0}hr{border:0;border-bottom:1px solid #f6f6f6;margin:20px 0}@media only screen and (max-width:620px){table[class=body] h1{font-size:28px!important;margin-bottom:10px!important}table[class=body] a,table[class=body] ol,table[class=body] p,table[class=body] span,table[class=body] td,table[class=body] ul{font-size:16px!important}table[class=body] .article,table[class=body] .wrapper{padding:10px!important}table[class=body] .content{padding:0!important}table[class=body] .container{padding:0!important;width:100%!important}table[class=body] .main{border-left-width:0!important;border-radius:0!important;border-right-width:0!important}table[class=body] .btn a,table[class=body] .btn table{width:100%!important}table[class=body] .img-responsive{height:auto!important;max-width:100%!important;width:auto!important}}@media all{.btn-primary a:hover,.btn-primary table td:hover{background-color:#34495e!important}.ExternalClass{width:100%}.ExternalClass,.ExternalClass div,.ExternalClass font,.ExternalClass p,.ExternalClass span,.ExternalClass td{line-height:100%}.apple-link a{color:inherit!important;font-family:inherit!important;font-size:inherit!important;font-weight:inherit!important;line-height:inherit!important;text-decoration:none!important}#MessageViewBody a{color:inherit;text-decoration:none;font-size:inherit;font-family:inherit;font-weight:inherit;line-height:inherit}.btn-primary a:hover{border-color:#34495e!important}}\r\n    </style>\r\n  </head>\r\n  <body class=\"\">\r\n    <span class=\"preheader\">{{ subject }}</span>\r\n    <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"body\">\r\n      <tr>\r\n        <td> </td>\r\n        <td class=\"container\">\r\n          <div class=\"content\">\r\n            <table role=\"presentation\" class=\"main-img\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                <tr>\r\n                    <td style=\"text-align: center;\">\r\n                        <h1 style=\"font-family: Poppins, sans-serif;\">Rob Martino Music</h1>\r\n                        <h2 style=\"font-family: Poppins, sans-serif;\">Contact Form Submission</h2>\r\n                    </td>\r\n                </tr>\r\n            </table>\r\n\r\n            <table role=\"presentation\" class=\"main\">\r\n              <tr>\r\n                <td class=\"wrapper\">\r\n                  <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                    <tr>\r\n                      <td>\r\n                        <p style=\"text-align:center;\">You\'ve received a new contact form submission from <a href=\"https://robmartinomusic.com/\" target=\"__blank\">robmartinomusic.com</a>.</p>\r\n                        {% set count = 0 %}\r\n                        {% for field in allFields %}\r\n                            <h3>{{ field.label }}:</h3>\r\n                            <p>{{ field.valueAsString }}</p>\r\n                            {% set count = count + 1 %}\r\n                        {% endfor %}\r\n                      </td>\r\n                    </tr>\r\n                  </table>\r\n                  <table role=\"presentation\" class=\"main-img\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                    <tr>\r\n                        <td style=\"text-align: center;\">\r\n                            <img src=\"https://robmartinomusic.com/imgs/hobbe-logo.png\" style=\"max-width:120px; height:auto; width:100%;\">\r\n                        </td>\r\n                    </tr>\r\n                </table>\r\n                </td>\r\n              </tr>\r\n            </table>\r\n          </div>\r\n        </td>\r\n        <td> </td>\r\n      </tr>\r\n    </table>\r\n  </body>\r\n</html>','Submitted on: {{ dateCreated|date(\'l, F j, Y \\\\a\\\\t g:ia\') }}\r\n\r\n{% for field in allFields %}\r\n - {{ field.label }}: {{ field.valueAsString }}\r\n{% endfor %}',1,0,NULL,NULL,'2024-12-23 16:59:42','2024-12-23 16:59:42','3cc1f59c-dfc2-4104-9c91-444e95131a77');
/*!40000 ALTER TABLE `freeform_notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_payments`
--

LOCK TABLES `freeform_payments` WRITE;
/*!40000 ALTER TABLE `freeform_payments` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_payments` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_pdf_templates`
--

LOCK TABLES `freeform_pdf_templates` WRITE;
/*!40000 ALTER TABLE `freeform_pdf_templates` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_pdf_templates` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_rules`
--

LOCK TABLES `freeform_rules` WRITE;
/*!40000 ALTER TABLE `freeform_rules` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_rules` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_rules_buttons`
--

LOCK TABLES `freeform_rules_buttons` WRITE;
/*!40000 ALTER TABLE `freeform_rules_buttons` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_rules_buttons` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_rules_conditions`
--

LOCK TABLES `freeform_rules_conditions` WRITE;
/*!40000 ALTER TABLE `freeform_rules_conditions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_rules_conditions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_rules_fields`
--

LOCK TABLES `freeform_rules_fields` WRITE;
/*!40000 ALTER TABLE `freeform_rules_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_rules_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_rules_notifications`
--

LOCK TABLES `freeform_rules_notifications` WRITE;
/*!40000 ALTER TABLE `freeform_rules_notifications` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_rules_notifications` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_rules_pages`
--

LOCK TABLES `freeform_rules_pages` WRITE;
/*!40000 ALTER TABLE `freeform_rules_pages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_rules_pages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_rules_submit_form`
--

LOCK TABLES `freeform_rules_submit_form` WRITE;
/*!40000 ALTER TABLE `freeform_rules_submit_form` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_rules_submit_form` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_saved_forms`
--

LOCK TABLES `freeform_saved_forms` WRITE;
/*!40000 ALTER TABLE `freeform_saved_forms` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_saved_forms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_session_context`
--

LOCK TABLES `freeform_session_context` WRITE;
/*!40000 ALTER TABLE `freeform_session_context` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_session_context` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_spam_reason`
--

LOCK TABLES `freeform_spam_reason` WRITE;
/*!40000 ALTER TABLE `freeform_spam_reason` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_spam_reason` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_statuses`
--

LOCK TABLES `freeform_statuses` WRITE;
/*!40000 ALTER TABLE `freeform_statuses` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_statuses` VALUES (1,'Pending','pending','orange',1,'2024-12-23 16:39:49','2024-12-23 16:39:49','5b586b9c-fdff-494e-9f31-87881e03a483'),(2,'Open','open','teal',2,'2024-12-23 16:39:49','2024-12-23 16:39:49','eb355cd3-9083-480d-bc54-0479de594610'),(3,'Closed','closed','red',3,'2024-12-23 16:39:49','2024-12-23 16:39:49','e64a4d79-b9c9-450f-b91e-fc42816f5dc1');
/*!40000 ALTER TABLE `freeform_statuses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_submission_notes`
--

LOCK TABLES `freeform_submission_notes` WRITE;
/*!40000 ALTER TABLE `freeform_submission_notes` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_submission_notes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_submissions`
--

LOCK TABLES `freeform_submissions` WRITE;
/*!40000 ALTER TABLE `freeform_submissions` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_submissions` VALUES (149,1,NULL,2,1,'7Sjc1TljoHbwT3rvYo6HoPwjXmjO287E1VLGSI3IPSUf7y0XEiUuVAC6ct1vPJx1Acg2NApb8naNFlwikrdUlhNSwZjXSRfOspuB','5.252.162.219',0,'2024-12-25 17:56:26','2024-12-25 17:56:26','60709962-f7ea-41af-a9a8-69a7d4ee075c'),(150,2,NULL,2,1,'UsTNqHvB8y7BVtL9gpucDCJXhXrwtC22KutnuTIh6fX3Z4HBEzam76s0I2PGkBtPlmo4tuXg2eABSIBCzjPPr7E8JTjweJDukAzr','5.252.162.219',0,'2024-12-28 18:45:41','2024-12-28 18:45:42','7fac3e25-2b28-4333-a599-831e8d0d87fe'),(151,3,NULL,2,1,'8OWJtG9ewFiyIKYdMPpwVjQ87QFmzpsr4C0wLF0pe7Xp36pU7swQJiCk61wQP0a21ApdYaoCQsrySrvuNBx8vLeBS2VE2Tu0nEt8','5.252.162.219',0,'2024-12-31 07:15:51','2024-12-31 07:15:51','e8077ecb-f34c-4037-8bf4-b8b6482e2455'),(152,4,NULL,2,1,'L00Mgy3hYbiCYngNfOVeCuwG9JEIQSzGVOsnakiXVan3XVThqXVIyP5qxuOwBdavc16BrNAeYUFoJPJCGOETAhzV6meQjvBXJUEL','5.252.162.219',0,'2025-01-03 03:28:43','2025-01-03 03:28:43','df9f2741-b96d-4d5d-9adf-fd8f1e6f45d5'),(153,5,NULL,2,1,'zYW2QyK1itRH61NrVxSYoh1yw25cvMVytTD8ImkX8sytQu3oKUiThlm47jTox278ompRqhno9rpj5gJOr17dSje3cJd0XC2qx4kI','102.129.223.92',0,'2025-01-16 10:55:55','2025-01-16 10:55:55','31220eb8-db87-4f8f-bd24-c986032cd58f'),(154,6,NULL,2,1,'iZ02WZ3gorIDZGAM0kzf66DuA7oU06cBzLPDyRc0kmkjSPP2dQ6xXuMwBR15Z8IZJHWPAx2n41QYEvBjJ61s0xv0TTnCJopEPAVJ','102.129.223.92',0,'2025-01-16 20:57:50','2025-01-16 20:57:50','68235be0-3fb7-4f42-b462-3354de5a1368'),(155,7,NULL,2,1,'Hu4yAlodCb1EqBInIG3bWmORWKdMAoChgSNVcJsIcO4bBfGVj20v60ofT1AVylXa6rSE6SqFEoZgWTtT7jG237eqQKdpG4xjXATj','102.129.223.92',0,'2025-01-17 16:27:50','2025-01-17 16:27:50','c262c139-16aa-4f38-b8e1-0d64d2b56df7'),(156,8,NULL,2,1,'O1eadrdfKs0OQ3F6GbgZkjl7LcfPQJfe0Th0hX6BYskooRM8GqwUvcrSnonqSBJH33l49huyPBCZZPpOHNOKpOlZdM6trBzZWzdM','216.24.210.33',0,'2025-01-25 02:12:52','2025-01-25 02:12:52','4ab2b5cd-4bd7-4dab-a9ad-4a2cc90accb0'),(157,9,NULL,2,1,'gwc3r4b6mWGMoLz3nJ6DImbfSuSTTLF2nezlIhJaAeHr0kCy0ZcuoSF2vbt0ng0G0QxM1bkPnJlrszgS7i2GfkEthsUGRxKLGSyY','102.129.223.92',0,'2025-01-29 20:59:54','2025-01-29 20:59:54','38482a10-2dc6-4148-b786-4dc1ffdcba75'),(158,10,NULL,2,1,'bPjLS9h3cgIeFBlHl8OCLgrKZw4tuGt077Y8NFl86iwI6Tp7E3GqsPVOM5HSmz09H8pUIOYP0dNjzfJKvrJVl0FOOxDnMK08rRzR','102.129.223.92',0,'2025-01-31 08:42:58','2025-01-31 08:42:58','e440894c-ff40-4d93-b898-35694ed1f561'),(159,11,NULL,2,1,'giSBdkihyoSQnqXEdu1LbisF9X4iBz68z6OCmhlbNdOJ4rVz9NZCgxlQRAIVBfGFkJDmbB1sR8j37VzCbeBzrOd5ljt3l6a8xmvg','102.129.223.92',0,'2025-01-31 08:56:43','2025-01-31 08:56:43','f639cd9c-b85c-40ee-8be3-f75b78250657'),(160,12,NULL,2,1,'iCe9JWSXB0t8G1kmmhCs5KvPUmACKuCqj7Ac37nbK9ad1yq50IsRMBdi5l0vuTimPMtbpeg0SzTKvY1dJw5v1Xr7ENiFJfvHvnxQ','102.129.223.92',0,'2025-02-04 08:53:55','2025-02-04 08:53:55','534d99fb-d6b1-4ce4-b860-6d5b7b5bced4'),(161,13,NULL,2,1,'L7UmOyNU7zhZllZsyBWHzCb7luw8f4T7N4EgPkmmn64VZffO8LzyaRGQgBMLtANu7jZIxwgh9IoniCWHBqBhjP4NQpWUpA0QxWTD','102.129.223.92',0,'2025-02-05 05:25:10','2025-02-05 05:25:10','7b2e3ce4-cf9f-4291-a216-51f36460e8f5'),(162,14,NULL,2,1,'IAwSny6FSZaKC9zaKd02CDz0uFOKJyyPO59wtmCp33m1Yfpby4w1PE4GJ7vY5DEJ0Be9qLKB4ZSoqHNM8LWsoapVEgKQNDufjaYN','102.129.223.92',0,'2025-02-05 22:54:44','2025-02-05 22:54:44','07c19806-7ef1-4acb-8532-601aaa8eeb01'),(163,15,NULL,3,1,'lW6T5lC52aiAijLE6YjYPmQ29egKP0TDa7FufJbCNDAzPm8PH9W2n7THKJKXYwtEB8a4Ie6XTSsHy5956l4cxcMjniAvkQ5Xk53u','14.233.204.146',0,'2025-02-14 11:18:31','2025-02-18 01:48:55','2fff9c8d-deb6-4334-94fe-70aecac5b280'),(164,16,NULL,2,1,'ec5BNRirYHfGtLPckjE3ia3HPrOyfII4DpLD9PYI9cXM3RkHmbavjF1ZC4ApjBER33SXs0Cv9BFBn22nelt3REcKYHAVK3yDVCFa','102.129.223.92',0,'2025-02-18 21:54:34','2025-02-18 21:54:34','af2d11e6-c59c-43f4-b117-b4374e763c3c'),(165,17,NULL,2,1,'6jo5jgp08KivYtbKAfESu2usp8hXzlVIVHwvtqyYN4ZDjkfnUr65v9EJ02WYlk3hkprD0gyAEGzMHFjyediIxAst2Xu7Rh853eOa','102.129.223.92',0,'2025-02-19 18:27:16','2025-02-19 18:27:16','4f488cc5-ca31-4925-af33-c43bb887e3ef'),(166,18,NULL,2,1,'ACN54Qph8B1MUai0FcPayDaBDQHbrcN0oe97GT94lRtACxaOhuLQUkWhL9dTvPAgCVqCf7Vpm2lxDynz4LG0ELsAbDHThMJyjhti','2600:4040:77d3:7900:a884:5869:e2c5:fdbb',0,'2025-02-21 03:04:15','2025-02-21 03:04:15','ca9e2c15-91c4-41b7-aadd-d54a5a84725d'),(167,19,NULL,2,1,'v6AIKdt1Qy8dZYwPFvg5MG2QcDkvDFpBuhh2m4YeV4jfB8p25e7NqTzooTjFSJSJeNYgD6ItkjwAvWLtnzsAXJUgRTJ0whZoJlTV','102.129.223.92',0,'2025-02-22 22:56:10','2025-02-22 22:56:10','e158157c-7209-4bf4-9fcf-067abc2ee7f0'),(168,20,NULL,2,1,'Ewg5HHPuc2JkwlsSjOnomDseDf3h9QEO53UdK2HQqseZOLpNqu3x2HrXfwkQpJi7UuQG7zy58b6twWwhx7gQAMnSSTJLeeaXadZP','102.129.223.92',0,'2025-02-23 10:55:10','2025-02-23 10:55:11','cfa3d8e9-8eaa-4877-98b8-3016da2fcd6e'),(169,21,NULL,2,1,'sSslImFEmXu3xAXCChVpU24CO9ToEuDQzSqs4SkemUIvmeh4ghuLHRIypV37kY8bP9ssiNEwwbwv9Nb4VZeklFoAEl8c3Cp25xop','102.129.223.92',0,'2025-02-24 18:57:07','2025-02-24 18:57:07','c56092fe-d6ff-483b-bea4-8f068010dd96'),(170,22,NULL,2,1,'IPgFsWpeavJhXRxHKB8efrcYOTDNhJnU6kKEGzRxsrE1IIgT7HGJNhd9R3730PSBrJerTGCwfuflJjbKR1HnqxTyO1PEDhmU7Q9y','102.129.223.92',0,'2025-03-03 12:27:33','2025-03-03 12:27:33','d1c6cecb-dac5-4bd2-b27a-f1532424bad0'),(171,23,NULL,2,1,'051JcPueTXLuMo1s7rLRqpUrKafabTJRjiK8KEtEgKvc9nUSAEMPRF1es3DEgpFmbXK1OVgzNHafGIlYYspCgF0p1HeRpMhPFexb','102.129.223.92',0,'2025-03-03 22:03:03','2025-03-03 22:03:03','83c0b20f-7507-4b45-9faa-37d32b47f92c'),(172,24,NULL,2,1,'yGs71JkC8sWzrh15JL2PpNs0b9mKVFvKv14oiwJKr4Bpy3svxWzZrIBDEZYJ9oAgzqFD1yiHCaSefzMpunnnBGiRDIEh2MU3NPwJ','102.129.223.92',0,'2025-03-05 14:39:17','2025-03-05 14:39:17','c2c6c5d2-479b-46f5-b3fc-f2c3283c118e'),(173,25,NULL,2,1,'Uhke9b33q79OQoaZ39Hc1QORyoBsW2lyHO9KEI8yZpzRFFyOQHnEr2GflfYDCHRMYpFM6EkeOvYawD6wNf0e12g1O9e1nkx2tDEH','102.129.223.92',0,'2025-03-06 20:26:41','2025-03-06 20:26:41','2be91b18-52f3-4b47-87a0-824402dbf8f2'),(174,26,NULL,2,1,'H9u0jn59Nkf84OH2qofcaqfRrjXheLidgcFDfy3GE2EvNgel3qQGu2hdUd4ewTioTmDDlFNUZcdvD5xOjoBTvvlCWCDiVfd0krvG','102.129.223.92',0,'2025-03-11 06:26:01','2025-03-11 06:26:01','ad01336b-ec10-4974-a44e-7b444d869b76'),(175,27,NULL,2,1,'83c4ZNHUmO1vGaYzp8ryZhu1Y8ivZ0lNeApMqYkoHtlUsFoXLPcJkBxRjJqUZg6BlzFoMtHbh8HtdiFCDECewsw00TSFBMsBDECF','102.129.223.92',0,'2025-03-18 21:52:25','2025-03-18 21:52:25','9a7457ca-6e1f-43b4-9006-0e2c4727c242'),(176,28,NULL,2,1,'UOSPlT9Wgsguh6j4wRbIYAJOxBNuFbHXGq8KZKOVmCrPRlmLdX7mK8u0tDxoWjPAQmcZq1w57iOYesYcdXenpuGOpLGZ9ts1yttW','102.129.223.92',0,'2025-03-21 14:55:16','2025-03-21 14:55:16','3f43b1bc-d8fa-4e56-a2c7-0d553aa65763'),(177,29,NULL,2,1,'2bIqYAe5c36trkd7CGspnznfsXbCz3w7bMCg0Qls01GVCp6FQuj90rTx0xLKEssO5izHZHTzp7foIoFgD3WpFkFGMrZ3VNRPaxrc','102.129.223.92',0,'2025-03-23 21:24:34','2025-03-23 21:24:34','1ca582af-f892-4ac4-b402-7e47732accb7'),(178,30,NULL,2,1,'6n9AGl74DdOjQ0w6t95VGDLBm8XrCzf1JQ613QzL2HsZ3XnFcrUa82dGFNTEuCU6Hb7docG02CsC7T3nKo2Bkuquflbx83cxP177','102.129.223.92',0,'2025-03-24 09:24:28','2025-03-24 09:24:28','c5351cee-fd34-4b64-a480-cbb37499cc0a'),(179,31,NULL,2,1,'ztjYUzt9esbSj5dGAPkxcYBEyAcEgPywxQBqYTrIzFYUkPmRIeiCrDUIQdbTpWjGWDN5kV1m09uaukpEWoxYBvxTOUqS9c06U6qx','102.129.223.92',0,'2025-03-25 16:22:21','2025-03-25 16:22:21','bc8f65cd-37b9-4c1e-ad45-5e5ffda9d945'),(180,32,NULL,2,1,'G7pWBzRzvNs5LZ314Pbw3GMUlGVY8UtpllYEYymS1HAcjgFw1JnjDeJuydXTw2ukvJcR3k6baR1siA41rMJ9EWYBEdVBA24azEqJ','102.129.223.92',0,'2025-03-27 01:23:02','2025-03-27 01:23:02','42a41c51-bf16-4fcb-b125-bf98ea06583b'),(181,33,NULL,2,1,'ShV2T63zEaCZI7FVG1M41wxuRM4odv2tkviD7NhZefcCUQ8fqg8nr2OuXcq9rQb6IerBwyUb65fp9H6RYL3t9o8xix58EyBIHIIL','102.129.223.92',0,'2025-03-27 17:23:07','2025-03-27 17:23:07','52d88c26-9888-43bf-8b45-a2c7f278fbd5'),(182,34,NULL,2,1,'8Q3JwSrvxsbV5hSLtUnaH27URdZAaVSwRusR7nWlzfgdNgCNZOgtTGgxhpPStMvVTwbmL3wSoG0swkck4dif1mJDNcdbCX8tjqaY','102.129.223.92',0,'2025-03-29 21:52:28','2025-03-29 21:52:28','4e388ab5-e170-4281-b95d-fd2b73338612'),(183,35,NULL,2,1,'uVl0RGs7M2TMLCbiqXE8PZyNgyVV1z8sDQHQURvlcyTGPl8OzjpIk9SuJpRiihVCMlHXPYBQ8R8aTRvHihrb2GjRfnIxksG67tUd','102.129.223.92',0,'2025-03-31 22:23:23','2025-03-31 22:23:23','059f45c2-93a2-4e06-9820-8cbf1f478cee'),(184,36,NULL,2,1,'NJLZz26CGj06koSYEgdDBVTfkAmBj5qytD3dpQ1cAhYPLvzIG4rKiI4DjuOt2v3onfwaWdpi8taI6qSl5QpkqInrcg90sJn0wz4m','102.129.223.92',0,'2025-04-01 00:52:59','2025-04-01 00:52:59','ba143048-b662-41bd-9a08-20f487937746'),(185,37,NULL,2,1,'kHhT6iqv4WniJ7N3ylenHrpuYBmoZjlBCA7p6QIvlTpzIJFd4drHe4Z7OGBfNNAxF9XuJjrXd7KQlG4Xh8CpjXnzFKFfqwFWquef','102.129.223.92',0,'2025-04-02 04:52:06','2025-04-02 04:52:06','044ebc2c-7f97-45b2-9a53-c030fe70e0a3'),(186,38,NULL,2,1,'SocctGlI9b4ev98IH0a3OmdiWgB8i0UCLKdkQSiCZQCTKCMv0w9oUPWTxKRtBGfMY5lZeaVE2DLDcn6NtyemJ5MitV6X3D7SPRbc','196.245.246.54',0,'2025-04-10 04:05:45','2025-04-10 04:05:45','ab62e43e-fc6e-46ea-bb50-9dd4be0787d9'),(187,39,NULL,2,1,'9nGEu97iLgyyqvqdrK8Rjoo5n7vYQZuAqCuoLOONkCi8MLPNeC9z4jLErD2GrBz3KfyIzZhnBL7HjjJdozNjpikiu8ftHvlSn9Hd','102.129.223.92',0,'2025-04-11 19:39:08','2025-04-11 19:39:08','46fcf494-696d-4260-93d1-f8afe7c95ca2'),(188,40,NULL,2,1,'AZPWSOX5OeNAwsvZmKVOqje1GBX3133mJh2WEbUJ1sSTCnGR5BYqsVUlzw0u2qMSavakKhLvt4nmK4MzBunpAZ36wrgWixrfE7K9','102.129.223.92',0,'2025-04-12 03:53:33','2025-04-12 03:53:33','a4f34fbc-f509-4d10-9fd1-6c91dba0446b'),(189,41,NULL,2,1,'OTjPUlISb3IO0dxrEl302GNcgexWlJbGbeQn2PlouGBb6hmfoBfMp6qIYwgzcSlX9g58VN1qKInGlZqxprH8nE2vb0C6Hmm9yoU8','102.129.223.92',0,'2025-04-13 13:23:39','2025-04-13 13:23:39','eb9076e3-fd17-476a-ba6d-4af3326d500c'),(190,42,NULL,2,1,'QS97TRJxjcfAQEfdv0eHOcJBomNugLa6yrv4yCewJVgicQP9fFMTfmJr5XKKPtJFTCL38j9lg0BOEkw8a3P6TGN55SZmdAwIwWTW','102.129.223.92',0,'2025-04-17 01:41:07','2025-04-17 01:41:07','e185a6f5-80dd-4ab2-ad07-94f1644d904a'),(191,43,NULL,2,1,'MgFxq0X3lh30lziTC24EcRQO3lse0hDmXyBCLboXKEV4icRnHU4O86gEK5MiRbzwkPqOvBMibQl6XMXn2IrlKD7lbEiv3m8FGzx2','102.129.223.92',0,'2025-04-20 16:42:42','2025-04-20 16:42:42','02ea1519-7e7a-4750-a57d-eb652a19fcdb'),(192,44,NULL,2,1,'8faRpn8Sn0aG2LNvYp91SDwdYLtvZjee8m4wiFz5JQyMg8Ff5057N1w6T8iDPf4ypMC0vpTfgRGRFohbzffYe2suMTIPEsfrJyPi','92.119.36.114',0,'2025-04-21 10:42:51','2025-04-21 10:42:51','d6cb05c8-a231-4c22-b867-e49b81be9c54'),(193,45,NULL,2,1,'sjmmZP5BjWzVlL9cRtLqLzWxhyixCc5AsxgkDBV9YsUeCNr6SEyrEuWY5PtGSy4LAzYOcW3TbIREjhXZshqjdxuaOztVXjL6pS07','102.129.223.92',0,'2025-04-22 20:47:58','2025-04-22 20:47:58','d13c5fe4-82ca-46b7-9178-887b49b52211'),(194,46,NULL,2,1,'SPmFJTi18UrB77pfvr9Up2tTRY0Fijzbf1aopWcmH524y4cjnyZP2sPOY8mtYGlRLkQ5Vabi4S3IuKBAhV7VcuypR1whCPNcsgsu','102.129.223.92',0,'2025-04-24 16:23:16','2025-04-24 16:23:16','dc8edb76-aa92-4aeb-bec5-5f0f5e1de610'),(195,47,NULL,2,1,'HwaFE5ioG8uZJibsLqDOP1evlB0GEqj5GN5dgYVqmSF6DoSpqpMmdWFRZ08AuUxtNDod9Gyp4IeNzZS3hy8SDLYi3Q2SgcLEYR3L','102.129.223.92',0,'2025-04-26 05:25:10','2025-04-26 05:25:10','db95a78a-f227-4071-a07c-fcfc15f64f93'),(196,48,NULL,2,1,'rjqDm6GazuJDy6SogUR7ni8oM07WdtbyTBf9etPIFzWOaZzSxfLxk53K1icSN7T3vnmDTOYARl44oNSwALRRsRaAQHIIfnIKrSHY','106.219.162.237',0,'2025-04-27 07:57:52','2025-04-27 07:57:52','3a6d6268-ddff-43c5-96a9-7003d698ec03'),(197,49,NULL,2,1,'tSO7kQIbEBO4R3HLfIm8vdkuv6gnjGip9cBUCzYRYVTEwCaAJorpREXLoeBC6CPcRfWt8zwXyGArsEvevUgdZk76icPYrqDOODHO','102.129.223.92',0,'2025-04-27 20:08:59','2025-04-27 20:08:59','1eec95be-06cd-4d7f-93b2-1dbaa5042242'),(203,50,NULL,2,1,'NNcc1ptoDGCjpPTr1mW2pVFEMZyEnAE8ePYHYCEB7VdQKG7fPNPB23OCRLeX8uNVTQ9coO5viMsfxtaU2p17xhGMMgJu9DU19zgh','149.102.238.137',0,'2025-05-02 17:12:28','2025-05-02 17:12:28','fab0ca67-f498-4404-8790-fce330a3dea6'),(204,51,NULL,2,1,'KQoEiaYMgt2dR6n4qgXCctJmgHRvzqJy7nmSflRgvBkK0F6H3tpVopF4uL1J3WQZuup2rMR7V2JAQtrRzAZ0hYo1HpZKKPiW6Ufc','102.129.223.92',0,'2025-05-06 09:25:00','2025-05-06 09:25:00','dd419069-720f-4d24-bb41-af222fbc38c3'),(205,52,NULL,2,1,'e6wsR1hq4sE3TZKdfEDECFU6d5UwDVMVw7UnQsBf68PMhb1jlh1WgecaaKEESW7axZjAZaa9nEBUI0CbykCseQeF8jIsdLLEJlnu','185.147.125.18',0,'2025-05-07 13:34:27','2025-05-07 13:34:27','392e4d52-58ca-4038-bf68-ee602d1ed9fb'),(206,53,NULL,2,1,'b0iewC9uMAN9EVJp1bp2X14ePrkT1Y8ZRajVNX2bZPaoqY803jo8lXsSEVQm4qrdbq17exw1AyNK2nA1if2hCEcLrcDZM7qREKiX','168.196.237.39',0,'2025-05-10 10:43:36','2025-05-10 10:43:37','345d4308-a305-45a9-8391-6f3b3316ac52'),(207,54,NULL,2,1,'JH8tshEp4SnLL54bFK7vjsYh13fHJutqCt8evTaChCbWPJSLgHuhAtHsUxcNIUjHxsXN63tfELsO8Oqs7IjLgc10neAMc3iwWfbj','102.129.223.92',0,'2025-05-16 04:25:45','2025-05-16 04:25:45','7472e692-c9ee-4198-a2cc-3755ee4d4674'),(208,55,NULL,2,1,'sGyEvIOsvEhvTYud0q73Xv08O68QtaMVe5N3Z0p2IHvyfSlUgZiNbLlaH9uU1nemaiO6d8Uz7QETK0UcawGDwoKPj5i8KCLDpdaV','154.47.27.73',0,'2025-05-18 06:55:56','2025-05-18 06:55:57','b13f2247-2ff7-49ec-a3a5-3559cd7dacdc'),(209,56,NULL,2,1,'2XyVMweI3P5BCHiy0qPOIFCWFt4d5JUFIMVxQW7dWaLa44HbtJbCxmu1A8sjBinyC2aNnHnvGj0AckOryQTw1EwNj9raM6KdIMKW','102.129.223.92',0,'2025-05-20 20:38:05','2025-05-20 20:38:05','b8da6769-7326-4bc3-a9e3-94673b1c7002'),(210,57,NULL,2,1,'eMbgs5UT5Clhztai1gTF132LuIFskWjmxPVfNalYViCBvymNYA3fPC5cdO93ATHc0eL80EBDXCy5umm5l2ZSWaN9EW8FKHOyvjJf','195.82.146.211',0,'2025-05-21 16:17:26','2025-05-21 16:17:26','69e1d4d4-cc5f-4935-ac60-e94323ed6fc5'),(211,58,NULL,2,1,'6LkOBZF8UXTSBLXDrs7j6EHgZXIcxg9tViOWVOipzJnorcWI7QPyBHudrwCiuFLeSG8U7sybEcBu2Qot1h4Tx0aMS4Sen3m6QJrY','102.129.223.92',0,'2025-05-23 09:56:42','2025-05-23 09:56:42','29d93242-dabd-4c94-908d-23643f7ed9ae'),(212,59,NULL,2,1,'pF1XC165xA86SefQ4TyKa0AGDT7Do5dScy6qV6vrWADggFL4Z3ex8BYylE7HWP1e91u05oJ8v1zbw6s4e1UtDX56Q3fgy14waXWI','77.246.104.80',0,'2025-06-13 22:15:48','2025-06-13 22:15:48','12caa677-6c3d-413a-9622-898138397afc'),(213,60,NULL,2,1,'KI5jlbvoWCsyX0tgopOZ3xr1nOyDolAzoHUcWwXj0Wifm4wODZgMTwaiHnX1ndTabqqdcTZ9fRAekKrFhDr1KWTbDB1GhwltkMma','204.12.215.98',0,'2025-06-18 19:30:26','2025-06-18 19:30:26','1488df3c-9334-4d07-9691-54afc3f411ba'),(214,61,NULL,2,1,'4xHEm1Oc6NYvMtOkGMtCJtyGfo7Cy2k1UVGUewNDoaOn0orlI6f4tUy7zWtxkygYmmipjxt41TbUF5S3gHgle7RAWfTDkNUNtLHo','104.234.73.183',0,'2025-07-02 04:50:52','2025-07-02 04:50:53','db1920ce-e594-4dbf-aab0-93302457033e');
/*!40000 ALTER TABLE `freeform_submissions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_submissions_contact_form_1`
--

LOCK TABLES `freeform_submissions_contact_form_1` WRITE;
/*!40000 ALTER TABLE `freeform_submissions_contact_form_1` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `freeform_submissions_contact_form_1` VALUES (149,'Eric','ericjonesmyemail@gmail.com','Who needs eyeballs, you need BUSINESS','Hi Robmartinomusic Owner!\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com for a live demo now.\r\n\r\nPlus, now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nhttps://boltleadgeneration.com to discover what LeadConnect can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry LeadConnect and get more leads now.\r\n\r\nEric\r\n\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nLeadConnect offers a complimentary 14-day trial – and it even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try LeadConnect now.\r\n\r\nWe are committed to protecting your privacy and providing a safe & high-quality online experience for our visitors. We understand that you care about how the information you provide to us is used and shared. We have developed a Privacy Policy to inform you of our policies about the collection, use, and disclosure of information we receive from users of our website. We operate the Website.\r\n\r\nOur Privacy Policy, along with our Terms & Conditions, governs your use of this site. By using the website, or by accepting the Terms of Use (via opt-in, checkbox, pop-up, or clicking an email link confirming the same), you agree to be bound by our Terms & Conditions and our Privacy Policy.\r\n\r\nIf you have provided any voluntarily given information, you may review and make changes to it via instructions found on the Website. To manage your receipt of marketing and non-transactional communications, you may Want to receive fewer emails, or none whatsoever? Update your email preferences.\r\n\r\nEmails related to orders are provided automatically – customers are not able to opt out of these. We will try to address any requests related to the management of personal information in a timely manner. However, it may not always be possible to fully remove or modify information in our databases if we have a valid reason to keep it for certain timeframes. If you have any questions, simply see our website to view our official policies.\r\n\r\nOur primary goal is to help you with lead generation. These emails are meant to give you advice on that topic, or to promote products that will help you have the kind of business films are written about.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com\r\n'),(150,'Eric','ericjonesmyemail@gmail.com','Turn Surf-Surf-Surf into Talk Talk Talk','Hello to the Robmartinomusic Owner,\r\n\r\nI am Eric and I recently came across your website at Robmartinomusic. I found it after a search, so your visibility seems to be working well.\r\n\r\nYour content looks helpful.\r\n\r\nHowever, one thing might be missing:\r\n\r\nA simple, prompt way for visitors to connect with you.\r\n\r\nResearch suggests that many visitors leave a site quickly without providing any contact information. Once they go, there’s no way to follow up.\r\n\r\nConsider this approach:\r\n\r\nWeb Visitors Into Leads is a tool that operates on your site, ready to gather each visitor’s name, email address, and phone number. You will know as soon as someone shows interest, allowing you to speak with them while they’re still viewing your site.\r\n\r\nView a Demonstration https://actionleadgeneration.com\r\n\r\nOnce you have their phone number, you can also begin a text conversation. If they aren’t ready to engage at that exact moment, you can maintain communication later by sharing additional updates or simply checking in.\r\n\r\nEverything described is straightforward to implement and may help improve your interactions with potential contacts.\r\n\r\nPlease visit https://actionleadgeneration.com to learn more about what Web Visitors Into Leads can do for you. It could help you connect with more interested individuals right now.\r\n\r\nEric\r\n\r\nP.S. Web Visitors Into Leads includes a trial period and supports international communication. There may be individuals ready to speak with you now, so please don’t miss the opportunity.  \r\nVisit https://actionleadgeneration.com to learn more.\r\n\r\nJust a note – the names and email used here, Eric and Jones, are placeholders and not actual contact details. We value transparency and want you to be aware. If you wish to connect with the person behind this message, please visit our website, and we will put you in touch with the appropriate individual.\r\n\r\n==================================================\r\n\r\nWe are committed to protecting your privacy and maintaining a positive online experience. We understand that you care about how your information is used and shared. We have developed a Privacy Policy to explain our guidelines for handling information we receive from users of our website. We operate this website.\r\n\r\nOur Privacy Policy, along with our Terms & Conditions, governs your use of this site. By using the website, or by confirming acceptance of the Terms of Use, you agree to follow both our Terms & Conditions and our Privacy Policy.\r\n\r\nIf you have provided information voluntarily, you may review and update it following the instructions on our website. To manage certain communications, you may unsubscribe using the link at the bottom of marketing emails. Transaction-related emails are not optional. We will do our best to handle any requests related to personal information promptly, although complete removal may not always be possible due to certain requirements. If you have any questions, please review our official policies on our website.\r\n\r\nOur goal is to help you enhance the effectiveness of your lead generation efforts. These emails offer guidance on that topic or introduce tools that may support your initiatives.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(151,'Eric','ericjonesmyemail@gmail.com','Your site – more leads?','Hello to the Robmartinomusic Owner. This is Eric and I noticed Robmartinomusic a short time ago.\r\n\r\nIt appears well structured… now what?\r\n\r\nWhat I mean is, when someone like me discovers your website – either through a search or just browsing around – what happens next? Are you receiving meaningful inquiries from your site, or enough to meet your needs?\r\n\r\nHonestly, most business websites come up a bit short when it comes to attracting engaged visitors. Research indicates that 70% of a site’s visitors leave and never return after only a moment.\r\n\r\nHere is an idea…\r\n\r\nWhat about making it simple for each visitor who arrives to receive a direct phone call from you as soon as they reach your site…\r\n\r\nThis is possible –\r\n\r\nWeb Visitors Into Leads is a tool that operates on your site, designed to collect each visitor’s name, email address, and phone number. It notifies you the moment they indicate interest – so that you can speak to that person while they are browsing your site.\r\n\r\nPlease visit https://actionleadgeneration.com to view a live demonstration of Web Visitors Into Leads and understand how it operates.\r\n\r\nYou will notice a significant difference between connecting with someone within 5 minutes compared to a half-hour or more later. This can greatly improve the likelihood of meaningful engagement.\r\n\r\nIt becomes even more helpful. After you have their phone number, with our SMS text communication feature, you can promptly begin a text conversation.\r\n\r\nThat way, even if you do not reach a conclusion immediately, you can stay connected through text messages for informational updates, content links, or simple check-in notes to establish a relationship.\r\n\r\nQuite helpful.\r\n\r\nPlease visit https://actionleadgeneration.com to learn how Web Visitors Into Leads can support your business.\r\n\r\nYou can potentially connect with many more interested individuals as soon as possible.\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads provides a no-cost 14-day evaluation period. It also supports international communication. There are interested individuals ready to speak with you now, so please do not delay.\r\n\r\nPlease visit https://actionleadgeneration.com to explore Web Visitors Into Leads.\r\n\r\nJust a brief note - the name and email used here, Eric and Jones, are placeholders and not real contact information. We value transparency and wanted to ensure you’re aware! If you wish to get in touch with the individual behind this message, please visit our website, and we will connect you with the appropriate person.\r\n\r\n==================================================\r\n\r\nWe are committed to protecting your privacy and providing a safe, high-quality online experience. We understand that you care about how your information is used and shared. We have developed a Privacy Policy to inform you of our guidelines regarding the collection, use, and disclosure of information received from users of our website. We operate this website.\r\n\r\nOur Privacy Policy, along with our Terms & Conditions, governs your use of this site. By using the website, or by accepting the Terms of Use, you agree to be bound by our Terms & Conditions and our Privacy Policy.\r\n\r\nIf you have provided information voluntarily, you may review and make changes to it by following the instructions found on the website. To manage marketing and non-transactional communications, you may unsubscribe by clicking the link at the bottom of any marketing email. Order-related emails are sent automatically and cannot be opted out of. We will do our best to address requests related to managing personal information in a timely manner. However, it may not always be possible to remove or modify data if certain retention requirements apply. If you have any questions, please visit our website to view our official policies.\r\n\r\nOur primary goal is to help you achieve strong results in lead generation. These emails are intended to offer guidance on that topic, or to introduce resources that may strengthen your outreach.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(152,'Eric','ericjonesmyemail@gmail.com','Who needs eyeballs, you need BUSINESS','Hi Robmartinomusic Owner!\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com for a live demo now.\r\n\r\nPlus, now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nhttps://boltleadgeneration.com to discover what LeadConnect can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry LeadConnect and get more leads now.\r\n\r\nEric\r\n\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nLeadConnect offers a complimentary 14-day trial – and it even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try LeadConnect now.\r\n\r\nWe are committed to protecting your privacy and providing a safe & high-quality online experience for our visitors. We understand that you care about how the information you provide to us is used and shared. We have developed a Privacy Policy to inform you of our policies about the collection, use, and disclosure of information we receive from users of our website. We operate the Website.\r\n\r\nOur Privacy Policy, along with our Terms & Conditions, governs your use of this site. By using the website, or by accepting the Terms of Use (via opt-in, checkbox, pop-up, or clicking an email link confirming the same), you agree to be bound by our Terms & Conditions and our Privacy Policy.\r\n\r\nIf you have provided any voluntarily given information, you may review and make changes to it via instructions found on the Website. To manage your receipt of marketing and non-transactional communications, you may Want to receive fewer emails, or none whatsoever? Update your email preferences.\r\n\r\nEmails related to orders are provided automatically – customers are not able to opt out of these. We will try to address any requests related to the management of personal information in a timely manner. However, it may not always be possible to fully remove or modify information in our databases if we have a valid reason to keep it for certain timeframes. If you have any questions, simply see our website to view our official policies.\r\n\r\nOur primary goal is to help you with lead generation. These emails are meant to give you advice on that topic, or to promote products that will help you have the kind of business films are written about.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com\r\n'),(153,'Eric','ericjonesmyemail@gmail.com','Who needs eyeballs, you need BUSINESS','Hello Robmartinomusic Owner\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://resultleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just \"how are you doing?\" notes to build a relationship.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them.\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(154,'Eric','ericjonesmyemail@gmail.com','Who needs eyeballs, you need BUSINESS','Hello Robmartinomusic,\r\n\r\nI\'m Eric and I recently discovered your website - Robmartinomusic - in the search results.\r\n\r\nThis is what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re receiving eyeballs – at least mine.\r\n\r\nYour content’s pretty good, would not change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs do not pay the bills.\r\n\r\nCUSTOMERS do pay the bills.\r\n\r\nAnd studies show that 7 out of 10 visitors like Robmartinomusic will drop by, have a look, and then leave without doing anything else.\r\n\r\nIt’s like they never even were there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it extremely easy for them to show interest, say, okay, let’s talk without needing them to even pull their phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your website, ready and waiting to capture any visitor’s Name, Email address, and Phone Number. It allows you know immediately – so you can speak with that lead immediately… before they leave.\r\n\r\nPlease visit the following URL to experience a Live Demo with Web Visitors Into Leads now to see precisely how it works and even give it a try… it could be huge for your business: https://trustedleadgeneration.com\r\n\r\nTime is of the essence when it comes to connecting with leads – the difference between contacting someone within 5 minutes compared to 30 minutes implies you can be converting up to 100X more leads now!\r\n\r\nMoreover, now that you’ve got their phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation immediately… which is so effective, because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up frequently with new offers, content links, even just follow-up notes to develop a relationship.\r\n\r\nEverything I’ve just described is very easy to implement, cost-effective, and beneficial.\r\n\r\nPlease visit the following URL to discover what Web Visitors Into Leads can do for your business, possibly converting up to 100X more visitors into leads today: https://trustedleadgeneration.com\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a free 14 days trial!\r\nIt even includes International Long Distance Calling.\r\nPaying customers are waiting.\r\nStart connecting today by visiting https://trustedleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here.  \r\nhttps://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(155,'Eric','ericjonesmyemail@gmail.com','Try this, get more leads','Hello to the Robmartinomusic Manager,\r\n\r\nI am Eric and I’m thinking you would like your website Robmartinomusic to produce additional inquiries.\r\n\r\nHere is one approach:\r\n\r\nWeb Visitors Into Leads is a tool that operates on your site, prepared to capture each visitor’s name, email, and phone number. It informs you as soon as someone expresses interest, allowing you to speak with them while they are still viewing Robmartinomusic.\r\n\r\nView a Demonstration https://actionleadgeneration.com to see how Web Visitors Into Leads works.\r\n\r\nOnce you have their phone number, our new SMS Text With Lead feature allows you to start a text conversation. You can answer questions, provide more details, and even finalize a connection that way.\r\n\r\nIf they are not ready at that moment, you can follow up later with text messages that share updated information, helpful links, or simply keep the dialogue open to establish a positive rapport.\r\n\r\nLearn More https://actionleadgeneration.com to understand how Web Visitors Into Leads can support your business, potentially engaging many more interested individuals.\r\n\r\nEric\r\n\r\nP.S. Studies suggest that most visitors leave quickly. This resource offers a 14-day evaluation period and also includes international communication support. There may be individuals ready to speak with you now, so please don’t let the opportunity pass.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(156,'Carmela','dulhunty.carmela@outlook.com','seeking information','\r\nDid you know there’s a better way to deliver affiliate marketing campaigns? With our service, you can send your message directly to website contact forms. Stop worrying about policies.\r\n\r\nContact me at the details below if you’d like to explore this further.\r\n\r\nRegards,\r\nCarmela Dulhunty\r\nEmail: Carmela.Dulhunty@morebiz.my\r\nWebsite: http://xcdsv4.formblastmarketing.top\r\n\r\n'),(157,'Eric','ericjonesmyemail@gmail.com','There they go…','Hello Robmartinomusic Owner!\r\n\r\nMy name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at Robmartinomusic.\r\n- They hang out for a minute to check it out. “I’m interested… but… maybe…”\r\n- And then they hit the back button and check out the other search results instead.\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a lot – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address and Phone Number. You’ll know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nVisit https://boltleadgeneration.com to try out a Live Demo with LeadConnect now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nVisit https://boltleadgeneration.com to discover what LeadConnect can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: LeadConnect offers a complimentary 14-day trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nVisit https://boltleadgeneration.com to try LeadConnect now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(158,'Eric','ericjonesmyemail@gmail.com','Your site – more leads?','Hello Robmartinomusic,\r\n\r\nI\'m Eric and I recently discovered your website - Robmartinomusic - in the search results.\r\n\r\nThis is what that signifies to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re receiving eyeballs – at least mine.\r\n\r\nYour content’s pretty good, would not change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs do not pay the bills.\r\n\r\nCUSTOMERS do pay the bills.\r\n\r\nAnd studies indicate that 7 out of 10 visitors to Robmartinomusic will drop by, have a look, and then leave without doing anything else.\r\n\r\nIt’s like they never even were there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it extremely easy for them to show interest, say, okay, let’s talk without needing them to even pull their phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your website, prepared and waiting to capture any visitor’s Name, Email address, and Phone Number. It allows you to know immediately – so you can speak with that lead immediately… before they leave.\r\n\r\nCLICK HERE https://trustedleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see precisely how it works and even give it a try… it could be huge for your business.\r\n\r\nYou’ll be astonished - the difference between contacting someone within 5 minutes versus a half-hour or more later could boost your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation immediately… which is so effective, because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up frequently with new offers, content links, even just follow-up notes to develop a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nGoto https://trustedleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a free 14 days trial!\r\nIt even includes International Long Distance Calling.\r\nPaying customers are waiting.\r\nStart connecting today by visiting https://trustedleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here.  \r\nhttps://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(159,'Eric','ericjonesmyemail@gmail.com','There they go…','Hello Robmartinomusic Owner,\r\n\r\nMy name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at Robmartinomusic.\r\n- They hang out for a minute to check it out. I’m interested… but… maybe…\r\n- And then they hit the back button and check out the other search results instead.\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nhttps://resultleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just how you doing? notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them.\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(160,'Eric','ericjonesmyemail@gmail.com','Cool website!','Hello to the Robmartinomusic Owner.\r\n\r\nGreat website!\r\n\r\nMy name’s Eric, and I just found your site - Robmartinomusic - when browsing the net. You showed up on the top of the search engine results, so I checked you out. Seems like what you’re doing is really interesting.\r\n\r\nBut if you don’t mind me asking – after someone like me lands across Robmartinomusic, what usually happens?\r\n\r\nIs your site generating leads for your business?\r\n\r\nI’m guessing some, but I also guess you’d like more… research show that 7 out of 10 people that land on a site end up leaving without any interaction.\r\n\r\nThat’s unfortunate.\r\n\r\nHere is an idea – what if there’s a simple way for each visitor to signal interest to get a phone call from you immediately…the moment they visit your site and said, “call me now.”\r\n\r\nYou can –\r\n\r\nWeb Visitors Into Leads is a tool that works on your site, ready to capture every visitor’s Name, Email address, and Phone Number. It allows you to know immediately – so that you can talk to that lead while they’re actually browsing your site.\r\n\r\nGo to https://actionleadgeneration.com to check out a Live Demo with Web Visitors Into Leads today to see exactly how it works.\r\n\r\nTime is essential when it comes to engaging with leads – the difference between contacting someone within 5 minutes compared to 30 minutes later is significant – like 100 times more effective!\r\n\r\nThat’s why we created our new SMS Text With Lead feature… because once you’ve collected the visitor’s phone number, you can automatically start a text message conversation.\r\n\r\nConsider the opportunities – even if you don’t close a deal right away, you can stay connected with text messages for new offers, content links, or even just a quick “how are you doing?” note to establish a relationship.\r\n\r\nWouldn’t that be helpful?\r\n\r\nGo to https://actionleadgeneration.com to find out what Web Visitors Into Leads can offer for your business.\r\n\r\nYou could be converting up to 100X more leads today!  \r\nEric\r\n\r\nPS: Web Visitors Into Leads provides a complimentary 14-day trial – and it even includes International calling.  \r\nYou have customers waiting to talk with you right now… don’t leave them waiting.  \r\nGo to https://actionleadgeneration.com to try Web Visitors Into Leads today.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(161,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello Robmartinomusic Owner!\r\n\r\nEric here with a quick thought about your website Robmartinomusic...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content.\r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard. Studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace. You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested, and you can call them directly to talk with them while they’re literally checking out Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging, you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n\r\nhttps://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a complimentary 14-day trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(162,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello to the Robmartinomusic Owner,\r\n\r\nThis is Eric here, with a brief note about your website Robmartinomusic.\r\n\r\nI am on the internet often, and I see many business websites.\r\n\r\nSimilar to yours, several of them have excellent content.  \r\nHowever, too often, they fall short when it comes to interacting and connecting with a visitor.\r\n\r\nI understand – it is challenging. Research shows that many individuals who arrive at a site leave within moments without sharing any details. You gained their initial attention, but nothing else.\r\n\r\nHere is a possible solution:\r\n\r\nWeb Visitors Into Leads is a tool that operates on your site, prepared to collect each visitor’s name, email address, and phone number. You will know right away that they are interested, and you could speak with them while they are still online viewing your site.\r\n\r\nPlease visit https://actionleadgeneration.com to view a Live Demo with Web Visitors Into Leads today to see exactly how it operates.\r\n\r\nIt can be significant for your business – and because you have their phone number, with our SMS Text With Lead capability, you can instantly begin a text conversation. Connecting with someone in those first minutes is far more effective than waiting longer.\r\n\r\nAdditionally, with text messaging, you may follow up later with new updates, content links, or simple notes to keep the conversation moving.\r\n\r\nEverything described is straightforward to implement, cost-effective, and genuinely helpful.\r\n\r\nPlease visit https://actionleadgeneration.com to learn what Web Visitors Into Leads can provide for your business.\r\n\r\nYou can be engaging with more visitors as we speak!\r\n\r\nEric\r\n\r\nP.S. Web Visitors Into Leads provides a 14-day evaluation – and it includes international calling. You have individuals who may be ready to speak with you now, so please do not delay.\r\n\r\nPlease visit https://actionleadgeneration.com to view Web Visitors Into Leads today.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(163,'Lori','vinhgrowth@gmail.com',' YouTube Promotion: Grow your subscribers by 700 each month','Hi. We run a YouTube growth service, which increases your number of subscribers both safety and practically.\r\n\r\n- We guarantee to gain you new 700+ subscribers per month\r\n- People subscribe because they are interested in your videos/channel, increasing video likes, comments and interaction.\r\n- All actions are made manually by our team. We do not use any bots.\r\n\r\nThe price is just $60 (USD) per month, and we can start immediately. If you are interested and would like to see some of our previous work, let me know and we can discuss further.\r\n\r\nKind Regards,\r\n\r\nTo Unsubscribe, reply with the word unsubscribe in the subject.'),(164,'Eric','ericjonesmyemail@gmail.com','Who needs eyeballs, you need BUSINESS','Hi Robmartinomusic Owner!\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com for a live demo now.\r\n\r\nPlus, now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nhttps://boltleadgeneration.com to discover what LeadConnect can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry LeadConnect and get more leads now.\r\n\r\nEric\r\n\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nLeadConnect offers a complimentary 14-day trial – and it even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try LeadConnect now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com\r\n'),(165,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello, Eric here with a quick thought about your website Robmartinomusic \r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - Robmartinomusic - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across Robmartinomusic, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out of 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought…\r\n\r\nHow about making it really EASY for every visitor who shows up to get a personal phone call from you as soon as they hit your site…\r\n\r\nYou can –\r\n  \r\nWeb Visitor is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nhttps://resultleadgeneration.com to try out a Live Demo with Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed—the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n     \r\nhttps://resultleadgeneration.com to discover what Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitor offers a complimentary 14-day trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nhttps://resultleadgeneration.com to try Web Visitor now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(166,'Xin Ni','nnniixiinnn@gmail.com','hi!!!!!!!!!!!!!!','Hi Rob!!!!!! This is Xin from Logan\'s party!!! It was a wonderful conversation with you!:) my number is 267-626-8773, same as WhatsApp!! let\'s keep in touch!!! Thanks again for your encouragement! *btw I found a postcard flyer of ARSNOVA in the drawer today lol! Definitely will go solar myth one day!!!!'),(167,'Eric','ericjonesmyemail@gmail.com','Who needs eyeballs, you need BUSINESS','Hello Robmartinomusic Owner\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://resultleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just \"how are you doing?\" notes to build a relationship.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them.\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(168,'Eric','ericjonesmyemail@gmail.com','Try this, get more leads','Hello, Robmartinomusic Owner.\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://resultleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just how you doing? notes to build a relationship.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them.\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(169,'Eric','ericjonesmyemail@gmail.com','Try this, get more leads','Hello Robmartinomusic Owner!\r\n\r\nMy name is Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com for a live demo now.\r\n\r\nPlus, now that you’ve got their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nhttps://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://boltleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(170,'Eric','ericjonesmyemail@gmail.com','Cool website!','Hello Robmartinomusic \r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, and I just found your site - Robmartinomusic - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n\r\nBut if you don’t mind me asking – after someone like me stumbles across Robmartinomusic, what usually happens?\r\n\r\nIs your site generating leads for your business?\r\n\r\nI’m guessing some, but I also bet you’d like more… research indicates that 7 out of 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to raise their hand to get a phone call from you INSTANTLY… the second they hit your site and said, call me now.\r\n\r\nYou can –\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It notifies you IMMEDIATELY – so that you can speak to that lead while they’re actively looking over your site.\r\n\r\nGoto https://boltleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see precisely how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n\r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just how you are doing? notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nVisit https://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nStop wasting money chasing eyeballs that don’t turn into paying customers.  \r\nPlease see this URL to try Web Visitors Into Leads now: https://boltleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here.  \r\nhttps://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com\r\n'),(171,'Eric','ericjonesmyemail@gmail.com','Strike when the iron’s hot','Hello to the Robmartinomusic Owner,\r\n\r\nI am Eric, and I found Robmartinomusic after performing a quick search – you appeared near the top of the rankings, so whatever you’re doing for visibility seems to be working well.\r\n\r\nHere’s my question: what happens after someone arrives on your website? Do they simply leave without taking any action?\r\n\r\nResearch indicates that many visitors find a site, glance around briefly, and then leave, often without any engagement. That means all the work you’ve done to bring them there doesn’t fully pay off.\r\n\r\nWhy let your efforts go to waste?\r\n\r\nConsider making it easy for interested visitors to connect with you, without requiring them to even pick up their device.\r\n\r\nWeb Visitors Into Leads is a tool that resides on your website, ready to capture a visitor’s name, email, and phone number. It allows you to know immediately when someone is interested, so you can speak with them while they are still there.\r\n\r\nPrompt outreach is key. Connecting with someone within a few minutes rather than much later can make a significant difference.\r\n\r\nView a Live Demo https://trustedleadgeneration.com  \r\nto see exactly how Web Visitors Into Leads works.\r\n\r\nWith our SMS Text With Lead feature, once you have their contact number, you can immediately begin a text conversation. Even if they don’t accept your initial offer, you can maintain contact by sharing updates, useful information, and reasons to stay connected.\r\n\r\nThis simple addition can make your website much more effective.\r\n\r\nVisit the link above to learn more about what Web Visitors Into Leads can do for your business—you may be pleasantly surprised.\r\n\r\nThank you, and keep up the great work!\r\n\r\nEric\r\n\r\nP.S. Web Visitors Into Leads offers an available at no charge 14-day evaluation period. You could be engaging far more visitors soon. It even includes international call capabilities. Don’t let potential connections slip away.  \r\nExplore Web Visitors Into Leads now: https://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here. click here https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(172,'Eric','ericjonesmyemail@gmail.com','Turn Surf-Surf-Surf into Talk Talk Talk','Hello Robmartinomusic Owner,\r\n\r\nThis is Eric and for just a second, imagine this:\r\n\r\n- Someone does a search and ends up at Robmartinomusic.\r\n- They hang out for a moment to check it out. I’m interested… but… maybe…\r\n- And then they click the back button and check out the other search results instead.\r\n- Bottom line – you got an eyeball, but nothing else.\r\n- They’re gone.\r\n\r\nThis isn’t really your fault – it happens a lot – studies show 7 out of 10 visitors to any site leave without leaving a trace.\r\n\r\nBut you can fix that.\r\n\r\nWeb Visitors Into Leads is a software that operates on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You will know instantly they’re interested and you can call them directly to chat with them - literally while they’re still on the internet looking at your site.\r\n\r\nPlease see this URL to test a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business: https://trustedleadgeneration.com\r\n\r\nTime is of the essence when it comes to connecting with leads – the difference between contacting someone within 5 minutes compared to 30 minutes later can be significant.\r\n\r\nMoreover, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation immediately… which is so effective, because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up frequently with new offers, content links, even just follow-up notes to develop a relationship.\r\n\r\nEverything I’ve just described is very easy to implement, cost-effective, and beneficial.\r\n\r\nPlease see this URL to discover what Web Visitors Into Leads can do for your business, possibly converting up to 100X more visitors into leads today: https://trustedleadgeneration.com\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a free 14-day trial – and it even includes International Long Distance Calling.\r\nYou have clients waiting to speak with you right now… don’t keep them waiting.\r\nPlease see this URL to try Web Visitors Into Leads now: https://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here. https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(173,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello Robmartinomusic Owner!\r\n\r\nEric here with a quick thought about your website Robmartinomusic...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content.\r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard. Studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace. You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested, and you can call them directly to talk with them while they’re literally checking out Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging, you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n\r\nhttps://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a complimentary 14-day trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(174,'Eric','ericjonesmyemail@gmail.com','Your site – more leads?','Hello Robmartinomusic \r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, and I just found your site - Robmartinomusic - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n\r\nBut if you don’t mind me asking – after someone like me stumbles across Robmartinomusic, what usually happens?\r\n\r\nIs your site generating leads for your business?\r\n\r\nI’m guessing some, but I also bet you’d like more… research indicates that 7 out of 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s an idea…\r\n\r\nHow about making it really EASY for every visitor who shows up to get a personal phone call from you as soon as they hit your site…\r\n\r\nYou can –\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address and Phone Number. It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nhttps://boltleadgeneration.com to try out a Live Demo with LeadConnect now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus 30 minutes later could boost your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation.\r\n\r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just, how you doing? notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nhttps://boltleadgeneration.com to discover what LeadConnect can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: LeadConnect offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try LeadConnect now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(175,'Eric','ericjonesmyemail@gmail.com','Strike when the iron’s hot','Hello Robmartinomusic\r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, I found Robmartinomusic after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site? Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, okay, let’s talk without requiring them to even pull their cell phone from their pocket?\r\n\r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address, and Phone Number. It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n\r\nYou know, strike when the iron’s hot!\r\n\r\nPlease see this URL to try out a Live Demo with Web Visitors Into Leads now to see precisely how it works and even give it a try… it could be huge for your business: https://boltleadgeneration.com\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text (SMS) conversation with them.\r\n\r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when the iron’s hot!\r\n\r\nPlease see this URL to discover what Web Visitors Into Leads can do for your business – you’ll be amazed: https://boltleadgeneration.com\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a free 14 days trial!\r\nIt even includes International Long Distance Calling.\r\nStop wasting money chasing eyeballs that don’t turn into paying customers.\r\nPlease see this URL to try Web Visitors Into Leads now: https://boltleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here.  \r\nhttps://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(176,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello, Eric here with a quick thought about your website Robmartinomusic \r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - Robmartinomusic - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across Robmartinomusic, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out of 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought…\r\n\r\nHow about making it really EASY for every visitor who shows up to get a personal phone call from you as soon as they hit your site…\r\n\r\nYou can –\r\n  \r\nWeb Visitor is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nhttps://resultleadgeneration.com to try out a Live Demo with Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed—the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n     \r\nhttps://resultleadgeneration.com to discover what Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitor offers a complimentary 14-day trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nhttps://resultleadgeneration.com to try Web Visitor now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(177,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello Robmartinomusic Owner!\r\n\r\nEric here with a quick thought about your website Robmartinomusic...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content.\r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard. Studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace. You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested, and you can call them directly to talk with them while they’re literally checking out Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging, you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n\r\nhttps://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a complimentary 14-day trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(178,'Eric','ericjonesmyemail@gmail.com','Your site – more leads?','Hello Robmartinomusic Owner,\r\n\r\nMy name is Eric and I just came across your website at Robmartinomusic...\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next? Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n\r\nHow about making it really EASY for every visitor who shows up to get a personal phone call from you as soon as they hit your site…\r\n\r\nYou can –\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nhttps://resultleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed—the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n\r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just how you doing? notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(179,'Eric','ericjonesmyemail@gmail.com','Try this, get more leads','Hello, Robmartinomusic Owner.\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://resultleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just how you doing? notes to build a relationship.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them.\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(180,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello, Eric here with a quick thought about your website Robmartinomusic \r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - Robmartinomusic - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across Robmartinomusic, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out of 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought…\r\n\r\nHow about making it really EASY for every visitor who shows up to get a personal phone call from you as soon as they hit your site…\r\n\r\nYou can –\r\n  \r\nWeb Visitor is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nhttps://resultleadgeneration.com to try out a Live Demo with Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed—the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n     \r\nhttps://resultleadgeneration.com to discover what Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitor offers a complimentary 14-day trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nhttps://resultleadgeneration.com to try Web Visitor now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(181,'Eric','ericjonesmyemail@gmail.com','Try this, get more leads','Hello, Robmartinomusic Owner.\r\n\r\nMy name’s Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://resultleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just how you doing? notes to build a relationship.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them.\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(182,'Eric','ericjonesmyemail@gmail.com','Your site – more leads?','Hello to the Robmartinomusic Owner. This is Eric and I noticed Robmartinomusic a short time ago.\r\n\r\nIt appears well structured… now what?\r\n\r\nWhat I mean is, when someone like me discovers your website – either through a search or just browsing around – what happens next? Are you receiving meaningful inquiries from your site, or enough to meet your needs?\r\n\r\nHonestly, most business websites come up a bit short when it comes to attracting engaged visitors. Research indicates that 70% of a site’s visitors leave and never return after only a moment.\r\n\r\nHere is an idea…\r\n\r\nWhat about making it simple for each visitor who arrives to receive a direct phone call from you as soon as they reach your site…\r\n\r\nThis is possible –\r\n\r\nWeb Visitors Into Leads is a tool that operates on your site, designed to collect each visitor’s name, email address, and phone number. It notifies you the moment they indicate interest – so that you can speak to that person while they are browsing your site.\r\n\r\nPlease visit https://actionleadgeneration.com to view a live demonstration of Web Visitors Into Leads and understand how it operates.\r\n\r\nYou will notice a significant difference between connecting with someone within 5 minutes compared to a half-hour or more later. This can greatly improve the likelihood of meaningful engagement.\r\n\r\nIt becomes even more helpful. After you have their phone number, with our SMS text communication feature, you can promptly begin a text conversation.\r\n\r\nThat way, even if you do not reach a conclusion immediately, you can stay connected through text messages for informational updates, content links, or simple check-in notes to establish a relationship.\r\n\r\nQuite helpful.\r\n\r\nPlease visit https://actionleadgeneration.com to learn how Web Visitors Into Leads can support your business.\r\n\r\nYou can potentially connect with many more interested individuals as soon as possible.\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads provides a no-cost 14-day evaluation period. It also supports international communication. There are interested individuals ready to speak with you now, so please do not delay.\r\n\r\nPlease visit https://actionleadgeneration.com to explore Web Visitors Into Leads.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(183,'Eric','ericjonesmyemail@gmail.com','Strike when the iron’s hot','Hello Robmartinomusic Owner!\r\n\r\nMy name’s Eric and I just came across your website at Robmartinomusic...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nhttps://resultleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text (SMS) conversation with them.\r\n\r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when the iron’s hot!\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a complimentary 14-day trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://resultleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(184,'Eric','ericjonesmyemail@gmail.com','Your site – more leads?','Hello Robmartinomusic \r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, and I just found your site - Robmartinomusic - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n\r\nBut if you don’t mind me asking – after someone like me stumbles across Robmartinomusic, what usually happens?\r\n\r\nIs your site generating leads for your business?\r\n\r\nI’m guessing some, but I also bet you’d like more… research indicates that 7 out of 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s an idea…\r\n\r\nHow about making it really EASY for every visitor who shows up to get a personal phone call from you as soon as they hit your site…\r\n\r\nYou can –\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address and Phone Number. It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nhttps://boltleadgeneration.com to try out a Live Demo with LeadConnect now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus 30 minutes later could boost your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation.\r\n\r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just, how you doing? notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nhttps://boltleadgeneration.com to discover what LeadConnect can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: LeadConnect offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try LeadConnect now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(185,'Eric','ericjonesmyemail@gmail.com','Why not TALK with your leads?','Hello Robmartinomusic Owner,\r\n\r\nMy name’s Eric and I just found your site Robmartinomusic \r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nVisit https://resultleadgeneration.com for a live demo now.\r\n\r\nWeb Visitor is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nhttps://resultleadgeneration.com to try out a Live Demo with Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is simple, easy, and effective.\r\n\r\nhttps://resultleadgeneration.com to discover what Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them.\r\nWeb Visitor offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://resultleadgeneration.com to try Web Visitor now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://resultleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(186,'Jo','joannariggs02@gmail.com','Explainer Video for your website?','Hi,\r\n\r\nI just visited robmartinomusic.com and wondered if you\'d ever thought about having an engaging video to explain what you do, or to be used on social media as a promotional tool?\r\n\r\nOur prices start from just $195 USD.\r\n\r\nLet me know if you\'re interested in seeing samples of our previous work.\r\n\r\nRegards,\r\nJo'),(187,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello Robmartinomusic Administrator,\r\n\r\nThis is Eric here with a short thought about your website Robmartinomusic...\r\n\r\nI’m on the internet frequently and I examine many business websites.\r\n\r\nSimilar to yours, many of them have excellent content.\r\n\r\nBut frequently, they come up short when it comes to interacting and connecting with anyone who visits.\r\n\r\nI understand – it’s challenging. Studies show 7 out of 10 people who arrive at a site leave in moments without leaving any trace. You got the view, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software tool that operates on your site, ready to gather any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested and you can call them directly to talk with them while they’re still viewing your site.\r\n\r\nPlease see this URL to experience a Live Demo with Web Visitors Into Leads now to see exactly how it works:  \r\nhttps://trustedleadgeneration.com\r\n\r\nIt can be significant for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can immediately start a text conversation. Contacting someone within minutes is significantly more effective than reaching out much later.\r\n\r\nAdditionally, with text messaging you can follow up later with new information, helpful links, or just notes to continue the conversation.\r\n\r\nEverything I’ve just described is easy to implement, reasonable, and beneficial.\r\n\r\nPlease see this URL to learn what Web Visitors Into Leads can do for your business:  \r\nhttps://trustedleadgeneration.com\r\n\r\nYou could be converting significantly more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a 14-day evaluation – and it even includes International calling.  \r\nYou have customers ready to talk with you right now… don’t keep them waiting.  \r\nPlease see this URL to use Web Visitors Into Leads now:  \r\nhttps://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here.  https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(188,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello Robmartinomusic Owner!\r\n\r\nEric here with a quick thought about your website Robmartinomusic...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content.\r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard. Studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace. You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested, and you can call them directly to talk with them while they’re literally checking out Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation immediately… and contacting someone in that 5-minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging, you can follow up later with new offers, content links, even just follow-up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n\r\nhttps://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a complimentary 14-day trial – you could be converting up to 100x more leads immediately!  \r\nIt even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(189,'Eric','ericjonesmyemail@gmail.com','Turn Surf-Surf-Surf into Talk Talk Talk','Hi Robmartinomusic Owner!\r\n\r\nMy name’s Eric and I just ran across your website at Robmartinomusic...\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nhttps://boltleadgeneration.com for a live demo now.\r\n\r\nLeadConnect is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nhttps://boltleadgeneration.com to try out a Live Demo with LeadConnect now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n\r\nhttps://boltleadgeneration.com to discover what LeadConnect can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\n\r\nPS: LeadConnect offers a complimentary 14-day trial – and it even includes International Long Distance Calling.  \r\nYou have customers waiting to talk with you right now… don’t keep them waiting.  \r\nhttps://boltleadgeneration.com to try LeadConnect now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com\r\n'),(190,'Eric','ericjonesmyemail@gmail.com','Why not TALK with your leads?','Hello Robmartinomusic Administrator,\r\n\r\nMy name is Eric, and I just found your site Robmartinomusic. It’s got a lot to offer, but here’s a suggestion to make it even better.\r\n\r\nWeb Visitors Into Leads – see the live demo now:  \r\nhttps://trustedleadgeneration.com\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to gather any visitor’s Name, Email address, and Phone Number. It alerts you the moment they inform you they’re interested – so that you can talk to that lead while they’re actually browsing your site.\r\n\r\nOnce you’ve gathered their phone number, with our new SMS Text With Lead feature, you can promptly start a text conversation. Even if they don’t agree on your offer then, you can follow up with text messages for new offers, content links, or even just friendly notes to build a relationship.\r\n\r\nLearn what Web Visitors Into Leads can do for your business:  \r\nhttps://trustedleadgeneration.com\r\n\r\nThe difference between contacting someone within 5 minutes versus waiting longer means you can be converting significantly more leads now!\r\n\r\nEric  \r\nPS: Studies show that 70% of a site’s visitors leave and are gone for good after just a moment. Don’t keep missing out on them.  \r\nWeb Visitors Into Leads offers a complimentary 14-day trial – it even includes International calling.  \r\nYou have customers ready to talk with you right now… don’t keep them waiting.  \r\nTry Web Visitors Into Leads now:  \r\nhttps://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here. https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(191,'Eric','ericjonesmyemail@gmail.com','Why not TALK with your leads?','Hello Robmartinomusic Administrator,\r\n\r\nMy name is Eric, and I just found your site Robmartinomusic. It’s got a lot to offer, but here’s a suggestion to make it even better.\r\n\r\nWeb Visitors Into Leads – see the live demo now:  \r\nhttps://trustedleadgeneration.com\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to gather any visitor’s Name, Email address, and Phone Number. It alerts you the moment they inform you they’re interested – so that you can talk to that lead while they’re actually browsing your site.\r\n\r\nOnce you’ve gathered their phone number, with our new SMS Text With Lead feature, you can promptly start a text conversation. Even if they don’t agree on your offer then, you can follow up with text messages for new offers, content links, or even just friendly notes to build a relationship.\r\n\r\nLearn what Web Visitors Into Leads can do for your business:  \r\nhttps://trustedleadgeneration.com\r\n\r\nThe difference between contacting someone within 5 minutes versus waiting longer means you can be converting significantly more leads now!\r\n\r\nEric  \r\nPS: Studies show that 70% of a site’s visitors leave and are gone for good after just a moment. Don’t keep missing out on them.  \r\nWeb Visitors Into Leads offers a complimentary 14-day trial – it even includes International calling.  \r\nYou have customers ready to talk with you right now… don’t keep them waiting.  \r\nTry Web Visitors Into Leads now:  \r\nhttps://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here. https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(192,'Inge','inge.trugernanner54@gmail.com','Hello robmartinomusic.com Administrator!','Hello,\r\nWe’re looking to establish long-term cooperation. Please send us your offer and price list. Contact me via WhatsApp:\r\n+44 739 495 7438'),(193,'Eric','ericjonesmyemail@gmail.com','Cool website!','Hello to the Robmartinomusic Owner,\r\n\r\nMy name’s Eric, and I recently came across your site, Robmartinomusic, while browsing online. Your site showed up near the top of the search results, so whatever you’re doing for visibility seems effective.\r\n\r\nIf I may ask: after someone like me finds Robmartinomusic, what typically happens?\r\n\r\nIs your site generating valuable inquiries for your business?\r\n\r\nMany visitors view a website and then leave without taking the next step. Research suggests that a majority of visitors exit quickly, leaving no contact information.\r\n\r\nConsider this idea: What if there was a straightforward way for each visitor to indicate they’d like a call from you right when they arrive?\r\n\r\nYou can make this happen.\r\n\r\nWeb Visitor is a tool that works on your site, ready to securely gather a visitor’s name, email, and phone number. It alerts you immediately, so you can speak with that person while they are still viewing your site.\r\n\r\nPlease visit:  \r\nhttps://trustedleadgeneration.com  \r\nto see a live demonstration of Web Visitor and observe precisely how it works.\r\n\r\nActing promptly matters when it comes to building connections. The difference between engaging with someone within a few minutes, versus waiting longer, can be substantial.\r\n\r\nOur new SMS Text With Lead feature allows you to begin a text conversation as soon as you have their number. Even if they aren’t ready right now, you can keep in touch with updates, offers, and helpful information.\r\n\r\nPlease visit the link above to learn what Web Visitor can do for your business. You might be surprised at how much more interest you can capture.\r\n\r\nEric\r\n\r\nP.S. Web Visitor offers a 14-day evaluation period and includes the ability to reach out internationally. Interested individuals may be ready to speak with you now, so please don’t miss out.  \r\nhttps://trustedleadgeneration.com\r\n\r\nWant to receive less emails, or none whatsoever? Update your email preferences by clicking here. https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(194,'Eric','ericjonesmyemail@gmail.com','Try this, get more leads','Hello Robmartinomusic Owner!\r\n\r\nMy name is Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com for a live demo now.\r\n\r\nPlus, now that you’ve got their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nhttps://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://boltleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(195,'Eric','ericjonesmyemail@gmail.com','Why not TALK with your leads?','Hello to the Robmartinomusic Owner,\r\n\r\nI am Eric, and I recently discovered your site, Robmartinomusic.\r\n\r\nYour site has a great deal going for it, but I have an idea to help make it even more effective.\r\n\r\nPlease take a look at Web Visitors Into Leads – you can visit https://actionleadgeneration.com for a demonstration today.\r\n\r\nWeb Visitors Into Leads is a tool that operates on your site, prepared to gather each visitor’s name, email address, and phone number. It notifies you the instant they show interest, allowing you to speak with them while they are still viewing your site.\r\n\r\nOnce you have their phone number, you can begin an SMS conversation immediately. If they are not ready at that moment, you can follow up later with messages to share updates, information, or simply check in and maintain a connection.\r\n\r\nPlease visit https://actionleadgeneration.com to learn more about what Web Visitors Into Leads can do for your business.\r\n\r\nConnecting with someone promptly rather than waiting a long time can make a substantial difference in your results.\r\n\r\nEric\r\n\r\nP.S. Research indicates that many site visitors leave quickly without returning. Web Visitors Into Leads includes a 14-day no-cost trial and supports international communication. There may be individuals ready to engage with you right now, so please do not delay.\r\n\r\nPlease visit https://actionleadgeneration.com to learn more about Web Visitors Into Leads.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(196,'Terry','terryfowlerr83@gmail.com','Re: SEO consultant','Hello robmartinomusic.com,\r\n\r\nUse sustainable, white-hat tactics to gain 10 to 20 new clients who are eager for your services.\r\n\r\nI\'d be happy to share more details about our services and solutions if you\'re interested.\r\n\r\nWell wishes,\r\nTerry Fowler | Digital Marketing Manager\r\n\r\n\r\n\r\nNote: - If you’re not Interested in our Services, send us  \"opt-out\"'),(197,'Eric','ericjonesmyemail@gmail.com','Turn Surf-Surf-Surf into Talk Talk Talk','Hello Robmartinomusic Owner,\r\n\r\nThis is Eric and for just a second, imagine this:\r\n\r\n- Someone does a search and ends up at Robmartinomusic.\r\n- They hang out for a moment to check it out. I’m interested… but… maybe…\r\n- And then they click the back button and check out the other search results instead.\r\n- Bottom line – you got an eyeball, but nothing else.\r\n- They’re gone.\r\n\r\nThis isn’t really your fault – it happens a lot – studies show 7 out of 10 visitors to any site leave without leaving a trace.\r\n\r\nBut you can fix that.\r\n\r\nWeb Visitors Into Leads is a software that operates on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You will know instantly they’re interested and you can call them directly to chat with them - literally while they’re still on the internet looking at your site.\r\n\r\nPlease see this URL to test a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business: https://trustedleadgeneration.com\r\n\r\nTime is of the essence when it comes to connecting with leads – the difference between contacting someone within 5 minutes compared to 30 minutes later can be significant.\r\n\r\nMoreover, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation immediately… which is so effective, because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up frequently with new offers, content links, even just follow-up notes to develop a relationship.\r\n\r\nEverything I’ve just described is very easy to implement, cost-effective, and beneficial.\r\n\r\nPlease see this URL to discover what Web Visitors Into Leads can do for your business, possibly converting up to 100X more visitors into leads today: https://trustedleadgeneration.com\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a free 14-day trial – and it even includes International Long Distance Calling.\r\nYou have clients waiting to speak with you right now… don’t keep them waiting.\r\nPlease see this URL to try Web Visitors Into Leads now: https://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here. https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(203,'Mamie','jeffery.mamie@gmail.com','Unlock Lifetime Earnings with Our 35% Affiliate Program!','Hello,  \r\n\r\nThis is Mike Jeffery from Monkey Digital,  \r\nI am reaching out to discuss a exciting collaboration.  \r\n\r\nHow would you like to place our promotions on your website and link back via your custom referral link towards hot-selling services from our platform?  \r\n\r\nThis way, you make a recurring 35% residual income, every month from any purchases that are made from your website.  \r\n\r\nThink about it, all businesses need SEO, so this is a big opportunity.  \r\n\r\nWe already have 12k+ affiliates and our payments are paid out every month.  \r\nRecently, we reached a significant amount in commissions to our partners.  \r\n\r\nIf interested, kindly chat with us here:  \r\nhttps://monkeydigital.co/affiliates-whatsapp/  \r\n\r\nOr join us today:  \r\nhttps://www.monkeydigital.co/join-our-affiliate-program/  \r\n\r\nLooking forward,  \r\nMike Jeffery  \r\nMonkey Digital\r\nPhone/whatsapp: +1 (775) 314-7914'),(204,'Eric','ericjonesmyemail@gmail.com','Try this, get more leads','Hello Robmartinomusic Owner!\r\n\r\nMy name is Eric and I’m betting you’d like your website Robmartinomusic to generate more leads.\r\n\r\nHere’s how:\r\n\r\nWeb Visitors Into Leads is a software widget that works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at Robmartinomusic.\r\n\r\nhttps://boltleadgeneration.com for a live demo now.\r\n\r\nPlus, now that you’ve got their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nhttps://boltleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\n\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a complimentary 14-day trial – and it even includes International Long Distance Calling.\r\nYou have customers waiting to talk with you right now… don’t keep them waiting.\r\nhttps://boltleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://boltleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(205,'OscarSaurf','zekisuquc419@gmail.com','Hello  i am wrote about your the price','Ola, quería saber o seu prezo.'),(206,'Apple Inc. 2025. All rights reserved. Apple Inc. 2025. All rights reserved.\r\n 1337691 https://t.me/ grandbooksommer !','ex.p.a.n.s.e.uy.o.r.a.c.le7.1@gmail.com','Apple Inc. 2025. All rights reserved. Apple Inc. 2025. All rights reserved.\r\n 286767 https://t.me/ grandbooksommer !',''),(207,'Eric','ericjonesmyemail@gmail.com','Who needs eyeballs, you need BUSINESS','Hello to the Robmartinomusic Manager,\r\n\r\nI am Eric, and I recently discovered your website Robmartinomusic in the search results.\r\n\r\nYour site is visible online and the content is solid.\r\n\r\nHowever, there’s one area that may help improve results:\r\n\r\nWhen visitors arrive at Robmartinomusic, many may look around briefly, then leave without taking further action. Research suggests most visitors exit quickly, and you never learn who they were or how to reach them.\r\n\r\nYou can change that.\r\n\r\nConsider using Web Visitors Into Leads. This tool operates on your site and is ready to securely collect each visitor’s name, email, and phone number. It informs you right away when someone shows interest, so you can connect with them while they are still on your website.\r\n\r\nView a Demonstration https://actionleadgeneration.com\r\n\r\nPrompt and meaningful outreach can make a substantial difference. Additionally, once you have a visitor’s phone number, you can begin a friendly text conversation. Even if they aren’t ready at that moment, you can keep in touch over time with relevant updates and useful information.\r\n\r\nThis approach is easy to implement and can help you engage more effectively with interested individuals.\r\n\r\nVisit the link above to see what Web Visitors Into Leads can do for your business. By reaching out promptly, you may find that more visitors become engaged prospects.\r\n\r\nEric\r\n\r\nP.S. Web Visitors Into Leads includes an evaluation period and supports international communication. Interested individuals may be ready to speak with you now, so please don’t miss the opportunity.\r\n\r\nVisit the link https://actionleadgeneration.com to learn more.\r\n\r\nIf you\'d like to Want to receive fewer emails, or none whatsoever? Update your email preferences by visiting https://actionleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(208,'Jaime','info@hilkom-digital.com','Only a Few SEO Spots Left – Start Your Monthly Strategy Now','Hi,\r\n\r\nIf you’re ready to grow your search traffic, you need an ongoing SEO strategy.\r\n\r\nAt Hilkom Digital, we deliver results-driven growth through expert-led SEO strategies. Our monthly plans are crafted with care and designed for businesses that want actual growth — not just temporary wins.\r\n\r\nDue to high demand and our dedicated workflow, we can only accept a limited number of clients each month. This ensures every campaign gets the attention it deserves.\r\n\r\n______________\r\nYour SEO Plan Covers:\r\n•	Complete technical & content SEO\r\n•	DA50+ backlink building\r\n•	Smart keyword focus and tracking\r\n•	Toxic link cleanup & disavow file handling\r\n•	Paid indexing for faster rankings\r\n•	Multilingual SEO support (DE, ES, FR, EN)\r\n______________\r\n\r\nSpots are limited — secure your monthly SEO plan now:\r\nhttps://www.hilkom-digital.com/seo-services/\r\n\r\nNeed more info? Chat with an SEO expert here:\r\nhttps://www.hilkom-digital.com/whatsapp-us/\r\n\r\nLet’s boost your digital presence, bring leads, and elevate your brand — the smart way.\r\n\r\nBest regards,\r\nMike Ehmann\r\nHilkom Digital\r\nPhone/WhatsApp: +1 (855) 221-7591\r\nsupport@hilkom-digital.com'),(209,'Eric','ericjonesmyemail@gmail.com','Turn Surf-Surf-Surf into Talk Talk Talk','Hello Robmartinomusic Owner,\r\n\r\nThis is Eric and for just a second, imagine this:\r\n\r\n- Someone does a search and ends up at Robmartinomusic.\r\n- They hang out for a moment to check it out. I’m interested… but… maybe…\r\n- And then they click the back button and check out the other search results instead.\r\n- Bottom line – you got an eyeball, but nothing else.\r\n- They’re gone.\r\n\r\nThis isn’t really your fault – it happens a lot – studies show 7 out of 10 visitors to any site leave without leaving a trace.\r\n\r\nBut you can fix that.\r\n\r\nWeb Visitors Into Leads is a software that operates on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You will know instantly they’re interested and you can call them directly to chat with them - literally while they’re still on the internet looking at your site.\r\n\r\nPlease see this URL to test a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business: https://trustedleadgeneration.com\r\n\r\nTime is of the essence when it comes to connecting with leads – the difference between contacting someone within 5 minutes compared to 30 minutes later can be significant.\r\n\r\nMoreover, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation immediately… which is so effective, because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up frequently with new offers, content links, even just follow-up notes to develop a relationship.\r\n\r\nEverything I’ve just described is very easy to implement, cost-effective, and beneficial.\r\n\r\nPlease see this URL to discover what Web Visitors Into Leads can do for your business, possibly converting up to 100X more visitors into leads today: https://trustedleadgeneration.com\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a free 14-day trial – and it even includes International Long Distance Calling.\r\nYou have clients waiting to speak with you right now… don’t keep them waiting.\r\nPlease see this URL to try Web Visitors Into Leads now: https://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here. https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(210,'LeeSaurf','zekisuquc419@gmail.com','Hi,   wrote about your   price for reseller','Hi, I wanted to know your price.'),(211,'Eric','ericjonesmyemail@gmail.com','how to turn eyeballs into phone calls','Hello Robmartinomusic Administrator,\r\n\r\nThis is Eric here with a short thought about your website Robmartinomusic...\r\n\r\nI’m on the internet frequently and I examine many business websites.\r\n\r\nSimilar to yours, many of them have excellent content.\r\n\r\nBut frequently, they come up short when it comes to interacting and connecting with anyone who visits.\r\n\r\nI understand – it’s challenging. Studies show 7 out of 10 people who arrive at a site leave in moments without leaving any trace. You got the view, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software tool that operates on your site, ready to gather any visitor’s Name, Email address, and Phone Number. You’ll know immediately they’re interested and you can call them directly to talk with them while they’re still viewing your site.\r\n\r\nPlease see this URL to experience a Live Demo with Web Visitors Into Leads now to see exactly how it works:  \r\nhttps://trustedleadgeneration.com\r\n\r\nIt can be significant for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can immediately start a text conversation. Contacting someone within minutes is significantly more effective than reaching out much later.\r\n\r\nAdditionally, with text messaging you can follow up later with new information, helpful links, or just notes to continue the conversation.\r\n\r\nEverything I’ve just described is easy to implement, reasonable, and beneficial.\r\n\r\nPlease see this URL to learn what Web Visitors Into Leads can do for your business:  \r\nhttps://trustedleadgeneration.com\r\n\r\nYou could be converting significantly more leads today!\r\n\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a 14-day evaluation – and it even includes International calling.  \r\nYou have customers ready to talk with you right now… don’t keep them waiting.  \r\nPlease see this URL to use Web Visitors Into Leads now:  \r\nhttps://trustedleadgeneration.com\r\n\r\nIf you\'d like to Want to receive less emails, or none whatsoever? Update your email preferences by clicking here.  https://trustedleadgeneration.com/unsubscribe.aspx?d=robmartinomusic.com'),(212,'SantehnikaPhedo','santehnikagrodno.v.ip@gmail.com','How do I choose the perfect pump for your home?','When it comes to pumps, it\'s easy to forget how important their contribution to everyday life is. They don\'t just move water — they do it efficiently, saving you resources and time. For summer residents who have their own plots, a pump can be a real salvation when watering, while owners of private homes will appreciate the opportunity to avoid unpleasant situations associated with flooding.\"\"Imagine that you can rest easy knowing that the pump will take care of your irrigation or drainage system. It really creates an extra level of peace in your life. Absolutely, [url=][color=#1C1C1C]pumps for home[/color][/url] should be at the top of the list of desired improvements if you want your home to be cozy and safe.'),(213,'Tanya Wolfe','twolfe166@hotmail.com','Website text concern','Hi,\r\n\r\nSpotted \"Rob\" on your website-- maybe it\'s a typo? I usually check these quickly using spellpros.com.\r\n\r\nCheers,\r\nTanya'),(214,'Jess','jessicalangdon240@gmail.com','Youtube Promotion: Grow your subscribers by 700 each month','Hi there,\r\n\r\nWe run a YouTube growth service, which increases your number of subscribers both safely and practically.\r\n\r\n- Gain 700-1500+ real, human subscribers who subscribe because they are interested in your channel/videos. \r\n- All actions are made manually by our team. We do not use any \'bots\'.\r\n- Channel Creation: If you haven\'t started your YouTube journey yet, we can create a professional channel for you as part of your initial order.\r\n\r\nThe price is just $60 (USD) per month, and we can start immediately.\r\n\r\nOur website is: https://furtherinfo.info/youtube\r\n\r\nKind regards,\r\nJess');
/*!40000 ALTER TABLE `freeform_submissions_contact_form_1` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_survey_preferences`
--

LOCK TABLES `freeform_survey_preferences` WRITE;
/*!40000 ALTER TABLE `freeform_survey_preferences` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_survey_preferences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `freeform_unfinalized_files`
--

LOCK TABLES `freeform_unfinalized_files` WRITE;
/*!40000 ALTER TABLE `freeform_unfinalized_files` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `freeform_unfinalized_files` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `globalsets`
--

LOCK TABLES `globalsets` WRITE;
/*!40000 ALTER TABLE `globalsets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `globalsets` VALUES (2,'Site Settings','siteSettings',10,1,'2023-06-11 22:50:16','2024-12-23 16:39:51','4fa68a9e-b36c-4280-b726-dfd06429714e'),(82,'Navigation Settings','navigationSettings',24,2,'2024-12-23 16:39:52','2024-12-23 16:39:52','4b1a0293-717c-4678-95cd-9432e1a591c6');
/*!40000 ALTER TABLE `globalsets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqlschemas`
--

LOCK TABLES `gqlschemas` WRITE;
/*!40000 ALTER TABLE `gqlschemas` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqlschemas` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqltokens`
--

LOCK TABLES `gqltokens` WRITE;
/*!40000 ALTER TABLE `gqltokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqltokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `imagetransforms`
--

LOCK TABLES `imagetransforms` WRITE;
/*!40000 ALTER TABLE `imagetransforms` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `imagetransforms` VALUES (1,'Thumbnail Square','thumbnailSquare','crop','center-center',250,250,'webp',60,'none',NULL,1,'2024-12-23 16:46:54','2024-12-23 16:39:53','2024-12-23 16:46:54','13e2d803-deff-4738-8c27-89c2d4424df7'),(2,'Large Width','largewidth','crop','center-center',800,NULL,'webp',100,'none',NULL,1,'2024-12-23 16:46:54','2024-12-23 16:39:53','2024-12-23 16:46:54','2615e6d4-c149-4539-851e-556e8843ba5f');
/*!40000 ALTER TABLE `imagetransforms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `info`
--

LOCK TABLES `info` WRITE;
/*!40000 ALTER TABLE `info` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `info` VALUES (1,'5.7.4','5.7.0.3',0,'orvosehzbvwu','3@zcqctrayfu','2023-06-11 22:50:08','2025-05-02 16:26:03','7bab98a6-ec04-44d4-9af9-e0dff0f28fb8');
/*!40000 ALTER TABLE `info` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `migrations` VALUES (1,'craft','Install','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','e6496df1-2457-4b44-b1a2-8c943f4ab606'),(2,'craft','m210121_145800_asset_indexing_changes','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','d35ca70d-a03e-4db9-ba25-fd2ff4f07031'),(3,'craft','m210624_222934_drop_deprecated_tables','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','87ab561b-4207-4232-a567-f4213d8d0735'),(4,'craft','m210724_180756_rename_source_cols','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','4e4039aa-6822-40ed-8a52-572fffc27963'),(5,'craft','m210809_124211_remove_superfluous_uids','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','6e811cba-1f8c-409b-b163-b5363341fd97'),(6,'craft','m210817_014201_universal_users','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','ffe5ca4f-bd6d-48ed-86e6-bc2c9360ee00'),(7,'craft','m210904_132612_store_element_source_settings_in_project_config','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','37120a12-f1db-49b0-947b-b98ea7e89fc9'),(8,'craft','m211115_135500_image_transformers','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','b4a774e0-e8b9-41bb-aaff-82b11e7327f8'),(9,'craft','m211201_131000_filesystems','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','5d15ac19-2550-49da-b22a-59242ddea22d'),(10,'craft','m220103_043103_tab_conditions','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','2f5f3b7c-06f6-4a2d-8a03-d599cb650eda'),(11,'craft','m220104_003433_asset_alt_text','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','74937d73-ecc2-4bdc-9c3f-404370ad2686'),(12,'craft','m220123_213619_update_permissions','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','464546d3-23ea-4082-a27c-fd77fe7175be'),(13,'craft','m220126_003432_addresses','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','c1377c31-518c-4236-919a-fa23deb969e3'),(14,'craft','m220209_095604_add_indexes','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','90b23be4-5789-41a4-8885-a18b1710b9d8'),(15,'craft','m220213_015220_matrixblocks_owners_table','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','6a8e57bd-a265-44b4-b038-dd0cf2d7e464'),(16,'craft','m220214_000000_truncate_sessions','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','2a6ae5bd-5a7c-463d-8a69-7c3f4ce8041a'),(17,'craft','m220222_122159_full_names','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','87da3a8e-3cc7-4991-80f1-620e1e258a8b'),(18,'craft','m220223_180559_nullable_address_owner','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','96da61b2-5d9b-4b9e-92e7-03b4a4c27d30'),(19,'craft','m220225_165000_transform_filesystems','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','6745d69a-585f-4d82-b606-ea702fdaa214'),(20,'craft','m220309_152006_rename_field_layout_elements','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','171f1d27-7403-411b-b6e4-f2c3ca8d3d18'),(21,'craft','m220314_211928_field_layout_element_uids','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','1610e337-6fb1-4b97-86cf-52991547db72'),(22,'craft','m220316_123800_transform_fs_subpath','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','410725ee-ffe8-43a8-8d16-0583feb104a3'),(23,'craft','m220317_174250_release_all_jobs','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','022d65fe-1a44-4d75-8cf3-dba3ca178821'),(24,'craft','m220330_150000_add_site_gql_schema_components','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','c798f803-3bd2-4f55-af98-aefa6cfb1c76'),(25,'craft','m220413_024536_site_enabled_string','2023-06-11 22:50:20','2023-06-11 22:50:20','2023-06-11 22:50:20','914e0178-a88c-4a39-bca0-fe12de266a47'),(26,'craft','m221027_160703_add_image_transform_fill','2023-11-10 04:19:31','2023-11-10 04:19:31','2023-11-10 04:19:31','b7e5dcc1-89fb-4eee-b16a-6c6a0ed24d7f'),(27,'craft','m221028_130548_add_canonical_id_index','2023-11-10 04:19:31','2023-11-10 04:19:31','2023-11-10 04:19:31','f66531f5-401b-46ce-8ed9-4279cb62c18b'),(28,'craft','m221118_003031_drop_element_fks','2023-11-10 04:19:32','2023-11-10 04:19:32','2023-11-10 04:19:32','70925e40-14a7-41c2-8858-585f1cb605ff'),(29,'craft','m230131_120713_asset_indexing_session_new_options','2023-11-10 04:19:32','2023-11-10 04:19:32','2023-11-10 04:19:32','c0362dde-5322-4901-b5d8-10aef405cec9'),(30,'craft','m230226_013114_drop_plugin_license_columns','2023-11-10 04:19:32','2023-11-10 04:19:32','2023-11-10 04:19:32','434600ca-1686-4bce-b272-5c05e9c32e84'),(31,'craft','m230531_123004_add_entry_type_show_status_field','2023-11-10 04:19:32','2023-11-10 04:19:32','2023-11-10 04:19:32','0eab53e3-7b7b-4008-8983-70305847324b'),(32,'craft','m230607_102049_add_entrytype_slug_translation_columns','2023-11-10 04:19:32','2023-11-10 04:19:32','2023-11-10 04:19:32','cd7845eb-321d-464b-83c5-398d374412a9'),(33,'craft','m230710_162700_element_activity','2023-11-10 04:19:32','2023-11-10 04:19:32','2023-11-10 04:19:32','07b42165-4800-4dda-bbe4-d70c3c74df64'),(34,'craft','m230820_162023_fix_cache_id_type','2023-11-10 04:19:33','2023-11-10 04:19:33','2023-11-10 04:19:33','548d23c0-7eb6-4625-a895-f0b05e89d963'),(35,'craft','m230826_094050_fix_session_id_type','2023-11-10 04:19:33','2023-11-10 04:19:33','2023-11-10 04:19:33','92cd7979-6a4e-43c5-ac91-fae88c49e872'),(36,'craft','m221101_115859_create_entries_authors_table','2024-12-23 16:29:06','2024-12-23 16:29:06','2024-12-23 16:29:06','a0446bfb-600e-4589-b0e8-e86e04644bcc'),(37,'craft','m221107_112121_add_max_authors_to_sections','2024-12-23 16:29:06','2024-12-23 16:29:06','2024-12-23 16:29:06','afa8d7d0-30e3-4140-9d00-e02358ba3f7d'),(38,'craft','m221205_082005_translatable_asset_alt_text','2024-12-23 16:29:06','2024-12-23 16:29:06','2024-12-23 16:29:06','1b658728-4be7-44d2-99d8-bb845d4899a0'),(39,'craft','m230314_110309_add_authenticator_table','2024-12-23 16:29:06','2024-12-23 16:29:06','2024-12-23 16:29:06','5f0a643f-27f2-4d0a-a4b2-31d2b63cbe82'),(40,'craft','m230314_111234_add_webauthn_table','2024-12-23 16:29:06','2024-12-23 16:29:06','2024-12-23 16:29:06','9dc1118b-f954-4988-b939-eefcafcff6c5'),(41,'craft','m230503_120303_add_recoverycodes_table','2024-12-23 16:29:07','2024-12-23 16:29:07','2024-12-23 16:29:07','7689098b-dc41-4a89-a037-52c2b34ae9f6'),(42,'craft','m230511_000000_field_layout_configs','2024-12-23 16:29:07','2024-12-23 16:29:07','2024-12-23 16:29:07','b22f3a7c-02be-4bb8-9b2a-923fced09efc'),(43,'craft','m230511_215903_content_refactor','2024-12-23 16:29:08','2024-12-23 16:29:08','2024-12-23 16:29:08','f3dbb692-f60d-462e-9a19-a45c1b17a613'),(44,'craft','m230524_000000_add_entry_type_show_slug_field','2024-12-23 16:29:08','2024-12-23 16:29:08','2024-12-23 16:29:08','aec38af8-a637-4eb6-afdc-ea4fe4ed4ca2'),(45,'craft','m230524_000001_entry_type_icons','2024-12-23 16:29:08','2024-12-23 16:29:08','2024-12-23 16:29:08','64f576b2-c158-4ebe-ae76-7ad359851006'),(46,'craft','m230524_000002_entry_type_colors','2024-12-23 16:29:08','2024-12-23 16:29:08','2024-12-23 16:29:08','1afc63eb-c4c0-471b-bb11-09ac85d0bb98'),(47,'craft','m230524_220029_global_entry_types','2024-12-23 16:29:09','2024-12-23 16:29:09','2024-12-23 16:29:09','0f76e1ba-69bb-4a7a-b169-cb39da641708'),(48,'craft','m230616_173810_kill_field_groups','2024-12-23 16:29:09','2024-12-23 16:29:09','2024-12-23 16:29:09','78285480-33b9-44c5-82a9-c5695d248c6c'),(49,'craft','m230616_183820_remove_field_name_limit','2024-12-23 16:29:10','2024-12-23 16:29:10','2024-12-23 16:29:10','9ad2e4a5-027c-4b70-a272-eb806847ccac'),(50,'craft','m230617_070415_entrify_matrix_blocks','2024-12-23 16:29:11','2024-12-23 16:29:11','2024-12-23 16:29:11','2295ef5a-b9c8-4fee-9cc9-1c6d49c6be78'),(51,'craft','m230904_190356_address_fields','2024-12-23 16:29:11','2024-12-23 16:29:11','2024-12-23 16:29:11','3b55f114-c470-4b13-bb57-aac618be3ffd'),(52,'craft','m230928_144045_add_subpath_to_volumes','2024-12-23 16:29:11','2024-12-23 16:29:11','2024-12-23 16:29:11','ed225c55-53b1-4c48-b9f5-7538eefbbde3'),(53,'craft','m231013_185640_changedfields_amend_primary_key','2024-12-23 16:29:11','2024-12-23 16:29:11','2024-12-23 16:29:11','aacdd6ca-57dc-4fa0-b937-6c4d78712acc'),(54,'craft','m231213_030600_element_bulk_ops','2024-12-23 16:29:11','2024-12-23 16:29:11','2024-12-23 16:29:11','fc739812-f26e-4f3b-9ca3-2484b01a05e1'),(55,'craft','m240129_150719_sites_language_amend_length','2024-12-23 16:29:11','2024-12-23 16:29:11','2024-12-23 16:29:11','388aa63f-790d-47bf-b7be-3f6a1af5e102'),(56,'craft','m240206_035135_convert_json_columns','2024-12-23 16:29:12','2024-12-23 16:29:12','2024-12-23 16:29:12','17208555-c653-4ba5-98ed-a6117be6bf6a'),(57,'craft','m240207_182452_address_line_3','2024-12-23 16:29:12','2024-12-23 16:29:12','2024-12-23 16:29:12','127b8de2-f1ea-448d-9333-7160c19be774'),(58,'craft','m240302_212719_solo_preview_targets','2024-12-23 16:29:12','2024-12-23 16:29:12','2024-12-23 16:29:12','57c43124-7178-4efa-9439-f706d2f42831'),(59,'craft','m240619_091352_add_auth_2fa_timestamp','2024-12-23 16:29:12','2024-12-23 16:29:12','2024-12-23 16:29:12','b5869e39-eff9-4361-9861-3a0d5645c43b'),(60,'craft','m240723_214330_drop_bulkop_fk','2024-12-23 16:29:12','2024-12-23 16:29:12','2024-12-23 16:29:12','2020c860-24b0-4bfb-881d-b5a6ded3d194'),(61,'craft','m240731_053543_soft_delete_fields','2024-12-23 16:29:12','2024-12-23 16:29:12','2024-12-23 16:29:12','a77ec681-7439-41f6-ba10-be1ae8ac18a4'),(62,'craft','m240805_154041_sso_identities','2024-12-23 16:29:13','2024-12-23 16:29:13','2024-12-23 16:29:13','a94649c2-d39b-4247-9614-87a1c2fbe53d'),(63,'craft','m240926_202248_track_entries_deleted_with_section','2024-12-23 16:29:13','2024-12-23 16:29:13','2024-12-23 16:29:13','8cf3935d-36b7-4f3f-8f30-3552e1c76e5b'),(64,'plugin:ckeditor','Install','2024-12-23 16:39:40','2024-12-23 16:39:40','2024-12-23 16:39:40','6c1ac76f-bafb-4b22-9426-cc28b0f1d2c7'),(65,'plugin:ckeditor','m230408_163704_v3_upgrade','2024-12-23 16:39:40','2024-12-23 16:39:40','2024-12-23 16:39:40','2a5e8ace-f778-4714-ae63-57a9718dfa1f'),(66,'plugin:freeform','Install','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','59a31f5e-4cb4-45c4-86eb-e939bd667497'),(67,'plugin:freeform','m180120_140521_CraftUpgrade','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','79e453b2-6bc3-48ef-8635-5143d9aad2f7'),(68,'plugin:freeform','m180125_124339_UpdateForeignKeyNames','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','704ff8b3-f78c-483e-a967-750431a39d7d'),(69,'plugin:freeform','m180214_094247_AddUniqueTokenToSubmissionsAndForms','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','89e4cef4-6a20-4735-be10-e633b86449a0'),(70,'plugin:freeform','m180220_072652_ChangeFileUploadFieldColumnType','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','4df875b4-dda2-42f0-9169-d8c27b1a86b3'),(71,'plugin:freeform','m180326_094124_AddIsSpamToSubmissions','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','eb479595-4f2a-4760-b0c3-db0734c532ac'),(72,'plugin:freeform','m180405_101920_AddIpAddressToSubmissions','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','ebff797c-dafb-4728-b3e2-e208b4c4eb5b'),(73,'plugin:freeform','m180410_131206_CreateIntegrationsQueue','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','12526534-fea5-47ba-9bcb-958218c7f497'),(74,'plugin:freeform','m180417_134527_AddMultipleSelectTypeToFields','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','52821070-9008-426d-b6b2-e182208a4c45'),(75,'plugin:freeform','m180430_151626_PaymentGateways','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','e07c37d2-0500-488f-a2c0-dbb25212cb82'),(76,'plugin:freeform','m180508_095131_CreatePaymentGatewayFieldsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','1a167167-f494-4385-aef1-7095e90f067e'),(77,'plugin:freeform','m180606_141402_AddConnectionsToFormProperties','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','8fe32e1b-7330-4364-9678-cc07b7940122'),(78,'plugin:freeform','m180730_171628_AddCcDetailsFieldType','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','3c14bb35-988d-43b2-847a-dd63aa46317e'),(79,'plugin:freeform','m180817_091801_AddRulesToFormProperties','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','a03242b9-f593-4c8a-9ba7-ce2d8b532938'),(80,'plugin:freeform','m181112_152751_ChangeTypeEnumColumnsToIndexedText','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2ce28964-eda3-4e8b-aa1e-8d092e24721b'),(81,'plugin:freeform','m181129_083939_ChangeIntegrationFieldTypeColumnTypeToString','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2fcad01f-6960-4297-b7f9-0829fd8592ca'),(82,'plugin:freeform','m190501_124050_MergingEditionsMigration','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','7b3e875b-1235-4835-b2ee-4057c1df5356'),(83,'plugin:freeform','m190502_155557_AddCCAndBCCToEmailNotifications','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','d1fd84b3-cc4d-4045-a8f3-7b1b75bcb0c0'),(84,'plugin:freeform','m190516_085150_AddPresetAssetsToNotifications','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2e5de101-b05c-41cf-bc5a-bb38564ca0ee'),(85,'plugin:freeform','m190529_135307_AddWebhookTables','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','73b85bb6-2c02-43f5-8709-1c16f57c391a'),(86,'plugin:freeform','m190604_125112_AddFormLimitSubmissionProperty','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2a5f7d6f-4f9a-4edf-b7ad-ee68bb2fa445'),(87,'plugin:freeform','m190610_074840_MigrateScriptInsertLocation','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','b52562a7-9313-48fa-b96a-9732d1013875'),(88,'plugin:freeform','m190614_103420_AddMissingMetaColumnsToProAndPaymentTables','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','7c42bda8-fcf2-4168-9134-55c1de807de3'),(89,'plugin:freeform','m190617_122427_RemoveBrokenForeignKeys','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2f15123f-ebfd-4352-ae8c-752b157492a8'),(90,'plugin:freeform','m190618_142759_AddFixedForeignKeys','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','0fb61cc1-fc48-4b63-b2b8-6debdf2c6fc3'),(91,'plugin:freeform','m190812_125059_AddNotesTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','b23d9d3f-d1a8-49c8-8001-92b81ecde3f9'),(92,'plugin:freeform','m190905_113428_FixIntervalCountNotNullColumn','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','3f766914-112d-438f-933e-601a7856e23f'),(93,'plugin:freeform','m191214_093453_AddExtraPostUrlColumnToForm','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','3488ba5c-1300-443f-b565-4b8c117c6776'),(94,'plugin:freeform','m200203_180318_AddSpamReasonTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','56d982ea-ebb8-4207-91ad-93a625ceb255'),(95,'plugin:freeform','m200214_083115_FixIntegrationQueueIndex','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','3dfa2bb9-7f85-4396-9a99-545dac09e2a8'),(96,'plugin:freeform','m200616_143808_FormPermissionsUpdate','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','87cb5090-c15e-44e8-a4bf-5249ebad11cf'),(97,'plugin:freeform','m200630_103347_IncreaseExportProfileSettingSize','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','70821ab4-3bbf-4205-8b1e-fd347551c5b2'),(98,'plugin:freeform','m200825_124009_SplitPipedriveIntegrationIntoDealsAndLeads','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','59edef2c-c6c5-493e-9946-043527efb5f1'),(99,'plugin:freeform','m200907_081059_AddValidationToFormProperties','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','fe587b6b-4c43-40f1-85c4-34433e32075f'),(100,'plugin:freeform','m200911_130215_AddReplyToNameToNotifications','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','5800f9fa-b53d-4719-92ff-a1ac901cefb0'),(101,'plugin:freeform','m201006_065315_AddFeedTables','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','146a3315-13c2-49d4-a10a-00131c9a773c'),(102,'plugin:freeform','m201014_161213_AddFormSortOrder','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','06d88471-784f-4379-a65f-33b02b157432'),(103,'plugin:freeform','m201027_103933_AddExportProfileDateRanges','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','c2a36737-ca35-4e3d-b080-09e6194206bb'),(104,'plugin:freeform','m201209_162655_AddAutoTextColumnToNotifications','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','084ed2fc-29a2-45fe-af03-ae569edee39f'),(105,'plugin:freeform','m210105_145259_AddGoogleTagManagerColumnsToForms','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','c511f9f5-6759-4fc7-80a7-c0643b21c1e1'),(106,'plugin:freeform','m210527_071651_AddDbSessionStorage','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','5a4fb4d9-5e5a-410d-8bfc-6fefae82f248'),(107,'plugin:freeform','m210609_183655_AddContextToUnfinalizedFiles','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','6e19680c-b7ba-48de-9a00-9a668c39f762'),(108,'plugin:freeform','m210629_172132_AddDateIndexToLockTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','f37a703e-6825-4551-8db7-c92ea2e58b37'),(109,'plugin:freeform','m210923_110033_AddSavedFormsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','620e37f4-adff-48af-99d3-0f32fee31987'),(110,'plugin:freeform','m211109_144235_RemoveContextFromUnfinalizedAssets','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','665f39bc-b66f-4b4a-b207-ec5aa024c925'),(111,'plugin:freeform','m211227_140312_AddFormTypes','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','eb41e17c-a254-4605-bc78-4b431058419f'),(112,'plugin:freeform','m220121_091429_AddUserIdToSubmissions','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','9545d22c-6302-471a-9414-fb6bd610fc43'),(113,'plugin:freeform','m220304_101448_ChangeAccessTokenColumnType','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','b6a7f85a-498d-4316-9319-c8eb45cb0888'),(114,'plugin:freeform','m220316_060248_SwitchFormSuccessBehaviourToRedirectReturnUrl','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','cd7b306f-b3b5-47ce-90b4-7b078ad1103e'),(115,'plugin:freeform','m220322_070819_RenameFormattingTemplates','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','03741aac-c24f-47a7-8e63-df6fd89398e5'),(116,'plugin:freeform','m220323_113852_MigrateEmailValuesToString','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','54b0ab06-e00e-4566-8213-a34400c07e5d'),(117,'plugin:freeform','m220330_111857_SplitSubmissionsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','9d14f174-f06f-4dfa-a7c5-e965acfa7b4d'),(118,'plugin:freeform','m220422_065929_AddExportNotificationsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','0cb11d4f-f5c9-4de2-b99b-1f40c3978465'),(119,'plugin:freeform','m220527_055207_ExpandIntegrationAccessTokenSize','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','79f5aee7-88dd-4998-be28-18103d07f37c'),(120,'plugin:freeform','m220530_052327_MigrateFormContentTableNamesToSnakeCase','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','248ccbc0-4e1e-4e80-ad43-bafe84c6e746'),(121,'plugin:freeform','m230101_100000_ConvertJsonToLongTextColumns','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','b6f79a2c-a418-443d-8472-436f632ed933'),(122,'plugin:freeform','m230101_100010_FF4to5_MigrateForms','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','9e394495-0d64-49cb-aebe-882e3f3ea30c'),(123,'plugin:freeform','m230101_100020_FF4to5_MigrateLayout','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','db58a097-9e02-4e05-bac5-d961f2986d3e'),(124,'plugin:freeform','m230101_100030_FF4to5_MigrateNotifications','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2bd060ca-804e-4003-8673-8fcd099f2e8c'),(125,'plugin:freeform','m230101_100050_FF4to5_MigrateIntegrations','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','c90208a0-6f77-47d8-8015-26bfdcdaf5f1'),(126,'plugin:freeform','m230101_100060_FF4to5_MigrateConditionalRules','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','b6003473-caef-413d-9339-fb446f83499d'),(127,'plugin:freeform','m230101_200000_FF4to5_MigrateData','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','8860d092-e1ae-49f8-967d-068ec7c1b91d'),(128,'plugin:freeform','m230101_300100_FF4RemoveOldTables','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','ae85a303-11e9-4946-bb27-d634792f4d82'),(129,'plugin:freeform','m230224_141036_RemoveRedundantFieldsFromIntegrationsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','dcf73bbf-d586-4bd2-a9a0-cb7d63b8001d'),(130,'plugin:freeform','m230224_141037_RenameIntegrationTableColumns','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','dd1d8100-faf3-48d5-a1f8-483171ed692b'),(131,'plugin:freeform','m230227_102619_MoveCRMIntegrationClasses','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','893005af-e8d0-43f9-a779-e35a6c80826a'),(132,'plugin:freeform','m230301_124411_MoveMailingListIntegrationClasses','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','4d9ed6c5-8b17-4fc9-bb99-cb8a2a9389f4'),(133,'plugin:freeform','m230424_010101_announcement_4_0_23','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','5266ac7e-6887-4f4d-8f07-f46f39eda87a'),(134,'plugin:freeform','m230516_010101_announcement_4_0_24','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','257f6a6a-201b-4acb-91a7-e526c6395bb7'),(135,'plugin:freeform','m230613_010101_announcement_4_1_0','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','c8e394a2-3e4b-4837-9f8b-30454abc7d49'),(136,'plugin:freeform','m230712_120518_RemoveIntegrationsQueueMailingListFieldIndex','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2596a76a-adbc-40ca-b5ab-ffd7cf4b9b9c'),(137,'plugin:freeform','m230725_124256_AddCategoryToCrmFields','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','9b79137a-20b6-4ec5-b1fd-afbc658449af'),(138,'plugin:freeform','m230809_081815_AddCategoryToMailingListFields','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','5748a489-7bfb-4521-b446-9c7f7b1aaa64'),(139,'plugin:freeform','m230824_111101_ChangeMailingListsToEmailMarketing','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','834fcb6b-979a-4e82-b68f-d0da45ca881e'),(140,'plugin:freeform','m230824_163145_RemoveWebhooksTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','03fa9de4-3a34-4a3f-9c03-fb600f89ce96'),(141,'plugin:freeform','m230901_143430_ChangeLabelFieldColumnType','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','1043a9e5-1457-400e-a012-bed286e5f51d'),(142,'plugin:freeform','m230920_103014_RemoveLastUpdateFromIntegrations','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','da6183b2-41fc-4565-9253-47edf34c5be9'),(143,'plugin:freeform','m230925_162351_AddEnabledToIntegrations','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','0f73a80f-ae93-4b90-908e-d6874e4f5985'),(144,'plugin:freeform','m231020_115409_MigrateIntegrationNamespaces','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','fb7cf1f3-b514-4308-b2d4-eca62d07b472'),(145,'plugin:freeform','m231116_104621_AlterPaymentTables','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','b39e544b-c2ee-4df5-acb3-725f3a07e5df'),(146,'plugin:freeform','m231128_142144_AddLinkToPaymentsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','9251e615-9ba8-4ce4-b03b-3707090c9dda'),(147,'plugin:freeform','m231206_132139_RemoveLockTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','94627f2b-c0b0-4790-ab70-b28b95c0b964'),(148,'plugin:freeform','m231219_105754_AddUsersToFormsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','e0c65aad-6bc7-4a71-9d01-94ac1153d5ad'),(149,'plugin:freeform','m231229_155623_CreateSurveysPreferencesTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','5d4862b2-b829-489f-bedd-507811c9b5a9'),(150,'plugin:freeform','m231230_074448_CreateFieldsTypeGroupsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','28a7b693-5d8a-4f0f-aa31-949e951abb43'),(151,'plugin:freeform','m240109_142124_UpdatePageButtonMetadata','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','6955f93a-72ff-4797-be81-b80422e9a3b9'),(152,'plugin:freeform','m240110_111258_ChangeFormFieldRowForeignKey','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2b31b591-e09f-42d0-9d6d-a448497c0389'),(153,'plugin:freeform','m240111_162954_RemoveStatisticsWidgetFromWidgetsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','4dca78ca-f31b-4d99-8437-1b3c3ce43b22'),(154,'plugin:freeform','m240315_100655_UserIntegrationMultiGroupChoice','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','8a0e238e-e1ce-4972-8ae3-ea59dc8f1c7b'),(155,'plugin:freeform','m240405_151009_MigrateEntryIntegrations','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','f45bdbcb-42cc-4ac9-b892-e72560d66f2c'),(156,'plugin:freeform','m240415_150746_CreateSubmitFormRuleTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','60e51d7c-2524-473e-a659-cb570e4fca5c'),(157,'plugin:freeform','m240425_062916_CreateButtonRuleTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','10ac446b-b70a-4831-8755-2ac30c0f5ff7'),(158,'plugin:freeform','m240429_120039_CreateFormSitesMapTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','610897e5-5392-448d-bffe-698b147a6917'),(159,'plugin:freeform','m240501_091330_AddHiddenFieldToGroupsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','6bd537f5-cf7c-4b59-af46-12b0f9fde390'),(160,'plugin:freeform','m240507_073204_DropStatusDefaultColumn','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','7d0decd3-5e93-460a-840a-75e2b480dea1'),(161,'plugin:freeform','m240521_110910_CreateLimitedUsersTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','db76c7eb-3753-4ce6-8832-e2cfbba4c170'),(162,'plugin:freeform','m240619_111214_GenerateSpamBlockIntegrations','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','c553dd41-c137-4487-9f23-21ea68040eff'),(163,'plugin:freeform','m240624_113811_AddArchivedDateToFormsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','9ac74655-eb81-4bde-b0cb-ad987d50acaf'),(164,'plugin:freeform','m240813_161214_UpdateStatusColors','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','1f3cc4fc-6198-41a4-af74-d510a03d58ed'),(165,'plugin:freeform','m240814_120443_RefactorGridAndFlexboxFormattingTemplatePaths','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','92b8df7d-8e5b-49c5-91ee-db8bdae47e47'),(166,'plugin:freeform','m240819_104209_AddTranslationTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','785dafa8-d555-4b7b-b09b-e52900efdfe9'),(167,'plugin:freeform','m240903_145017_CreateFormGroupsTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','903f13ab-e79a-4785-a9e8-e4a3c2b359e8'),(168,'plugin:freeform','m240903_145034_CreateFormGroupsEntriesTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','eb824dce-1d76-4610-ab13-a996b1377f7b'),(169,'plugin:freeform','m241023_080038_AddPdfTemplateTable','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','08317a6d-814d-42eb-88d5-0c64a62f204c'),(170,'plugin:freeform','m241104_091432_AddOptionsToIntegrationFields','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','2f39db2c-70cc-4410-aa5a-1d5c5704c8e2'),(171,'plugin:freeform','m241126_113656_UpdateTableLayoutProperties','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','0832997b-5e85-4018-b149-0c464f5c012f'),(172,'plugin:freeform','m241210_054218_AddOptionColumnFixForIntegrations','2024-12-23 16:39:49','2024-12-23 16:39:49','2024-12-23 16:39:49','a3032d84-08a0-4a8d-9f40-0ab74461211a'),(173,'craft','m241120_190905_user_affiliated_sites','2025-05-02 16:25:45','2025-05-02 16:25:45','2025-05-02 16:25:45','0669b37d-ff4b-40b8-877a-32d9e635991f'),(174,'craft','m241125_122914_add_viewUsers_permission','2025-05-02 16:25:45','2025-05-02 16:25:45','2025-05-02 16:25:45','4b81816c-7f69-45e2-acaa-9331a842c442'),(175,'craft','m250119_135304_entry_type_overrides','2025-05-02 16:25:45','2025-05-02 16:25:45','2025-05-02 16:25:45','0fe822b9-78dd-4c28-b92d-0e828e23052d'),(176,'craft','m250206_135036_search_index_queue','2025-05-02 16:25:46','2025-05-02 16:25:46','2025-05-02 16:25:46','481831ac-a82a-4954-a937-04293c1af23d'),(177,'craft','m250207_172349_bulkop_events','2025-05-02 16:25:46','2025-05-02 16:25:46','2025-05-02 16:25:46','d2b241a3-4a37-4d64-8297-6cc579091101'),(178,'craft','m250315_131608_unlimited_authors','2025-05-02 16:25:46','2025-05-02 16:25:46','2025-05-02 16:25:46','95191525-a56f-49b3-ba7b-d994ad327799'),(179,'craft','m250403_171253_static_statuses','2025-05-02 16:25:46','2025-05-02 16:25:46','2025-05-02 16:25:46','a079fe6f-7239-4c70-9f0b-e0cfc452e3f6'),(180,'plugin:freeform','m250121_085946_AddForeignKeyToAssetsInUnfinalizedAssets','2025-05-02 16:25:46','2025-05-02 16:25:46','2025-05-02 16:25:46','a983be05-81b4-4e37-ba17-b12ff030db77'),(181,'plugin:freeform','m250121_163320_UpdateCRMFieldOptionsColumnType','2025-05-02 16:25:46','2025-05-02 16:25:46','2025-05-02 16:25:46','dabeb746-9a35-40c8-a4ab-f12d5ceb26b3'),(182,'plugin:freeform','m250121_163956_UpdateEmailMarketingFieldOptionsColumnType','2025-05-02 16:25:46','2025-05-02 16:25:46','2025-05-02 16:25:46','0e456bd3-ec0e-44be-bb2c-e79dc659bf62');
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `plugins`
--

LOCK TABLES `plugins` WRITE;
/*!40000 ALTER TABLE `plugins` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `plugins` VALUES (1,'google-recaptcha','2.3.0','1.0.0','2023-11-10 04:19:39','2023-11-10 04:19:39','2023-11-10 04:19:39','bac3b5eb-086e-4237-b9a4-cb68a96a0baa'),(2,'ckeditor','4.8.0','3.0.0.0','2024-12-23 16:39:40','2024-12-23 16:39:40','2025-05-02 16:25:31','db0296db-6844-4687-ab59-e7564f8587af'),(3,'cp-css','3.0.0','2.0.0','2024-12-23 16:39:40','2024-12-23 16:39:40','2024-12-23 16:39:40','c0dbd56d-fa88-4740-85b0-7c6e2f3a383e'),(4,'freeform','5.10.11','5.4.2','2024-12-23 16:39:40','2024-12-23 16:39:40','2025-05-02 16:25:47','98584151-181d-4a1d-8ccb-953b986e1b77');
/*!40000 ALTER TABLE `plugins` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `projectconfig`
--

LOCK TABLES `projectconfig` WRITE;
/*!40000 ALTER TABLE `projectconfig` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `projectconfig` VALUES ('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elementCondition','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.autocapitalize','true'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.autocomplete','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.autocorrect','true'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.class','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.dateAdded','\"2024-12-23T16:29:15+00:00\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.disabled','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.elementCondition','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.id','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.includeInCards','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.inputType','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.instructions','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.label','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.max','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.min','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.name','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.orientation','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.placeholder','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.providesThumbs','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.readonly','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.requirable','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.size','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.step','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.tip','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.title','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\addresses\\\\LabelField\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.uid','\"70e5e657-7239-4906-b051-e615e0bb82aa\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.userCondition','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.warning','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.0.width','100'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.attribute','\"countryCode\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.dateAdded','\"2024-12-23T16:29:15+00:00\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.elementCondition','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.id','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.includeInCards','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.instructions','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.label','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.orientation','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.providesThumbs','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.requirable','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.tip','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\addresses\\\\CountryCodeField\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.uid','\"879b37dc-7f98-497a-83eb-316e40a714dc\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.userCondition','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.warning','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.1.width','100'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.dateAdded','\"2024-12-23T16:29:15+00:00\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.elementCondition','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.includeInCards','true'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.instructions','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.label','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.providesThumbs','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.required','false'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.tip','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\addresses\\\\AddressField\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.uid','\"a53dc581-c151-4f75-8a63-b2e9493fc545\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.userCondition','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.elements.2.warning','null'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.name','\"Content\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.uid','\"0eecb70d-d965-4f3f-9be4-1649ebedaeb8\"'),('addresses.fieldLayouts.ac88ed23-0855-458d-b3de-ef7a980d97f0.tabs.0.userCondition','null'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.headingLevels.0','1'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.headingLevels.1','2'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.headingLevels.2','3'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.headingLevels.3','4'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.headingLevels.4','5'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.headingLevels.5','6'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.name','\"Simple\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.options.alignment.options.0','\"left\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.options.alignment.options.1','\"center\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.options.alignment.options.2','\"right\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.0','\"heading\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.1','\"alignment\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.10','\"|\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.11','\"subscript\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.2','\"|\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.3','\"bold\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.4','\"italic\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.5','\"underline\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.6','\"link\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.7','\"|\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.8','\"bulletedList\"'),('ckeditor.configs.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465.toolbar.9','\"numberedList\"'),('dateModified','1746202912'),('elementSources.craft\\elements\\Entry.0.key','\"*\"'),('elementSources.craft\\elements\\Entry.0.type','\"native\"'),('elementSources.craft\\elements\\Entry.1.heading','\"Pages\"'),('elementSources.craft\\elements\\Entry.1.type','\"heading\"'),('elementSources.craft\\elements\\Entry.2.key','\"singles\"'),('elementSources.craft\\elements\\Entry.2.type','\"native\"'),('elementSources.craft\\elements\\Entry.3.defaultSort.0','\"title\"'),('elementSources.craft\\elements\\Entry.3.defaultSort.1','\"asc\"'),('elementSources.craft\\elements\\Entry.3.disabled','false'),('elementSources.craft\\elements\\Entry.3.key','\"section:d9c26beb-6bee-444c-b33f-13a168793722\"'),('elementSources.craft\\elements\\Entry.3.tableAttributes.0','\"type\"'),('elementSources.craft\\elements\\Entry.3.tableAttributes.1','\"dateUpdated\"'),('elementSources.craft\\elements\\Entry.3.tableAttributes.2','\"uri\"'),('elementSources.craft\\elements\\Entry.3.type','\"native\"'),('elementSources.craft\\elements\\Entry.4.heading','\"Components\"'),('elementSources.craft\\elements\\Entry.4.type','\"heading\"'),('elementSources.craft\\elements\\Entry.5.defaultSort.0','\"postDate\"'),('elementSources.craft\\elements\\Entry.5.defaultSort.1','\"desc\"'),('elementSources.craft\\elements\\Entry.5.disabled','false'),('elementSources.craft\\elements\\Entry.5.key','\"section:da0be12f-51b0-474c-915f-0d17dfa97850\"'),('elementSources.craft\\elements\\Entry.5.tableAttributes.0','\"postDate\"'),('elementSources.craft\\elements\\Entry.5.tableAttributes.1','\"field:57ee90df-01e6-437a-8c5c-38815877f909\"'),('elementSources.craft\\elements\\Entry.5.tableAttributes.2','\"field:962ca735-e2e0-4550-a295-93f517459468\"'),('elementSources.craft\\elements\\Entry.5.type','\"native\"'),('elementSources.craft\\elements\\Entry.6.defaultSort.0','\"title\"'),('elementSources.craft\\elements\\Entry.6.defaultSort.1','\"asc\"'),('elementSources.craft\\elements\\Entry.6.disabled','false'),('elementSources.craft\\elements\\Entry.6.key','\"section:e83e534b-ba3e-41e5-9e73-051db8c4b65b\"'),('elementSources.craft\\elements\\Entry.6.tableAttributes.0','\"type\"'),('elementSources.craft\\elements\\Entry.6.tableAttributes.1','\"postDate\"'),('elementSources.craft\\elements\\Entry.6.type','\"native\"'),('elementSources.craft\\elements\\Entry.7.defaultSort.0','\"postDate\"'),('elementSources.craft\\elements\\Entry.7.defaultSort.1','\"desc\"'),('elementSources.craft\\elements\\Entry.7.disabled','false'),('elementSources.craft\\elements\\Entry.7.key','\"section:825f4bb2-160e-43de-b9e1-179a555f48ec\"'),('elementSources.craft\\elements\\Entry.7.tableAttributes.0','\"postDate\"'),('elementSources.craft\\elements\\Entry.7.tableAttributes.1','\"field:cf9cc357-e972-4534-96a3-16243a7d4e25\"'),('elementSources.craft\\elements\\Entry.7.tableAttributes.2','\"field:e2acdefe-2270-4161-989c-4cacd80454da\"'),('elementSources.craft\\elements\\Entry.7.tableAttributes.3','\"link\"'),('elementSources.craft\\elements\\Entry.7.type','\"native\"'),('elementSources.craft\\elements\\Entry.8.defaultSort.0','\"postDate\"'),('elementSources.craft\\elements\\Entry.8.defaultSort.1','\"desc\"'),('elementSources.craft\\elements\\Entry.8.disabled','false'),('elementSources.craft\\elements\\Entry.8.key','\"section:15fdb8d9-166a-4c6c-b61e-17cbec66abd1\"'),('elementSources.craft\\elements\\Entry.8.tableAttributes.0','\"type\"'),('elementSources.craft\\elements\\Entry.8.tableAttributes.1','\"postDate\"'),('elementSources.craft\\elements\\Entry.8.type','\"native\"'),('email.fromEmail','\"$EMAIL_SYS_ADDRESS\"'),('email.fromName','\"$SENDER_NAME\"'),('email.replyToEmail','\"$REPLY_TO_ADDRESS\"'),('email.template','null'),('email.transportSettings.command','\"/usr/local/bin/mailpit sendmail -t --smtp-addr 127.0.0.1:1025\"'),('email.transportType','\"craft\\\\mail\\\\transportadapters\\\\Sendmail\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.color','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elementCondition','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.autocapitalize','true'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.autocomplete','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.autocorrect','true'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.class','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.dateAdded','\"2024-12-06T21:22:42+00:00\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.disabled','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.elementCondition','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.id','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.includeInCards','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.inputType','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.instructions','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.label','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.max','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.min','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.name','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.orientation','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.placeholder','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.providesThumbs','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.readonly','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.required','true'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.size','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.step','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.tip','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.title','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.uid','\"d3f55934-f5cf-488b-b225-68d224808a22\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.userCondition','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.warning','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.0.width','100'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.dateAdded','\"2024-12-06T21:22:42+00:00\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.elementCondition','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.fieldUid','\"e8fbb0cf-f013-47b2-8a71-e0aac50e9a06\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.handle','\"embedCode\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.includeInCards','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.instructions','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.label','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.providesThumbs','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.required','false'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.tip','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.uid','\"8a8f6a4e-e44f-4f75-ba6c-93934f05d583\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.userCondition','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.warning','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.elements.1.width','100'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.name','\"Bandcamp Embed\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.uid','\"358b2e5f-a79a-4b07-8eeb-00b203dc8e18\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.fieldLayouts.a17f307f-c301-4429-8b56-b7558f30ea0c.tabs.0.userCondition','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.handle','\"bandcampEmbed\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.hasTitleField','true'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.icon','\"\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.name','\"Bandcamp Embed\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.showSlugField','true'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.showStatusField','true'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.slugTranslationKeyFormat','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.slugTranslationMethod','\"site\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.titleFormat','\"\"'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.titleTranslationKeyFormat','null'),('entryTypes.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9.titleTranslationMethod','\"site\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.color','\"sky\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.cardView.0','\"layoutElement:23d6b77a-e903-4ceb-991d-6b1f2310d49b\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.cardView.1','\"layoutElement:d89d9435-d547-4ba7-bc61-7ab17389355e\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elementCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.autocapitalize','true'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.autocomplete','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.autocorrect','true'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.class','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.dateAdded','\"2024-12-23T15:39:46+00:00\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.disabled','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.elementCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.id','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.includeInCards','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.inputType','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.instructions','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.label','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.max','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.min','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.name','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.orientation','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.placeholder','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.providesThumbs','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.readonly','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.required','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.size','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.step','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.tip','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.title','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.uid','\"a268d50a-a1d3-441e-b8c6-8b59b92c4cd9\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.userCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.warning','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.0.width','100'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.1.dateAdded','\"2024-12-23T15:49:44+00:00\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.1.elementCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.1.uid','\"73adf8b9-bf6e-4c4d-ad7b-3e52904c0f12\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.1.userCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.dateAdded','\"2024-12-23T15:49:44+00:00\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.elementCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.fieldUid','\"299192bd-bbe9-4f2a-b1b4-b8f6f80905ef\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.handle','\"embedsLeft\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.includeInCards','true'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.instructions','\"Select the music embeds to display on the left side of this module (top on mobile).\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.label','\"Embeds | Left\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.providesThumbs','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.required','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.tip','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.uid','\"23d6b77a-e903-4ceb-991d-6b1f2310d49b\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.userCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.warning','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.2.width','50'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.dateAdded','\"2024-12-23T15:49:44+00:00\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.elementCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.fieldUid','\"299192bd-bbe9-4f2a-b1b4-b8f6f80905ef\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.handle','\"embedsRight\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.includeInCards','true'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.instructions','\"Select the music embeds to display on the right side of this module (bottom on mobile).\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.label','\"Embeds | Right\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.providesThumbs','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.required','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.tip','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.uid','\"d89d9435-d547-4ba7-bc61-7ab17389355e\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.userCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.warning','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.elements.3.width','50'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.name','\"Content\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.uid','\"2a63d9c1-a199-47a4-9e5d-1c4a71633778\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.fieldLayouts.63310011-23c1-4072-bb75-680121ee9d7e.tabs.0.userCondition','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.handle','\"embedsModule\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.hasTitleField','true'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.icon','\"music\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.name','\"Embeds Module\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.showSlugField','false'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.showStatusField','true'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.slugTranslationKeyFormat','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.slugTranslationMethod','\"site\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.titleFormat','\"\"'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.titleTranslationKeyFormat','null'),('entryTypes.2e37ec0b-896a-4a3b-953f-59d7f5127a84.titleTranslationMethod','\"site\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.color','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.cardView.0','\"layoutElement:fe57c07c-1d69-43c3-8baf-c2260e45ac3e\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elementCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.autocapitalize','true'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.autocomplete','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.autocorrect','true'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.class','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.disabled','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.elementCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.id','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.includeInCards','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.inputType','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.instructions','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.label','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.max','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.min','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.name','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.orientation','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.placeholder','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.providesThumbs','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.readonly','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.required','true'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.size','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.step','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.tip','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.title','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.uid','\"6fc70047-bb74-4133-9e67-2e87291af2a2\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.userCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.warning','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.0.width','50'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.elementCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.fieldUid','\"21bf5ac9-a185-4970-b6dc-e66c96ef0807\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.handle','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.includeInCards','true'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.instructions','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.label','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.providesThumbs','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.required','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.tip','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.uid','\"fe57c07c-1d69-43c3-8baf-c2260e45ac3e\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.userCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.warning','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.1.width','50'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.2.dateAdded','\"2024-12-13T21:56:34+00:00\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.2.elementCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.2.uid','\"8d3a8b42-9b0d-426b-8222-730940f8f05b\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.2.userCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.dateAdded','\"2024-12-13T21:56:34+00:00\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.elementCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.fieldUid','\"8714d452-365e-4edd-ba97-237557f2207f\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.handle','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.includeInCards','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.instructions','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.label','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.providesThumbs','true'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.required','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.tip','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.uid','\"64feaee3-2e6d-4070-8a5f-799139399d2c\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.userCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.warning','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.elements.3.width','100'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.name','\"YouTube Video\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.uid','\"722bb48c-811c-419a-9a90-a20cf0e98a2c\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.fieldLayouts.c1f4dd43-494c-4ed0-a33e-4dd588a90f0d.tabs.0.userCondition','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.handle','\"youtubeVideo\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.hasTitleField','true'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.icon','\"\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.name','\"YouTube Video\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.showSlugField','false'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.showStatusField','true'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.slugTranslationKeyFormat','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.slugTranslationMethod','\"site\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.titleFormat','\"\"'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.titleTranslationKeyFormat','null'),('entryTypes.3879dbdd-7514-41f1-b0f8-cb825ab28546.titleTranslationMethod','\"site\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.color','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elementCondition','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.autocapitalize','true'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.autocomplete','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.autocorrect','true'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.class','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.disabled','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.elementCondition','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.id','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.includeInCards','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.inputType','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.instructions','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.label','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.max','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.min','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.name','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.orientation','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.placeholder','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.providesThumbs','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.readonly','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.required','true'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.size','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.step','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.tip','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.title','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.uid','\"47116a2f-d30d-40a7-a63e-23502354a68d\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.userCondition','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.warning','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.0.width','100'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.elementCondition','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.fieldUid','\"be2a1882-9121-4306-87b1-450de9d53256\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.handle','\"embedCode\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.includeInCards','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.instructions','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.label','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.providesThumbs','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.required','false'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.tip','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.uid','\"036d6841-6bb9-487d-a01b-c28cb4d2937b\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.userCondition','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.warning','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.elements.1.width','100'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.name','\"SoundCloud Embed\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.uid','\"20decf46-25c4-45dc-87cc-dd00b5b911b9\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.fieldLayouts.e4347c61-d895-4989-b23b-7902e307d7da.tabs.0.userCondition','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.handle','\"soundcloudEmbed\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.hasTitleField','true'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.icon','\"\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.name','\"SoundCloud Embed\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.showSlugField','true'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.showStatusField','true'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.slugTranslationKeyFormat','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.slugTranslationMethod','\"site\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.titleFormat','\"\"'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.titleTranslationKeyFormat','null'),('entryTypes.44f5fc6a-9bb6-457e-99fd-d88a30b802f0.titleTranslationMethod','\"site\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.color','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.cardView.0','\"layoutElement:4449fc6a-6bcd-4096-9f74-db2eb500d9c3\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.cardView.1','\"layoutElement:09393b89-901f-431a-ac15-6e09ec994593\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elementCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.autocapitalize','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.autocomplete','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.autocorrect','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.class','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.disabled','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.elementCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.id','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.includeInCards','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.inputType','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.instructions','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.label','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.max','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.min','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.name','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.orientation','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.placeholder','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.providesThumbs','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.readonly','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.required','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.size','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.step','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.tip','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.title','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.uid','\"6dfceb4f-a9aa-4a26-ac03-e7b49f426172\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.userCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.warning','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.0.width','100'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.elementCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.fieldUid','\"cf9cc357-e972-4534-96a3-16243a7d4e25\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.handle','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.includeInCards','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.instructions','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.label','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.providesThumbs','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.required','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.tip','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.uid','\"4449fc6a-6bcd-4096-9f74-db2eb500d9c3\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.userCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.warning','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.1.width','100'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.elementCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.fieldUid','\"e2acdefe-2270-4161-989c-4cacd80454da\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.handle','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.includeInCards','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.instructions','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.label','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.providesThumbs','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.required','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.tip','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.uid','\"09393b89-901f-431a-ac15-6e09ec994593\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.userCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.warning','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.2.width','100'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.elementCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.fieldUid','\"afa92d21-9da5-4728-b388-676ab1b11c37\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.handle','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.includeInCards','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.instructions','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.label','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.providesThumbs','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.required','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.tip','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.uid','\"24fce9c1-bfcc-4bc8-be40-6c1a4d7b1bf2\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.userCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.warning','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.3.width','100'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.elementCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.fieldUid','\"82e690ff-8e29-4b0d-850d-c09a6cc8871f\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.handle','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.includeInCards','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.instructions','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.label','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.providesThumbs','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.required','false'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.tip','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.uid','\"f0b26a45-2a0e-4226-97d0-031e0c5f7f1e\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.userCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.warning','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.elements.4.width','100'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.name','\"Gigs\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.uid','\"49e37225-d557-43d3-bf39-bc06951a61f1\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.fieldLayouts.45ee0ef2-d574-44c6-a28d-ac7826a02477.tabs.0.userCondition','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.handle','\"gigs_default\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.hasTitleField','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.icon','\"\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.name','\"Gigs - Default\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.showSlugField','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.showStatusField','true'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.slugTranslationKeyFormat','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.slugTranslationMethod','\"site\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.titleFormat','\"\"'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.titleTranslationKeyFormat','null'),('entryTypes.66d475d7-97b8-40dc-9212-f05ea6e23d4c.titleTranslationMethod','\"site\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.color','\"sky\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.cardView.0','\"type\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.cardView.1','\"layoutElement:bf086f1b-fdb4-49a5-914d-ff5be4160d9e\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.0.dateAdded','\"2024-12-17T16:22:42+00:00\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.0.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.0.heading','\"Content\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.0.uid','\"3dbe31b5-53d2-482b-b91b-a6d44c5290c2\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.0.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.autocapitalize','true'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.autocomplete','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.autocorrect','true'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.class','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.dateAdded','\"2024-12-17T15:59:14+00:00\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.disabled','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.id','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.includeInCards','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.inputType','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.instructions','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.label','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.max','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.min','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.name','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.orientation','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.placeholder','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.providesThumbs','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.readonly','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.required','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.size','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.step','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.tip','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.title','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.uid','\"393267c5-a945-4648-9976-949f21d2842f\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.warning','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.1.width','100'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.2.dateAdded','\"2024-12-17T16:02:07+00:00\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.2.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.2.uid','\"73dbc846-3428-4615-930a-0dc1f3e5dd34\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.2.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.dateAdded','\"2024-12-17T16:02:07+00:00\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.fieldUid','\"0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.handle','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.includeInCards','true'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.instructions','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.label','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.providesThumbs','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.required','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.tip','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.uid','\"bf086f1b-fdb4-49a5-914d-ff5be4160d9e\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.warning','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.elements.3.width','100'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.name','\"Content\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.uid','\"e1cf09d8-74f4-475c-8524-2a3e91c02c2f\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.0.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.0.dateAdded','\"2024-12-17T16:22:42+00:00\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.0.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.0.heading','\"Appearance\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.0.uid','\"1f571744-b142-453d-9b23-79c8c0c6efea\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.0.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.dateAdded','\"2024-12-17T16:22:42+00:00\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.handle','\"backgroundColor\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.includeInCards','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.instructions','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.label','\"Background Color\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.providesThumbs','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.required','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.tip','\"Defaults to light grey (#eeeeee)\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.uid','\"71ded80b-49b9-46e3-85ff-2602c77d923f\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.warning','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.1.width','50'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.dateAdded','\"2024-12-17T16:22:42+00:00\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.elementCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.handle','\"contentColor\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.includeInCards','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.instructions','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.label','\"Content Color\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.providesThumbs','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.required','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.tip','\"Defaults to Slate 600 (#475569)\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.uid','\"6bec848a-f4fe-4af0-bdae-e301b4a079f4\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.warning','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.elements.2.width','50'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.name','\"Appearance\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.uid','\"9a89d999-ab9b-4ea7-aa37-537e93e629b1\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.fieldLayouts.d78b9da7-5b76-4153-a3de-121fee83c729.tabs.1.userCondition','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.handle','\"gigsModule\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.hasTitleField','true'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.icon','\"drum\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.name','\"Gigs Module\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.showSlugField','false'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.showStatusField','true'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.slugTranslationKeyFormat','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.slugTranslationMethod','\"site\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.titleFormat','\"\"'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.titleTranslationKeyFormat','null'),('entryTypes.72dbefd4-129d-400a-8161-f80241c6cd51.titleTranslationMethod','\"site\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elementCondition','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.autocapitalize','true'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.autocomplete','false'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.autocorrect','true'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.class','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.disabled','false'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.elementCondition','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.id','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.inputType','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.instructions','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.label','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.max','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.min','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.name','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.orientation','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.placeholder','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.readonly','false'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.requirable','false'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.size','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.step','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.tip','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.title','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.uid','\"ccf316cc-dcf8-4899-ad56-a2c7a5b7b9c3\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.userCondition','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.warning','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.0.width','100'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.elementCondition','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.fieldUid','\"139b20e8-6e1b-4e75-be7f-776bc8a50d43\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.instructions','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.label','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.required','false'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.tip','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.uid','\"00aaed21-f3e9-4b6c-958f-618a06e3e7ca\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.userCondition','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.warning','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.elements.1.width','100'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.name','\"Custom Page\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.uid','\"ba7ae951-de64-4bf5-9fab-7c37580fc30a\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.fieldLayouts.25586ae0-ad0e-4e86-84bc-2aa4a77fbc94.tabs.0.userCondition','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.handle','\"customPage\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.hasTitleField','true'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.name','\"Custom Page\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.showStatusField','true'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.slugTranslationKeyFormat','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.slugTranslationMethod','\"site\"'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.sortOrder','1'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.titleFormat','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.titleTranslationKeyFormat','null'),('entryTypes.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1.titleTranslationMethod','\"site\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.color','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elementCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.0.dateAdded','\"2024-12-11T22:07:54+00:00\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.0.elementCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.0.heading','\"Homepage Content\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.0.uid','\"42183623-71c0-4fd4-9458-52dcc7bbdd6f\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.0.userCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.dateAdded','\"2024-12-11T21:55:33+00:00\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.elementCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.fieldUid','\"d036f92a-3e96-4a73-b959-e8cf8df3c077\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.handle','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.includeInCards','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.instructions','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.label','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.providesThumbs','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.required','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.tip','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.uid','\"a04b38f6-8a21-4cab-868b-a8272a1734d6\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.userCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.warning','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.1.width','100'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.dateAdded','\"2024-12-11T21:55:33+00:00\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.elementCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.fieldUid','\"d036f92a-3e96-4a73-b959-e8cf8df3c077\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.handle','\"subheading\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.includeInCards','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.instructions','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.label','\"Subheading\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.providesThumbs','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.required','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.tip','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.uid','\"6632dbcb-1a41-4851-b4ce-714e6ed7806a\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.userCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.warning','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.2.width','100'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.3.dateAdded','\"2024-12-11T21:55:33+00:00\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.3.elementCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.3.uid','\"9cd608f7-2056-47ea-a23d-66c6e245f5b2\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.3.userCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.dateAdded','\"2024-12-11T21:55:33+00:00\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.elementCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.fieldUid','\"d10f8d89-ce67-4b10-bbe3-42358861dbc1\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.handle','\"backgroundVideo\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.includeInCards','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.instructions','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.label','\"Background Video\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.providesThumbs','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.required','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.tip','\"Will fallback to an image by default on mobile view.\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.uid','\"d967ff84-b439-468f-9c28-9ddfdcc40765\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.userCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.warning','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.elements.4.width','100'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.name','\"Content\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.uid','\"8165a1c5-0fdb-4e05-b74d-815df015a964\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.fieldLayouts.d4aefd62-4576-451d-bfed-e8d83cd166ff.tabs.0.userCondition','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.handle','\"home\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.hasTitleField','false'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.icon','\"house\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.name','\"Home\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.showSlugField','true'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.showStatusField','true'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.slugTranslationKeyFormat','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.slugTranslationMethod','\"site\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.titleFormat','\"{section.name|raw}\"'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.titleTranslationKeyFormat','null'),('entryTypes.8506d742-5b2a-47fe-97d8-880505113629.titleTranslationMethod','\"site\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.color','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.cardView.0','\"type\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.cardView.1','\"layoutElement:23c0dbad-08fa-486b-8725-6ac79053a366\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elementCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.dateAdded','\"2024-12-11T15:37:30+00:00\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.elementCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.fieldUid','\"29495b4d-2d51-4bf0-8f60-535b022b411f\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.handle','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.includeInCards','true'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.instructions','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.label','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.providesThumbs','false'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.required','false'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.tip','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.uid','\"23c0dbad-08fa-486b-8725-6ac79053a366\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.userCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.warning','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.elements.0.width','100'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.name','\"Content\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.uid','\"f682f24c-294a-4d33-8715-73444572bc43\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.0.userCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elementCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.dateAdded','\"2024-12-11T15:38:29+00:00\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.elementCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.handle','\"backgroundColor\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.includeInCards','false'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.instructions','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.label','\"Background Color\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.providesThumbs','false'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.required','false'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.tip','\"Defaults to light grey (#eeeeee)\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.uid','\"18a0333b-a5a3-48b0-9081-bb68339fe86e\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.userCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.warning','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.elements.0.width','100'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.name','\"Appearance\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.uid','\"02d96b39-4c8f-4939-ba82-0ee166c39ac2\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.fieldLayouts.b319f363-355d-4058-ada9-93d307a7fb0d.tabs.1.userCondition','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.handle','\"spacer\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.hasTitleField','false'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.icon','\"gear\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.name','\"Spacer\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.showSlugField','false'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.showStatusField','true'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.slugTranslationKeyFormat','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.slugTranslationMethod','\"site\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.titleFormat','\"\"'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.titleTranslationKeyFormat','null'),('entryTypes.9acc1147-87aa-4431-a099-130a6abe949c.titleTranslationMethod','\"site\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.color','\"sky\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.cardView.0','\"layoutElement:6943897f-3459-431b-acf7-eda6ce763c03\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.0.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.0.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.0.heading','\"Content\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.0.uid','\"49096e4c-fbeb-47dd-afb1-8a980e3f4a01\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.0.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.autocapitalize','true'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.autocomplete','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.autocorrect','true'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.class','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.dateAdded','\"2024-12-09T21:02:59+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.disabled','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.id','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.includeInCards','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.inputType','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.instructions','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.label','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.max','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.min','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.name','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.orientation','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.placeholder','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.providesThumbs','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.readonly','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.required','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.size','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.step','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.tip','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.title','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.uid','\"a4976ec1-004b-465e-9668-663eef31afb4\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.warning','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.1.width','100'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.2.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.2.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.2.uid','\"e941b2be-fb17-4079-9f98-4e6b178a6651\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.2.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.fieldUid','\"3b374f35-1602-4985-917c-bd65649ca09e\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.handle','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.includeInCards','true'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.instructions','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.label','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.providesThumbs','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.required','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.tip','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.uid','\"6943897f-3459-431b-acf7-eda6ce763c03\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.warning','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.elements.3.width','100'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.name','\"Content\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.uid','\"a5dc5f50-b6b2-4f71-8403-493a84bcdf3d\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.0.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.0.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.0.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.0.heading','\"Appearance\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.0.uid','\"d71f2690-6e17-4cbb-acc7-d1d665367050\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.0.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.handle','\"backgroundColor\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.includeInCards','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.instructions','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.label','\"Background Color\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.providesThumbs','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.required','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.tip','\"Defaults to light grey (#eeeeee)\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.uid','\"a08a9864-42f7-402e-91e4-c3c5b829ec12\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.warning','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.1.width','50'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.handle','\"contentColor\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.includeInCards','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.instructions','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.label','\"Content Color\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.providesThumbs','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.required','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.tip','\"Defaults to Slate 600 (#475569)\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.uid','\"3c5e564b-5439-4a1b-9dd1-790d5b051f4b\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.warning','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.2.width','50'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.3.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.3.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.3.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.3.uid','\"c2453b04-ec57-433d-98d4-9168e12bd9e6\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.3.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.dateAdded','\"2024-12-16T21:04:31+00:00\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.elementCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.fieldUid','\"00f0f6fc-444a-4eb0-b660-fcbb5c85f41f\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.handle','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.includeInCards','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.instructions','\"Select number of card columns within the video grid.\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.label','\"Number of Card Columns\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.providesThumbs','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.required','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.tip','\"Defaults to 2 columns.\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.uid','\"a3d64401-5bbb-4c18-bf87-927e5484984a\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.warning','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.elements.4.width','100'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.name','\"Appearance\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.uid','\"4e73971e-c42e-41d7-b623-14f437aac977\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.fieldLayouts.1ea3226d-28de-4336-8608-8923a8c6d075.tabs.1.userCondition','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.handle','\"videoGrid\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.hasTitleField','true'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.icon','\"play\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.name','\"Video Grid\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.showSlugField','false'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.showStatusField','true'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.slugTranslationKeyFormat','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.slugTranslationMethod','\"site\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.titleFormat','\"\"'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.titleTranslationKeyFormat','null'),('entryTypes.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6.titleTranslationMethod','\"site\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.color','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elementCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.autocapitalize','true'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.autocomplete','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.autocorrect','true'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.class','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.dateAdded','\"2024-12-09T20:57:15+00:00\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.disabled','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.elementCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.id','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.includeInCards','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.inputType','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.instructions','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.label','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.max','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.min','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.name','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.orientation','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.placeholder','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.providesThumbs','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.readonly','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.required','true'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.size','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.step','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.tip','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.title','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.uid','\"cb6948ae-53c8-42d5-88df-09a622aef28b\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.userCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.warning','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.0.width','100'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.1.dateAdded','\"2024-12-09T21:05:37+00:00\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.1.elementCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.1.uid','\"aed4db2f-2fa6-4762-85c7-18fca033f959\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.1.userCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.dateAdded','\"2024-12-09T21:05:37+00:00\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.elementCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.fieldUid','\"643f413e-3181-4811-821a-4eb565329c16\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.handle','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.includeInCards','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.instructions','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.label','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.providesThumbs','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.required','false'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.tip','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.uid','\"bdd64b90-f86e-490a-9c9f-dd52808849f8\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.userCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.warning','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.elements.2.width','100'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.name','\"Content\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.uid','\"a575f1c4-0d9d-4756-b161-3bd618e29634\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.fieldLayouts.ee98d65b-ec38-434d-8fc9-622afe9c9010.tabs.0.userCondition','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.handle','\"builderPage\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.hasTitleField','true'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.icon','\"cubes\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.name','\"Builder Page\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.showSlugField','true'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.showStatusField','true'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.slugTranslationKeyFormat','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.slugTranslationMethod','\"site\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.titleFormat','\"\"'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.titleTranslationKeyFormat','null'),('entryTypes.b2893806-8044-42c4-967c-a961476b4c1c.titleTranslationMethod','\"site\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.color','\"sky\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.cardView.0','\"type\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.cardView.1','\"layoutElement:e38579d0-3f4b-46df-86e4-9b46d38f80fb\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.0.dateAdded','\"2024-12-17T15:55:45+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.0.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.0.heading','\"Content & Form\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.0.uid','\"01d39a1d-da3c-4258-b2fe-05a9fcb8459b\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.0.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.autocapitalize','true'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.autocomplete','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.autocorrect','true'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.class','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.dateAdded','\"2024-12-09T21:02:19+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.disabled','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.id','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.includeInCards','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.inputType','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.instructions','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.label','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.max','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.min','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.name','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.orientation','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.placeholder','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.providesThumbs','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.readonly','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.required','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.size','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.step','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.tip','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.title','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.uid','\"f40941ff-b0aa-491d-899b-0a8c438d8c6a\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.warning','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.1.width','100'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.2.dateAdded','\"2024-12-17T15:55:45+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.2.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.2.uid','\"e793e111-2bfc-45c2-a543-cd575cb2f236\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.2.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.dateAdded','\"2024-12-17T15:57:14+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.dismissible','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.style','\"tip\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.tip','\"Contact Form will automatically be rendered within this module.\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\Tip\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.uid','\"26cb54e9-692c-4234-be3a-a78aeb2a7a81\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.elements.3.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.name','\"Content\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.uid','\"51fe21f1-e92d-44d5-993e-af1a1747109b\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.0.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.0.dateAdded','\"2024-12-17T15:55:45+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.0.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.0.heading','\"Media\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.0.uid','\"d589a319-b8e6-483d-b610-c603bae58e6e\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.0.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.dateAdded','\"2024-12-17T15:55:45+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.fieldUid','\"77d34c46-29a6-47a9-b5c4-8a7ffa61a10d\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.handle','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.includeInCards','true'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.instructions','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.label','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.providesThumbs','true'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.required','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.tip','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.uid','\"e38579d0-3f4b-46df-86e4-9b46d38f80fb\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.warning','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.elements.1.width','100'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.name','\"Media\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.uid','\"e14063ce-488f-4db9-8bc4-c594f8e754ac\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.1.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.0.dateAdded','\"2024-12-17T15:55:45+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.0.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.0.heading','\"Appearance\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.0.uid','\"c3fb8968-1b77-40f0-b64d-a3d18964fabe\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.0.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.dateAdded','\"2024-12-17T15:55:45+00:00\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.elementCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.fieldUid','\"e253049a-7803-4ae2-9b10-fb60c6c591b8\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.handle','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.includeInCards','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.instructions','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.label','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.providesThumbs','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.required','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.tip','\"Select where the media should be aligned in this module.\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.uid','\"8d2fe42a-ce89-4c3c-ab75-7077c8288c8b\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.warning','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.elements.1.width','100'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.name','\"Appearance\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.uid','\"9c4a77d1-3a35-4329-b09d-a357d5a31f9f\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.fieldLayouts.3b9e8101-e667-460d-9d58-b3263e2b40d2.tabs.2.userCondition','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.handle','\"mediaForm\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.hasTitleField','true'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.icon','\"pen-field\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.name','\"Media & Form\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.showSlugField','false'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.showStatusField','true'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.slugTranslationKeyFormat','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.slugTranslationMethod','\"site\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.titleFormat','\"\"'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.titleTranslationKeyFormat','null'),('entryTypes.bb9b9ea2-bf37-44e0-be22-153bca5edd1b.titleTranslationMethod','\"site\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.color','\"sky\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.cardView.0','\"type\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.cardView.1','\"layoutElement:83e1b785-31e6-43ef-b9f4-bb7876909f01\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.0.dateAdded','\"2024-12-11T16:12:40+00:00\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.0.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.0.heading','\"Content\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.0.uid','\"8c600950-1ddd-49d3-aced-19eb226522fe\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.0.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.autocapitalize','true'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.autocomplete','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.autocorrect','true'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.class','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.dateAdded','\"2024-12-09T21:01:17+00:00\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.disabled','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.id','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.includeInCards','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.inputType','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.instructions','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.label','\"Title (optional)\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.max','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.min','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.name','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.orientation','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.placeholder','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.providesThumbs','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.readonly','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.required','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.size','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.step','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.tip','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.title','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.uid','\"0a6f6218-f26f-44f8-ad46-e01dbe2f2db1\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.warning','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.1.width','100'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.dateAdded','\"2024-12-11T16:04:45+00:00\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.fieldUid','\"bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.handle','\"contentBody\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.includeInCards','true'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.instructions','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.label','\"Content Body\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.providesThumbs','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.required','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.tip','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.uid','\"83e1b785-31e6-43ef-b9f4-bb7876909f01\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.warning','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.elements.2.width','100'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.name','\"Content\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.uid','\"278ac8ce-0230-45f8-8b5a-db1e203ae280\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.0.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.0.dateAdded','\"2024-12-11T16:12:40+00:00\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.0.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.0.heading','\"Appearance\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.0.uid','\"7203d243-646c-468d-a2eb-349045146575\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.0.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.dateAdded','\"2024-12-11T16:12:40+00:00\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.handle','\"backgroundColor\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.includeInCards','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.instructions','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.label','\"Background Color\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.providesThumbs','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.required','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.tip','\"Defaults to light grey (#eeeeee)\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.uid','\"c16179d6-400d-4018-be91-230624617fa4\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.warning','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.1.width','50'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.dateAdded','\"2024-12-11T16:12:40+00:00\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.elementCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.handle','\"contentColor\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.includeInCards','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.instructions','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.label','\"Content Color\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.providesThumbs','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.required','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.tip','\"Defaults to Slate 600 (#475569)\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.uid','\"6f905075-4334-45e7-b089-8ad3f5347372\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.warning','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.elements.2.width','50'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.name','\"Appearance\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.uid','\"8619f87b-709b-4fd7-8ddc-d85284ad8338\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.fieldLayouts.f3684c66-104b-4a56-901c-f8c161bb11f1.tabs.1.userCondition','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.handle','\"generalContent\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.hasTitleField','true'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.icon','\"align-justify\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.name','\"General Content\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.showSlugField','false'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.showStatusField','true'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.slugTranslationKeyFormat','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.slugTranslationMethod','\"site\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.titleFormat','\"\"'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.titleTranslationKeyFormat','null'),('entryTypes.cd84622a-df79-4b5b-9d98-f9e7ed621fd0.titleTranslationMethod','\"site\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elementCondition','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.autocapitalize','true'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.autocomplete','false'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.autocorrect','true'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.class','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.disabled','false'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.elementCondition','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.id','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.inputType','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.instructions','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.label','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.max','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.min','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.name','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.orientation','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.placeholder','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.readonly','false'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.requirable','false'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.size','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.step','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.tip','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.title','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.uid','\"22625b58-3084-4a82-b270-15b8198b5ce6\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.userCondition','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.warning','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.0.width','100'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.elementCondition','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.fieldUid','\"ad2a34fc-908d-4a7e-b211-235d769602d3\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.instructions','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.label','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.required','false'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.tip','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.uid','\"7c7f8bad-b29c-43d4-aab7-e46e00775240\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.userCondition','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.warning','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.elements.1.width','100'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.name','\"Gallery Page\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.uid','\"7436cdd9-7d2e-4b5e-a35f-3aa5153924ca\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.fieldLayouts.279e5b91-22f6-4dbb-8e3d-95bc6c2706a9.tabs.0.userCondition','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.handle','\"galleryPage\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.hasTitleField','true'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.name','\"Gallery Page\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.showStatusField','true'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.slugTranslationKeyFormat','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.slugTranslationMethod','\"site\"'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.sortOrder','2'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.titleFormat','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.titleTranslationKeyFormat','null'),('entryTypes.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae.titleTranslationMethod','\"site\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.color','\"sky\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.cardView.0','\"layoutElement:cba033be-6772-48c8-a025-f758da83e0c7\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.0.dateAdded','\"2024-12-19T16:58:36+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.0.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.0.heading','\"Content\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.0.uid','\"ea4446f9-aba1-44b0-838c-937914534360\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.0.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.autocapitalize','true'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.autocomplete','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.autocorrect','true'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.class','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.dateAdded','\"2024-12-09T21:03:50+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.disabled','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.id','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.inputType','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.instructions','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.label','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.max','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.min','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.name','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.orientation','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.placeholder','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.readonly','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.size','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.step','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.title','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.uid','\"049d8f86-7169-4019-af93-a04ffbdaada3\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.1.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.2.dateAdded','\"2024-12-18T20:57:48+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.2.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.2.uid','\"50c97eb0-5ccd-476f-892f-40be1c7a21f2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.2.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.dateAdded','\"2024-12-18T20:57:48+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.fieldUid','\"ad2a34fc-908d-4a7e-b211-235d769602d3\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.handle','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.includeInCards','true'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.instructions','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.label','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.uid','\"cba033be-6772-48c8-a025-f758da83e0c7\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.elements.3.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.name','\"Content\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.uid','\"337bbd63-718d-4ad0-b9b8-b46ad2bd16c1\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.0.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.0.dateAdded','\"2024-12-19T16:58:36+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.0.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.0.heading','\"General Swiper Settings\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.0.uid','\"410afcef-8165-4020-a171-e898c2496f9b\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.0.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.dateAdded','\"2024-12-19T16:58:36+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.handle','\"configAutoHeight\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.instructions','\"If enabled, slider wrapper will adapt its height to the height of the currently active slide.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.label','\"Auto-Height\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.uid','\"87a5d55e-755f-4b58-b0b0-b83f8253e5a0\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.1.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.dateAdded','\"2024-12-19T21:58:04+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.fieldUid','\"46e12ab7-e122-464d-8364-4bfe2eefa5c3\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.handle','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.instructions','\"Select the slide transition effect.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.label','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.tip','\"Defaults to \'slide\' setting.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.uid','\"43c8d12b-18de-4460-91f7-13da7b631af9\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.10.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.11.dateAdded','\"2024-12-20T18:34:16+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.11.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.11.heading','\"Thumbnails\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.11.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.11.uid','\"11cb01a4-4057-424c-9143-b2a3fd2bb929\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.11.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.dateAdded','\"2024-12-20T18:34:16+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.handle','\"configThumbnails\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.instructions','\"If enabled, a navigable thumbnail slider will display below the main slider.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.label','\"Include Thumbnail Slider\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.uid','\"5045aa0a-dc55-44d3-9da7-f3f4eb28a0ba\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.12.width','50'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.dateAdded','\"2024-12-20T19:15:43+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.class','\"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.conditionRules.0.class','\"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.conditionRules.0.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.conditionRules.0.layoutElementUid','\"5045aa0a-dc55-44d3-9da7-f3f4eb28a0ba\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.conditionRules.0.uid','\"9e0a0c7c-d42d-4a29-9bb5-54a78ea6acb0\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.conditionRules.0.value','true'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.elementType','\"craft\\\\elements\\\\Entry\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.elementCondition.fieldContext','\"global\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.fieldUid','\"e6988761-5603-46e0-8f9a-7ec7b54a0e3e\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.handle','\"configSpaceBetween\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.instructions','\"Set the space/gap between the thumbnail slides.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.label','\"Space Between Thumbnail Slides\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.tip','\"Defaults to 10 pixels.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.uid','\"349be4f9-a1b7-4e71-be5c-412fbc7d4b81\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.13.width','50'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.dateAdded','\"2024-12-19T17:35:07+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.handle','\"configAutoplay\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.instructions','\"If enabled, the swiper will automatically swipe to the next slide without interaction.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.label','\"Autoplay\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.uid','\"b82c031d-45a7-4f45-994c-1b3fd2339738\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.2.width','50'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.dateAdded','\"2024-12-19T17:35:07+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.class','\"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.conditionRules.0.class','\"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.conditionRules.0.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.conditionRules.0.layoutElementUid','\"b82c031d-45a7-4f45-994c-1b3fd2339738\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.conditionRules.0.uid','\"eb329d17-11a2-42ac-848d-ecdd4c09e71f\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.conditionRules.0.value','true'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.elementType','\"craft\\\\elements\\\\Entry\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.elementCondition.fieldContext','\"global\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.fieldUid','\"9200bcdf-7a8c-466f-97f5-f08080ac3d03\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.handle','\"configAutoplayDelay\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.instructions','\"Set the number of seconds to wait until the next slide is displayed.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.label','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.tip','\"Defaults to 5 seconds if not set.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.uid','\"77074409-4fed-4ddf-85c4-f0ad4e1aa6cb\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.3.width','50'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.dateAdded','\"2024-12-19T18:07:20+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.handle','\"configFreemode\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.instructions','\"If enabled, the swiper slides will be \\\"unlocked\\\" so that slides can be loosely navigated.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.label','\"Freemode\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.uid','\"b3f6966d-7da6-4790-b5c4-d67b739b0c0f\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.4.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.dateAdded','\"2024-12-19T19:12:04+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.handle','\"configGrabCursor\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.instructions','\"If enabled, the user\'s mouse cursor will be a grab hand when interacting with the swiper slides.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.label','\"Grab Cursor\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.uid','\"ac1e7d09-fa7f-4da0-9c9c-01a72d9c5afd\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.5.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.dateAdded','\"2024-12-19T19:16:46+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.handle','\"configLoop\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.instructions','\"If enabled, the swiper\'s slides will continuously loop.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.label','\"Loop\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.uid','\"b97b878c-6671-4f9e-8d1b-19c8f1f218a6\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.6.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.dateAdded','\"2024-12-19T19:20:52+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.fieldUid','\"71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.handle','\"configOneWayMovement\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.instructions','\"If enabled, slides will swipe only forward (one-way) regardless of swipe direction.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.label','\"One-Way Movement\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.uid','\"3af07ae9-5448-41b1-a5d7-8cf7c680a3bb\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.7.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.dateAdded','\"2024-12-19T19:30:47+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.fieldUid','\"bced0888-a5a3-4f1f-b38c-6b52b005477d\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.handle','\"configSpeed\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.includeInCards','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.instructions','\"Adjust the speed (in seconds) of the swipe animation between slides.\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.label','\"Speed\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.providesThumbs','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.required','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.tip','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.uid','\"f8f3c242-ec5c-4eb5-bc50-bdb9e7f8c73d\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.warning','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.8.width','100'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.9.dateAdded','\"2024-12-19T21:58:04+00:00\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.9.elementCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.9.heading','\"Swiper Effects\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.9.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.9.uid','\"98513b59-10f7-4be5-a2bb-0a1f45e2f176\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.elements.9.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.name','\"Appearance\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.uid','\"b6e78faf-d2f6-4539-8a04-5974a60a9a62\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.fieldLayouts.cf958c25-b339-481e-aa05-c28eb5453c5b.tabs.1.userCondition','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.handle','\"gallery\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.hasTitleField','true'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.icon','\"rectangle-history\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.name','\"Gallery\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.showSlugField','false'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.showStatusField','true'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.slugTranslationKeyFormat','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.slugTranslationMethod','\"site\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.titleFormat','\"\"'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.titleTranslationKeyFormat','null'),('entryTypes.e01c47a5-80c5-41ea-9079-eb5d9c990ce4.titleTranslationMethod','\"site\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.color','\"sky\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.cardView.0','\"type\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.cardView.1','\"layoutElement:e852593c-0eee-4f81-9f97-6d7338a34729\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.cardView.2','\"layoutElement:646a03f3-de83-4c80-a744-3df1b36feaa6\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.0.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.0.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.0.heading','\"Content\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.0.uid','\"f03f0f81-dbd6-4091-ba52-545150533398\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.0.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.autocapitalize','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.autocomplete','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.autocorrect','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.class','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.dateAdded','\"2024-12-09T21:00:14+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.disabled','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.id','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.includeInCards','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.inputType','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.label','\"Title (optional)\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.max','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.min','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.name','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.orientation','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.placeholder','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.readonly','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.size','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.step','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.tip','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.title','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.uid','\"1e61cece-f808-4530-8dd9-3d772838e9ab\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.1.width','100'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.2.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.2.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.2.uid','\"a19d6249-3292-40f1-a7cb-762d49609ffe\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.2.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.fieldUid','\"bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.handle','\"contentBody\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.includeInCards','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.label','\"Content Body\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.tip','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.uid','\"646a03f3-de83-4c80-a744-3df1b36feaa6\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.elements.3.width','100'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.name','\"Content\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.uid','\"77d98afa-4006-40be-bbb4-028c6fe10e7a\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.0.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.0.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.0.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.0.heading','\"Media\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.0.uid','\"a7b2d8fd-94c6-40ed-adbb-c244b11de5ba\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.0.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.fieldUid','\"77d34c46-29a6-47a9-b5c4-8a7ffa61a10d\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.handle','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.includeInCards','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.label','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.tip','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.uid','\"e852593c-0eee-4f81-9f97-6d7338a34729\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.1.width','50'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.fieldUid','\"8f75a6ba-cffb-47c7-8031-e37daf2cdd33\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.handle','\"includeVideo\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.includeInCards','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.label','\"Add Video\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.tip','\"Enable this to add a video popup element to this image.\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.uid','\"ddf98bdc-334f-45fb-ad97-ff47dab66999\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.2.width','50'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.class','\"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.conditionRules.0.class','\"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.conditionRules.0.fieldUid','\"8f75a6ba-cffb-47c7-8031-e37daf2cdd33\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.conditionRules.0.layoutElementUid','\"ddf98bdc-334f-45fb-ad97-ff47dab66999\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.conditionRules.0.uid','\"0360ecd4-be32-4082-8256-697b6370e199\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.conditionRules.0.value','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.elementType','\"craft\\\\elements\\\\Entry\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.elementCondition.fieldContext','\"global\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.heading','\"Video\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.uid','\"2fc91234-2b25-4145-b42e-3585eb13f8fb\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.3.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.class','\"craft\\\\elements\\\\conditions\\\\entries\\\\EntryCondition\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.conditionRules.0.class','\"craft\\\\fields\\\\conditions\\\\LightswitchFieldConditionRule\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.conditionRules.0.fieldUid','\"8f75a6ba-cffb-47c7-8031-e37daf2cdd33\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.conditionRules.0.layoutElementUid','\"ddf98bdc-334f-45fb-ad97-ff47dab66999\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.conditionRules.0.uid','\"cbc5c51c-af75-4afb-9361-83661dd9a2ba\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.conditionRules.0.value','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.elementType','\"craft\\\\elements\\\\Entry\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.elementCondition.fieldContext','\"global\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.fieldUid','\"21bf5ac9-a185-4970-b6dc-e66c96ef0807\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.handle','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.includeInCards','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.label','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.tip','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.uid','\"997a595a-0b6b-4019-b9e1-1f110d6b36b7\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.elements.4.width','100'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.name','\"Media\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.uid','\"5547c3e2-8d95-46fe-92c1-fa64213d2e81\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.1.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.0.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.0.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.0.heading','\"Appearance\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.0.uid','\"ea8c56f0-739b-46fd-95ff-18254a5bd550\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.0.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.fieldUid','\"e253049a-7803-4ae2-9b10-fb60c6c591b8\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.handle','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.includeInCards','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.label','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.tip','\"Select where the media should be aligned in this module.\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.uid','\"b2a010a0-f97d-4241-97fa-34e1309866ce\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.1.width','100'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.2.dateAdded','\"2024-12-10T21:09:07+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.2.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.2.type','\"craft\\\\fieldlayoutelements\\\\HorizontalRule\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.2.uid','\"63ad09fd-e9fb-4fd1-b72c-5f5f571a7de5\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.2.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.dateAdded','\"2024-12-10T20:55:24+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.handle','\"backgroundColor\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.includeInCards','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.label','\"Background Color\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.tip','\"Defaults to light grey (#eeeeee)\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.uid','\"e3c2d2bb-2ed2-4842-b343-da08f0fef487\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.3.width','50'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.dateAdded','\"2024-12-10T21:09:07+00:00\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.elementCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.fieldUid','\"b28163a8-205c-4838-ac55-20538571deaa\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.handle','\"contentColor\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.includeInCards','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.instructions','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.label','\"Content Color\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.providesThumbs','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.required','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.tip','\"Defaults to Slate 600 (#475569)\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.uid','\"ffa6c54e-cb3d-4884-a2f6-0c39e11ced39\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.warning','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.elements.4.width','50'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.name','\"Appearance\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.uid','\"3c248002-9f57-4f9d-b790-b8be7b481a8c\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.fieldLayouts.6ad38b32-9a3d-498f-be49-6983ca12bc18.tabs.2.userCondition','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.handle','\"mediaContent\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.hasTitleField','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.icon','\"image-polaroid\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.name','\"Media & Content\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.showSlugField','false'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.showStatusField','true'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.slugTranslationKeyFormat','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.slugTranslationMethod','\"site\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.titleFormat','\"\"'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.titleTranslationKeyFormat','null'),('entryTypes.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e.titleTranslationMethod','\"site\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.color','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elementCondition','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.autocapitalize','true'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.autocomplete','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.autocorrect','true'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.class','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.disabled','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.elementCondition','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.id','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.includeInCards','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.inputType','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.instructions','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.label','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.max','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.min','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.name','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.orientation','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.placeholder','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.providesThumbs','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.readonly','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.required','true'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.size','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.step','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.tip','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.title','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\entries\\\\EntryTitleField\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.uid','\"9a388b4a-5b98-4822-82f9-ef14e26b3e64\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.userCondition','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.warning','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.0.width','100'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.elementCondition','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.fieldUid','\"9529e1cb-135c-4e74-bd95-f62c6d2bc858\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.handle','\"embedCode\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.includeInCards','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.instructions','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.label','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.providesThumbs','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.required','false'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.tip','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.uid','\"58557f92-7d83-4a51-8d3e-b9b38ab91b11\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.userCondition','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.warning','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.elements.1.width','100'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.name','\"Spotify Embed\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.uid','\"9dd4191e-eea3-4711-bfea-cf7c2564ca6e\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.fieldLayouts.c123a272-94e8-4203-bbe3-9b0757fe5ebc.tabs.0.userCondition','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.handle','\"spotifyEmbed\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.hasTitleField','true'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.icon','\"\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.name','\"Spotify Embed\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.showSlugField','true'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.showStatusField','true'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.slugTranslationKeyFormat','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.slugTranslationMethod','\"site\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.titleFormat','\"\"'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.titleTranslationKeyFormat','null'),('entryTypes.f494ab8a-02d3-48a3-bf69-103c6c96824c.titleTranslationMethod','\"site\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.columnSuffix','null'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.handle','\"gridColumns\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.instructions','null'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.name','\"Grid Columns\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.searchable','false'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.customOptions','false'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.0.__assoc__.0.0','\"label\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.0.__assoc__.0.1','\"2-column\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.0.__assoc__.1.0','\"value\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.0.__assoc__.1.1','\"lg:grid-cols-2\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.0.__assoc__.2.0','\"default\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.0.__assoc__.2.1','\"1\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.1.__assoc__.0.0','\"label\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.1.__assoc__.0.1','\"3-column\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.1.__assoc__.1.0','\"value\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.1.__assoc__.1.1','\"lg:grid-cols-3\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.1.__assoc__.2.0','\"default\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.1.__assoc__.2.1','\"\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.2.__assoc__.0.0','\"label\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.2.__assoc__.0.1','\"4-column\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.2.__assoc__.1.0','\"value\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.2.__assoc__.1.1','\"md:grid-cols-3 lg:grid-cols-4\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.2.__assoc__.2.0','\"default\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.settings.options.2.__assoc__.2.1','\"\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.translationKeyFormat','null'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.translationMethod','\"none\"'),('fields.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f.type','\"craft\\\\fields\\\\Dropdown\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.columnSuffix','null'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.handle','\"gigSelect\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.instructions','\"If none are selected, all upcoming gigs will be dynamically rendered in this module.\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.name','\"Gig Select\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.searchable','false'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.allowSelfRelations','false'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.branchLimit','null'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.maintainHierarchy','false'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.maxRelations','20'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.minRelations','null'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.selectionLabel','\"Add a gig\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.showCardsInGrid','false'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.showSiteMenu','true'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.sources.0','\"section:825f4bb2-160e-43de-b9e1-179a555f48ec\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.targetSiteId','null'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.validateRelatedElements','false'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.settings.viewMode','\"cards\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.translationKeyFormat','null'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.translationMethod','\"none\"'),('fields.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6.type','\"craft\\\\fields\\\\Entries\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.columnSuffix','\"jxvqpmcm\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.contentColumnType','\"text\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.handle','\"pageTemplate\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.instructions','\"Path to page template\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.name','\"Page Template\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.searchable','false'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.byteLimit','null'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.charLimit','null'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.code','false'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.columnType','null'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.initialRows','4'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.multiline','false'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.placeholder','null'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.settings.uiMode','\"normal\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.translationKeyFormat','null'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.translationMethod','\"none\"'),('fields.139b20e8-6e1b-4e75-be7f-776bc8a50d43.type','\"craft\\\\fields\\\\PlainText\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.columnSuffix','null'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.handle','\"navigationLinks\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.instructions','null'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.name','\"Navigation Links\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.searchable','false'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.allowSelfRelations','false'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.branchLimit','null'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.maintainHierarchy','false'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.maxRelations','10'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.minRelations','null'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.selectionLabel','\"Add a nav link\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.showCardsInGrid','false'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.showSiteMenu','false'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.sources.0','\"section:d9c26beb-6bee-444c-b33f-13a168793722\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.sources.1','\"singles\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.targetSiteId','null'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.validateRelatedElements','false'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.settings.viewMode','\"list\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.translationKeyFormat','null'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.translationMethod','\"none\"'),('fields.186e3495-0405-4ef9-8b6a-13ea813ea449.type','\"craft\\\\fields\\\\Entries\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.columnSuffix','\"ydkphbeb\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.contentColumnType','\"text\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.handle','\"youtubeVideoId\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.instructions','\"YouTube Video ID\\r\\nExample: ID for https://www.youtube.com/watch?v=E_l-b-8qSYA is E_l-b-8qSYA.\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.name','\"YouTube Video ID\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.searchable','false'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.byteLimit','null'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.charLimit','null'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.code','false'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.columnType','null'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.initialRows','4'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.multiline','false'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.placeholder','null'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.settings.uiMode','\"normal\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.translationKeyFormat','null'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.translationMethod','\"none\"'),('fields.21bf5ac9-a185-4970-b6dc-e66c96ef0807.type','\"craft\\\\fields\\\\PlainText\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.columnSuffix','null'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.handle','\"paddingSpacer\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.instructions','null'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.name','\"Padding Spacer\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.searchable','false'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.customOptions','false'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.0.__assoc__.0.0','\"label\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.0.__assoc__.0.1','\"Small\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.0.__assoc__.1.0','\"value\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.0.__assoc__.1.1','\"small\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.0.__assoc__.2.0','\"default\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.0.__assoc__.2.1','\"1\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.1.__assoc__.0.0','\"label\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.1.__assoc__.0.1','\"Medium\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.1.__assoc__.1.0','\"value\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.1.__assoc__.1.1','\"medium\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.1.__assoc__.2.0','\"default\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.1.__assoc__.2.1','\"\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.2.__assoc__.0.0','\"label\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.2.__assoc__.0.1','\"Large\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.2.__assoc__.1.0','\"value\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.2.__assoc__.1.1','\"large\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.2.__assoc__.2.0','\"default\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.2.__assoc__.2.1','\"\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.3.__assoc__.0.0','\"label\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.3.__assoc__.0.1','\"XL\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.3.__assoc__.1.0','\"value\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.3.__assoc__.1.1','\"xl\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.3.__assoc__.2.0','\"default\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.3.__assoc__.2.1','\"\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.4.__assoc__.0.0','\"label\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.4.__assoc__.0.1','\"2XL\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.4.__assoc__.1.0','\"value\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.4.__assoc__.1.1','\"2xl\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.4.__assoc__.2.0','\"default\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.4.__assoc__.2.1','\"\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.5.__assoc__.0.0','\"label\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.5.__assoc__.0.1','\"3XL\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.5.__assoc__.1.0','\"value\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.5.__assoc__.1.1','\"3xl\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.5.__assoc__.2.0','\"default\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.settings.options.5.__assoc__.2.1','\"\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.translationKeyFormat','null'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.translationMethod','\"none\"'),('fields.29495b4d-2d51-4bf0-8f60-535b022b411f.type','\"craft\\\\fields\\\\Dropdown\"'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.columnSuffix','null'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.handle','\"embedSelect\"'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.instructions','null'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.name','\"Embed Select\"'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.searchable','false'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.allowSelfRelations','false'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.branchLimit','null'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.maintainHierarchy','false'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.maxRelations','10'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.minRelations','null'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.selectionLabel','\"Add an embed\"'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.showCardsInGrid','false'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.showSiteMenu','false'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.sources.0','\"section:e83e534b-ba3e-41e5-9e73-051db8c4b65b\"'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.targetSiteId','null'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.validateRelatedElements','false'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.settings.viewMode','\"list\"'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.translationKeyFormat','null'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.translationMethod','\"none\"'),('fields.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef.type','\"craft\\\\fields\\\\Entries\"'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.columnSuffix','null'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.handle','\"videoSelect\"'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.instructions','null'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.name','\"Video Select\"'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.searchable','false'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.allowSelfRelations','false'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.branchLimit','null'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.maintainHierarchy','false'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.maxRelations','10'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.minRelations','null'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.selectionLabel','\"Add a video\"'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.showCardsInGrid','false'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.showSiteMenu','false'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.sources.0','\"section:15fdb8d9-166a-4c6c-b61e-17cbec66abd1\"'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.targetSiteId','null'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.validateRelatedElements','false'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.settings.viewMode','\"cards\"'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.translationKeyFormat','null'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.translationMethod','\"none\"'),('fields.3b374f35-1602-4985-917c-bd65649ca09e.type','\"craft\\\\fields\\\\Entries\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.columnSuffix','null'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.handle','\"configEffect\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.instructions','null'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.name','\"Animation Effect\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.searchable','false'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.customOptions','false'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.0.__assoc__.0.0','\"label\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.0.__assoc__.0.1','\"Slide\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.0.__assoc__.1.0','\"value\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.0.__assoc__.1.1','\"slide\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.0.__assoc__.2.0','\"default\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.0.__assoc__.2.1','\"1\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.1.__assoc__.0.0','\"label\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.1.__assoc__.0.1','\"Fade\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.1.__assoc__.1.0','\"value\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.1.__assoc__.1.1','\"fade\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.1.__assoc__.2.0','\"default\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.1.__assoc__.2.1','\"\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.2.__assoc__.0.0','\"label\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.2.__assoc__.0.1','\"Cube\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.2.__assoc__.1.0','\"value\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.2.__assoc__.1.1','\"cube\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.2.__assoc__.2.0','\"default\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.2.__assoc__.2.1','\"\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.3.__assoc__.0.0','\"label\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.3.__assoc__.0.1','\"Coverflow\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.3.__assoc__.1.0','\"value\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.3.__assoc__.1.1','\"coverflow\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.3.__assoc__.2.0','\"default\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.3.__assoc__.2.1','\"\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.4.__assoc__.0.0','\"label\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.4.__assoc__.0.1','\"Flip\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.4.__assoc__.1.0','\"value\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.4.__assoc__.1.1','\"flip\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.4.__assoc__.2.0','\"default\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.4.__assoc__.2.1','\"\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.5.__assoc__.0.0','\"label\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.5.__assoc__.0.1','\"Cards\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.5.__assoc__.1.0','\"value\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.5.__assoc__.1.1','\"cards\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.5.__assoc__.2.0','\"default\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.settings.options.5.__assoc__.2.1','\"\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.translationKeyFormat','null'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.translationMethod','\"none\"'),('fields.46e12ab7-e122-464d-8364-4bfe2eefa5c3.type','\"craft\\\\fields\\\\Dropdown\"'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.columnSuffix','\"qqiavbhr\"'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.contentColumnType','\"string\"'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.handle','\"submissionEmail\"'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.instructions','null'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.name','\"Email Address\"'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.searchable','false'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.settings.placeholder','null'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.translationKeyFormat','null'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.translationMethod','\"none\"'),('fields.57ee90df-01e6-437a-8c5c-38815877f909.type','\"craft\\\\fields\\\\Email\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.columnSuffix','null'),('fields.643f413e-3181-4811-821a-4eb565329c16.handle','\"pageBuilder\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.instructions','null'),('fields.643f413e-3181-4811-821a-4eb565329c16.name','\"Page Builder\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.searchable','false'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.createButtonLabel','\"New module\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.defaultIndexViewMode','\"cards\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.0','\"2e37ec0b-896a-4a3b-953f-59d7f5127a84\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.1','\"e01c47a5-80c5-41ea-9079-eb5d9c990ce4\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.2','\"cd84622a-df79-4b5b-9d98-f9e7ed621fd0\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.3','\"72dbefd4-129d-400a-8161-f80241c6cd51\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.4','\"ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.5','\"bb9b9ea2-bf37-44e0-be22-153bca5edd1b\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.6','\"9d2b7c77-acc5-4dba-8641-d02de2fbc1b6\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.entryTypes.7','\"9acc1147-87aa-4431-a099-130a6abe949c\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.includeTableView','false'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.maxEntries','12'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.minEntries','null'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.pageSize','50'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.propagationKeyFormat','null'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.propagationMethod','\"all\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.showCardsInGrid','false'),('fields.643f413e-3181-4811-821a-4eb565329c16.settings.viewMode','\"cards\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.translationKeyFormat','null'),('fields.643f413e-3181-4811-821a-4eb565329c16.translationMethod','\"site\"'),('fields.643f413e-3181-4811-821a-4eb565329c16.type','\"craft\\\\fields\\\\Matrix\"'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.columnSuffix','null'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.handle','\"lightswitch\"'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.instructions','null'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.name','\"Lightswitch\"'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.searchable','false'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.settings.default','false'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.settings.offLabel','null'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.settings.onLabel','null'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.translationKeyFormat','null'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.translationMethod','\"none\"'),('fields.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2.type','\"craft\\\\fields\\\\Lightswitch\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.columnSuffix','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.handle','\"singleImage\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.instructions','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.name','\"Single Image\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.searchable','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.allowedKinds.0','\"image\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.allowSelfRelations','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.allowSubfolders','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.allowUploads','true'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.branchLimit','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.defaultUploadLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.defaultUploadLocationSubpath','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.maintainHierarchy','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.maxRelations','1'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.minRelations','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.previewMode','\"full\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.restrictedDefaultUploadSubpath','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.restrictedLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.restrictedLocationSubpath','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.restrictFiles','true'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.restrictLocation','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.selectionLabel','\"Add an image\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.showCardsInGrid','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.showSiteMenu','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.showUnpermittedFiles','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.showUnpermittedVolumes','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.sources.0','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.targetSiteId','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.validateRelatedElements','false'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.settings.viewMode','\"large\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.translationKeyFormat','null'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.translationMethod','\"none\"'),('fields.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d.type','\"craft\\\\fields\\\\Assets\"'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.columnSuffix','\"lcmhpagu\"'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.contentColumnType','\"string(255)\"'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.handle','\"gigLink\"'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.instructions','null'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.name','\"Link\"'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.searchable','false'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.settings.maxLength','255'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.settings.types.0','\"url\"'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.translationKeyFormat','null'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.translationMethod','\"none\"'),('fields.82e690ff-8e29-4b0d-850d-c09a6cc8871f.type','\"craft\\\\fields\\\\Url\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.columnSuffix','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.handle','\"videoThumbnail\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.instructions','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.name','\"Video Thumbnail\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.searchable','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.allowedKinds.0','\"image\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.allowSelfRelations','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.allowSubfolders','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.allowUploads','true'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.branchLimit','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.defaultUploadLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.defaultUploadLocationSubpath','\"video-thumbs\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.maintainHierarchy','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.maxRelations','1'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.minRelations','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.previewMode','\"full\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.restrictedDefaultUploadSubpath','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.restrictedLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.restrictedLocationSubpath','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.restrictFiles','true'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.restrictLocation','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.selectionLabel','\"Add a thumbnail\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.showCardsInGrid','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.showSiteMenu','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.showUnpermittedFiles','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.showUnpermittedVolumes','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.sources.0','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.targetSiteId','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.validateRelatedElements','false'),('fields.8714d452-365e-4edd-ba97-237557f2207f.settings.viewMode','\"large\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.translationKeyFormat','null'),('fields.8714d452-365e-4edd-ba97-237557f2207f.translationMethod','\"none\"'),('fields.8714d452-365e-4edd-ba97-237557f2207f.type','\"craft\\\\fields\\\\Assets\"'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.columnSuffix','null'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.handle','\"simpleToggle\"'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.instructions','null'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.name','\"Simple Toggle\"'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.searchable','false'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.settings.default','false'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.settings.offLabel','null'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.settings.onLabel','null'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.translationKeyFormat','null'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.translationMethod','\"none\"'),('fields.8f75a6ba-cffb-47c7-8031-e37daf2cdd33.type','\"craft\\\\fields\\\\Lightswitch\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.columnSuffix','\"vhxmksft\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.contentColumnType','\"text\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.handle','\"clientEmail\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.instructions','null'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.name','\"Client Email\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.searchable','false'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.byteLimit','null'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.charLimit','null'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.code','false'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.columnType','null'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.initialRows','4'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.multiline','false'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.placeholder','\"email@email.com\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.settings.uiMode','\"normal\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.translationKeyFormat','null'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.translationMethod','\"none\"'),('fields.9167b446-1840-45ea-8aa9-300e555b1344.type','\"craft\\\\fields\\\\PlainText\"'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.columnSuffix','null'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.handle','\"autoplayDelay\"'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.instructions','null'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.name','\"Autoplay Delay\"'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.searchable','false'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.settings.defaultValue','5'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.settings.max','12'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.settings.min','2'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.settings.step','1'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.settings.suffix','\"seconds\"'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.translationKeyFormat','null'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.translationMethod','\"none\"'),('fields.9200bcdf-7a8c-466f-97f5-f08080ac3d03.type','\"craft\\\\fields\\\\Range\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.columnSuffix','\"yzgetqnv\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.contentColumnType','\"text\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.handle','\"spotifyEmbed\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.instructions','\"Copy your Spotify Embed code and paste it here ...\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.name','\"Spotify Embed\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.searchable','false'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.byteLimit','null'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.charLimit','null'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.code','false'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.columnType','null'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.initialRows','10'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.multiline','true'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.placeholder','\"Code goes here ...\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.settings.uiMode','\"normal\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.translationKeyFormat','null'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.translationMethod','\"none\"'),('fields.9529e1cb-135c-4e74-bd95-f62c6d2bc858.type','\"craft\\\\fields\\\\PlainText\"'),('fields.962ca735-e2e0-4550-a295-93f517459468.columnSuffix','\"ziqqexut\"'),('fields.962ca735-e2e0-4550-a295-93f517459468.contentColumnType','\"text\"'),('fields.962ca735-e2e0-4550-a295-93f517459468.handle','\"submissionSubject\"'),('fields.962ca735-e2e0-4550-a295-93f517459468.instructions','null'),('fields.962ca735-e2e0-4550-a295-93f517459468.name','\"Subject\"'),('fields.962ca735-e2e0-4550-a295-93f517459468.searchable','false'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.byteLimit','null'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.charLimit','null'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.code','false'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.columnType','null'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.initialRows','4'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.multiline','false'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.placeholder','null'),('fields.962ca735-e2e0-4550-a295-93f517459468.settings.uiMode','\"normal\"'),('fields.962ca735-e2e0-4550-a295-93f517459468.translationKeyFormat','null'),('fields.962ca735-e2e0-4550-a295-93f517459468.translationMethod','\"none\"'),('fields.962ca735-e2e0-4550-a295-93f517459468.type','\"craft\\\\fields\\\\PlainText\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.columnSuffix','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.contentColumnType','\"string\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.handle','\"siteLogo\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.instructions','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.name','\"Site Logo\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.searchable','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.allowedKinds.0','\"image\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.allowSelfRelations','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.allowSubfolders','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.allowUploads','true'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.branchLimit','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.defaultUploadLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.defaultUploadLocationSubpath','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.localizeRelations','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.maintainHierarchy','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.maxRelations','1'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.minRelations','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.previewMode','\"full\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.restrictedDefaultUploadSubpath','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.restrictedLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.restrictedLocationSubpath','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.restrictFiles','true'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.restrictLocation','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.selectionLabel','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.showSiteMenu','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.showUnpermittedFiles','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.showUnpermittedVolumes','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.sources.0','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.targetSiteId','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.validateRelatedElements','false'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.settings.viewMode','\"large\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.translationKeyFormat','null'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.translationMethod','\"site\"'),('fields.a10d1b66-619c-4f4b-99c3-ad63094cbee2.type','\"craft\\\\fields\\\\Assets\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.columnSuffix','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.contentColumnType','\"string\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.handle','\"galleryImages\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.instructions','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.name','\"Gallery Images\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.searchable','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.allowedKinds.0','\"image\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.allowSelfRelations','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.allowSubfolders','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.allowUploads','true'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.branchLimit','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.defaultUploadLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.defaultUploadLocationSubpath','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.localizeRelations','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.maintainHierarchy','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.maxRelations','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.minRelations','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.previewMode','\"full\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.restrictedDefaultUploadSubpath','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.restrictedLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.restrictedLocationSubpath','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.restrictFiles','true'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.restrictLocation','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.selectionLabel','\"Add Gallery images\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.showSiteMenu','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.showUnpermittedFiles','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.showUnpermittedVolumes','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.sources.0','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.targetSiteId','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.validateRelatedElements','false'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.settings.viewMode','\"list\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.translationKeyFormat','null'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.translationMethod','\"site\"'),('fields.ad2a34fc-908d-4a7e-b211-235d769602d3.type','\"craft\\\\fields\\\\Assets\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.columnSuffix','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.contentColumnType','\"string\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.handle','\"gigFeaturedImage\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.instructions','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.name','\"Featured Image\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.searchable','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.allowedKinds.0','\"image\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.allowSelfRelations','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.allowSubfolders','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.allowUploads','true'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.branchLimit','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.defaultUploadLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.defaultUploadLocationSubpath','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.localizeRelations','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.maintainHierarchy','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.maxRelations','1'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.minRelations','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.previewMode','\"full\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.restrictedDefaultUploadSubpath','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.restrictedLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.restrictedLocationSubpath','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.restrictFiles','true'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.restrictLocation','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.selectionLabel','\"Add a featured image\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.showSiteMenu','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.showUnpermittedFiles','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.showUnpermittedVolumes','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.sources.0','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.targetSiteId','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.validateRelatedElements','false'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.settings.viewMode','\"large\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.translationKeyFormat','null'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.translationMethod','\"site\"'),('fields.afa92d21-9da5-4728-b388-676ab1b11c37.type','\"craft\\\\fields\\\\Assets\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.columnSuffix','null'),('fields.b28163a8-205c-4838-ac55-20538571deaa.handle','\"colorPicker\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.instructions','null'),('fields.b28163a8-205c-4838-ac55-20538571deaa.name','\"Color Picker\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.searchable','false'),('fields.b28163a8-205c-4838-ac55-20538571deaa.settings.defaultColor','null'),('fields.b28163a8-205c-4838-ac55-20538571deaa.settings.presets.0','\"#283450\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.settings.presets.1','\"#475569\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.settings.presets.2','\"#eeeeee\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.settings.presets.3','\"#198754\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.translationKeyFormat','null'),('fields.b28163a8-205c-4838-ac55-20538571deaa.translationMethod','\"none\"'),('fields.b28163a8-205c-4838-ac55-20538571deaa.type','\"craft\\\\fields\\\\Color\"'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.columnSuffix','\"fggnchnh\"'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.contentColumnType','\"text\"'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.handle','\"submissionName\"'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.instructions','null'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.name','\"Name\"'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.searchable','false'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.byteLimit','null'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.charLimit','null'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.code','false'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.columnType','null'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.initialRows','4'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.multiline','false'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.placeholder','null'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.settings.uiMode','\"normal\"'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.translationKeyFormat','null'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.translationMethod','\"none\"'),('fields.b61a32ce-4093-4b76-986a-5303ee05cc28.type','\"craft\\\\fields\\\\PlainText\"'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.columnSuffix','null'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.handle','\"contentBodySimple\"'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.instructions','null'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.name','\"Content Body (Simple)\"'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.searchable','false'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.availableTransforms','\"\"'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.availableVolumes','\"*\"'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.ckeConfig','\"e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465\"'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.createButtonLabel','null'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.defaultTransform','null'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.enableSourceEditingForNonAdmins','false'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.purifierConfig','null'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.purifyHtml','true'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.showUnpermittedFiles','false'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.showUnpermittedVolumes','false'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.showWordCount','true'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.settings.wordLimit','null'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.translationKeyFormat','null'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.translationMethod','\"none\"'),('fields.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1.type','\"craft\\\\ckeditor\\\\Field\"'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.columnSuffix','null'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.handle','\"swiperSpeed\"'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.instructions','null'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.name','\"Swiper Speed\"'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.searchable','false'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.settings.defaultValue','3'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.settings.max','10'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.settings.min','1'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.settings.step','1'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.settings.suffix','\"seconds\"'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.translationKeyFormat','null'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.translationMethod','\"none\"'),('fields.bced0888-a5a3-4f1f-b38c-6b52b005477d.type','\"craft\\\\fields\\\\Range\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.columnSuffix','\"qpoyhsol\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.contentColumnType','\"text\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.handle','\"soundcloudEmbed\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.instructions','\"Copy the SoiundCloud Embed code from your track and paste it here ...\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.name','\"SoundCloud Embed\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.searchable','false'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.byteLimit','null'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.charLimit','null'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.code','false'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.columnType','null'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.initialRows','10'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.multiline','true'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.placeholder','\"Code goes here ...\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.settings.uiMode','\"normal\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.translationKeyFormat','null'),('fields.be2a1882-9121-4306-87b1-450de9d53256.translationMethod','\"none\"'),('fields.be2a1882-9121-4306-87b1-450de9d53256.type','\"craft\\\\fields\\\\PlainText\"'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.columnSuffix','\"rzbqtsud\"'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.contentColumnType.0','\"date:datetime\"'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.contentColumnType.1','\"tz:string\"'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.handle','\"gigDate\"'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.instructions','null'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.name','\"Date\"'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.searchable','false'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.settings.max','null'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.settings.min','null'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.settings.minuteIncrement','30'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.settings.showDate','true'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.settings.showTime','true'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.settings.showTimeZone','true'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.translationKeyFormat','null'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.translationMethod','\"none\"'),('fields.cf9cc357-e972-4534-96a3-16243a7d4e25.type','\"craft\\\\fields\\\\Date\"'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.columnSuffix','null'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.handle','\"heading\"'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.instructions','null'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.name','\"Heading\"'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.searchable','false'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.settings.byteLimit','null'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.settings.charLimit','null'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.settings.code','false'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.settings.initialRows','4'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.settings.multiline','false'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.settings.placeholder','null'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.settings.uiMode','\"normal\"'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.translationKeyFormat','null'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.translationMethod','\"none\"'),('fields.d036f92a-3e96-4a73-b959-e8cf8df3c077.type','\"craft\\\\fields\\\\PlainText\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.columnSuffix','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.handle','\"singleVideo\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.instructions','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.name','\"Single Video\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.searchable','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.allowedKinds.0','\"video\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.allowSelfRelations','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.allowSubfolders','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.allowUploads','true'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.branchLimit','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.defaultUploadLocationSource','\"volume:542617dd-cf2a-41c4-9716-97fac95cd8f6\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.defaultUploadLocationSubpath','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.maintainHierarchy','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.maxRelations','1'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.minRelations','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.previewMode','\"full\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.restrictedDefaultUploadSubpath','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.restrictedLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.restrictedLocationSubpath','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.restrictFiles','true'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.restrictLocation','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.selectionLabel','\"Add a video\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.showCardsInGrid','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.showSiteMenu','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.showUnpermittedFiles','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.showUnpermittedVolumes','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.sources.0','\"volume:542617dd-cf2a-41c4-9716-97fac95cd8f6\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.targetSiteId','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.validateRelatedElements','false'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.settings.viewMode','\"large\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.translationKeyFormat','null'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.translationMethod','\"none\"'),('fields.d10f8d89-ce67-4b10-bbe3-42358861dbc1.type','\"craft\\\\fields\\\\Assets\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.columnSuffix','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.contentColumnType','\"string\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.handle','\"favicon\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.instructions','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.name','\"Favicon\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.searchable','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.allowedKinds.0','\"image\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.allowSelfRelations','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.allowSubfolders','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.allowUploads','true'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.branchLimit','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.defaultUploadLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.defaultUploadLocationSubpath','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.localizeRelations','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.maintainHierarchy','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.maxRelations','1'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.minRelations','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.previewMode','\"full\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.restrictedDefaultUploadSubpath','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.restrictedLocationSource','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.restrictedLocationSubpath','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.restrictFiles','true'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.restrictLocation','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.selectionLabel','\"Add a favicon\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.showSiteMenu','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.showUnpermittedFiles','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.showUnpermittedVolumes','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.sources.0','\"volume:4be4bc77-6721-4564-9441-605a1a6c0bad\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.targetSiteId','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.validateRelatedElements','false'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.settings.viewMode','\"list\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.translationKeyFormat','null'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.translationMethod','\"site\"'),('fields.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83.type','\"craft\\\\fields\\\\Assets\"'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.columnSuffix','\"rtpzqnhp\"'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.contentColumnType','\"text\"'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.handle','\"submissionMessage\"'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.instructions','null'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.name','\"Message\"'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.searchable','false'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.byteLimit','null'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.charLimit','null'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.code','false'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.columnType','null'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.initialRows','6'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.multiline','true'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.placeholder','null'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.settings.uiMode','\"normal\"'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.translationKeyFormat','null'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.translationMethod','\"none\"'),('fields.e17818c9-74b2-427e-9cf0-57f61d51b663.type','\"craft\\\\fields\\\\PlainText\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.columnSuffix','null'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.handle','\"mediaAlign\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.instructions','null'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.name','\"Media Align\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.searchable','false'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.customOptions','false'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.0.__assoc__.0.0','\"label\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.0.__assoc__.0.1','\"Left\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.0.__assoc__.1.0','\"value\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.0.__assoc__.1.1','\"left\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.0.__assoc__.2.0','\"default\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.0.__assoc__.2.1','\"1\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.1.__assoc__.0.0','\"label\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.1.__assoc__.0.1','\"Right\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.1.__assoc__.1.0','\"value\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.1.__assoc__.1.1','\"right\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.1.__assoc__.2.0','\"default\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.settings.options.1.__assoc__.2.1','\"\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.translationKeyFormat','null'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.translationMethod','\"none\"'),('fields.e253049a-7803-4ae2-9b10-fb60c6c591b8.type','\"craft\\\\fields\\\\Dropdown\"'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.columnSuffix','\"secazwrd\"'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.contentColumnType','\"text\"'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.handle','\"gigLocation\"'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.instructions','null'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.name','\"Location\"'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.searchable','false'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.byteLimit','null'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.charLimit','null'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.code','false'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.columnType','null'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.initialRows','4'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.multiline','false'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.placeholder','null'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.settings.uiMode','\"normal\"'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.translationKeyFormat','null'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.translationMethod','\"none\"'),('fields.e2acdefe-2270-4161-989c-4cacd80454da.type','\"craft\\\\fields\\\\PlainText\"'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.columnSuffix','null'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.handle','\"spaceBetween\"'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.instructions','null'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.name','\"Space Between\"'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.searchable','false'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.settings.defaultValue','10'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.settings.max','40'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.settings.min','2'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.settings.step','2'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.settings.suffix','\"pixels\"'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.translationKeyFormat','null'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.translationMethod','\"none\"'),('fields.e6988761-5603-46e0-8f9a-7ec7b54a0e3e.type','\"craft\\\\fields\\\\Range\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.columnSuffix','\"inugegzp\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.contentColumnType','\"text\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.handle','\"bandcampEmbed\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.instructions','\"Copy the Embed code from Bandcamp and paste it here ...\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.name','\"Bandcamp Embed\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.searchable','false'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.byteLimit','null'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.charLimit','null'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.code','false'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.columnType','null'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.initialRows','10'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.multiline','true'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.placeholder','\"Code goes here ...\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.settings.uiMode','\"normal\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.translationKeyFormat','null'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.translationMethod','\"none\"'),('fields.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06.type','\"craft\\\\fields\\\\PlainText\"'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.columnSuffix','\"siyosvvg\"'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.contentColumnType','\"text\"'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.handle','\"submissionPhone\"'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.instructions','null'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.name','\"Phone Number\"'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.searchable','false'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.byteLimit','null'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.charLimit','null'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.code','false'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.columnType','null'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.initialRows','4'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.multiline','false'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.placeholder','null'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.settings.uiMode','\"normal\"'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.translationKeyFormat','null'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.translationMethod','\"none\"'),('fields.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d.type','\"craft\\\\fields\\\\PlainText\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.columnSuffix','null'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.handle','\"pageSelect\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.instructions','null'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.name','\"Page Select\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.searchable','false'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.allowSelfRelations','false'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.branchLimit','null'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.maintainHierarchy','false'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.maxRelations','1'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.minRelations','null'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.selectionLabel','\"Add a page\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.showCardsInGrid','false'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.showSiteMenu','false'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.sources.0','\"section:d9c26beb-6bee-444c-b33f-13a168793722\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.sources.1','\"singles\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.targetSiteId','null'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.validateRelatedElements','false'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.settings.viewMode','\"list\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.translationKeyFormat','null'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.translationMethod','\"none\"'),('fields.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea.type','\"craft\\\\fields\\\\Entries\"'),('fs.localFilesystem.hasUrls','true'),('fs.localFilesystem.name','\"Local Filesystem\"'),('fs.localFilesystem.settings.path','\"imgs\"'),('fs.localFilesystem.type','\"craft\\\\fs\\\\Local\"'),('fs.localFilesystem.url','\"/imgs\"'),('fs.localTransforms.hasUrls','true'),('fs.localTransforms.name','\"Local Transforms\"'),('fs.localTransforms.settings.path','\"imgs/transforms\"'),('fs.localTransforms.type','\"craft\\\\fs\\\\Local\"'),('fs.localTransforms.url','\"/imgs/transforms\"'),('fs.videoFilesystem.hasUrls','true'),('fs.videoFilesystem.name','\"Video Filesystem\"'),('fs.videoFilesystem.settings.path','\"vids\"'),('fs.videoFilesystem.type','\"craft\\\\fs\\\\Local\"'),('fs.videoFilesystem.url','\"/vids\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elementCondition','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.0.dateAdded','\"2024-12-17T15:32:01+00:00\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.0.elementCondition','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.0.heading','\"Navigation Settings\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.0.uid','\"35f658d7-2d63-4079-b1b7-8ffee70ec203\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.0.userCondition','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.dateAdded','\"2024-12-17T15:42:36+00:00\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.elementCondition','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.fieldUid','\"186e3495-0405-4ef9-8b6a-13ea813ea449\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.handle','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.includeInCards','false'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.instructions','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.label','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.providesThumbs','false'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.required','false'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.tip','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.uid','\"b21157a3-3efc-42f6-8515-0897c09c344d\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.userCondition','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.warning','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.elements.1.width','100'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.name','\"Navigation Settings\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.uid','\"4b8af8d8-2cc9-47dd-80b5-7df1d539415a\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.fieldLayouts.30ebfe5c-9f2a-4441-b824-d086e91d839e.tabs.0.userCondition','null'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.handle','\"navigationSettings\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.name','\"Navigation Settings\"'),('globalSets.4b1a0293-717c-4678-95cd-9432e1a591c6.sortOrder','2'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elementCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.0.dateAdded','\"2024-12-17T15:28:07+00:00\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.0.elementCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.0.heading','\"Site Settings\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\Heading\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.0.uid','\"66a5705a-cde3-4ef9-b59e-e5b804664329\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.0.userCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.elementCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.fieldUid','\"a10d1b66-619c-4f4b-99c3-ad63094cbee2\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.handle','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.includeInCards','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.instructions','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.label','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.providesThumbs','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.required','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.tip','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.uid','\"ce516f33-2e70-405c-99a1-2d8d64bacc3d\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.userCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.warning','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.1.width','100'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.elementCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.fieldUid','\"dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.handle','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.includeInCards','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.instructions','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.label','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.providesThumbs','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.required','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.tip','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.uid','\"71169323-2209-4100-8975-7e9bb5a6d9d7\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.userCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.warning','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.2.width','100'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.dateAdded','\"2024-12-06T21:22:43+00:00\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.elementCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.fieldUid','\"9167b446-1840-45ea-8aa9-300e555b1344\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.handle','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.includeInCards','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.instructions','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.label','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.providesThumbs','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.required','false'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.tip','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.uid','\"c8c54e69-7104-493a-bd99-0e36b6428cac\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.userCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.warning','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.elements.3.width','100'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.name','\"Site Settings\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.uid','\"c0ed7fb0-9c7a-44ca-8762-26003b537f66\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.fieldLayouts.f894566f-5464-4b8d-8ad0-d61946bf5361.tabs.0.userCondition','null'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.handle','\"siteSettings\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.name','\"Site Settings\"'),('globalSets.4fa68a9e-b36c-4280-b726-dfd06429714e.sortOrder','1'),('graphql.publicToken.enabled','false'),('graphql.publicToken.expiryDate','null'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.fill','null'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.format','\"webp\"'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.handle','\"thumbnailSquare\"'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.height','250'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.interlace','\"none\"'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.mode','\"crop\"'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.name','\"Thumbnail Square\"'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.position','\"center-center\"'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.quality','60'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.upscale','true'),('imageTransforms.13e2d803-deff-4738-8c27-89c2d4424df7.width','250'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.fill','null'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.format','\"webp\"'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.handle','\"largewidth\"'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.height','null'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.interlace','\"none\"'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.mode','\"crop\"'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.name','\"Large Width\"'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.position','\"center-center\"'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.quality','100'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.upscale','true'),('imageTransforms.2615e6d4-c149-4539-851e-556e8843ba5f.width','800'),('meta.__names__.00f0f6fc-444a-4eb0-b660-fcbb5c85f41f','\"Grid Columns\"'),('meta.__names__.0b8cf1cf-11d8-41b8-ba67-59e6c2b12aa6','\"Gig Select\"'),('meta.__names__.139b20e8-6e1b-4e75-be7f-776bc8a50d43','\"Page Template\"'),('meta.__names__.13e2d803-deff-4738-8c27-89c2d4424df7','\"Thumbnail Square\"'),('meta.__names__.15fdb8d9-166a-4c6c-b61e-17cbec66abd1','\"Videos\"'),('meta.__names__.186e3495-0405-4ef9-8b6a-13ea813ea449','\"Navigation Links\"'),('meta.__names__.1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9','\"Bandcamp Embed\"'),('meta.__names__.21bf5ac9-a185-4970-b6dc-e66c96ef0807','\"YouTube Video ID\"'),('meta.__names__.2615e6d4-c149-4539-851e-556e8843ba5f','\"Large Width\"'),('meta.__names__.29495b4d-2d51-4bf0-8f60-535b022b411f','\"Padding Spacer\"'),('meta.__names__.299192bd-bbe9-4f2a-b1b4-b8f6f80905ef','\"Embed Select\"'),('meta.__names__.2e37ec0b-896a-4a3b-953f-59d7f5127a84','\"Embeds Module\"'),('meta.__names__.3879dbdd-7514-41f1-b0f8-cb825ab28546','\"YouTube Video\"'),('meta.__names__.3b374f35-1602-4985-917c-bd65649ca09e','\"Video Select\"'),('meta.__names__.44f5fc6a-9bb6-457e-99fd-d88a30b802f0','\"SoundCloud Embed\"'),('meta.__names__.46e12ab7-e122-464d-8364-4bfe2eefa5c3','\"Animation Effect\"'),('meta.__names__.4b1a0293-717c-4678-95cd-9432e1a591c6','\"Navigation Settings\"'),('meta.__names__.4be4bc77-6721-4564-9441-605a1a6c0bad','\"Local Images\"'),('meta.__names__.4fa68a9e-b36c-4280-b726-dfd06429714e','\"Site Settings\"'),('meta.__names__.542617dd-cf2a-41c4-9716-97fac95cd8f6','\"Local Videos\"'),('meta.__names__.57ee90df-01e6-437a-8c5c-38815877f909','\"Email Address\"'),('meta.__names__.643f413e-3181-4811-821a-4eb565329c16','\"Page Builder\"'),('meta.__names__.66d475d7-97b8-40dc-9212-f05ea6e23d4c','\"Gigs - Default\"'),('meta.__names__.71cf1bcb-d0f5-48f0-ab76-d9612c63f6a2','\"Lightswitch\"'),('meta.__names__.72dbefd4-129d-400a-8161-f80241c6cd51','\"Gigs Module\"'),('meta.__names__.76c85625-5e8e-4126-9f8f-6c15d50877ae','\"Rob Martino Music\"'),('meta.__names__.77d34c46-29a6-47a9-b5c4-8a7ffa61a10d','\"Single Image\"'),('meta.__names__.7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1','\"Custom Page\"'),('meta.__names__.825f4bb2-160e-43de-b9e1-179a555f48ec','\"Gigs\"'),('meta.__names__.82e690ff-8e29-4b0d-850d-c09a6cc8871f','\"Link\"'),('meta.__names__.844f6d9c-168f-4c8e-904a-202432cef59e','\"Rob Martino Music\"'),('meta.__names__.8506d742-5b2a-47fe-97d8-880505113629','\"Home\"'),('meta.__names__.8714d452-365e-4edd-ba97-237557f2207f','\"Video Thumbnail\"'),('meta.__names__.8f75a6ba-cffb-47c7-8031-e37daf2cdd33','\"Simple Toggle\"'),('meta.__names__.9167b446-1840-45ea-8aa9-300e555b1344','\"Client Email\"'),('meta.__names__.9200bcdf-7a8c-466f-97f5-f08080ac3d03','\"Autoplay Delay\"'),('meta.__names__.9529e1cb-135c-4e74-bd95-f62c6d2bc858','\"Spotify Embed\"'),('meta.__names__.962ca735-e2e0-4550-a295-93f517459468','\"Subject\"'),('meta.__names__.9acc1147-87aa-4431-a099-130a6abe949c','\"Spacer\"'),('meta.__names__.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4','\"Home\"'),('meta.__names__.9d2b7c77-acc5-4dba-8641-d02de2fbc1b6','\"Video Grid\"'),('meta.__names__.a10d1b66-619c-4f4b-99c3-ad63094cbee2','\"Site Logo\"'),('meta.__names__.ad2a34fc-908d-4a7e-b211-235d769602d3','\"Gallery Images\"'),('meta.__names__.afa92d21-9da5-4728-b388-676ab1b11c37','\"Featured Image\"'),('meta.__names__.b28163a8-205c-4838-ac55-20538571deaa','\"Color Picker\"'),('meta.__names__.b2893806-8044-42c4-967c-a961476b4c1c','\"Builder Page\"'),('meta.__names__.b61a32ce-4093-4b76-986a-5303ee05cc28','\"Name\"'),('meta.__names__.bb9b9ea2-bf37-44e0-be22-153bca5edd1b','\"Media & Form\"'),('meta.__names__.bc2fc90b-6d22-4a49-8fbd-a852acb9fdd1','\"Content Body (Simple)\"'),('meta.__names__.bced0888-a5a3-4f1f-b38c-6b52b005477d','\"Swiper Speed\"'),('meta.__names__.be2a1882-9121-4306-87b1-450de9d53256','\"SoundCloud Embed\"'),('meta.__names__.cd84622a-df79-4b5b-9d98-f9e7ed621fd0','\"General Content\"'),('meta.__names__.cf9cc357-e972-4534-96a3-16243a7d4e25','\"Date\"'),('meta.__names__.d036f92a-3e96-4a73-b959-e8cf8df3c077','\"Heading\"'),('meta.__names__.d10f8d89-ce67-4b10-bbe3-42358861dbc1','\"Single Video\"'),('meta.__names__.d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae','\"Gallery Page\"'),('meta.__names__.d9c26beb-6bee-444c-b33f-13a168793722','\"Pages\"'),('meta.__names__.dc9dbdd1-71b5-4b7e-8fc1-134104cb3a83','\"Favicon\"'),('meta.__names__.e01c47a5-80c5-41ea-9079-eb5d9c990ce4','\"Gallery\"'),('meta.__names__.e17818c9-74b2-427e-9cf0-57f61d51b663','\"Message\"'),('meta.__names__.e253049a-7803-4ae2-9b10-fb60c6c591b8','\"Media Align\"'),('meta.__names__.e2acdefe-2270-4161-989c-4cacd80454da','\"Location\"'),('meta.__names__.e2bfd84f-8706-44c0-8e7e-9a6ea6a1c465','\"Simple\"'),('meta.__names__.e6988761-5603-46e0-8f9a-7ec7b54a0e3e','\"Space Between\"'),('meta.__names__.e83e534b-ba3e-41e5-9e73-051db8c4b65b','\"Embeds\"'),('meta.__names__.e8fbb0cf-f013-47b2-8a71-e0aac50e9a06','\"Bandcamp Embed\"'),('meta.__names__.ea0ea7a1-4453-4b64-ac7c-c9b0d226ab5d','\"Phone Number\"'),('meta.__names__.ef1961c5-1e3c-4d3f-8f8e-b4ea3cfbed6e','\"Media & Content\"'),('meta.__names__.f03c2b0b-cfc0-4cb6-8b3a-940aed3e2bea','\"Page Select\"'),('meta.__names__.f494ab8a-02d3-48a3-bf69-103c6c96824c','\"Spotify Embed\"'),('plugins.ckeditor.edition','\"standard\"'),('plugins.ckeditor.enabled','true'),('plugins.ckeditor.schemaVersion','\"3.0.0.0\"'),('plugins.cp-css.edition','\"standard\"'),('plugins.cp-css.enabled','true'),('plugins.cp-css.schemaVersion','\"2.0.0\"'),('plugins.cp-css.settings.additionalCss','\":root {\\r\\n  --rob-darkblue: #283450;\\r\\n  --rob-light: #eeeeee;\\r\\n}\\r\\n\\r\\n.global-sidebar__header {\\r\\n  background-color: var(--rob-darkblue);\\r\\n  color: #fff;\\r\\n}\\r\\n\\r\\n.global-sidebar__header a#system-info:hover {\\r\\n  background-color: var(--rob-darkblue) !important;\\r\\n  color: var(--rob-light);\\r\\n}\\r\\n\\r\\na#system-info #site-icon svg g path {\\r\\n  fill: var(--rob-light);\\r\\n}\\r\\n\"'),('plugins.cp-css.settings.cacheBusting','true'),('plugins.cp-css.settings.cssFile','\"\"'),('plugins.freeform.edition','\"express\"'),('plugins.freeform.enabled','true'),('plugins.freeform.schemaVersion','\"5.4.2\"'),('plugins.freeform.settings.alertNotificationRecipients','null'),('plugins.freeform.settings.allowDashesInFieldHandles','false'),('plugins.freeform.settings.allowFileTemplateEdit','\"1\"'),('plugins.freeform.settings.autoScroll','true'),('plugins.freeform.settings.autoScrollToErrors','true'),('plugins.freeform.settings.badgeType','\"all\"'),('plugins.freeform.settings.blockedEmails','null'),('plugins.freeform.settings.blockedEmailsError','\"Invalid Email Address\"'),('plugins.freeform.settings.blockedIpAddresses','null'),('plugins.freeform.settings.blockedKeywords','null'),('plugins.freeform.settings.blockedKeywordsError','\"Invalid Entry Data\"'),('plugins.freeform.settings.bypassSpamCheckOnLoggedInUsers','false'),('plugins.freeform.settings.clientDigestFrequency','1'),('plugins.freeform.settings.clientDigestRecipients','null'),('plugins.freeform.settings.defaultFromEmail','\"{{ craft.app.projectConfig.get(\'email.fromEmail\') }}\"'),('plugins.freeform.settings.defaultFromName','\"{{ craft.app.projectConfig.get(\'email.fromName\') }}\"'),('plugins.freeform.settings.defaults.__assoc__.0.0','\"previewHtml\"'),('plugins.freeform.settings.defaults.__assoc__.0.1','true'),('plugins.freeform.settings.defaults.__assoc__.1.0','\"twigInHtml\"'),('plugins.freeform.settings.defaults.__assoc__.1.1','true'),('plugins.freeform.settings.defaults.__assoc__.2.0','\"twigIsolation\"'),('plugins.freeform.settings.defaults.__assoc__.2.1','true'),('plugins.freeform.settings.defaults.__assoc__.3.0','\"includeSampleTemplates\"'),('plugins.freeform.settings.defaults.__assoc__.3.1','true'),('plugins.freeform.settings.defaults.__assoc__.4.0','\"notifications\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.0.0','\"admin\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.0.1.__assoc__.0.0','\"template\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.0.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.0.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.0.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.0.1.__assoc__.0.1.__assoc__.1.1','\"\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.1.0','\"conditional\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.1.1.__assoc__.0.0','\"template\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.1.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.1.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.1.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.1.1.__assoc__.0.1.__assoc__.1.1','\"\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.2.0','\"userSelect\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.2.1.__assoc__.0.0','\"template\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.2.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.2.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.2.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.2.1.__assoc__.0.1.__assoc__.1.1','\"\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.3.0','\"emailField\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.3.1.__assoc__.0.0','\"template\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.3.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.3.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.3.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.4.1.__assoc__.3.1.__assoc__.0.1.__assoc__.1.1','\"\"'),('plugins.freeform.settings.defaults.__assoc__.5.0','\"settings\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.0','\"general\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.0.0','\"formType\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.0.1.__assoc__.1.1','\"Solspace\\\\Freeform\\\\Form\\\\Types\\\\Regular\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.1.0','\"submissionTitle\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.1.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.1.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.1.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.1.1.__assoc__.1.1','\"{{ dateCreated|date(\\\"Y-m-d H:i:s\\\") }}\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.2.0','\"formattingTemplate\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.2.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.2.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.2.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.0.1.__assoc__.2.1.__assoc__.1.1','\"basic-light/index.twig\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.0','\"dataStorage\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.0.0','\"storeData\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.0.1.__assoc__.1.1','\"1\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.1.0','\"defaultStatus\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.1.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.1.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.1.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.1.1.__assoc__.1.1','\"2\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.2.0','\"collectIp\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.2.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.2.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.2.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.1.1.__assoc__.2.1.__assoc__.1.1','\"1\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.0','\"processing\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.0.0','\"ajax\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.0.1.__assoc__.1.1','\"1\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.1.0','\"showIndicator\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.1.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.1.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.1.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.1.1.__assoc__.1.1','\"1\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.2.0','\"showText\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.2.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.2.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.2.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.2.1.__assoc__.1.1','\"1\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.3.0','\"processingText\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.3.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.3.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.3.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.2.1.__assoc__.3.1.__assoc__.1.1','\"Processing...\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.0','\"successAndErrors\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.0.0','\"successBehavior\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.0.1.__assoc__.1.1','\"reload\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.1.0','\"returnUrl\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.1.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.1.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.1.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.1.1.__assoc__.1.1','\"\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.2.0','\"successTemplate\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.2.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.2.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.2.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.2.1.__assoc__.1.1','\"\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.3.0','\"successMessage\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.3.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.3.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.3.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.3.1.__assoc__.1.1','\"Form has been submitted successfully!\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.4.0','\"errorMessage\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.4.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.4.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.4.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.3.1.__assoc__.4.1.__assoc__.1.1','\"Sorry, there was an error submitting the form. Please try again.\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.4.0','\"limits\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.4.1.__assoc__.0.0','\"duplicateCheck\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.4.1.__assoc__.0.1.__assoc__.0.0','\"locked\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.4.1.__assoc__.0.1.__assoc__.0.1','false'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.4.1.__assoc__.0.1.__assoc__.1.0','\"value\"'),('plugins.freeform.settings.defaults.__assoc__.5.1.__assoc__.4.1.__assoc__.0.1.__assoc__.1.1','\"no_limit\"'),('plugins.freeform.settings.defaultView','\"forms\"'),('plugins.freeform.settings.digestFrequency','1'),('plugins.freeform.settings.digestOnlyOnProduction','false'),('plugins.freeform.settings.digestRecipients','null'),('plugins.freeform.settings.displayFeed','true'),('plugins.freeform.settings.emailTemplateDefault','\"database\"'),('plugins.freeform.settings.emailTemplateDirectory','\"\"'),('plugins.freeform.settings.emailTemplateStorageType','\"files_database\"'),('plugins.freeform.settings.exportHandlesAsNames','false'),('plugins.freeform.settings.exportLabels','false'),('plugins.freeform.settings.fillWithGet','false'),('plugins.freeform.settings.footerScripts','false'),('plugins.freeform.settings.formattingTemplate','\"basic-light/index.twig\"'),('plugins.freeform.settings.formFieldShowOnlyAllowedForms','false'),('plugins.freeform.settings.formSubmitDisable','true'),('plugins.freeform.settings.formSubmitExpiration','null'),('plugins.freeform.settings.formTemplateDirectory','\"\"'),('plugins.freeform.settings.minimumSubmitTime','null'),('plugins.freeform.settings.pluginName','null'),('plugins.freeform.settings.purgableSpamAgeInDays','null'),('plugins.freeform.settings.purgableSubmissionAgeInDays','null'),('plugins.freeform.settings.purgableUnfinalizedAssetAgeInMinutes','180'),('plugins.freeform.settings.queuePriority','null'),('plugins.freeform.settings.rememberPageSubmitOrder','true'),('plugins.freeform.settings.removeNewlines','false'),('plugins.freeform.settings.renderFormHtmlInCpViews','true'),('plugins.freeform.settings.saveFormSessionLimit','10'),('plugins.freeform.settings.saveFormTtl','30'),('plugins.freeform.settings.scriptInsertLocation','\"footer\"'),('plugins.freeform.settings.scriptInsertType','\"files\"'),('plugins.freeform.settings.sessionContext','\"payload\"'),('plugins.freeform.settings.sessionContextCount','100'),('plugins.freeform.settings.sessionContextSecret','\"\"'),('plugins.freeform.settings.sessionContextTimeToLiveMinutes','180'),('plugins.freeform.settings.sessionEntryMaxCount','50'),('plugins.freeform.settings.sessionEntryTTL','10800'),('plugins.freeform.settings.showErrorsForBlockedEmails','false'),('plugins.freeform.settings.showErrorsForBlockedKeywords','false'),('plugins.freeform.settings.sitesEnabled','false'),('plugins.freeform.settings.spamFolderEnabled','true'),('plugins.freeform.settings.spamProtectionBehavior','\"simulate_success\"'),('plugins.freeform.settings.submissionThrottlingCount','null'),('plugins.freeform.settings.submissionThrottlingTimeFrame','null'),('plugins.freeform.settings.successTemplateDirectory','\"\"'),('plugins.freeform.settings.updateSearchIndexes','true'),('plugins.freeform.settings.useQueueForEmailNotifications','false'),('plugins.freeform.settings.useQueueForIntegrations','false'),('plugins.google-recaptcha.edition','\"standard\"'),('plugins.google-recaptcha.enabled','false'),('plugins.google-recaptcha.schemaVersion','\"1.0.0\"'),('plugins.google-recaptcha.settings.actionName','\"contactpage\"'),('plugins.google-recaptcha.settings.actions','\"\"'),('plugins.google-recaptcha.settings.badge','\"bottomright\"'),('plugins.google-recaptcha.settings.scoreThreshold','\"0.5\"'),('plugins.google-recaptcha.settings.secretKey','\"$RECAPTCHA_SECRET_KEY\"'),('plugins.google-recaptcha.settings.siteKey','\"$RECAPTCHA_SITE_KEY\"'),('plugins.google-recaptcha.settings.size','\"normal\"'),('plugins.google-recaptcha.settings.theme','\"light\"'),('plugins.google-recaptcha.settings.version','\"3\"'),('routes.05c70d77-3ee1-4cb8-9297-1b1cd425767d.siteUid','null'),('routes.05c70d77-3ee1-4cb8-9297-1b1cd425767d.sortOrder','3'),('routes.05c70d77-3ee1-4cb8-9297-1b1cd425767d.template','\"tailwindtests/test-layouts\"'),('routes.05c70d77-3ee1-4cb8-9297-1b1cd425767d.uriParts.0','\"test-layouts\"'),('routes.05c70d77-3ee1-4cb8-9297-1b1cd425767d.uriPattern','\"test-layouts\"'),('routes.4639a494-6efa-4af9-88d5-a98e1f2e770c.siteUid','null'),('routes.4639a494-6efa-4af9-88d5-a98e1f2e770c.sortOrder','7'),('routes.4639a494-6efa-4af9-88d5-a98e1f2e770c.template','\"tailwindtests/test-styleguide\"'),('routes.4639a494-6efa-4af9-88d5-a98e1f2e770c.uriParts.0','\"test-styleguide\"'),('routes.4639a494-6efa-4af9-88d5-a98e1f2e770c.uriPattern','\"test-styleguide\"'),('routes.4b1d4eeb-1e99-4b5c-adea-af6e266c60c4.siteUid','null'),('routes.4b1d4eeb-1e99-4b5c-adea-af6e266c60c4.sortOrder','1'),('routes.4b1d4eeb-1e99-4b5c-adea-af6e266c60c4.template','\"tailwindtests/test-flex\"'),('routes.4b1d4eeb-1e99-4b5c-adea-af6e266c60c4.uriParts.0','\"test-flex\"'),('routes.4b1d4eeb-1e99-4b5c-adea-af6e266c60c4.uriPattern','\"test-flex\"'),('routes.7e9603e6-cd7e-45ec-97a4-cdd7d26aebe2.siteUid','null'),('routes.7e9603e6-cd7e-45ec-97a4-cdd7d26aebe2.sortOrder','4'),('routes.7e9603e6-cd7e-45ec-97a4-cdd7d26aebe2.template','\"tailwindtests/test-borders\"'),('routes.7e9603e6-cd7e-45ec-97a4-cdd7d26aebe2.uriParts.0','\"test-borders\"'),('routes.7e9603e6-cd7e-45ec-97a4-cdd7d26aebe2.uriPattern','\"test-borders\"'),('routes.b834f5fc-dc98-4f31-bb7c-aee59e45ed8e.siteUid','null'),('routes.b834f5fc-dc98-4f31-bb7c-aee59e45ed8e.sortOrder','6'),('routes.b834f5fc-dc98-4f31-bb7c-aee59e45ed8e.template','\"tailwindtests/test-animations\"'),('routes.b834f5fc-dc98-4f31-bb7c-aee59e45ed8e.uriParts.0','\"test-animations\"'),('routes.b834f5fc-dc98-4f31-bb7c-aee59e45ed8e.uriPattern','\"test-animations\"'),('routes.b8ddf362-bb3d-4216-bb3e-b0940b74f36b.siteUid','null'),('routes.b8ddf362-bb3d-4216-bb3e-b0940b74f36b.sortOrder','8'),('routes.b8ddf362-bb3d-4216-bb3e-b0940b74f36b.template','\"tailwindtests/test-darkmode\"'),('routes.b8ddf362-bb3d-4216-bb3e-b0940b74f36b.uriParts.0','\"test-darkmode\"'),('routes.b8ddf362-bb3d-4216-bb3e-b0940b74f36b.uriPattern','\"test-darkmode\"'),('routes.c75a9634-6a95-45bb-b9fc-87f9a003abee.siteUid','null'),('routes.c75a9634-6a95-45bb-b9fc-87f9a003abee.sortOrder','5'),('routes.c75a9634-6a95-45bb-b9fc-87f9a003abee.template','\"tailwindtests/test-effects-filters\"'),('routes.c75a9634-6a95-45bb-b9fc-87f9a003abee.uriParts.0','\"test-effects-filters\"'),('routes.c75a9634-6a95-45bb-b9fc-87f9a003abee.uriPattern','\"test-effects-filters\"'),('routes.ebfaa07f-5ed0-4894-9ccc-a4c9659498a9.siteUid','null'),('routes.ebfaa07f-5ed0-4894-9ccc-a4c9659498a9.sortOrder','2'),('routes.ebfaa07f-5ed0-4894-9ccc-a4c9659498a9.template','\"tailwindtests/test-grid\"'),('routes.ebfaa07f-5ed0-4894-9ccc-a4c9659498a9.uriParts.0','\"test-grid\"'),('routes.ebfaa07f-5ed0-4894-9ccc-a4c9659498a9.uriPattern','\"test-grid\"'),('routes.fed82de6-cfcd-4727-ae9d-2a7018878bc1.siteUid','null'),('routes.fed82de6-cfcd-4727-ae9d-2a7018878bc1.sortOrder','9'),('routes.fed82de6-cfcd-4727-ae9d-2a7018878bc1.template','\"tailwindtests/test-home\"'),('routes.fed82de6-cfcd-4727-ae9d-2a7018878bc1.uriParts.0','\"test-home\"'),('routes.fed82de6-cfcd-4727-ae9d-2a7018878bc1.uriPattern','\"test-home\"'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.defaultPlacement','\"end\"'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.enableVersioning','true'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.entryTypes.0','\"3879dbdd-7514-41f1-b0f8-cb825ab28546\"'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.handle','\"videos\"'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.maxAuthors','1'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.name','\"Videos\"'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.propagationMethod','\"all\"'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.enabledByDefault','true'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.hasUrls','false'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.template','null'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.uriFormat','null'),('sections.15fdb8d9-166a-4c6c-b61e-17cbec66abd1.type','\"channel\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.defaultPlacement','\"end\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.enableVersioning','false'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.entryTypes.0','\"66d475d7-97b8-40dc-9212-f05ea6e23d4c\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.handle','\"gigs\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.maxAuthors','1'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.name','\"Gigs\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.previewTargets.0.__assoc__.0.0','\"label\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.previewTargets.0.__assoc__.0.1','\"Primary entry page\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.previewTargets.0.__assoc__.1.0','\"urlFormat\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.previewTargets.0.__assoc__.1.1','\"{url}\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.propagationMethod','\"all\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.enabledByDefault','true'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.hasUrls','true'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.template','null'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.uriFormat','\"gigs/{slug}\"'),('sections.825f4bb2-160e-43de-b9e1-179a555f48ec.type','\"channel\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.defaultPlacement','\"end\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.enableVersioning','false'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.entryTypes.0','\"8506d742-5b2a-47fe-97d8-880505113629\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.handle','\"home\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.maxAuthors','1'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.name','\"Home\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.previewTargets.0.__assoc__.0.0','\"label\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.previewTargets.0.__assoc__.0.1','\"Primary entry page\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.previewTargets.0.__assoc__.1.0','\"urlFormat\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.previewTargets.0.__assoc__.1.1','\"{url}\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.propagationMethod','\"all\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.enabledByDefault','true'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.hasUrls','true'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.template','\"home\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.uriFormat','\"__home__\"'),('sections.9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4.type','\"single\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.defaultPlacement','\"beginning\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.enableVersioning','true'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.entryTypes.0','\"b2893806-8044-42c4-967c-a961476b4c1c\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.entryTypes.1','\"d9a1cab9-8fb1-45aa-be80-4a16b5d5a3ae\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.entryTypes.2','\"7a3aa4ab-1d46-43c7-b592-2aaa13c4e1d1\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.handle','\"pages\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.maxAuthors','1'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.name','\"Pages\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.previewTargets.0.__assoc__.0.0','\"label\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.previewTargets.0.__assoc__.0.1','\"Primary entry page\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.previewTargets.0.__assoc__.1.0','\"urlFormat\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.previewTargets.0.__assoc__.1.1','\"{url}\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.previewTargets.0.__assoc__.2.0','\"refresh\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.previewTargets.0.__assoc__.2.1','\"1\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.propagationMethod','\"all\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.enabledByDefault','true'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.hasUrls','true'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.template','\"_pages/_base\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.uriFormat','\"{slug}\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.structure.maxLevels','1'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.structure.uid','\"60678798-1b32-434e-b9a3-375d854aafe7\"'),('sections.d9c26beb-6bee-444c-b33f-13a168793722.type','\"structure\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.defaultPlacement','\"end\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.enableVersioning','false'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.entryTypes.0','\"1ba6b8f5-1f13-4f16-8dd0-f90db9e050f9\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.entryTypes.1','\"44f5fc6a-9bb6-457e-99fd-d88a30b802f0\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.entryTypes.2','\"f494ab8a-02d3-48a3-bf69-103c6c96824c\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.handle','\"embeds\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.maxAuthors','1'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.name','\"Embeds\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.propagationMethod','\"all\"'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.enabledByDefault','true'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.hasUrls','false'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.template','null'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.siteSettings.844f6d9c-168f-4c8e-904a-202432cef59e.uriFormat','null'),('sections.e83e534b-ba3e-41e5-9e73-051db8c4b65b.type','\"channel\"'),('siteGroups.76c85625-5e8e-4126-9f8f-6c15d50877ae.name','\"Rob Martino Music\"'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.baseUrl','\"$PRIMARY_SITE_URL\"'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.enabled','true'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.handle','\"default\"'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.hasUrls','true'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.language','\"en\"'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.name','\"Rob Martino Music\"'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.primary','true'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.siteGroup','\"76c85625-5e8e-4126-9f8f-6c15d50877ae\"'),('sites.844f6d9c-168f-4c8e-904a-202432cef59e.sortOrder','1'),('system.edition','\"solo\"'),('system.live','true'),('system.name','\"Rob Martino Music\"'),('system.schemaVersion','\"5.7.0.3\"'),('system.timeZone','\"America/Los_Angeles\"'),('users.allowPublicRegistration','false'),('users.defaultGroup','null'),('users.photoSubpath','null'),('users.photoVolumeUid','null'),('users.requireEmailVerification','true'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elementCondition','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.autocapitalize','true'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.autocomplete','false'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.autocorrect','true'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.class','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.disabled','false'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.elementCondition','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.id','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.inputType','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.instructions','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.label','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.max','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.min','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.name','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.orientation','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.placeholder','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.readonly','false'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.requirable','false'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.size','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.step','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.tip','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.title','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\assets\\\\AssetTitleField\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.uid','\"f278b982-ac20-4918-ac40-1849d642bb11\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.userCondition','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.warning','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.elements.0.width','100'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.name','\"Content\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.uid','\"feee6ad3-4eb1-45da-99bf-88c9fe87c140\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fieldLayouts.d30ad1d2-d72e-47f0-b630-a60820c3ddb2.tabs.0.userCondition','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.fs','\"localFilesystem\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.handle','\"localImages\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.name','\"Local Images\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.sortOrder','1'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.titleTranslationKeyFormat','null'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.titleTranslationMethod','\"site\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.transformFs','\"localTransforms\"'),('volumes.4be4bc77-6721-4564-9441-605a1a6c0bad.transformSubpath','\"\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elementCondition','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.autocapitalize','true'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.autocomplete','false'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.autocorrect','true'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.class','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.disabled','false'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.elementCondition','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.id','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.inputType','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.instructions','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.label','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.max','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.min','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.name','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.orientation','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.placeholder','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.readonly','false'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.requirable','false'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.size','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.step','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.tip','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.title','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\assets\\\\AssetTitleField\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.uid','\"b1e1be8c-0a34-4ab5-b928-12be7d716ef3\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.userCondition','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.warning','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.elements.0.width','100'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.name','\"Content\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.uid','\"36b29584-0e2c-44aa-9183-9125ce17a094\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fieldLayouts.4631d292-bafd-4363-a467-9e79d10e2b83.tabs.0.userCondition','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.fs','\"videoFilesystem\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.handle','\"localVideos\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.name','\"Local Videos\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.sortOrder','2'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.titleTranslationKeyFormat','null'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.titleTranslationMethod','\"site\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.transformFs','\"\"'),('volumes.542617dd-cf2a-41c4-9716-97fac95cd8f6.transformSubpath','\"\"');
/*!40000 ALTER TABLE `projectconfig` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `queue`
--

LOCK TABLES `queue` WRITE;
/*!40000 ALTER TABLE `queue` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `queue` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `recoverycodes`
--

LOCK TABLES `recoverycodes` WRITE;
/*!40000 ALTER TABLE `recoverycodes` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `recoverycodes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `relations`
--

LOCK TABLES `relations` WRITE;
/*!40000 ALTER TABLE `relations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `relations` VALUES (9,4,25,NULL,9,1,'2023-06-11 23:07:20','2023-06-11 23:07:20','e6d7423a-affb-4eca-b361-17debc3cf83a'),(10,4,25,NULL,12,2,'2023-06-11 23:07:20','2023-06-11 23:07:20','7ceb8210-8903-4d79-a988-b5d37910f76a'),(11,4,25,NULL,6,3,'2023-06-11 23:07:20','2023-06-11 23:07:20','32fff671-2f8f-4a49-9195-48e1645fc68b'),(12,4,25,NULL,10,4,'2023-06-11 23:07:20','2023-06-11 23:07:20','81cf9a30-b284-429f-97bd-b6d0c2bc460b'),(13,4,25,NULL,11,5,'2023-06-11 23:07:20','2023-06-11 23:07:20','d033c311-1820-4d46-90bc-3eb7abaa5c63'),(14,4,25,NULL,13,6,'2023-06-11 23:07:20','2023-06-11 23:07:20','b9f32400-5e1a-463e-98da-442195de4b23'),(26,4,51,NULL,9,1,'2023-06-12 18:58:07','2023-06-12 18:58:07','c0bc799b-a58a-41d4-829d-1ff6e701b211'),(27,4,51,NULL,12,2,'2023-06-12 18:58:07','2023-06-12 18:58:07','84490d9c-180a-4c45-bbc7-aa06d5a7609c'),(28,4,51,NULL,6,3,'2023-06-12 18:58:07','2023-06-12 18:58:07','cb571b2d-b3fd-44f6-a1af-331a044c3686'),(29,4,51,NULL,49,4,'2023-06-12 18:58:07','2023-06-12 18:58:07','67b01db8-bcf4-4b01-873d-6f85d80792bc'),(30,4,51,NULL,10,5,'2023-06-12 18:58:07','2023-06-12 18:58:07','32bcc900-96ea-4e4d-929b-722b6aa74384'),(31,4,51,NULL,11,6,'2023-06-12 18:58:07','2023-06-12 18:58:07','d4525f54-737d-4358-97b6-1ac3e982d39f'),(32,4,51,NULL,48,7,'2023-06-12 18:58:07','2023-06-12 18:58:07','0792cb40-924d-4d06-8ea0-858d6c96c24c'),(33,4,51,NULL,13,8,'2023-06-12 18:58:07','2023-06-12 18:58:07','3580b8ac-cca5-4333-a816-24cc7d55bc44'),(35,30,1,NULL,17,1,'2024-12-23 16:55:42','2024-12-23 16:55:42','f7db0aef-29ee-4b33-9e33-b523276aa93b'),(37,37,86,NULL,15,1,'2024-12-23 17:06:30','2024-12-23 17:06:30','6e6d3bec-f049-48da-91bc-939c6c4c3c94'),(38,37,88,NULL,15,1,'2024-12-23 17:06:30','2024-12-23 17:06:30','1313a940-47d8-4cef-8d6e-5342d57ee4ef'),(40,37,92,NULL,15,1,'2024-12-23 17:07:38','2024-12-23 17:07:38','79dee66e-09d2-4740-bf5b-445604c62aba'),(46,28,95,NULL,32,1,'2024-12-23 17:08:55','2024-12-23 17:08:55','8b6d379e-d866-472d-bb67-5b2f44b24a86'),(47,28,95,NULL,31,2,'2024-12-23 17:08:55','2024-12-23 17:08:55','583a9c19-9946-4b07-aadb-acdf5417c337'),(48,28,95,NULL,28,3,'2024-12-23 17:08:55','2024-12-23 17:08:55','9daf8a3c-66a8-4f2d-b80e-78e71ff4f610'),(49,28,95,NULL,30,4,'2024-12-23 17:08:55','2024-12-23 17:08:55','c5167c94-9561-4e1b-abc2-3e57c144599f'),(50,28,95,NULL,29,5,'2024-12-23 17:08:55','2024-12-23 17:08:55','78451490-67ba-44df-85d9-8e23bb5d0461'),(51,28,97,NULL,32,1,'2024-12-23 17:08:55','2024-12-23 17:08:55','2b512639-a76e-46f4-a8cb-b649b21cda97'),(52,28,97,NULL,31,2,'2024-12-23 17:08:55','2024-12-23 17:08:55','26ffeeca-b4d8-4300-b187-39c2a37f7a33'),(53,28,97,NULL,28,3,'2024-12-23 17:08:55','2024-12-23 17:08:55','6530d43f-1e0e-4b51-b547-e6097a682597'),(54,28,97,NULL,30,4,'2024-12-23 17:08:55','2024-12-23 17:08:55','2f8624cf-90ea-474b-b5bf-2af62d0df73a'),(55,28,97,NULL,29,5,'2024-12-23 17:08:55','2024-12-23 17:08:55','ad2298dd-2ef7-4c8e-97cd-3d9e7d2af748'),(56,26,82,NULL,18,1,'2024-12-23 17:09:39','2024-12-23 17:09:39','edb8d2dd-8aea-4667-9d88-2441c8bc0c48'),(57,26,82,NULL,20,2,'2024-12-23 17:09:39','2024-12-23 17:09:39','b9c70839-c6e9-413d-815b-098308127293'),(58,26,82,NULL,22,3,'2024-12-23 17:09:39','2024-12-23 17:09:39','30fc985c-9303-4cf7-ae52-4dfeae291830'),(59,26,82,NULL,24,4,'2024-12-23 17:09:39','2024-12-23 17:09:39','0892374f-bc84-4d03-a2e3-d6c56faf7be1'),(60,26,82,NULL,26,5,'2024-12-23 17:09:39','2024-12-23 17:09:39','47d8cefc-b5a9-4f13-8c02-28cd6e4cc109'),(65,27,102,NULL,41,1,'2024-12-23 17:11:06','2024-12-23 17:11:06','3f47833b-5d4c-4f55-9a96-e77824b47ead'),(66,27,102,NULL,39,2,'2024-12-23 17:11:06','2024-12-23 17:11:06','38777589-99db-45e7-b24b-4a333a76e5c8'),(67,27,102,NULL,35,3,'2024-12-23 17:11:06','2024-12-23 17:11:06','1a82169d-868e-4b4f-8b99-152e402a4259'),(68,27,102,NULL,33,4,'2024-12-23 17:11:06','2024-12-23 17:11:06','51bfc2f4-e68d-41e0-b3a2-f9e65e9a9605'),(69,27,105,NULL,41,1,'2024-12-23 17:11:06','2024-12-23 17:11:06','1e6d0fe4-b98b-446e-abe9-247b5076903b'),(70,27,105,NULL,39,2,'2024-12-23 17:11:06','2024-12-23 17:11:06','3596629c-0a7b-48a4-b9ae-888747c5fa62'),(71,27,105,NULL,35,3,'2024-12-23 17:11:06','2024-12-23 17:11:06','47725b8a-723a-4f74-a229-e6586c425ca6'),(72,27,105,NULL,33,4,'2024-12-23 17:11:06','2024-12-23 17:11:06','e0b53b62-c9ec-4ddc-9ce9-7a1aeded9d6f'),(74,31,41,NULL,114,1,'2024-12-23 17:21:24','2024-12-23 17:21:24','e779638a-02f9-4ee6-a459-8585cad799ac'),(75,31,116,NULL,114,1,'2024-12-23 17:21:24','2024-12-23 17:21:24','2cbc93ce-297d-41d2-a9dc-1cc3e6d1ef1a'),(77,31,39,NULL,117,1,'2024-12-23 17:21:36','2024-12-23 17:21:36','819983a1-1c1d-4bc2-8c23-898abc056b70'),(78,31,119,NULL,117,1,'2024-12-23 17:21:36','2024-12-23 17:21:36','a5f355c3-ea3d-44f6-aef8-19cf1670f072'),(80,31,35,NULL,120,1,'2024-12-23 17:21:47','2024-12-23 17:21:47','2392e30a-21b9-4bad-a3e7-ea2fbdbf4521'),(81,31,122,NULL,120,1,'2024-12-23 17:21:47','2024-12-23 17:21:47','429d95b6-6619-456f-89f3-faf2b3de43a6'),(83,31,33,NULL,123,1,'2024-12-23 17:21:56','2024-12-23 17:21:56','7ef3bf36-4437-4a22-affd-cdc3e418ecf0'),(84,31,125,NULL,123,1,'2024-12-23 17:21:56','2024-12-23 17:21:56','e780692b-d733-45be-a9dd-04f87e53f00f'),(86,37,128,NULL,7,1,'2024-12-23 17:24:00','2024-12-23 17:24:00','ad059b7a-fbd6-41e9-a449-577ceb30c439'),(87,37,130,NULL,7,1,'2024-12-23 17:24:01','2024-12-23 17:24:01','8f48dcd8-1d3b-4869-9ebc-d7021ca6dd3d'),(104,4,142,NULL,9,1,'2024-12-23 17:28:05','2024-12-23 17:28:05','8206bbda-581e-4a58-9c5e-e021f4c7a9ef'),(105,4,142,NULL,12,2,'2024-12-23 17:28:05','2024-12-23 17:28:05','eeb62672-c7cc-436a-aa5e-cb058ca36171'),(106,4,142,NULL,6,3,'2024-12-23 17:28:05','2024-12-23 17:28:05','c9d9fdfe-ba07-4f3e-9799-006b226c76e2'),(107,4,142,NULL,49,4,'2024-12-23 17:28:05','2024-12-23 17:28:05','99f6d802-ded3-4c7d-8742-7150ffa0637d'),(108,4,142,NULL,10,5,'2024-12-23 17:28:05','2024-12-23 17:28:05','de291836-74bb-4cfe-b5f4-cbbff74e3b1f'),(109,4,142,NULL,11,6,'2024-12-23 17:28:05','2024-12-23 17:28:05','b6e6d4ec-8676-44a2-ba58-ec4c00fac54a'),(110,4,142,NULL,48,7,'2024-12-23 17:28:05','2024-12-23 17:28:05','ffb761d6-e226-4d0c-9f67-e0522bfa3713'),(111,4,142,NULL,13,8,'2024-12-23 17:28:05','2024-12-23 17:28:05','2b4ca726-21a8-41bf-bc62-78e3d05f6b4f'),(112,4,144,NULL,9,1,'2024-12-23 17:28:05','2024-12-23 17:28:05','9ee28e51-c1ee-4754-a576-60ab56c31efa'),(113,4,144,NULL,12,2,'2024-12-23 17:28:05','2024-12-23 17:28:05','4afc5691-d5e4-4fc5-a3e8-0ea95731cf94'),(114,4,144,NULL,6,3,'2024-12-23 17:28:05','2024-12-23 17:28:05','ed9dec41-ec24-41a7-8e9a-9a349b0aed33'),(115,4,144,NULL,49,4,'2024-12-23 17:28:05','2024-12-23 17:28:05','ac6ca2d1-00f0-4ebb-9510-506487d9c0f7'),(116,4,144,NULL,10,5,'2024-12-23 17:28:05','2024-12-23 17:28:05','976b8f6a-a8a5-4374-a8ff-adcc7a943e29'),(117,4,144,NULL,11,6,'2024-12-23 17:28:05','2024-12-23 17:28:05','08bcff48-e6f7-4678-b984-7fa06f14671c'),(118,4,144,NULL,48,7,'2024-12-23 17:28:05','2024-12-23 17:28:05','c087e414-01fd-41fe-973f-8bb4f4e076a4'),(119,4,144,NULL,13,8,'2024-12-23 17:28:05','2024-12-23 17:28:05','3856f4dc-4c89-4d53-8eec-fd71c07e7a4d'),(128,4,148,NULL,9,1,'2024-12-23 17:29:11','2024-12-23 17:29:11','b37d2587-365d-4d03-a888-cfdb9d7cf1e4'),(129,4,148,NULL,12,2,'2024-12-23 17:29:11','2024-12-23 17:29:11','68c27f01-24fb-4703-8515-5bf282509c15'),(130,4,148,NULL,6,3,'2024-12-23 17:29:11','2024-12-23 17:29:11','09ca9270-bd57-4319-84aa-9fdc12b5cbd7'),(131,4,148,NULL,49,4,'2024-12-23 17:29:11','2024-12-23 17:29:11','364b8933-ab73-4c4e-aec2-8081f378252d'),(132,4,148,NULL,10,5,'2024-12-23 17:29:11','2024-12-23 17:29:11','580ec281-4fd1-4fff-a3a9-95e63a1663dd'),(133,4,148,NULL,11,6,'2024-12-23 17:29:11','2024-12-23 17:29:11','cfa17a30-aaf9-49d4-9d45-d6294c28b6eb'),(134,4,148,NULL,48,7,'2024-12-23 17:29:11','2024-12-23 17:29:11','d6caa789-4603-471b-a650-f0cf4a1da385'),(135,4,148,NULL,13,8,'2024-12-23 17:29:11','2024-12-23 17:29:11','a893a719-eea5-452c-b2cb-37133fb4888c'),(140,10,2,NULL,201,1,'2025-05-02 16:14:24','2025-05-02 16:14:24','c7d01dd9-1169-42b5-868e-184ccbef037c'),(141,3,2,NULL,202,1,'2025-05-02 16:14:24','2025-05-02 16:14:24','b30aa51c-0b14-4b44-97dc-2cfd8c9e5272');
/*!40000 ALTER TABLE `relations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `revisions` VALUES (1,18,3,1,''),(2,20,3,1,''),(3,22,3,1,''),(4,24,3,1,''),(5,26,3,1,''),(6,33,3,1,''),(7,35,3,1,''),(8,37,3,1,''),(9,39,3,1,''),(10,41,3,1,''),(11,24,3,2,'Applied “Draft 1”'),(12,26,3,2,'Applied “Draft 1”'),(13,86,3,1,NULL),(14,26,3,3,'Applied “Draft 1”'),(15,86,3,2,NULL),(16,22,3,2,'Applied “Draft 1”'),(17,95,3,1,NULL),(18,20,3,2,'Applied “Draft 1”'),(19,101,3,1,NULL),(20,102,3,1,NULL),(21,41,3,2,'Applied “Draft 1”'),(22,39,3,2,'Applied “Draft 1”'),(23,35,3,2,'Applied “Draft 1”'),(24,33,3,2,'Applied “Draft 1”'),(25,18,3,2,'Applied “Draft 1”'),(26,128,3,1,NULL),(27,18,3,3,'Applied “Draft 1”'),(28,133,3,1,NULL),(29,18,3,4,'Applied “Draft 1”'),(30,133,3,2,NULL),(31,24,3,3,'Applied “Draft 1”'),(32,142,3,1,NULL),(33,24,3,4,'Applied “Draft 1”'),(34,142,3,2,NULL);
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `searchindex`
--

LOCK TABLES `searchindex` WRITE;
/*!40000 ALTER TABLE `searchindex` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `searchindex` VALUES (1,'slug',0,1,' home '),(1,'title',0,1,' home '),(2,'slug',0,1,''),(3,'email',0,1,' jsudimak302 gmail com '),(3,'firstname',0,1,''),(3,'fullname',0,1,''),(3,'lastname',0,1,''),(3,'slug',0,1,''),(3,'username',0,1,' jsudimak '),(4,'alt',0,1,''),(4,'extension',0,1,' png '),(4,'filename',0,1,' hobbe logo png '),(4,'kind',0,1,' image '),(4,'slug',0,1,''),(4,'title',0,1,' hobbe logo '),(6,'alt',0,1,''),(6,'extension',0,1,' jpg '),(6,'filename',0,1,' 8static dominos jpg '),(6,'kind',0,1,' image '),(6,'slug',0,1,''),(6,'title',0,1,' 8static dominos '),(7,'alt',0,1,''),(7,'extension',0,1,' jpg '),(7,'filename',0,1,' about jpg '),(7,'kind',0,1,' image '),(7,'slug',0,1,''),(7,'title',0,1,' about '),(8,'alt',0,1,''),(8,'extension',0,1,' jpg '),(8,'filename',0,1,' bitgen jpg '),(8,'kind',0,1,' image '),(8,'slug',0,1,''),(8,'title',0,1,' bitgen '),(9,'alt',0,1,''),(9,'extension',0,1,' jpg '),(9,'filename',0,1,' gallery 1 jpg '),(9,'kind',0,1,' image '),(9,'slug',0,1,''),(9,'title',0,1,' gallery 1 '),(10,'alt',0,1,''),(10,'extension',0,1,' jpg '),(10,'filename',0,1,' gallery 2 jpg '),(10,'kind',0,1,' image '),(10,'slug',0,1,''),(10,'title',0,1,' gallery 2 '),(11,'alt',0,1,''),(11,'extension',0,1,' jpg '),(11,'filename',0,1,' gallery 3 jpg '),(11,'kind',0,1,' image '),(11,'slug',0,1,''),(11,'title',0,1,' gallery 3 '),(12,'alt',0,1,''),(12,'extension',0,1,' jpg '),(12,'filename',0,1,' gallery 6 jpg '),(12,'kind',0,1,' image '),(12,'slug',0,1,''),(12,'title',0,1,' gallery 6 '),(13,'alt',0,1,''),(13,'extension',0,1,' jpg '),(13,'filename',0,1,' gallery 7 jpg '),(13,'kind',0,1,' image '),(13,'slug',0,1,''),(13,'title',0,1,' gallery 7 '),(14,'alt',0,1,''),(14,'extension',0,1,' jpg '),(14,'filename',0,1,' home bg mobile jpg '),(14,'kind',0,1,' image '),(14,'slug',0,1,''),(14,'title',0,1,' home bg mobile '),(15,'alt',0,1,''),(15,'extension',0,1,' jpg '),(15,'filename',0,1,' sentry bar feb2020 alt jpg '),(15,'kind',0,1,' image '),(15,'slug',0,1,''),(15,'title',0,1,' sentry bar feb2020 alt '),(16,'alt',0,1,''),(16,'extension',0,1,' jpg '),(16,'filename',0,1,' sentry bar feb2020 jpg '),(16,'kind',0,1,' image '),(16,'slug',0,1,''),(16,'title',0,1,' sentry bar feb2020 '),(17,'alt',0,1,''),(17,'extension',0,1,' mp4 '),(17,'filename',0,1,' rob video mp4 '),(17,'kind',0,1,' video '),(17,'slug',0,1,''),(17,'title',0,1,' rob video '),(18,'slug',0,1,' about '),(18,'title',0,1,' about '),(20,'slug',0,1,' live '),(20,'title',0,1,' live '),(22,'slug',0,1,' listen '),(22,'title',0,1,' listen '),(24,'slug',0,1,' gallery '),(24,'title',0,1,' gallery '),(26,'slug',0,1,' contact '),(26,'title',0,1,' contact '),(28,'slug',0,1,' craggy rabbit '),(28,'title',0,1,' craggy rabbit '),(29,'slug',0,1,' nmlstyl fourtitude band version '),(29,'title',0,1,' nmlstyl fourtitude band version '),(30,'slug',0,1,' valentines day lottery '),(30,'title',0,1,' valentines day lottery '),(31,'slug',0,1,' nmlstyl s t spotify '),(31,'title',0,1,' nmlstyl s t spotify '),(32,'slug',0,1,' speed of three paradox '),(32,'title',0,1,' speed of three paradox '),(33,'slug',0,1,' 110 percent mysterious travelers '),(33,'title',0,1,' 110 percent mysterious travelers '),(35,'slug',0,1,' black monday mysterious travelers '),(35,'title',0,1,' black monday mysterious travelers '),(37,'slug',0,1,' the overtime mcgill chamber jazz orchestra 2019 '),(37,'title',0,1,' the overtime mcgill chamber jazz orchestra 2019 '),(39,'slug',0,1,' infinitaves nmlstyl magfest 2020 '),(39,'title',0,1,' infinitaves nmlstyl magfest 2020 '),(41,'slug',0,1,' nmlstyl bitgen xiii full set '),(41,'title',0,1,' nmlstyl bitgen xiii full set '),(48,'alt',0,1,''),(48,'extension',0,1,' jpg '),(48,'filename',0,1,' drums blue jpg '),(48,'kind',0,1,' image '),(48,'slug',0,1,''),(48,'title',0,1,' drums blue '),(49,'alt',0,1,''),(49,'extension',0,1,' jpg '),(49,'filename',0,1,' nmlstyl jpg '),(49,'kind',0,1,' image '),(49,'slug',0,1,''),(49,'title',0,1,' nmlstyl '),(82,'slug',0,1,''),(86,'slug',0,1,' contact '),(86,'title',0,1,' contact '),(95,'slug',0,1,' embeds '),(95,'title',0,1,' embeds '),(101,'slug',0,1,' upcoming gigs '),(101,'title',0,1,' upcoming gigs '),(102,'slug',0,1,' videos '),(102,'title',0,1,' videos '),(114,'alt',0,1,''),(114,'extension',0,1,' jpg '),(114,'filename',0,1,' nmlstyl bitgen13 jpg '),(114,'kind',0,1,' image '),(114,'slug',0,1,''),(114,'title',0,1,' nmlstyl bitgen13 '),(117,'alt',0,1,''),(117,'extension',0,1,' jpg '),(117,'filename',0,1,' nmlstyl magfest2020 jpg '),(117,'kind',0,1,' image '),(117,'slug',0,1,''),(117,'title',0,1,' nmlstyl magfest2020 '),(120,'alt',0,1,''),(120,'extension',0,1,' jpg '),(120,'filename',0,1,' black monday jpg '),(120,'kind',0,1,' image '),(120,'slug',0,1,''),(120,'title',0,1,' black monday '),(123,'alt',0,1,''),(123,'extension',0,1,' jpg '),(123,'filename',0,1,' 110percent jpg '),(123,'kind',0,1,' image '),(123,'slug',0,1,''),(123,'title',0,1,' 110percent '),(128,'slug',0,1,' temp czklqsvrjkusygouvtqvcscsjiriclpsylwj '),(128,'title',0,1,''),(133,'slug',0,1,' temp ebhrszhslredkrpkuolcxlowaojtfidtbety '),(133,'title',0,1,''),(142,'slug',0,1,' temp cjdotupksogqdkxjsqpktajhayvxkxjgjblc '),(142,'title',0,1,''),(149,'emailaddress',0,1,' ericjonesmyemail gmail com '),(149,'fullname',0,1,' eric '),(149,'html',0,1,''),(149,'message',0,1,' hi robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https boltleadgeneration com for a live demo now plus now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https boltleadgeneration com to discover what leadconnect can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try leadconnect and get more leads now eric ps the studies show 7 out of 10 visitors dont hang around you cant afford to lose them leadconnect offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try leadconnect now we are committed to protecting your privacy and providing a safe high quality online experience for our visitors we understand that you care about how the information you provide to us is used and shared we have developed a privacy policy to inform you of our policies about the collection use and disclosure of information we receive from users of our website we operate the website our privacy policy along with our terms conditions governs your use of this site by using the website or by accepting the terms of use via opt in checkbox pop up or clicking an email link confirming the same you agree to be bound by our terms conditions and our privacy policy if you have provided any voluntarily given information you may review and make changes to it via instructions found on the website to manage your receipt of marketing and non transactional communications you may want to receive fewer emails or none whatsoever update your email preferences emails related to orders are provided automatically customers are not able to opt out of these we will try to address any requests related to the management of personal information in a timely manner however it may not always be possible to fully remove or modify information in our databases if we have a valid reason to keep it for certain timeframes if you have any questions simply see our website to view our official policies our primary goal is to help you with lead generation these emails are meant to give you advice on that topic or to promote products that will help you have the kind of business films are written about if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(149,'slug',0,1,''),(149,'subject',0,1,' who needs eyeballs you need business '),(149,'title',0,1,' 2024 12 25 09 56 26 '),(150,'emailaddress',0,1,' ericjonesmyemail gmail com '),(150,'fullname',0,1,' eric '),(150,'html',0,1,''),(150,'message',0,1,' hello to the robmartinomusic owner i am eric and i recently came across your website at robmartinomusic i found it after a search so your visibility seems to be working well your content looks helpful however one thing might be missing a simple prompt way for visitors to connect with you research suggests that many visitors leave a site quickly without providing any contact information once they go theres no way to follow up consider this approach web visitors into leads is a tool that operates on your site ready to gather each visitors name email address and phone number you will know as soon as someone shows interest allowing you to speak with them while theyre still viewing your site view a demonstration https actionleadgeneration com once you have their phone number you can also begin a text conversation if they arent ready to engage at that exact moment you can maintain communication later by sharing additional updates or simply checking in everything described is straightforward to implement and may help improve your interactions with potential contacts please visit https actionleadgeneration com to learn more about what web visitors into leads can do for you it could help you connect with more interested individuals right now eric p s web visitors into leads includes a trial period and supports international communication there may be individuals ready to speak with you now so please dont miss the opportunity visit https actionleadgeneration com to learn more just a note the names and email used here eric and jones are placeholders and not actual contact details we value transparency and want you to be aware if you wish to connect with the person behind this message please visit our website and we will put you in touch with the appropriate individual ================================================== we are committed to protecting your privacy and maintaining a positive online experience we understand that you care about how your information is used and shared we have developed a privacy policy to explain our guidelines for handling information we receive from users of our website we operate this website our privacy policy along with our terms conditions governs your use of this site by using the website or by confirming acceptance of the terms of use you agree to follow both our terms conditions and our privacy policy if you have provided information voluntarily you may review and update it following the instructions on our website to manage certain communications you may unsubscribe using the link at the bottom of marketing emails transaction related emails are not optional we will do our best to handle any requests related to personal information promptly although complete removal may not always be possible due to certain requirements if you have any questions please review our official policies on our website our goal is to help you enhance the effectiveness of your lead generation efforts these emails offer guidance on that topic or introduce tools that may support your initiatives if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(150,'slug',0,1,''),(150,'subject',0,1,' turn surf surf surf into talk talk talk '),(150,'title',0,1,' 2024 12 28 10 45 41 '),(151,'emailaddress',0,1,' ericjonesmyemail gmail com '),(151,'fullname',0,1,' eric '),(151,'html',0,1,''),(151,'message',0,1,' hello to the robmartinomusic owner this is eric and i noticed robmartinomusic a short time ago it appears well structured now what what i mean is when someone like me discovers your website either through a search or just browsing around what happens next are you receiving meaningful inquiries from your site or enough to meet your needs honestly most business websites come up a bit short when it comes to attracting engaged visitors research indicates that 70% of a sites visitors leave and never return after only a moment here is an idea what about making it simple for each visitor who arrives to receive a direct phone call from you as soon as they reach your site this is possible web visitors into leads is a tool that operates on your site designed to collect each visitors name email address and phone number it notifies you the moment they indicate interest so that you can speak to that person while they are browsing your site please visit https actionleadgeneration com to view a live demonstration of web visitors into leads and understand how it operates you will notice a significant difference between connecting with someone within 5 minutes compared to a half hour or more later this can greatly improve the likelihood of meaningful engagement it becomes even more helpful after you have their phone number with our sms text communication feature you can promptly begin a text conversation that way even if you do not reach a conclusion immediately you can stay connected through text messages for informational updates content links or simple check in notes to establish a relationship quite helpful please visit https actionleadgeneration com to learn how web visitors into leads can support your business you can potentially connect with many more interested individuals as soon as possible eric ps web visitors into leads provides a no cost 14 day evaluation period it also supports international communication there are interested individuals ready to speak with you now so please do not delay please visit https actionleadgeneration com to explore web visitors into leads just a brief note the name and email used here eric and jones are placeholders and not real contact information we value transparency and wanted to ensure youre aware if you wish to get in touch with the individual behind this message please visit our website and we will connect you with the appropriate person ================================================== we are committed to protecting your privacy and providing a safe high quality online experience we understand that you care about how your information is used and shared we have developed a privacy policy to inform you of our guidelines regarding the collection use and disclosure of information received from users of our website we operate this website our privacy policy along with our terms conditions governs your use of this site by using the website or by accepting the terms of use you agree to be bound by our terms conditions and our privacy policy if you have provided information voluntarily you may review and make changes to it by following the instructions found on the website to manage marketing and non transactional communications you may unsubscribe by clicking the link at the bottom of any marketing email order related emails are sent automatically and cannot be opted out of we will do our best to address requests related to managing personal information in a timely manner however it may not always be possible to remove or modify data if certain retention requirements apply if you have any questions please visit our website to view our official policies our primary goal is to help you achieve strong results in lead generation these emails are intended to offer guidance on that topic or to introduce resources that may strengthen your outreach if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(151,'slug',0,1,''),(151,'subject',0,1,' your site more leads '),(151,'title',0,1,' 2024 12 30 23 15 51 '),(152,'emailaddress',0,1,' ericjonesmyemail gmail com '),(152,'fullname',0,1,' eric '),(152,'html',0,1,''),(152,'message',0,1,' hi robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https boltleadgeneration com for a live demo now plus now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https boltleadgeneration com to discover what leadconnect can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try leadconnect and get more leads now eric ps the studies show 7 out of 10 visitors dont hang around you cant afford to lose them leadconnect offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try leadconnect now we are committed to protecting your privacy and providing a safe high quality online experience for our visitors we understand that you care about how the information you provide to us is used and shared we have developed a privacy policy to inform you of our policies about the collection use and disclosure of information we receive from users of our website we operate the website our privacy policy along with our terms conditions governs your use of this site by using the website or by accepting the terms of use via opt in checkbox pop up or clicking an email link confirming the same you agree to be bound by our terms conditions and our privacy policy if you have provided any voluntarily given information you may review and make changes to it via instructions found on the website to manage your receipt of marketing and non transactional communications you may want to receive fewer emails or none whatsoever update your email preferences emails related to orders are provided automatically customers are not able to opt out of these we will try to address any requests related to the management of personal information in a timely manner however it may not always be possible to fully remove or modify information in our databases if we have a valid reason to keep it for certain timeframes if you have any questions simply see our website to view our official policies our primary goal is to help you with lead generation these emails are meant to give you advice on that topic or to promote products that will help you have the kind of business films are written about if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(152,'slug',0,1,''),(152,'subject',0,1,' who needs eyeballs you need business '),(152,'title',0,1,' 2025 01 02 19 28 43 '),(153,'emailaddress',0,1,' ericjonesmyemail gmail com '),(153,'fullname',0,1,' eric '),(153,'html',0,1,''),(153,'message',0,1,' hello robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https resultleadgeneration com for a live demo now and now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how are you doing notes to build a relationship https resultleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps studies show that 70% of a sites visitors disappear and are gone forever after just a moment dont keep losing them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(153,'slug',0,1,''),(153,'subject',0,1,' who needs eyeballs you need business '),(153,'title',0,1,' 2025 01 16 02 55 55 '),(154,'emailaddress',0,1,' ericjonesmyemail gmail com '),(154,'fullname',0,1,' eric '),(154,'html',0,1,''),(154,'message',0,1,' hello robmartinomusic im eric and i recently discovered your website robmartinomusic in the search results this is what that means to me your seos working youre receiving eyeballs at least mine your contents pretty good would not change a thing but eyeballs do not pay the bills customers do pay the bills and studies show that 7 out of 10 visitors like robmartinomusic will drop by have a look and then leave without doing anything else its like they never even were there you can fix this you can make it extremely easy for them to show interest say okay lets talk without needing them to even pull their phone from their pocket thanks to web visitors into leads web visitors into leads is a software widget that sits on your website ready and waiting to capture any visitors name email address and phone number it allows you know immediately so you can speak with that lead immediately before they leave please visit the following url to experience a live demo with web visitors into leads now to see precisely how it works and even give it a try it could be huge for your business https trustedleadgeneration com time is of the essence when it comes to connecting with leads the difference between contacting someone within 5 minutes compared to 30 minutes implies you can be converting up to 100x more leads now moreover now that youve got their phone number with our new sms text with lead feature you can instantly start a text sms conversation immediately which is so effective because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later the new text messaging feature lets you follow up frequently with new offers content links even just follow up notes to develop a relationship everything ive just described is very easy to implement cost effective and beneficial please visit the following url to discover what web visitors into leads can do for your business possibly converting up to 100x more visitors into leads today https trustedleadgeneration com eric ps web visitors into leads offers a free 14 days trial it even includes international long distance calling paying customers are waiting start connecting today by visiting https trustedleadgeneration com to try web visitors into leads now if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(154,'slug',0,1,''),(154,'subject',0,1,' who needs eyeballs you need business '),(154,'title',0,1,' 2025 01 16 12 57 50 '),(155,'emailaddress',0,1,' ericjonesmyemail gmail com '),(155,'fullname',0,1,' eric '),(155,'html',0,1,''),(155,'message',0,1,' hello to the robmartinomusic manager i am eric and im thinking you would like your website robmartinomusic to produce additional inquiries here is one approach web visitors into leads is a tool that operates on your site prepared to capture each visitors name email and phone number it informs you as soon as someone expresses interest allowing you to speak with them while they are still viewing robmartinomusic view a demonstration https actionleadgeneration com to see how web visitors into leads works once you have their phone number our new sms text with lead feature allows you to start a text conversation you can answer questions provide more details and even finalize a connection that way if they are not ready at that moment you can follow up later with text messages that share updated information helpful links or simply keep the dialogue open to establish a positive rapport learn more https actionleadgeneration com to understand how web visitors into leads can support your business potentially engaging many more interested individuals eric p s studies suggest that most visitors leave quickly this resource offers a 14 day evaluation period and also includes international communication support there may be individuals ready to speak with you now so please dont let the opportunity pass if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(155,'slug',0,1,''),(155,'subject',0,1,' try this get more leads '),(155,'title',0,1,' 2025 01 17 08 27 50 '),(156,'emailaddress',0,1,' dulhunty carmela outlook com '),(156,'fullname',0,1,' carmela '),(156,'html',0,1,''),(156,'message',0,1,' did you know theres a better way to deliver affiliate marketing campaigns with our service you can send your message directly to website contact forms stop worrying about policies contact me at the details below if youd like to explore this further regards carmela dulhunty email carmela dulhunty morebiz my website http xcdsv4 formblastmarketing top '),(156,'slug',0,1,''),(156,'subject',0,1,' seeking information '),(156,'title',0,1,' 2025 01 24 18 12 52 '),(157,'emailaddress',0,1,' ericjonesmyemail gmail com '),(157,'fullname',0,1,' eric '),(157,'html',0,1,''),(157,'message',0,1,' hello robmartinomusic owner my names eric and for just a second imagine this someone does a search and winds up at robmartinomusic they hang out for a minute to check it out im interested but maybe and then they hit the back button and check out the other search results instead bottom line you got an eyeball but nothing else to show for it there they go this isnt really your fault it happens a lot studies show 7 out of 10 visitors to any site disappear without leaving a trace but you can fix that leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number youll know right then and there enabling you to call that lead while theyre literally looking over your site visit https boltleadgeneration com to try out a live demo with leadconnect now to see exactly how it works time is money when it comes to connecting with leads the difference between contacting someone within 5 minutes versus 30 minutes later can be huge like 100 times better plus now that you have their phone number with our new sms text with lead feature you can automatically start a text sms conversation so even if you dont close a deal then you can follow up with text messages for new offers content links even just how you doing notes to build a relationship strong stuff visit https boltleadgeneration com to discover what leadconnect can do for your business you could be converting up to 100x more leads today eric ps leadconnect offers a complimentary 14 day trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting visit https boltleadgeneration com to try leadconnect now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(157,'slug',0,1,''),(157,'subject',0,1,' there they go '),(157,'title',0,1,' 2025 01 29 12 59 54 '),(158,'emailaddress',0,1,' ericjonesmyemail gmail com '),(158,'fullname',0,1,' eric '),(158,'html',0,1,''),(158,'message',0,1,' hello robmartinomusic im eric and i recently discovered your website robmartinomusic in the search results this is what that signifies to me your seos working youre receiving eyeballs at least mine your contents pretty good would not change a thing but eyeballs do not pay the bills customers do pay the bills and studies indicate that 7 out of 10 visitors to robmartinomusic will drop by have a look and then leave without doing anything else its like they never even were there you can fix this you can make it extremely easy for them to show interest say okay lets talk without needing them to even pull their phone from their pocket thanks to web visitors into leads web visitors into leads is a software widget that sits on your website prepared and waiting to capture any visitors name email address and phone number it allows you to know immediately so you can speak with that lead immediately before they leave click here https trustedleadgeneration com to try out a live demo with web visitors into leads now to see precisely how it works and even give it a try it could be huge for your business youll be astonished the difference between contacting someone within 5 minutes versus a half hour or more later could boost your results 100 fold it gets even better once youve captured their phone number with our new sms text with lead feature you can instantly start a text sms conversation immediately which is so effective because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later the new text messaging feature lets you follow up frequently with new offers content links even just follow up notes to develop a relationship pretty sweet and effective goto https trustedleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps web visitors into leads offers a free 14 days trial it even includes international long distance calling paying customers are waiting start connecting today by visiting https trustedleadgeneration com to try web visitors into leads now if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(158,'slug',0,1,''),(158,'subject',0,1,' your site more leads '),(158,'title',0,1,' 2025 01 31 00 42 58 '),(159,'emailaddress',0,1,' ericjonesmyemail gmail com '),(159,'fullname',0,1,' eric '),(159,'html',0,1,''),(159,'message',0,1,' hello robmartinomusic owner my names eric and for just a second imagine this someone does a search and winds up at robmartinomusic they hang out for a minute to check it out im interested but maybe and then they hit the back button and check out the other search results instead bottom line you got an eyeball but nothing else to show for it there they go this isnt really your fault it happens a lot studies show 7 out of 10 visitors to any site disappear without leaving a trace but you can fix that web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it lets you know right then and there enabling you to call that lead while theyre literally looking over your site https resultleadgeneration com to try out a live demo with web visitors into leads now to see exactly how it works time is money when it comes to connecting with leads the difference between contacting someone within 5 minutes versus 30 minutes later can be huge like 100 times better plus now that you have their phone number with our new sms text with lead feature you can automatically start a text sms conversation so even if you dont close a deal then you can follow up with text messages for new offers content links even just how you doing notes to build a relationship strong stuff https resultleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps studies show that 70% of a sites visitors disappear and are gone forever after just a moment dont keep losing them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(159,'slug',0,1,''),(159,'subject',0,1,' there they go '),(159,'title',0,1,' 2025 01 31 00 56 43 '),(160,'emailaddress',0,1,' ericjonesmyemail gmail com '),(160,'fullname',0,1,' eric '),(160,'html',0,1,''),(160,'message',0,1,' hello to the robmartinomusic owner great website my names eric and i just found your site robmartinomusic when browsing the net you showed up on the top of the search engine results so i checked you out seems like what youre doing is really interesting but if you dont mind me asking after someone like me lands across robmartinomusic what usually happens is your site generating leads for your business im guessing some but i also guess youd like more research show that 7 out of 10 people that land on a site end up leaving without any interaction thats unfortunate here is an idea what if theres a simple way for each visitor to signal interest to get a phone call from you immediately the moment they visit your site and said call me now you can web visitors into leads is a tool that works on your site ready to capture every visitors name email address and phone number it allows you to know immediately so that you can talk to that lead while theyre actually browsing your site go to https actionleadgeneration com to check out a live demo with web visitors into leads today to see exactly how it works time is essential when it comes to engaging with leads the difference between contacting someone within 5 minutes compared to 30 minutes later is significant like 100 times more effective thats why we created our new sms text with lead feature because once youve collected the visitors phone number you can automatically start a text message conversation consider the opportunities even if you dont close a deal right away you can stay connected with text messages for new offers content links or even just a quick how are you doing note to establish a relationship wouldnt that be helpful go to https actionleadgeneration com to find out what web visitors into leads can offer for your business you could be converting up to 100x more leads today eric ps web visitors into leads provides a complimentary 14 day trial and it even includes international calling you have customers waiting to talk with you right now dont leave them waiting go to https actionleadgeneration com to try web visitors into leads today if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(160,'slug',0,1,''),(160,'subject',0,1,' cool website '),(160,'title',0,1,' 2025 02 04 00 53 55 '),(161,'emailaddress',0,1,' ericjonesmyemail gmail com '),(161,'fullname',0,1,' eric '),(161,'html',0,1,''),(161,'message',0,1,' hello robmartinomusic owner eric here with a quick thought about your website robmartinomusic im on the internet a lot and i look at a lot of business websites like yours many of them have great content but all too often they come up short when it comes to engaging and connecting with anyone who visits i get it its hard studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace you got the eyeball but nothing else heres a solution for you leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them while theyre literally checking out robmartinomusic https boltleadgeneration com to try out a live demo with web visitors into leads now to see exactly how it works it could be a game changer for your business and because youve got that phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is extremely simple to implement cost effective and profitable https boltleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps web visitors into leads offers a complimentary 14 day trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try web visitors into leads now if youd like to want to receive less emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(161,'slug',0,1,''),(161,'subject',0,1,' how to turn eyeballs into phone calls '),(161,'title',0,1,' 2025 02 04 21 25 10 '),(162,'emailaddress',0,1,' ericjonesmyemail gmail com '),(162,'fullname',0,1,' eric '),(162,'html',0,1,''),(162,'message',0,1,' hello to the robmartinomusic owner this is eric here with a brief note about your website robmartinomusic i am on the internet often and i see many business websites similar to yours several of them have excellent content however too often they fall short when it comes to interacting and connecting with a visitor i understand it is challenging research shows that many individuals who arrive at a site leave within moments without sharing any details you gained their initial attention but nothing else here is a possible solution web visitors into leads is a tool that operates on your site prepared to collect each visitors name email address and phone number you will know right away that they are interested and you could speak with them while they are still online viewing your site please visit https actionleadgeneration com to view a live demo with web visitors into leads today to see exactly how it operates it can be significant for your business and because you have their phone number with our sms text with lead capability you can instantly begin a text conversation connecting with someone in those first minutes is far more effective than waiting longer additionally with text messaging you may follow up later with new updates content links or simple notes to keep the conversation moving everything described is straightforward to implement cost effective and genuinely helpful please visit https actionleadgeneration com to learn what web visitors into leads can provide for your business you can be engaging with more visitors as we speak eric p s web visitors into leads provides a 14 day evaluation and it includes international calling you have individuals who may be ready to speak with you now so please do not delay please visit https actionleadgeneration com to view web visitors into leads today if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(162,'slug',0,1,''),(162,'subject',0,1,' how to turn eyeballs into phone calls '),(162,'title',0,1,' 2025 02 05 14 54 44 '),(163,'emailaddress',0,1,' vinhgrowth gmail com '),(163,'fullname',0,1,' lori '),(163,'html',0,1,''),(163,'message',0,1,' hi we run a youtube growth service which increases your number of subscribers both safety and practically we guarantee to gain you new 700 subscribers per month people subscribe because they are interested in your videos channel increasing video likes comments and interaction all actions are made manually by our team we do not use any bots the price is just $60 usd per month and we can start immediately if you are interested and would like to see some of our previous work let me know and we can discuss further kind regards to unsubscribe reply with the word unsubscribe in the subject '),(163,'slug',0,1,''),(163,'subject',0,1,' youtube promotion grow your subscribers by 700 each month '),(163,'title',0,1,' 2025 02 14 03 18 31 '),(164,'emailaddress',0,1,' ericjonesmyemail gmail com '),(164,'fullname',0,1,' eric '),(164,'html',0,1,''),(164,'message',0,1,' hi robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https boltleadgeneration com for a live demo now plus now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https boltleadgeneration com to discover what leadconnect can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try leadconnect and get more leads now eric ps the studies show 7 out of 10 visitors dont hang around you cant afford to lose them leadconnect offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try leadconnect now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(164,'slug',0,1,''),(164,'subject',0,1,' who needs eyeballs you need business '),(164,'title',0,1,' 2025 02 18 13 54 34 '),(165,'emailaddress',0,1,' ericjonesmyemail gmail com '),(165,'fullname',0,1,' eric '),(165,'html',0,1,''),(165,'message',0,1,' hello eric here with a quick thought about your website robmartinomusic cool website my names eric and i just found your site robmartinomusic while surfing the net you showed up at the top of the search results so i checked you out looks like what youre doing is pretty cool but if you dont mind me asking after someone like me stumbles across robmartinomusic what usually happens is your site generating leads for your business im guessing some but i also bet youd like more studies show that 7 out of 10 who land on a site wind up leaving without a trace not good heres a thought how about making it really easy for every visitor who shows up to get a personal phone call from you as soon as they hit your site you can web visitor is a software widget that works on your site ready to capture any visitors name email address and phone number it lets you know immediately so that you can talk to that lead while theyre literally looking over your site https resultleadgeneration com to try out a live demo with web visitor now to see exactly how it works youll be amazed the difference between contacting someone within 5 minutes versus a half hour or more later could increase your results 100 fold it gets even better once youve captured their phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is simple easy and effective https resultleadgeneration com to discover what web visitor can do for your business potentially converting up to 100x more eyeballs into leads today eric ps web visitor offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitor now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(165,'slug',0,1,''),(165,'subject',0,1,' how to turn eyeballs into phone calls '),(165,'title',0,1,' 2025 02 19 10 27 16 '),(166,'emailaddress',0,1,' nnniixiinnn gmail com '),(166,'fullname',0,1,' xin ni '),(166,'html',0,1,''),(166,'message',0,1,' hi rob this is xin from logans party it was a wonderful conversation with you my number is 267 626 8773 same as whatsapp lets keep in touch thanks again for your encouragement btw i found a postcard flyer of arsnova in the drawer today lol definitely will go solar myth one day '),(166,'slug',0,1,''),(166,'subject',0,1,' hi '),(166,'title',0,1,' 2025 02 20 19 04 15 '),(167,'emailaddress',0,1,' ericjonesmyemail gmail com '),(167,'fullname',0,1,' eric '),(167,'html',0,1,''),(167,'message',0,1,' hello robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https resultleadgeneration com for a live demo now and now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how are you doing notes to build a relationship https resultleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps studies show that 70% of a sites visitors disappear and are gone forever after just a moment dont keep losing them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(167,'slug',0,1,''),(167,'subject',0,1,' who needs eyeballs you need business '),(167,'title',0,1,' 2025 02 22 14 56 10 '),(168,'emailaddress',0,1,' ericjonesmyemail gmail com '),(168,'fullname',0,1,' eric '),(168,'html',0,1,''),(168,'message',0,1,' hello robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https resultleadgeneration com for a live demo now and now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https resultleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps studies show that 70% of a sites visitors disappear and are gone forever after just a moment dont keep losing them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(168,'slug',0,1,''),(168,'subject',0,1,' try this get more leads '),(168,'title',0,1,' 2025 02 23 02 55 10 '),(169,'emailaddress',0,1,' ericjonesmyemail gmail com '),(169,'fullname',0,1,' eric '),(169,'html',0,1,''),(169,'message',0,1,' hello robmartinomusic owner my name is eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https boltleadgeneration com for a live demo now plus now that youve got their phone number with our new sms text with lead feature you can automatically start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https boltleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps the studies show 7 out of 10 visitors dont hang around you cant afford to lose them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(169,'slug',0,1,''),(169,'subject',0,1,' try this get more leads '),(169,'title',0,1,' 2025 02 24 10 57 07 '),(170,'emailaddress',0,1,' ericjonesmyemail gmail com '),(170,'fullname',0,1,' eric '),(170,'html',0,1,''),(170,'message',0,1,' hello robmartinomusic i just found your site quick question my names eric and i just found your site robmartinomusic while surfing the net you showed up at the top of the search results so i checked you out looks like what youre doing is pretty cool but if you dont mind me asking after someone like me stumbles across robmartinomusic what usually happens is your site generating leads for your business im guessing some but i also bet youd like more research indicates that 7 out of 10 who land on a site wind up leaving without a trace not good heres a thought what if there was an easy way for every visitor to raise their hand to get a phone call from you instantly the second they hit your site and said call me now you can web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it notifies you immediately so that you can speak to that lead while theyre actively looking over your site goto https boltleadgeneration com to try out a live demo with web visitors into leads now to see precisely how it works time is money when it comes to connecting with leads the difference between contacting someone within 5 minutes versus 30 minutes later is huge like 100 times better thats why we built out our new sms text with lead feature because once youve captured the visitors phone number you can automatically start a text message sms conversation think about the possibilities even if you dont close a deal then and there you can follow up with text messages for new offers content links even just how you are doing notes to build a relationship wouldnt that be cool visit https boltleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps web visitors into leads offers a free 14 days trial you could be converting up to 100x more leads immediately it even includes international long distance calling stop wasting money chasing eyeballs that dont turn into paying customers please see this url to try web visitors into leads now https boltleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(170,'slug',0,1,''),(170,'subject',0,1,' cool website '),(170,'title',0,1,' 2025 03 03 04 27 33 '),(171,'emailaddress',0,1,' ericjonesmyemail gmail com '),(171,'fullname',0,1,' eric '),(171,'html',0,1,''),(171,'message',0,1,' hello to the robmartinomusic owner i am eric and i found robmartinomusic after performing a quick search you appeared near the top of the rankings so whatever youre doing for visibility seems to be working well heres my question what happens after someone arrives on your website do they simply leave without taking any action research indicates that many visitors find a site glance around briefly and then leave often without any engagement that means all the work youve done to bring them there doesnt fully pay off why let your efforts go to waste consider making it easy for interested visitors to connect with you without requiring them to even pick up their device web visitors into leads is a tool that resides on your website ready to capture a visitors name email and phone number it allows you to know immediately when someone is interested so you can speak with them while they are still there prompt outreach is key connecting with someone within a few minutes rather than much later can make a significant difference view a live demo https trustedleadgeneration com to see exactly how web visitors into leads works with our sms text with lead feature once you have their contact number you can immediately begin a text conversation even if they dont accept your initial offer you can maintain contact by sharing updates useful information and reasons to stay connected this simple addition can make your website much more effective visit the link above to learn more about what web visitors into leads can do for your business you may be pleasantly surprised thank you and keep up the great work eric p s web visitors into leads offers an available at no charge 14 day evaluation period you could be engaging far more visitors soon it even includes international call capabilities dont let potential connections slip away explore web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here click here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(171,'slug',0,1,''),(171,'subject',0,1,' strike when the irons hot '),(171,'title',0,1,' 2025 03 03 14 03 03 '),(172,'emailaddress',0,1,' ericjonesmyemail gmail com '),(172,'fullname',0,1,' eric '),(172,'html',0,1,''),(172,'message',0,1,' hello robmartinomusic owner this is eric and for just a second imagine this someone does a search and ends up at robmartinomusic they hang out for a moment to check it out im interested but maybe and then they click the back button and check out the other search results instead bottom line you got an eyeball but nothing else theyre gone this isnt really your fault it happens a lot studies show 7 out of 10 visitors to any site leave without leaving a trace but you can fix that web visitors into leads is a software that operates on your site ready to capture any visitors name email address and phone number you will know instantly theyre interested and you can call them directly to chat with them literally while theyre still on the internet looking at your site please see this url to test a live demo with web visitors into leads now to see exactly how it works and even give it a try it could be huge for your business https trustedleadgeneration com time is of the essence when it comes to connecting with leads the difference between contacting someone within 5 minutes compared to 30 minutes later can be significant moreover now that youve got that phone number with our new sms text with lead feature you can instantly start a text sms conversation immediately which is so effective because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later the new text messaging feature lets you follow up frequently with new offers content links even just follow up notes to develop a relationship everything ive just described is very easy to implement cost effective and beneficial please see this url to discover what web visitors into leads can do for your business possibly converting up to 100x more visitors into leads today https trustedleadgeneration com eric ps web visitors into leads offers a free 14 day trial and it even includes international long distance calling you have clients waiting to speak with you right now dont keep them waiting please see this url to try web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(172,'slug',0,1,''),(172,'subject',0,1,' turn surf surf surf into talk talk talk '),(172,'title',0,1,' 2025 03 05 06 39 17 '),(173,'emailaddress',0,1,' ericjonesmyemail gmail com '),(173,'fullname',0,1,' eric '),(173,'html',0,1,''),(173,'message',0,1,' hello robmartinomusic owner eric here with a quick thought about your website robmartinomusic im on the internet a lot and i look at a lot of business websites like yours many of them have great content but all too often they come up short when it comes to engaging and connecting with anyone who visits i get it its hard studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace you got the eyeball but nothing else heres a solution for you leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them while theyre literally checking out robmartinomusic https boltleadgeneration com to try out a live demo with web visitors into leads now to see exactly how it works it could be a game changer for your business and because youve got that phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is extremely simple to implement cost effective and profitable https boltleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps web visitors into leads offers a complimentary 14 day trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try web visitors into leads now if youd like to want to receive less emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(173,'slug',0,1,''),(173,'subject',0,1,' how to turn eyeballs into phone calls '),(173,'title',0,1,' 2025 03 06 12 26 41 '),(174,'emailaddress',0,1,' ericjonesmyemail gmail com '),(174,'fullname',0,1,' eric '),(174,'html',0,1,''),(174,'message',0,1,' hello robmartinomusic i just found your site quick question my names eric and i just found your site robmartinomusic while surfing the net you showed up at the top of the search results so i checked you out looks like what youre doing is pretty cool but if you dont mind me asking after someone like me stumbles across robmartinomusic what usually happens is your site generating leads for your business im guessing some but i also bet youd like more research indicates that 7 out of 10 who land on a site wind up leaving without a trace not good heres an idea how about making it really easy for every visitor who shows up to get a personal phone call from you as soon as they hit your site you can leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you the moment they let you know theyre interested so that you can talk to that lead while theyre literally looking over your site https boltleadgeneration com to try out a live demo with leadconnect now to see exactly how it works youll be amazed the difference between contacting someone within 5 minutes versus 30 minutes later could boost your results 100 fold it gets even better once youve captured their phone number with our new sms text with lead feature you can instantly start a text sms conversation that way even if you dont close a deal right away you can follow up with text messages for new offers content links even just how you doing notes to build a relationship pretty sweet and effective https boltleadgeneration com to discover what leadconnect can do for your business you could be converting up to 100x more leads today eric ps leadconnect offers a free 14 days trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try leadconnect now if youd like to want to receive less emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(174,'slug',0,1,''),(174,'subject',0,1,' your site more leads '),(174,'title',0,1,' 2025 03 10 23 26 01 '),(175,'emailaddress',0,1,' ericjonesmyemail gmail com '),(175,'fullname',0,1,' eric '),(175,'html',0,1,''),(175,'message',0,1,' hello robmartinomusic i just found your site quick question my names eric i found robmartinomusic after doing a quick search you showed up near the top of the rankings so whatever youre doing for seo looks like its working well so heres my question what happens after someone lands on your site anything research tells us at least 70% of the people who find your site after a quick once over they disappear forever that means that all the work and effort you put into getting them to show up goes down the tubes why would you want all that good work and the great site youve built go to waste because the odds are theyll just skip over calling or even grabbing their phone leaving you high and dry but heres a thought what if you could make it super simple for someone to raise their hand say okay lets talk without requiring them to even pull their cell phone from their pocket you can thanks to revolutionary new software that can literally make that first call happen now web visitors into leads is a software widget that sits on your site ready and waiting to capture any visitors name email address and phone number it lets you know immediately so that you can talk to that lead while theyre still there at your site you know strike when the irons hot please see this url to try out a live demo with web visitors into leads now to see precisely how it works and even give it a try it could be huge for your business https boltleadgeneration com when targeting leads you have to act fast the difference between contacting someone within 5 minutes versus 30 minutes later is huge like 100 times better thats why you should check out our new sms text with lead feature as well once youve captured the phone number of the website visitor you can automatically kick off a text sms conversation with them imagine how powerful this could be even if they dont take you up on your offer immediately you can stay in touch with them using text messages to make new offers provide links to great content and build your credibility just this alone could be a game changer to make your website even more effective strike when the irons hot please see this url to discover what web visitors into leads can do for your business youll be amazed https boltleadgeneration com thanks and keep up the great work eric ps web visitors into leads offers a free 14 days trial it even includes international long distance calling stop wasting money chasing eyeballs that dont turn into paying customers please see this url to try web visitors into leads now https boltleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(175,'slug',0,1,''),(175,'subject',0,1,' strike when the irons hot '),(175,'title',0,1,' 2025 03 18 14 52 25 '),(176,'emailaddress',0,1,' ericjonesmyemail gmail com '),(176,'fullname',0,1,' eric '),(176,'html',0,1,''),(176,'message',0,1,' hello eric here with a quick thought about your website robmartinomusic cool website my names eric and i just found your site robmartinomusic while surfing the net you showed up at the top of the search results so i checked you out looks like what youre doing is pretty cool but if you dont mind me asking after someone like me stumbles across robmartinomusic what usually happens is your site generating leads for your business im guessing some but i also bet youd like more studies show that 7 out of 10 who land on a site wind up leaving without a trace not good heres a thought how about making it really easy for every visitor who shows up to get a personal phone call from you as soon as they hit your site you can web visitor is a software widget that works on your site ready to capture any visitors name email address and phone number it lets you know immediately so that you can talk to that lead while theyre literally looking over your site https resultleadgeneration com to try out a live demo with web visitor now to see exactly how it works youll be amazed the difference between contacting someone within 5 minutes versus a half hour or more later could increase your results 100 fold it gets even better once youve captured their phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is simple easy and effective https resultleadgeneration com to discover what web visitor can do for your business potentially converting up to 100x more eyeballs into leads today eric ps web visitor offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitor now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(176,'slug',0,1,''),(176,'subject',0,1,' how to turn eyeballs into phone calls '),(176,'title',0,1,' 2025 03 21 07 55 16 '),(177,'emailaddress',0,1,' ericjonesmyemail gmail com '),(177,'fullname',0,1,' eric '),(177,'html',0,1,''),(177,'message',0,1,' hello robmartinomusic owner eric here with a quick thought about your website robmartinomusic im on the internet a lot and i look at a lot of business websites like yours many of them have great content but all too often they come up short when it comes to engaging and connecting with anyone who visits i get it its hard studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace you got the eyeball but nothing else heres a solution for you leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them while theyre literally checking out robmartinomusic https boltleadgeneration com to try out a live demo with web visitors into leads now to see exactly how it works it could be a game changer for your business and because youve got that phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is extremely simple to implement cost effective and profitable https boltleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps web visitors into leads offers a complimentary 14 day trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try web visitors into leads now if youd like to want to receive less emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(177,'slug',0,1,''),(177,'subject',0,1,' how to turn eyeballs into phone calls '),(177,'title',0,1,' 2025 03 23 14 24 34 '),(178,'emailaddress',0,1,' ericjonesmyemail gmail com '),(178,'fullname',0,1,' eric '),(178,'html',0,1,''),(178,'message',0,1,' hello robmartinomusic owner my name is eric and i just came across your website at robmartinomusic looks great but now what by that i mean when someone like me finds your website either through search or just bouncing around what happens next do you get a lot of leads from your site or at least enough to make you happy honestly most business websites fall a bit short when it comes to generating paying customers studies show that 70% of a sites visitors disappear and are gone forever after just a moment heres an idea how about making it really easy for every visitor who shows up to get a personal phone call from you as soon as they hit your site you can web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they let you know theyre interested so that you can talk to that lead while theyre literally looking over your site https resultleadgeneration com to try out a live demo with web visitors into leads now to see exactly how it works youll be amazed the difference between contacting someone within 5 minutes versus a half hour or more later could increase your results 100 fold it gets even better once youve captured their phone number with our new sms text with lead feature you can automatically start a text sms conversation that way even if you dont close a deal right away you can follow up with text messages for new offers content links even just how you doing notes to build a relationship pretty sweet and effective https resultleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(178,'slug',0,1,''),(178,'subject',0,1,' your site more leads '),(178,'title',0,1,' 2025 03 24 02 24 28 '),(179,'emailaddress',0,1,' ericjonesmyemail gmail com '),(179,'fullname',0,1,' eric '),(179,'html',0,1,''),(179,'message',0,1,' hello robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https resultleadgeneration com for a live demo now and now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https resultleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps studies show that 70% of a sites visitors disappear and are gone forever after just a moment dont keep losing them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(179,'slug',0,1,''),(179,'subject',0,1,' try this get more leads '),(179,'title',0,1,' 2025 03 25 09 22 21 '),(180,'emailaddress',0,1,' ericjonesmyemail gmail com '),(180,'fullname',0,1,' eric '),(180,'html',0,1,''),(180,'message',0,1,' hello eric here with a quick thought about your website robmartinomusic cool website my names eric and i just found your site robmartinomusic while surfing the net you showed up at the top of the search results so i checked you out looks like what youre doing is pretty cool but if you dont mind me asking after someone like me stumbles across robmartinomusic what usually happens is your site generating leads for your business im guessing some but i also bet youd like more studies show that 7 out of 10 who land on a site wind up leaving without a trace not good heres a thought how about making it really easy for every visitor who shows up to get a personal phone call from you as soon as they hit your site you can web visitor is a software widget that works on your site ready to capture any visitors name email address and phone number it lets you know immediately so that you can talk to that lead while theyre literally looking over your site https resultleadgeneration com to try out a live demo with web visitor now to see exactly how it works youll be amazed the difference between contacting someone within 5 minutes versus a half hour or more later could increase your results 100 fold it gets even better once youve captured their phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is simple easy and effective https resultleadgeneration com to discover what web visitor can do for your business potentially converting up to 100x more eyeballs into leads today eric ps web visitor offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitor now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(180,'slug',0,1,''),(180,'subject',0,1,' how to turn eyeballs into phone calls '),(180,'title',0,1,' 2025 03 26 18 23 02 '),(181,'emailaddress',0,1,' ericjonesmyemail gmail com '),(181,'fullname',0,1,' eric '),(181,'html',0,1,''),(181,'message',0,1,' hello robmartinomusic owner my names eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https resultleadgeneration com for a live demo now and now that youve got their phone number our new sms text with lead feature enables you to start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https resultleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps studies show that 70% of a sites visitors disappear and are gone forever after just a moment dont keep losing them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(181,'slug',0,1,''),(181,'subject',0,1,' try this get more leads '),(181,'title',0,1,' 2025 03 27 10 23 07 '),(182,'emailaddress',0,1,' ericjonesmyemail gmail com '),(182,'fullname',0,1,' eric '),(182,'html',0,1,''),(182,'message',0,1,' hello to the robmartinomusic owner this is eric and i noticed robmartinomusic a short time ago it appears well structured now what what i mean is when someone like me discovers your website either through a search or just browsing around what happens next are you receiving meaningful inquiries from your site or enough to meet your needs honestly most business websites come up a bit short when it comes to attracting engaged visitors research indicates that 70% of a sites visitors leave and never return after only a moment here is an idea what about making it simple for each visitor who arrives to receive a direct phone call from you as soon as they reach your site this is possible web visitors into leads is a tool that operates on your site designed to collect each visitors name email address and phone number it notifies you the moment they indicate interest so that you can speak to that person while they are browsing your site please visit https actionleadgeneration com to view a live demonstration of web visitors into leads and understand how it operates you will notice a significant difference between connecting with someone within 5 minutes compared to a half hour or more later this can greatly improve the likelihood of meaningful engagement it becomes even more helpful after you have their phone number with our sms text communication feature you can promptly begin a text conversation that way even if you do not reach a conclusion immediately you can stay connected through text messages for informational updates content links or simple check in notes to establish a relationship quite helpful please visit https actionleadgeneration com to learn how web visitors into leads can support your business you can potentially connect with many more interested individuals as soon as possible eric ps web visitors into leads provides a no cost 14 day evaluation period it also supports international communication there are interested individuals ready to speak with you now so please do not delay please visit https actionleadgeneration com to explore web visitors into leads if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(182,'slug',0,1,''),(182,'subject',0,1,' your site more leads '),(182,'title',0,1,' 2025 03 29 14 52 28 '),(183,'emailaddress',0,1,' ericjonesmyemail gmail com '),(183,'fullname',0,1,' eric '),(183,'html',0,1,''),(183,'message',0,1,' hello robmartinomusic owner my names eric and i just came across your website at robmartinomusic i found it after a quick search so your seos working out content looks pretty good one things missing though a quick easy way to connect with you now because studies show that a web lead like me will only hang out a few seconds 7 out of 10 disappear almost instantly surf surf surf then gone forever i have the solution web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them literally while theyre still on the web looking at your site https resultleadgeneration com to try out a live demo with web visitors into leads now to see exactly how it works and even give it a try it could be huge for your business when targeting leads you have to act fast the difference between contacting someone within 5 minutes versus 30 minutes later can be huge like 100 times better thats why you should check out our new sms text with lead feature as well once youve captured the phone number of the website visitor you can automatically kick off a text sms conversation with them imagine how powerful this could be even if they dont take you up on your offer immediately you can stay in touch with them using text messages to make new offers provide links to great content and build your credibility just this alone could be a game changer to make your website even more effective strike when the irons hot https resultleadgeneration com to discover what web visitors into leads can do for your business potentially converting up to 100x more eyeballs into leads today eric ps web visitors into leads offers a complimentary 14 day trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(183,'slug',0,1,''),(183,'subject',0,1,' strike when the irons hot '),(183,'title',0,1,' 2025 03 31 15 23 23 '),(184,'emailaddress',0,1,' ericjonesmyemail gmail com '),(184,'fullname',0,1,' eric '),(184,'html',0,1,''),(184,'message',0,1,' hello robmartinomusic i just found your site quick question my names eric and i just found your site robmartinomusic while surfing the net you showed up at the top of the search results so i checked you out looks like what youre doing is pretty cool but if you dont mind me asking after someone like me stumbles across robmartinomusic what usually happens is your site generating leads for your business im guessing some but i also bet youd like more research indicates that 7 out of 10 who land on a site wind up leaving without a trace not good heres an idea how about making it really easy for every visitor who shows up to get a personal phone call from you as soon as they hit your site you can leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you the moment they let you know theyre interested so that you can talk to that lead while theyre literally looking over your site https boltleadgeneration com to try out a live demo with leadconnect now to see exactly how it works youll be amazed the difference between contacting someone within 5 minutes versus 30 minutes later could boost your results 100 fold it gets even better once youve captured their phone number with our new sms text with lead feature you can instantly start a text sms conversation that way even if you dont close a deal right away you can follow up with text messages for new offers content links even just how you doing notes to build a relationship pretty sweet and effective https boltleadgeneration com to discover what leadconnect can do for your business you could be converting up to 100x more leads today eric ps leadconnect offers a free 14 days trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try leadconnect now if youd like to want to receive less emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(184,'slug',0,1,''),(184,'subject',0,1,' your site more leads '),(184,'title',0,1,' 2025 03 31 17 52 59 '),(185,'emailaddress',0,1,' ericjonesmyemail gmail com '),(185,'fullname',0,1,' eric '),(185,'html',0,1,''),(185,'message',0,1,' hello robmartinomusic owner my names eric and i just found your site robmartinomusic its got a lot going for it but heres an idea to make it even more effective visit https resultleadgeneration com for a live demo now web visitor is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you the moment they let you know theyre interested so that you can talk to that lead while theyre literally looking over your site https resultleadgeneration com to try out a live demo with web visitor now to see exactly how it works it could be huge for your business and because youve got that phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is simple easy and effective https resultleadgeneration com to discover what web visitor can do for your business you could be converting up to 100x more leads today eric ps studies show that 70% of a sites visitors disappear and are gone forever after just a moment dont keep losing them web visitor offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https resultleadgeneration com to try web visitor now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https resultleadgeneration com unsubscribe aspx d=robmartinomusic com '),(185,'slug',0,1,''),(185,'subject',0,1,' why not talk with your leads '),(185,'title',0,1,' 2025 04 01 21 52 06 '),(186,'emailaddress',0,1,' joannariggs02 gmail com '),(186,'fullname',0,1,' jo '),(186,'html',0,1,''),(186,'message',0,1,' hi i just visited robmartinomusic com and wondered if youd ever thought about having an engaging video to explain what you do or to be used on social media as a promotional tool our prices start from just $195 usd let me know if youre interested in seeing samples of our previous work regards jo '),(186,'slug',0,1,''),(186,'subject',0,1,' explainer video for your website '),(186,'title',0,1,' 2025 04 09 21 05 45 '),(187,'emailaddress',0,1,' ericjonesmyemail gmail com '),(187,'fullname',0,1,' eric '),(187,'html',0,1,''),(187,'message',0,1,' hello robmartinomusic administrator this is eric here with a short thought about your website robmartinomusic im on the internet frequently and i examine many business websites similar to yours many of them have excellent content but frequently they come up short when it comes to interacting and connecting with anyone who visits i understand its challenging studies show 7 out of 10 people who arrive at a site leave in moments without leaving any trace you got the view but nothing else heres a solution for you web visitors into leads is a software tool that operates on your site ready to gather any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them while theyre still viewing your site please see this url to experience a live demo with web visitors into leads now to see exactly how it works https trustedleadgeneration com it can be significant for your business and because youve got that phone number with our new sms text with lead feature you can immediately start a text conversation contacting someone within minutes is significantly more effective than reaching out much later additionally with text messaging you can follow up later with new information helpful links or just notes to continue the conversation everything ive just described is easy to implement reasonable and beneficial please see this url to learn what web visitors into leads can do for your business https trustedleadgeneration com you could be converting significantly more leads today eric ps web visitors into leads offers a 14 day evaluation and it even includes international calling you have customers ready to talk with you right now dont keep them waiting please see this url to use web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(187,'slug',0,1,''),(187,'subject',0,1,' how to turn eyeballs into phone calls '),(187,'title',0,1,' 2025 04 11 12 39 08 '),(188,'emailaddress',0,1,' ericjonesmyemail gmail com '),(188,'fullname',0,1,' eric '),(188,'html',0,1,''),(188,'message',0,1,' hello robmartinomusic owner eric here with a quick thought about your website robmartinomusic im on the internet a lot and i look at a lot of business websites like yours many of them have great content but all too often they come up short when it comes to engaging and connecting with anyone who visits i get it its hard studies show 7 out of 10 people who land on a site abandon it in moments without leaving even a trace you got the eyeball but nothing else heres a solution for you leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them while theyre literally checking out robmartinomusic https boltleadgeneration com to try out a live demo with web visitors into leads now to see exactly how it works it could be a game changer for your business and because youve got that phone number with our new sms text with lead feature you can automatically start a text sms conversation immediately and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later plus with text messaging you can follow up later with new offers content links even just follow up notes to keep the conversation going everything ive just described is extremely simple to implement cost effective and profitable https boltleadgeneration com to discover what web visitors into leads can do for your business you could be converting up to 100x more leads today eric ps web visitors into leads offers a complimentary 14 day trial you could be converting up to 100x more leads immediately it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try web visitors into leads now if youd like to want to receive less emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(188,'slug',0,1,''),(188,'subject',0,1,' how to turn eyeballs into phone calls '),(188,'title',0,1,' 2025 04 11 20 53 33 '),(189,'emailaddress',0,1,' ericjonesmyemail gmail com '),(189,'fullname',0,1,' eric '),(189,'html',0,1,''),(189,'message',0,1,' hi robmartinomusic owner my names eric and i just ran across your website at robmartinomusic its got a lot going for it but heres an idea to make it even more effective https boltleadgeneration com for a live demo now leadconnect is a software widget that works on your site ready to capture any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them literally while theyre still on the web looking at your site https boltleadgeneration com to try out a live demo with leadconnect now to see exactly how it works and even give it a try it could be huge for your business plus now that youve got that phone number with our new sms text with lead feature you can automatically start a text sms conversation pronto which is so powerful because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later the new text messaging feature lets you follow up regularly with new offers content links even just how you doing notes to build a relationship everything ive just described is extremely simple to implement cost effective and profitable https boltleadgeneration com to discover what leadconnect can do for your business potentially converting up to 100x more eyeballs into leads today eric ps leadconnect offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try leadconnect now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(189,'slug',0,1,''),(189,'subject',0,1,' turn surf surf surf into talk talk talk '),(189,'title',0,1,' 2025 04 13 06 23 39 '),(190,'emailaddress',0,1,' ericjonesmyemail gmail com '),(190,'fullname',0,1,' eric '),(190,'html',0,1,''),(190,'message',0,1,' hello robmartinomusic administrator my name is eric and i just found your site robmartinomusic its got a lot to offer but heres a suggestion to make it even better web visitors into leads see the live demo now https trustedleadgeneration com web visitors into leads is a software widget that works on your site ready to gather any visitors name email address and phone number it alerts you the moment they inform you theyre interested so that you can talk to that lead while theyre actually browsing your site once youve gathered their phone number with our new sms text with lead feature you can promptly start a text conversation even if they dont agree on your offer then you can follow up with text messages for new offers content links or even just friendly notes to build a relationship learn what web visitors into leads can do for your business https trustedleadgeneration com the difference between contacting someone within 5 minutes versus waiting longer means you can be converting significantly more leads now eric ps studies show that 70% of a sites visitors leave and are gone for good after just a moment dont keep missing out on them web visitors into leads offers a complimentary 14 day trial it even includes international calling you have customers ready to talk with you right now dont keep them waiting try web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(190,'slug',0,1,''),(190,'subject',0,1,' why not talk with your leads '),(190,'title',0,1,' 2025 04 16 18 41 07 '),(191,'emailaddress',0,1,' ericjonesmyemail gmail com '),(191,'fullname',0,1,' eric '),(191,'html',0,1,''),(191,'message',0,1,' hello robmartinomusic administrator my name is eric and i just found your site robmartinomusic its got a lot to offer but heres a suggestion to make it even better web visitors into leads see the live demo now https trustedleadgeneration com web visitors into leads is a software widget that works on your site ready to gather any visitors name email address and phone number it alerts you the moment they inform you theyre interested so that you can talk to that lead while theyre actually browsing your site once youve gathered their phone number with our new sms text with lead feature you can promptly start a text conversation even if they dont agree on your offer then you can follow up with text messages for new offers content links or even just friendly notes to build a relationship learn what web visitors into leads can do for your business https trustedleadgeneration com the difference between contacting someone within 5 minutes versus waiting longer means you can be converting significantly more leads now eric ps studies show that 70% of a sites visitors leave and are gone for good after just a moment dont keep missing out on them web visitors into leads offers a complimentary 14 day trial it even includes international calling you have customers ready to talk with you right now dont keep them waiting try web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(191,'slug',0,1,''),(191,'subject',0,1,' why not talk with your leads '),(191,'title',0,1,' 2025 04 20 09 42 42 '),(192,'emailaddress',0,1,' inge trugernanner54 gmail com '),(192,'fullname',0,1,' inge '),(192,'html',0,1,''),(192,'message',0,1,' hello were looking to establish long term cooperation please send us your offer and price list contact me via whatsapp 44 739 495 7438 '),(192,'slug',0,1,''),(192,'subject',0,1,' hello robmartinomusic com administrator '),(192,'title',0,1,' 2025 04 21 03 42 51 '),(193,'emailaddress',0,1,' ericjonesmyemail gmail com '),(193,'fullname',0,1,' eric '),(193,'html',0,1,''),(193,'message',0,1,' hello to the robmartinomusic owner my names eric and i recently came across your site robmartinomusic while browsing online your site showed up near the top of the search results so whatever youre doing for visibility seems effective if i may ask after someone like me finds robmartinomusic what typically happens is your site generating valuable inquiries for your business many visitors view a website and then leave without taking the next step research suggests that a majority of visitors exit quickly leaving no contact information consider this idea what if there was a straightforward way for each visitor to indicate theyd like a call from you right when they arrive you can make this happen web visitor is a tool that works on your site ready to securely gather a visitors name email and phone number it alerts you immediately so you can speak with that person while they are still viewing your site please visit https trustedleadgeneration com to see a live demonstration of web visitor and observe precisely how it works acting promptly matters when it comes to building connections the difference between engaging with someone within a few minutes versus waiting longer can be substantial our new sms text with lead feature allows you to begin a text conversation as soon as you have their number even if they arent ready right now you can keep in touch with updates offers and helpful information please visit the link above to learn what web visitor can do for your business you might be surprised at how much more interest you can capture eric p s web visitor offers a 14 day evaluation period and includes the ability to reach out internationally interested individuals may be ready to speak with you now so please dont miss out https trustedleadgeneration com want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(193,'slug',0,1,''),(193,'subject',0,1,' cool website '),(193,'title',0,1,' 2025 04 22 13 47 58 '),(194,'emailaddress',0,1,' ericjonesmyemail gmail com '),(194,'fullname',0,1,' eric '),(194,'html',0,1,''),(194,'message',0,1,' hello robmartinomusic owner my name is eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https boltleadgeneration com for a live demo now plus now that youve got their phone number with our new sms text with lead feature you can automatically start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https boltleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps the studies show 7 out of 10 visitors dont hang around you cant afford to lose them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(194,'slug',0,1,''),(194,'subject',0,1,' try this get more leads '),(194,'title',0,1,' 2025 04 24 09 23 16 '),(195,'emailaddress',0,1,' ericjonesmyemail gmail com '),(195,'fullname',0,1,' eric '),(195,'html',0,1,''),(195,'message',0,1,' hello to the robmartinomusic owner i am eric and i recently discovered your site robmartinomusic your site has a great deal going for it but i have an idea to help make it even more effective please take a look at web visitors into leads you can visit https actionleadgeneration com for a demonstration today web visitors into leads is a tool that operates on your site prepared to gather each visitors name email address and phone number it notifies you the instant they show interest allowing you to speak with them while they are still viewing your site once you have their phone number you can begin an sms conversation immediately if they are not ready at that moment you can follow up later with messages to share updates information or simply check in and maintain a connection please visit https actionleadgeneration com to learn more about what web visitors into leads can do for your business connecting with someone promptly rather than waiting a long time can make a substantial difference in your results eric p s research indicates that many site visitors leave quickly without returning web visitors into leads includes a 14 day no cost trial and supports international communication there may be individuals ready to engage with you right now so please do not delay please visit https actionleadgeneration com to learn more about web visitors into leads if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(195,'slug',0,1,''),(195,'subject',0,1,' why not talk with your leads '),(195,'title',0,1,' 2025 04 25 22 25 10 '),(196,'emailaddress',0,1,' terryfowlerr83 gmail com '),(196,'fullname',0,1,' terry '),(196,'html',0,1,''),(196,'message',0,1,' hello robmartinomusic com use sustainable white hat tactics to gain 10 to 20 new clients who are eager for your services id be happy to share more details about our services and solutions if youre interested well wishes terry fowler digital marketing manager note if youre not interested in our services send us opt out '),(196,'slug',0,1,''),(196,'subject',0,1,' re seo consultant '),(196,'title',0,1,' 2025 04 27 00 57 52 '),(197,'emailaddress',0,1,' ericjonesmyemail gmail com '),(197,'fullname',0,1,' eric '),(197,'html',0,1,''),(197,'message',0,1,' hello robmartinomusic owner this is eric and for just a second imagine this someone does a search and ends up at robmartinomusic they hang out for a moment to check it out im interested but maybe and then they click the back button and check out the other search results instead bottom line you got an eyeball but nothing else theyre gone this isnt really your fault it happens a lot studies show 7 out of 10 visitors to any site leave without leaving a trace but you can fix that web visitors into leads is a software that operates on your site ready to capture any visitors name email address and phone number you will know instantly theyre interested and you can call them directly to chat with them literally while theyre still on the internet looking at your site please see this url to test a live demo with web visitors into leads now to see exactly how it works and even give it a try it could be huge for your business https trustedleadgeneration com time is of the essence when it comes to connecting with leads the difference between contacting someone within 5 minutes compared to 30 minutes later can be significant moreover now that youve got that phone number with our new sms text with lead feature you can instantly start a text sms conversation immediately which is so effective because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later the new text messaging feature lets you follow up frequently with new offers content links even just follow up notes to develop a relationship everything ive just described is very easy to implement cost effective and beneficial please see this url to discover what web visitors into leads can do for your business possibly converting up to 100x more visitors into leads today https trustedleadgeneration com eric ps web visitors into leads offers a free 14 day trial and it even includes international long distance calling you have clients waiting to speak with you right now dont keep them waiting please see this url to try web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(197,'slug',0,1,''),(197,'subject',0,1,' turn surf surf surf into talk talk talk '),(197,'title',0,1,' 2025 04 27 13 08 59 '),(201,'alt',0,1,''),(201,'extension',0,1,' png '),(201,'filename',0,1,' face new png '),(201,'kind',0,1,' image '),(201,'slug',0,1,''),(201,'title',0,1,' face new '),(202,'alt',0,1,''),(202,'extension',0,1,' png '),(202,'filename',0,1,' hobbe favicon png '),(202,'kind',0,1,' image '),(202,'slug',0,1,''),(202,'title',0,1,' hobbe favicon '),(203,'emailaddress',0,1,' jeffery mamie gmail com '),(203,'fullname',0,1,' mamie '),(203,'html',0,1,''),(203,'message',0,1,' hello this is mike jeffery from monkey digital i am reaching out to discuss a exciting collaboration how would you like to place our promotions on your website and link back via your custom referral link towards hot selling services from our platform this way you make a recurring 35% residual income every month from any purchases that are made from your website think about it all businesses need seo so this is a big opportunity we already have 12k affiliates and our payments are paid out every month recently we reached a significant amount in commissions to our partners if interested kindly chat with us here https monkeydigital co affiliates whatsapp or join us today https www monkeydigital co join our affiliate program looking forward mike jeffery monkey digital phone whatsapp 1 775 314 7914 '),(203,'slug',0,1,''),(203,'subject',0,1,' unlock lifetime earnings with our 35% affiliate program '),(203,'title',0,1,' 2025 05 02 10 12 28 '),(204,'emailaddress',0,1,' ericjonesmyemail gmail com '),(204,'fullname',0,1,' eric '),(204,'html',0,1,''),(204,'message',0,1,' hello robmartinomusic owner my name is eric and im betting youd like your website robmartinomusic to generate more leads heres how web visitors into leads is a software widget that works on your site ready to capture any visitors name email address and phone number it signals you as soon as they say theyre interested so that you can talk to that lead while theyre still there at robmartinomusic https boltleadgeneration com for a live demo now plus now that youve got their phone number with our new sms text with lead feature you can automatically start a text sms conversation answer questions provide more info and close a deal that way if they dont take you up on your offer then just follow up with text messages for new offers content links even just how you doing notes to build a relationship https boltleadgeneration com to discover what web visitors into leads can do for your business the difference between contacting someone within 5 minutes versus a half hour means you could be converting up to 100x more leads today try web visitors into leads and get more leads now eric ps the studies show 7 out of 10 visitors dont hang around you cant afford to lose them web visitors into leads offers a complimentary 14 day trial and it even includes international long distance calling you have customers waiting to talk with you right now dont keep them waiting https boltleadgeneration com to try web visitors into leads now if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https boltleadgeneration com unsubscribe aspx d=robmartinomusic com '),(204,'slug',0,1,''),(204,'subject',0,1,' try this get more leads '),(204,'title',0,1,' 2025 05 06 02 25 00 '),(205,'emailaddress',0,1,' zekisuquc419 gmail com '),(205,'fullname',0,1,' oscarsaurf '),(205,'html',0,1,''),(205,'message',0,1,' ola queria saber o seu prezo '),(205,'slug',0,1,''),(205,'subject',0,1,' hello i am wrote about your the price '),(205,'title',0,1,' 2025 05 07 06 34 27 '),(206,'emailaddress',0,1,' ex p a n s e uy o r a c le7 1 gmail com '),(206,'fullname',0,1,' apple inc 2025 all rights reserved apple inc 2025 all rights reserved 1337691 https t me grandbooksommer '),(206,'html',0,1,''),(206,'message',0,1,''),(206,'slug',0,1,''),(206,'subject',0,1,' apple inc 2025 all rights reserved apple inc 2025 all rights reserved 286767 https t me grandbooksommer '),(206,'title',0,1,' 2025 05 10 03 43 36 '),(207,'emailaddress',0,1,' ericjonesmyemail gmail com '),(207,'fullname',0,1,' eric '),(207,'html',0,1,''),(207,'message',0,1,' hello to the robmartinomusic manager i am eric and i recently discovered your website robmartinomusic in the search results your site is visible online and the content is solid however theres one area that may help improve results when visitors arrive at robmartinomusic many may look around briefly then leave without taking further action research suggests most visitors exit quickly and you never learn who they were or how to reach them you can change that consider using web visitors into leads this tool operates on your site and is ready to securely collect each visitors name email and phone number it informs you right away when someone shows interest so you can connect with them while they are still on your website view a demonstration https actionleadgeneration com prompt and meaningful outreach can make a substantial difference additionally once you have a visitors phone number you can begin a friendly text conversation even if they arent ready at that moment you can keep in touch over time with relevant updates and useful information this approach is easy to implement and can help you engage more effectively with interested individuals visit the link above to see what web visitors into leads can do for your business by reaching out promptly you may find that more visitors become engaged prospects eric p s web visitors into leads includes an evaluation period and supports international communication interested individuals may be ready to speak with you now so please dont miss the opportunity visit the link https actionleadgeneration com to learn more if youd like to want to receive fewer emails or none whatsoever update your email preferences by visiting https actionleadgeneration com unsubscribe aspx d=robmartinomusic com '),(207,'slug',0,1,''),(207,'subject',0,1,' who needs eyeballs you need business '),(207,'title',0,1,' 2025 05 15 21 25 45 '),(208,'emailaddress',0,1,' info hilkom digital com '),(208,'fullname',0,1,' jaime '),(208,'html',0,1,''),(208,'message',0,1,' hi if youre ready to grow your search traffic you need an ongoing seo strategy at hilkom digital we deliver results driven growth through expert led seo strategies our monthly plans are crafted with care and designed for businesses that want actual growth not just temporary wins due to high demand and our dedicated workflow we can only accept a limited number of clients each month this ensures every campaign gets the attention it deserves your seo plan covers complete technical content seo da50 backlink building smart keyword focus and tracking toxic link cleanup disavow file handling paid indexing for faster rankings multilingual seo support de es fr en spots are limited secure your monthly seo plan now https www hilkom digital com seo services need more info chat with an seo expert here https www hilkom digital com whatsapp us lets boost your digital presence bring leads and elevate your brand the smart way best regards mike ehmann hilkom digital phone whatsapp 1 855 221 7591 support hilkom digital com '),(208,'slug',0,1,''),(208,'subject',0,1,' only a few seo spots left start your monthly strategy now '),(208,'title',0,1,' 2025 05 17 23 55 56 '),(209,'emailaddress',0,1,' ericjonesmyemail gmail com '),(209,'fullname',0,1,' eric '),(209,'html',0,1,''),(209,'message',0,1,' hello robmartinomusic owner this is eric and for just a second imagine this someone does a search and ends up at robmartinomusic they hang out for a moment to check it out im interested but maybe and then they click the back button and check out the other search results instead bottom line you got an eyeball but nothing else theyre gone this isnt really your fault it happens a lot studies show 7 out of 10 visitors to any site leave without leaving a trace but you can fix that web visitors into leads is a software that operates on your site ready to capture any visitors name email address and phone number you will know instantly theyre interested and you can call them directly to chat with them literally while theyre still on the internet looking at your site please see this url to test a live demo with web visitors into leads now to see exactly how it works and even give it a try it could be huge for your business https trustedleadgeneration com time is of the essence when it comes to connecting with leads the difference between contacting someone within 5 minutes compared to 30 minutes later can be significant moreover now that youve got that phone number with our new sms text with lead feature you can instantly start a text sms conversation immediately which is so effective because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later the new text messaging feature lets you follow up frequently with new offers content links even just follow up notes to develop a relationship everything ive just described is very easy to implement cost effective and beneficial please see this url to discover what web visitors into leads can do for your business possibly converting up to 100x more visitors into leads today https trustedleadgeneration com eric ps web visitors into leads offers a free 14 day trial and it even includes international long distance calling you have clients waiting to speak with you right now dont keep them waiting please see this url to try web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(209,'slug',0,1,''),(209,'subject',0,1,' turn surf surf surf into talk talk talk '),(209,'title',0,1,' 2025 05 20 13 38 05 '),(210,'emailaddress',0,1,' zekisuquc419 gmail com '),(210,'fullname',0,1,' leesaurf '),(210,'html',0,1,''),(210,'message',0,1,' hi i wanted to know your price '),(210,'slug',0,1,''),(210,'subject',0,1,' hi wrote about your price for reseller '),(210,'title',0,1,' 2025 05 21 09 17 26 '),(211,'emailaddress',0,1,' ericjonesmyemail gmail com '),(211,'fullname',0,1,' eric '),(211,'html',0,1,''),(211,'message',0,1,' hello robmartinomusic administrator this is eric here with a short thought about your website robmartinomusic im on the internet frequently and i examine many business websites similar to yours many of them have excellent content but frequently they come up short when it comes to interacting and connecting with anyone who visits i understand its challenging studies show 7 out of 10 people who arrive at a site leave in moments without leaving any trace you got the view but nothing else heres a solution for you web visitors into leads is a software tool that operates on your site ready to gather any visitors name email address and phone number youll know immediately theyre interested and you can call them directly to talk with them while theyre still viewing your site please see this url to experience a live demo with web visitors into leads now to see exactly how it works https trustedleadgeneration com it can be significant for your business and because youve got that phone number with our new sms text with lead feature you can immediately start a text conversation contacting someone within minutes is significantly more effective than reaching out much later additionally with text messaging you can follow up later with new information helpful links or just notes to continue the conversation everything ive just described is easy to implement reasonable and beneficial please see this url to learn what web visitors into leads can do for your business https trustedleadgeneration com you could be converting significantly more leads today eric ps web visitors into leads offers a 14 day evaluation and it even includes international calling you have customers ready to talk with you right now dont keep them waiting please see this url to use web visitors into leads now https trustedleadgeneration com if youd like to want to receive less emails or none whatsoever update your email preferences by clicking here https trustedleadgeneration com unsubscribe aspx d=robmartinomusic com '),(211,'slug',0,1,''),(211,'subject',0,1,' how to turn eyeballs into phone calls '),(211,'title',0,1,' 2025 05 23 02 56 42 '),(212,'emailaddress',0,1,' santehnikagrodno v ip gmail com '),(212,'fullname',0,1,' santehnikaphedo '),(212,'html',0,1,''),(212,'message',0,1,' when it comes to pumps its easy to forget how important their contribution to everyday life is they dont just move water they do it efficiently saving you resources and time for summer residents who have their own plots a pump can be a real salvation when watering while owners of private homes will appreciate the opportunity to avoid unpleasant situations associated with flooding imagine that you can rest easy knowing that the pump will take care of your irrigation or drainage system it really creates an extra level of peace in your life absolutely url= color= 1c1c1c pumps for home color url should be at the top of the list of desired improvements if you want your home to be cozy and safe '),(212,'slug',0,1,''),(212,'subject',0,1,' how do i choose the perfect pump for your home '),(212,'title',0,1,' 2025 06 13 15 15 48 '),(213,'emailaddress',0,1,' twolfe166 hotmail com '),(213,'fullname',0,1,' tanya wolfe '),(213,'html',0,1,''),(213,'message',0,1,' hi spotted rob on your website maybe its a typo i usually check these quickly using spellpros com cheers tanya '),(213,'slug',0,1,''),(213,'subject',0,1,' website text concern '),(213,'title',0,1,' 2025 06 18 12 30 26 '),(214,'emailaddress',0,1,' jessicalangdon240 gmail com '),(214,'fullname',0,1,' jess '),(214,'html',0,1,''),(214,'message',0,1,' hi there we run a youtube growth service which increases your number of subscribers both safely and practically gain 700 1500 real human subscribers who subscribe because they are interested in your channel videos all actions are made manually by our team we do not use any bots channel creation if you havent started your youtube journey yet we can create a professional channel for you as part of your initial order the price is just $60 usd per month and we can start immediately our website is https furtherinfo info youtube kind regards jess '),(214,'slug',0,1,''),(214,'subject',0,1,' youtube promotion grow your subscribers by 700 each month '),(214,'title',0,1,' 2025 07 01 21 50 52 ');
/*!40000 ALTER TABLE `searchindex` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `searchindexqueue`
--

LOCK TABLES `searchindexqueue` WRITE;
/*!40000 ALTER TABLE `searchindexqueue` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `searchindexqueue` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `searchindexqueue_fields`
--

LOCK TABLES `searchindexqueue_fields` WRITE;
/*!40000 ALTER TABLE `searchindexqueue_fields` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `searchindexqueue_fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sections`
--

LOCK TABLES `sections` WRITE;
/*!40000 ALTER TABLE `sections` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sections` VALUES (2,NULL,'Embeds','embeds','channel',0,1,'all','end',NULL,'2023-06-11 22:50:12','2023-06-11 22:50:12',NULL,'e83e534b-ba3e-41e5-9e73-051db8c4b65b'),(3,NULL,'Gigs','gigs','channel',0,1,'all','end','[{\"label\": \"Primary entry page\", \"urlFormat\": \"{url}\"}]','2023-06-11 22:50:12','2024-12-23 16:29:12',NULL,'825f4bb2-160e-43de-b9e1-179a555f48ec'),(4,NULL,'Home','home','single',0,1,'all','end','[{\"label\": \"Primary entry page\", \"urlFormat\": \"{url}\"}]','2023-06-11 22:50:12','2024-12-23 16:29:12',NULL,'9ba0ed5d-fc6f-4a0f-8d43-f13470b75bf4'),(5,1,'Pages','pages','structure',1,1,'all','beginning','[{\"label\": \"Primary entry page\", \"refresh\": \"1\", \"urlFormat\": \"{url}\"}]','2023-06-11 22:50:12','2024-12-23 16:39:51',NULL,'d9c26beb-6bee-444c-b33f-13a168793722'),(6,NULL,'Videos','videos','channel',1,1,'all','end',NULL,'2023-06-11 22:50:13','2023-06-11 22:50:13',NULL,'15fdb8d9-166a-4c6c-b61e-17cbec66abd1');
/*!40000 ALTER TABLE `sections` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sections_entrytypes`
--

LOCK TABLES `sections_entrytypes` WRITE;
/*!40000 ALTER TABLE `sections_entrytypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sections_entrytypes` VALUES (2,1,1,NULL,NULL),(2,7,2,NULL,NULL),(2,8,3,NULL,NULL),(3,4,1,NULL,NULL),(4,6,1,NULL,NULL),(5,2,3,NULL,NULL),(5,5,2,NULL,NULL),(5,16,1,NULL,NULL),(6,9,1,NULL,NULL);
/*!40000 ALTER TABLE `sections_entrytypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sections_sites`
--

LOCK TABLES `sections_sites` WRITE;
/*!40000 ALTER TABLE `sections_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sections_sites` VALUES (2,2,1,0,NULL,NULL,1,'2023-06-11 22:50:12','2023-06-11 22:50:12','388583dd-369c-4e9d-8257-726e276fe45f'),(3,3,1,1,'gigs/{slug}',NULL,1,'2023-06-11 22:50:12','2023-06-11 22:50:12','c437f4c8-0b23-4344-8d20-0f454c9ee01a'),(4,4,1,1,'__home__','home',1,'2023-06-11 22:50:12','2023-06-11 22:50:12','5851f289-949a-4ae1-8a73-8510cfea4a68'),(5,5,1,1,'{slug}','_pages/_base',1,'2023-06-11 22:50:12','2023-06-11 22:50:12','f79a85e4-24ba-40e6-8f6c-9642574e9f2f'),(6,6,1,0,NULL,NULL,1,'2023-06-11 22:50:13','2023-06-11 22:50:13','9b2b3283-5b33-437a-b203-39aefda1b75b');
/*!40000 ALTER TABLE `sections_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sequences`
--

LOCK TABLES `sequences` WRITE;
/*!40000 ALTER TABLE `sequences` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `sequences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `shunnedmessages`
--

LOCK TABLES `shunnedmessages` WRITE;
/*!40000 ALTER TABLE `shunnedmessages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `shunnedmessages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sitegroups`
--

LOCK TABLES `sitegroups` WRITE;
/*!40000 ALTER TABLE `sitegroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sitegroups` VALUES (1,'Rob Martino Music','2023-06-11 22:50:09','2023-06-11 22:50:09',NULL,'76c85625-5e8e-4126-9f8f-6c15d50877ae');
/*!40000 ALTER TABLE `sitegroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sites`
--

LOCK TABLES `sites` WRITE;
/*!40000 ALTER TABLE `sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sites` VALUES (1,1,1,'1','Rob Martino Music','default','en',1,'$PRIMARY_SITE_URL',1,'2023-06-11 22:50:09','2024-12-23 16:46:54',NULL,'844f6d9c-168f-4c8e-904a-202432cef59e');
/*!40000 ALTER TABLE `sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sso_identities`
--

LOCK TABLES `sso_identities` WRITE;
/*!40000 ALTER TABLE `sso_identities` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `sso_identities` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `structureelements`
--

LOCK TABLES `structureelements` WRITE;
/*!40000 ALTER TABLE `structureelements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `structureelements` VALUES (1,1,NULL,1,1,12,0,'2023-06-11 23:03:41','2023-06-11 23:07:20','a38789a8-cd25-4ff9-a0d5-c84fc1f12fa3'),(2,1,18,1,10,11,1,'2023-06-11 23:03:41','2023-06-11 23:07:20','edd7c773-650b-413f-a1af-a428c48fee6c'),(3,1,20,1,8,9,1,'2023-06-11 23:04:18','2023-06-11 23:07:20','26ce4dff-d8f4-46c4-b292-d49ebc2eef88'),(4,1,22,1,6,7,1,'2023-06-11 23:05:19','2023-06-11 23:07:20','31c61d18-72d3-4c19-b594-ecbd856d2b44'),(5,1,24,1,4,5,1,'2023-06-11 23:05:54','2023-06-11 23:07:20','3ac20220-eb81-4b04-85e7-a36ee15d1fa4'),(6,1,26,1,2,3,1,'2023-06-11 23:07:20','2023-06-11 23:07:20','c24dd46a-b266-4c77-902e-230c54132239');
/*!40000 ALTER TABLE `structureelements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `structures`
--

LOCK TABLES `structures` WRITE;
/*!40000 ALTER TABLE `structures` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `structures` VALUES (1,1,'2023-06-11 22:50:12','2024-12-23 16:39:51',NULL,'60678798-1b32-434e-b9a3-375d854aafe7');
/*!40000 ALTER TABLE `structures` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `systemmessages`
--

LOCK TABLES `systemmessages` WRITE;
/*!40000 ALTER TABLE `systemmessages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `systemmessages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `taggroups`
--

LOCK TABLES `taggroups` WRITE;
/*!40000 ALTER TABLE `taggroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `taggroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `tokens`
--

LOCK TABLES `tokens` WRITE;
/*!40000 ALTER TABLE `tokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `tokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `usergroups`
--

LOCK TABLES `usergroups` WRITE;
/*!40000 ALTER TABLE `usergroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `usergroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `usergroups_users`
--

LOCK TABLES `usergroups_users` WRITE;
/*!40000 ALTER TABLE `usergroups_users` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `usergroups_users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions`
--

LOCK TABLES `userpermissions` WRITE;
/*!40000 ALTER TABLE `userpermissions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions_usergroups`
--

LOCK TABLES `userpermissions_usergroups` WRITE;
/*!40000 ALTER TABLE `userpermissions_usergroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions_usergroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions_users`
--

LOCK TABLES `userpermissions_users` WRITE;
/*!40000 ALTER TABLE `userpermissions_users` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions_users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpreferences`
--

LOCK TABLES `userpreferences` WRITE;
/*!40000 ALTER TABLE `userpreferences` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `userpreferences` VALUES (3,'{\"locale\": null, \"language\": \"en\", \"useShapes\": false, \"weekStartDay\": \"1\", \"underlineLinks\": false, \"profileTemplates\": false, \"showFieldHandles\": true, \"showExceptionView\": false, \"alwaysShowFocusRings\": false, \"notificationDuration\": \"5000\", \"enableDebugToolbarForCp\": false, \"enableDebugToolbarForSite\": false}');
/*!40000 ALTER TABLE `userpreferences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `users` VALUES (3,NULL,NULL,1,0,0,0,1,'jsudimak','',NULL,NULL,'jsudimak302@gmail.com','$2y$13$aXI8fnKRz.IxczBSonIRyO3pOjM3BBMZ25mLGfUPgUnyl1Fc5jIMG','2025-07-02 23:21:05',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,0,'2023-06-11 22:50:19','2023-06-11 22:50:19','2025-07-02 23:21:05');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `volumefolders`
--

LOCK TABLES `volumefolders` WRITE;
/*!40000 ALTER TABLE `volumefolders` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `volumefolders` VALUES (1,NULL,1,'Local Images',NULL,'2023-06-11 22:50:16','2023-06-11 22:50:16','d405919f-e916-4d83-ab60-0c97566333b5'),(2,NULL,2,'Local Videos',NULL,'2023-06-11 22:50:16','2023-06-11 22:50:16','c41583af-ee08-4966-a3c1-472759a794d7'),(3,NULL,NULL,'Temporary filesystem',NULL,'2023-06-11 22:53:05','2023-06-11 22:53:05','009d3b05-6f18-4b78-9084-5cadfa6f216a'),(5,1,1,'transforms','transforms/','2023-06-11 23:02:49','2023-06-11 23:02:49','eee1c41b-2a99-4ae2-a0a5-a9c5794153ed'),(7,1,1,'video-thumbs','video-thumbs/','2024-12-23 17:13:37','2024-12-23 17:13:37','87d49c75-36c1-4913-b117-6b275bfbf3d9'),(9,5,1,'video-thumbs','transforms/video-thumbs/','2025-05-02 16:05:12','2025-05-02 16:05:12','6219992d-19f8-4cc3-8ba1-df2d8b6ffbcf');
/*!40000 ALTER TABLE `volumefolders` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `volumes` VALUES (1,11,'Local Images','localImages','localFilesystem',NULL,'localTransforms','','site',NULL,'none',NULL,1,'2023-06-11 22:50:16','2024-12-23 16:39:51',NULL,'4be4bc77-6721-4564-9441-605a1a6c0bad'),(2,12,'Local Videos','localVideos','videoFilesystem',NULL,'','','site',NULL,'none',NULL,2,'2023-06-11 22:50:16','2024-12-23 16:39:51',NULL,'542617dd-cf2a-41c4-9716-97fac95cd8f6');
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `webauthn`
--

LOCK TABLES `webauthn` WRITE;
/*!40000 ALTER TABLE `webauthn` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `webauthn` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `widgets` VALUES (1,3,'craft\\widgets\\RecentEntries',1,NULL,'{\"limit\": 10, \"siteId\": 1, \"section\": \"*\"}',1,'2023-06-11 22:50:31','2023-06-11 22:50:31','128c6839-82a7-44e2-93f6-bb0663b59138'),(2,3,'craft\\widgets\\CraftSupport',2,NULL,'[]',1,'2023-06-11 22:50:31','2023-06-11 22:50:31','f20abae9-7fb4-4ed0-832b-6b2c5174dd6d'),(3,3,'craft\\widgets\\Updates',3,NULL,'[]',1,'2023-06-11 22:50:31','2023-06-11 22:50:31','9cc47b3d-144d-4f71-8f20-39b90c5b6fc8');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping routines for database 'robmartinomusic_db'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-07-02 23:31:27
